// services/viz/public/mojom/compositing/begin_frame_args.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_BEGIN_FRAME_ARGS_MOJOM_BLINK_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_BEGIN_FRAME_ARGS_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/public/mojom/compositing/begin_frame_args.mojom-features.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/begin_frame_args.mojom-shared.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/begin_frame_args.mojom-blink-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/time.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "components/viz/common/frame_sinks/begin_frame_args.h"
#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace viz::mojom::blink {





class BLINK_PLATFORM_EXPORT BeginFrameId {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BeginFrameId, T>::value>;
  using DataView = BeginFrameIdDataView;
  using Data_ = internal::BeginFrameId_Data;

  template <typename... Args>
  static BeginFrameIdPtr New(Args&&... args) {
    return BeginFrameIdPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BeginFrameIdPtr From(const U& u) {
    return mojo::TypeConverter<BeginFrameIdPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BeginFrameId>::Convert(*this);
  }


  BeginFrameId();

  BeginFrameId(
      uint64_t source_id,
      uint64_t sequence_number);


  ~BeginFrameId();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BeginFrameIdPtr>
  BeginFrameIdPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BeginFrameId::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, BeginFrameId::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, BeginFrameId::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BeginFrameId::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BeginFrameId::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BeginFrameId::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BeginFrameId_UnserializedMessageContext<
            UserType, BeginFrameId::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<BeginFrameId::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return BeginFrameId::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BeginFrameId_UnserializedMessageContext<
            UserType, BeginFrameId::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BeginFrameId::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint64_t source_id;
  
  uint64_t sequence_number;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BeginFrameId::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BeginFrameId::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BeginFrameId::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BeginFrameId::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class BLINK_PLATFORM_EXPORT BeginFrameAck {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BeginFrameAck, T>::value>;
  using DataView = BeginFrameAckDataView;
  using Data_ = internal::BeginFrameAck_Data;

  template <typename... Args>
  static BeginFrameAckPtr New(Args&&... args) {
    return BeginFrameAckPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BeginFrameAckPtr From(const U& u) {
    return mojo::TypeConverter<BeginFrameAckPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BeginFrameAck>::Convert(*this);
  }


  BeginFrameAck();

  BeginFrameAck(
      uint64_t source_id,
      uint64_t sequence_number,
      int64_t trace_id,
      bool has_damage);


  ~BeginFrameAck();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BeginFrameAckPtr>
  BeginFrameAckPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BeginFrameAck::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, BeginFrameAck::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, BeginFrameAck::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BeginFrameAck::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BeginFrameAck::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BeginFrameAck::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BeginFrameAck_UnserializedMessageContext<
            UserType, BeginFrameAck::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<BeginFrameAck::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return BeginFrameAck::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BeginFrameAck_UnserializedMessageContext<
            UserType, BeginFrameAck::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BeginFrameAck::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint64_t source_id;
  
  uint64_t sequence_number;
  
  int64_t trace_id;
  
  bool has_damage;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BeginFrameAck::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BeginFrameAck::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BeginFrameAck::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BeginFrameAck::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}








class BLINK_PLATFORM_EXPORT BeginFrameArgs {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BeginFrameArgs, T>::value>;
  using DataView = BeginFrameArgsDataView;
  using Data_ = internal::BeginFrameArgs_Data;

  template <typename... Args>
  static BeginFrameArgsPtr New(Args&&... args) {
    return BeginFrameArgsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BeginFrameArgsPtr From(const U& u) {
    return mojo::TypeConverter<BeginFrameArgsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BeginFrameArgs>::Convert(*this);
  }


  BeginFrameArgs();

  BeginFrameArgs(
      ::base::TimeTicks frame_time,
      ::base::TimeTicks deadline,
      ::base::TimeDelta interval,
      BeginFrameIdPtr frame_id,
      uint64_t frames_throttled_since_last,
      int64_t trace_id,
      ::base::TimeTicks dispatch_time,
      ::base::TimeTicks client_arrival_time,
      BeginFrameArgsType type,
      bool on_critical_path,
      bool animate_only);

BeginFrameArgs(const BeginFrameArgs&) = delete;
BeginFrameArgs& operator=(const BeginFrameArgs&) = delete;

  ~BeginFrameArgs();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BeginFrameArgsPtr>
  BeginFrameArgsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BeginFrameArgs::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, BeginFrameArgs::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, BeginFrameArgs::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BeginFrameArgs::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BeginFrameArgs::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BeginFrameArgs::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BeginFrameArgs_UnserializedMessageContext<
            UserType, BeginFrameArgs::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<BeginFrameArgs::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return BeginFrameArgs::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BeginFrameArgs_UnserializedMessageContext<
            UserType, BeginFrameArgs::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BeginFrameArgs::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::TimeTicks frame_time;
  
  ::base::TimeTicks deadline;
  
  ::base::TimeDelta interval;
  
  BeginFrameIdPtr frame_id;
  
  uint64_t frames_throttled_since_last;
  
  int64_t trace_id;
  
  ::base::TimeTicks dispatch_time;
  
  ::base::TimeTicks client_arrival_time;
  
  BeginFrameArgsType type;
  
  bool on_critical_path;
  
  bool animate_only;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BeginFrameArgs::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BeginFrameArgs::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BeginFrameArgs::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BeginFrameArgs::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}


template <typename StructPtrType>
BeginFrameIdPtr BeginFrameId::Clone() const {
  return New(
      mojo::Clone(source_id),
      mojo::Clone(sequence_number)
  );
}

template <typename T, BeginFrameId::EnableIfSame<T>*>
bool BeginFrameId::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->source_id, other_struct.source_id))
    return false;
  if (!mojo::Equals(this->sequence_number, other_struct.sequence_number))
    return false;
  return true;
}

template <typename T, BeginFrameId::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.source_id < rhs.source_id)
    return true;
  if (rhs.source_id < lhs.source_id)
    return false;
  if (lhs.sequence_number < rhs.sequence_number)
    return true;
  if (rhs.sequence_number < lhs.sequence_number)
    return false;
  return false;
}
template <typename StructPtrType>
BeginFrameArgsPtr BeginFrameArgs::Clone() const {
  return New(
      mojo::Clone(frame_time),
      mojo::Clone(deadline),
      mojo::Clone(interval),
      mojo::Clone(frame_id),
      mojo::Clone(frames_throttled_since_last),
      mojo::Clone(trace_id),
      mojo::Clone(dispatch_time),
      mojo::Clone(client_arrival_time),
      mojo::Clone(type),
      mojo::Clone(on_critical_path),
      mojo::Clone(animate_only)
  );
}

template <typename T, BeginFrameArgs::EnableIfSame<T>*>
bool BeginFrameArgs::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->frame_time, other_struct.frame_time))
    return false;
  if (!mojo::Equals(this->deadline, other_struct.deadline))
    return false;
  if (!mojo::Equals(this->interval, other_struct.interval))
    return false;
  if (!mojo::Equals(this->frame_id, other_struct.frame_id))
    return false;
  if (!mojo::Equals(this->frames_throttled_since_last, other_struct.frames_throttled_since_last))
    return false;
  if (!mojo::Equals(this->trace_id, other_struct.trace_id))
    return false;
  if (!mojo::Equals(this->dispatch_time, other_struct.dispatch_time))
    return false;
  if (!mojo::Equals(this->client_arrival_time, other_struct.client_arrival_time))
    return false;
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->on_critical_path, other_struct.on_critical_path))
    return false;
  if (!mojo::Equals(this->animate_only, other_struct.animate_only))
    return false;
  return true;
}

template <typename T, BeginFrameArgs::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.frame_time < rhs.frame_time)
    return true;
  if (rhs.frame_time < lhs.frame_time)
    return false;
  if (lhs.deadline < rhs.deadline)
    return true;
  if (rhs.deadline < lhs.deadline)
    return false;
  if (lhs.interval < rhs.interval)
    return true;
  if (rhs.interval < lhs.interval)
    return false;
  if (lhs.frame_id < rhs.frame_id)
    return true;
  if (rhs.frame_id < lhs.frame_id)
    return false;
  if (lhs.frames_throttled_since_last < rhs.frames_throttled_since_last)
    return true;
  if (rhs.frames_throttled_since_last < lhs.frames_throttled_since_last)
    return false;
  if (lhs.trace_id < rhs.trace_id)
    return true;
  if (rhs.trace_id < lhs.trace_id)
    return false;
  if (lhs.dispatch_time < rhs.dispatch_time)
    return true;
  if (rhs.dispatch_time < lhs.dispatch_time)
    return false;
  if (lhs.client_arrival_time < rhs.client_arrival_time)
    return true;
  if (rhs.client_arrival_time < lhs.client_arrival_time)
    return false;
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  if (lhs.on_critical_path < rhs.on_critical_path)
    return true;
  if (rhs.on_critical_path < lhs.on_critical_path)
    return false;
  if (lhs.animate_only < rhs.animate_only)
    return true;
  if (rhs.animate_only < lhs.animate_only)
    return false;
  return false;
}
template <typename StructPtrType>
BeginFrameAckPtr BeginFrameAck::Clone() const {
  return New(
      mojo::Clone(source_id),
      mojo::Clone(sequence_number),
      mojo::Clone(trace_id),
      mojo::Clone(has_damage)
  );
}

template <typename T, BeginFrameAck::EnableIfSame<T>*>
bool BeginFrameAck::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->source_id, other_struct.source_id))
    return false;
  if (!mojo::Equals(this->sequence_number, other_struct.sequence_number))
    return false;
  if (!mojo::Equals(this->trace_id, other_struct.trace_id))
    return false;
  if (!mojo::Equals(this->has_damage, other_struct.has_damage))
    return false;
  return true;
}

template <typename T, BeginFrameAck::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.source_id < rhs.source_id)
    return true;
  if (rhs.source_id < lhs.source_id)
    return false;
  if (lhs.sequence_number < rhs.sequence_number)
    return true;
  if (rhs.sequence_number < lhs.sequence_number)
    return false;
  if (lhs.trace_id < rhs.trace_id)
    return true;
  if (rhs.trace_id < lhs.trace_id)
    return false;
  if (lhs.has_damage < rhs.has_damage)
    return true;
  if (rhs.has_damage < lhs.has_damage)
    return false;
  return false;
}


}  // viz::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::viz::mojom::blink::BeginFrameId::DataView,
                                         ::viz::mojom::blink::BeginFrameIdPtr> {
  static bool IsNull(const ::viz::mojom::blink::BeginFrameIdPtr& input) { return !input; }
  static void SetToNull(::viz::mojom::blink::BeginFrameIdPtr* output) { output->reset(); }

  static decltype(::viz::mojom::blink::BeginFrameId::source_id) source_id(
      const ::viz::mojom::blink::BeginFrameIdPtr& input) {
    return input->source_id;
  }

  static decltype(::viz::mojom::blink::BeginFrameId::sequence_number) sequence_number(
      const ::viz::mojom::blink::BeginFrameIdPtr& input) {
    return input->sequence_number;
  }

  static bool Read(::viz::mojom::blink::BeginFrameId::DataView input, ::viz::mojom::blink::BeginFrameIdPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::viz::mojom::blink::BeginFrameArgs::DataView,
                                         ::viz::mojom::blink::BeginFrameArgsPtr> {
  static bool IsNull(const ::viz::mojom::blink::BeginFrameArgsPtr& input) { return !input; }
  static void SetToNull(::viz::mojom::blink::BeginFrameArgsPtr* output) { output->reset(); }

  static const decltype(::viz::mojom::blink::BeginFrameArgs::frame_time)& frame_time(
      const ::viz::mojom::blink::BeginFrameArgsPtr& input) {
    return input->frame_time;
  }

  static const decltype(::viz::mojom::blink::BeginFrameArgs::deadline)& deadline(
      const ::viz::mojom::blink::BeginFrameArgsPtr& input) {
    return input->deadline;
  }

  static const decltype(::viz::mojom::blink::BeginFrameArgs::interval)& interval(
      const ::viz::mojom::blink::BeginFrameArgsPtr& input) {
    return input->interval;
  }

  static const decltype(::viz::mojom::blink::BeginFrameArgs::frame_id)& frame_id(
      const ::viz::mojom::blink::BeginFrameArgsPtr& input) {
    return input->frame_id;
  }

  static decltype(::viz::mojom::blink::BeginFrameArgs::frames_throttled_since_last) frames_throttled_since_last(
      const ::viz::mojom::blink::BeginFrameArgsPtr& input) {
    return input->frames_throttled_since_last;
  }

  static decltype(::viz::mojom::blink::BeginFrameArgs::trace_id) trace_id(
      const ::viz::mojom::blink::BeginFrameArgsPtr& input) {
    return input->trace_id;
  }

  static const decltype(::viz::mojom::blink::BeginFrameArgs::dispatch_time)& dispatch_time(
      const ::viz::mojom::blink::BeginFrameArgsPtr& input) {
    return input->dispatch_time;
  }

  static const decltype(::viz::mojom::blink::BeginFrameArgs::client_arrival_time)& client_arrival_time(
      const ::viz::mojom::blink::BeginFrameArgsPtr& input) {
    return input->client_arrival_time;
  }

  static decltype(::viz::mojom::blink::BeginFrameArgs::type) type(
      const ::viz::mojom::blink::BeginFrameArgsPtr& input) {
    return input->type;
  }

  static decltype(::viz::mojom::blink::BeginFrameArgs::on_critical_path) on_critical_path(
      const ::viz::mojom::blink::BeginFrameArgsPtr& input) {
    return input->on_critical_path;
  }

  static decltype(::viz::mojom::blink::BeginFrameArgs::animate_only) animate_only(
      const ::viz::mojom::blink::BeginFrameArgsPtr& input) {
    return input->animate_only;
  }

  static bool Read(::viz::mojom::blink::BeginFrameArgs::DataView input, ::viz::mojom::blink::BeginFrameArgsPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::viz::mojom::blink::BeginFrameAck::DataView,
                                         ::viz::mojom::blink::BeginFrameAckPtr> {
  static bool IsNull(const ::viz::mojom::blink::BeginFrameAckPtr& input) { return !input; }
  static void SetToNull(::viz::mojom::blink::BeginFrameAckPtr* output) { output->reset(); }

  static decltype(::viz::mojom::blink::BeginFrameAck::source_id) source_id(
      const ::viz::mojom::blink::BeginFrameAckPtr& input) {
    return input->source_id;
  }

  static decltype(::viz::mojom::blink::BeginFrameAck::sequence_number) sequence_number(
      const ::viz::mojom::blink::BeginFrameAckPtr& input) {
    return input->sequence_number;
  }

  static decltype(::viz::mojom::blink::BeginFrameAck::trace_id) trace_id(
      const ::viz::mojom::blink::BeginFrameAckPtr& input) {
    return input->trace_id;
  }

  static decltype(::viz::mojom::blink::BeginFrameAck::has_damage) has_damage(
      const ::viz::mojom::blink::BeginFrameAckPtr& input) {
    return input->has_damage;
  }

  static bool Read(::viz::mojom::blink::BeginFrameAck::DataView input, ::viz::mojom::blink::BeginFrameAckPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_BEGIN_FRAME_ARGS_MOJOM_BLINK_H_