// services/viz/public/mojom/compositing/animation.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/viz/public/mojom/compositing/animation.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/viz/public/mojom/compositing/animation.mojom-params-data.h"
namespace viz {
namespace mojom {

NOINLINE static const char* TimingStepPositionToStringHelper(TimingStepPosition value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case TimingStepPosition::kStart:
      return "kStart";
    case TimingStepPosition::kEnd:
      return "kEnd";
    case TimingStepPosition::kJumpBoth:
      return "kJumpBoth";
    case TimingStepPosition::kJumpEnd:
      return "kJumpEnd";
    case TimingStepPosition::kJumpNone:
      return "kJumpNone";
    case TimingStepPosition::kJumpStart:
      return "kJumpStart";
    default:
      return nullptr;
  }
}

std::string TimingStepPositionToString(TimingStepPosition value) {
  const char *str = TimingStepPositionToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown TimingStepPosition value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, TimingStepPosition value) {
  return os << TimingStepPositionToString(value);
}

NOINLINE static const char* AnimationDirectionToStringHelper(AnimationDirection value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case AnimationDirection::kNormal:
      return "kNormal";
    case AnimationDirection::kReverse:
      return "kReverse";
    case AnimationDirection::kAlternateNormal:
      return "kAlternateNormal";
    case AnimationDirection::kAlternateReverse:
      return "kAlternateReverse";
    default:
      return nullptr;
  }
}

std::string AnimationDirectionToString(AnimationDirection value) {
  const char *str = AnimationDirectionToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown AnimationDirection value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, AnimationDirection value) {
  return os << AnimationDirectionToString(value);
}

NOINLINE static const char* AnimationFillModeToStringHelper(AnimationFillMode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case AnimationFillMode::kNone:
      return "kNone";
    case AnimationFillMode::kForwards:
      return "kForwards";
    case AnimationFillMode::kBackwards:
      return "kBackwards";
    case AnimationFillMode::kBoth:
      return "kBoth";
    case AnimationFillMode::kAuto:
      return "kAuto";
    default:
      return nullptr;
  }
}

std::string AnimationFillModeToString(AnimationFillMode value) {
  const char *str = AnimationFillModeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown AnimationFillMode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, AnimationFillMode value) {
  return os << AnimationFillModeToString(value);
}

namespace internal {
// static
bool TimingFunction_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const TimingFunction_Data* object = static_cast<const TimingFunction_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case TimingFunction_Tag::kCubicBezier: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_cubic_bezier, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_cubic_bezier, validation_context))
        return false;
      return true;
    }
    case TimingFunction_Tag::kSteps: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_steps, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_steps, validation_context))
        return false;
      return true;
    }
    case TimingFunction_Tag::kLinear: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_linear, 3, validation_context)) {
        return false;
      }
      constexpr const mojo::internal::ContainerValidateParams& linear_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      if (!mojo::internal::ValidateContainer(object->data.f_linear, validation_context,
                                             &linear_validate_params)) {
        return false;
      }
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in TimingFunction");
      return false;
    }
  }
}
// static
bool TransformOperation_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const TransformOperation_Data* object = static_cast<const TransformOperation_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case TransformOperation_Tag::kIdentity: {

      return true;
    }
    case TransformOperation_Tag::kPerspectiveDepth: {

      return true;
    }
    case TransformOperation_Tag::kSkew: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_skew, 3, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_skew, validation_context))
        return false;
      return true;
    }
    case TransformOperation_Tag::kScale: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_scale, 4, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_scale, validation_context))
        return false;
      return true;
    }
    case TransformOperation_Tag::kTranslate: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_translate, 5, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_translate, validation_context))
        return false;
      return true;
    }
    case TransformOperation_Tag::kRotate: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_rotate, 6, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_rotate, validation_context))
        return false;
      return true;
    }
    case TransformOperation_Tag::kMatrix: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_matrix, 7, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_matrix, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in TransformOperation");
      return false;
    }
  }
}
// static
bool AnimationKeyframeValue_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const AnimationKeyframeValue_Data* object = static_cast<const AnimationKeyframeValue_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case AnimationKeyframeValue_Tag::kScalar: {

      return true;
    }
    case AnimationKeyframeValue_Tag::kColor: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_color, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_color, validation_context))
        return false;
      return true;
    }
    case AnimationKeyframeValue_Tag::kSize: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_size, 3, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_size, validation_context))
        return false;
      return true;
    }
    case AnimationKeyframeValue_Tag::kRect: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_rect, 4, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_rect, validation_context))
        return false;
      return true;
    }
    case AnimationKeyframeValue_Tag::kTransform: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_transform, 5, validation_context)) {
        return false;
      }
      constexpr const mojo::internal::ContainerValidateParams& transform_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      if (!mojo::internal::ValidateContainer(object->data.f_transform, validation_context,
                                             &transform_validate_params)) {
        return false;
      }
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in AnimationKeyframeValue");
      return false;
    }
  }
}


// static
bool CubicBezierTimingFunction_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CubicBezierTimingFunction_Data* object =
      static_cast<const CubicBezierTimingFunction_Data*>(data);

  return true;
}

CubicBezierTimingFunction_Data::CubicBezierTimingFunction_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool StepsTimingFunction_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const StepsTimingFunction_Data* object =
      static_cast<const StepsTimingFunction_Data*>(data);


  if (!::viz::mojom::internal::TimingStepPosition_Data
        ::Validate(object->step_position, validation_context))
    return false;

  return true;
}

StepsTimingFunction_Data::StepsTimingFunction_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LinearEasingPoint_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LinearEasingPoint_Data* object =
      static_cast<const LinearEasingPoint_Data*>(data);

  return true;
}

LinearEasingPoint_Data::LinearEasingPoint_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AxisAngle_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AxisAngle_Data* object =
      static_cast<const AxisAngle_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->axis, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->axis, validation_context))
    return false;

  return true;
}

AxisAngle_Data::AxisAngle_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AnimationKeyframe_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AnimationKeyframe_Data* object =
      static_cast<const AnimationKeyframe_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->value, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->value, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->start_time, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->start_time, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnion(object->timing_function, validation_context))
    return false;

  return true;
}

AnimationKeyframe_Data::AnimationKeyframe_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AnimationKeyframeModel_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 104, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AnimationKeyframeModel_Data* object =
      static_cast<const AnimationKeyframeModel_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->element_id, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->element_id, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->timing_function, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->timing_function, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->keyframes, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& keyframes_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->keyframes, validation_context,
                                         &keyframes_validate_params)) {
    return false;
  }


  if (!::viz::mojom::internal::AnimationDirection_Data
        ::Validate(object->direction, validation_context))
    return false;


  if (!::viz::mojom::internal::AnimationFillMode_Data
        ::Validate(object->fill_mode, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->time_offset, 13, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->time_offset, validation_context))
    return false;

  return true;
}

AnimationKeyframeModel_Data::AnimationKeyframeModel_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Animation_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Animation_Data* object =
      static_cast<const Animation_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->element_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->element_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->keyframe_models, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& keyframe_models_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->keyframe_models, validation_context,
                                         &keyframe_models_validate_params)) {
    return false;
  }

  return true;
}

Animation_Data::Animation_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AnimationTimeline_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AnimationTimeline_Data* object =
      static_cast<const AnimationTimeline_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->new_animations, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& new_animations_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->new_animations, validation_context,
                                         &new_animations_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->removed_animations, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& removed_animations_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->removed_animations, validation_context,
                                         &removed_animations_validate_params)) {
    return false;
  }

  return true;
}

AnimationTimeline_Data::AnimationTimeline_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace viz

namespace perfetto {

// static
void TraceFormatTraits<::viz::mojom::TimingStepPosition>::WriteIntoTrace(
   perfetto::TracedValue context, ::viz::mojom::TimingStepPosition value) {
  return std::move(context).WriteString(::viz::mojom::TimingStepPositionToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::viz::mojom::AnimationDirection>::WriteIntoTrace(
   perfetto::TracedValue context, ::viz::mojom::AnimationDirection value) {
  return std::move(context).WriteString(::viz::mojom::AnimationDirectionToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::viz::mojom::AnimationFillMode>::WriteIntoTrace(
   perfetto::TracedValue context, ::viz::mojom::AnimationFillMode value) {
  return std::move(context).WriteString(::viz::mojom::AnimationFillModeToString(value));
}

} // namespace perfetto