// services/viz/public/mojom/compositing/animation.mojom-shared-internal.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_ANIMATION_MOJOM_SHARED_INTERNAL_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_ANIMATION_MOJOM_SHARED_INTERNAL_H_
#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/message_fragment.h"
#include "mojo/public/c/system/macros.h"
#include "cc/mojom/element_id.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared-internal.h"
#include "skia/public/mojom/skcolor.mojom-shared-internal.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared-internal.h"
#include "ui/gfx/mojom/transform.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/interfaces/bindings/native_struct.mojom-shared-internal.h"



namespace mojo {
namespace internal {
class ValidationContext;
}
}


namespace viz::mojom {
namespace internal {
class CubicBezierTimingFunction_Data;
class StepsTimingFunction_Data;
class LinearEasingPoint_Data;
class AxisAngle_Data;
class AnimationKeyframe_Data;
class AnimationKeyframeModel_Data;
class Animation_Data;
class AnimationTimeline_Data;
class TimingFunction_Data;
class TransformOperation_Data;
class AnimationKeyframeValue_Data;

struct TimingStepPosition_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
      case 3:
      case 4:
      case 5:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct AnimationDirection_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
      case 3:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct AnimationFillMode_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
      case 3:
      case 4:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

#pragma pack(push, 1)


class  TimingFunction_Data {
 public:
  // Used to identify Mojom Union Data Classes.
  typedef void MojomUnionDataType;

  TimingFunction_Data() = default;
  // Do nothing in the destructor since it won't be called when it is a
  // non-inlined union.
  ~TimingFunction_Data() = default;

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context,
                       bool inlined);

  bool is_null() const { return size == 0; }

  void set_null() {
    size = 0U;
    tag = static_cast<TimingFunction_Tag>(0);
    data.unknown = 0U;
  }

  // TODO(crbug.com/40731316): SHOUTY_CASE values are being deprecated per C++ code style
  // guidelines (https://google.github.io/styleguide/cppguide.html#Enumerator_Names),
  // please use kCamelCase values instead.  Cleanup NULL_VALUE, BOOL_VALUE, INT_VALUE, etc.
  // generation once codebase is transitioned to kNullValue, kBoolValue, kIntValue, etc.
  enum class TimingFunction_Tag : uint32_t {

    
    kCubicBezier,
    
    kSteps,
    
    kLinear,
  };

  // A note on layout:
  // "Each non-static data member is allocated as if it were the sole member of
  // a struct." - Section 9.5.2 ISO/IEC 14882:2011 (The C++ Spec)
  union MOJO_ALIGNAS(8) Union_ {
    Union_() : unknown(0) {}
    mojo::internal::Pointer<internal::CubicBezierTimingFunction_Data> f_cubic_bezier;
    mojo::internal::Pointer<internal::StepsTimingFunction_Data> f_steps;
    mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::LinearEasingPoint_Data>>> f_linear;
    uint64_t unknown;
  };

  uint32_t size;
  TimingFunction_Tag tag;
  Union_ data;
};
static_assert(sizeof(TimingFunction_Data) == mojo::internal::kUnionDataSize,
              "Bad sizeof(TimingFunction_Data)");


class  TransformOperation_Data {
 public:
  // Used to identify Mojom Union Data Classes.
  typedef void MojomUnionDataType;

  TransformOperation_Data() = default;
  // Do nothing in the destructor since it won't be called when it is a
  // non-inlined union.
  ~TransformOperation_Data() = default;

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context,
                       bool inlined);

  bool is_null() const { return size == 0; }

  void set_null() {
    size = 0U;
    tag = static_cast<TransformOperation_Tag>(0);
    data.unknown = 0U;
  }

  // TODO(crbug.com/40731316): SHOUTY_CASE values are being deprecated per C++ code style
  // guidelines (https://google.github.io/styleguide/cppguide.html#Enumerator_Names),
  // please use kCamelCase values instead.  Cleanup NULL_VALUE, BOOL_VALUE, INT_VALUE, etc.
  // generation once codebase is transitioned to kNullValue, kBoolValue, kIntValue, etc.
  enum class TransformOperation_Tag : uint32_t {

    
    kIdentity,
    
    kPerspectiveDepth,
    
    kSkew,
    
    kScale,
    
    kTranslate,
    
    kRotate,
    
    kMatrix,
  };

  // A note on layout:
  // "Each non-static data member is allocated as if it were the sole member of
  // a struct." - Section 9.5.2 ISO/IEC 14882:2011 (The C++ Spec)
  union MOJO_ALIGNAS(8) Union_ {
    Union_() : unknown(0) {}
    uint8_t f_identity : 1;
    float f_perspective_depth;
    mojo::internal::Pointer<::gfx::mojom::internal::Vector2dF_Data> f_skew;
    mojo::internal::Pointer<::gfx::mojom::internal::Vector3dF_Data> f_scale;
    mojo::internal::Pointer<::gfx::mojom::internal::Vector3dF_Data> f_translate;
    mojo::internal::Pointer<internal::AxisAngle_Data> f_rotate;
    mojo::internal::Pointer<::gfx::mojom::internal::Transform_Data> f_matrix;
    uint64_t unknown;
  };

  uint32_t size;
  TransformOperation_Tag tag;
  Union_ data;
};
static_assert(sizeof(TransformOperation_Data) == mojo::internal::kUnionDataSize,
              "Bad sizeof(TransformOperation_Data)");


class  AnimationKeyframeValue_Data {
 public:
  // Used to identify Mojom Union Data Classes.
  typedef void MojomUnionDataType;

  AnimationKeyframeValue_Data() = default;
  // Do nothing in the destructor since it won't be called when it is a
  // non-inlined union.
  ~AnimationKeyframeValue_Data() = default;

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context,
                       bool inlined);

  bool is_null() const { return size == 0; }

  void set_null() {
    size = 0U;
    tag = static_cast<AnimationKeyframeValue_Tag>(0);
    data.unknown = 0U;
  }

  // TODO(crbug.com/40731316): SHOUTY_CASE values are being deprecated per C++ code style
  // guidelines (https://google.github.io/styleguide/cppguide.html#Enumerator_Names),
  // please use kCamelCase values instead.  Cleanup NULL_VALUE, BOOL_VALUE, INT_VALUE, etc.
  // generation once codebase is transitioned to kNullValue, kBoolValue, kIntValue, etc.
  enum class AnimationKeyframeValue_Tag : uint32_t {

    
    kScalar,
    
    kColor,
    
    kSize,
    
    kRect,
    
    kTransform,
  };

  // A note on layout:
  // "Each non-static data member is allocated as if it were the sole member of
  // a struct." - Section 9.5.2 ISO/IEC 14882:2011 (The C++ Spec)
  union MOJO_ALIGNAS(8) Union_ {
    Union_() : unknown(0) {}
    float f_scalar;
    mojo::internal::Pointer<::skia::mojom::internal::SkColor_Data> f_color;
    mojo::internal::Pointer<::gfx::mojom::internal::SizeF_Data> f_size;
    mojo::internal::Pointer<::gfx::mojom::internal::Rect_Data> f_rect;
    mojo::internal::Pointer<mojo::internal::Array_Data<internal::TransformOperation_Data>> f_transform;
    uint64_t unknown;
  };

  uint32_t size;
  AnimationKeyframeValue_Tag tag;
  Union_ data;
};
static_assert(sizeof(AnimationKeyframeValue_Data) == mojo::internal::kUnionDataSize,
              "Bad sizeof(AnimationKeyframeValue_Data)");
class  CubicBezierTimingFunction_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  double x1;
  double y1;
  double x2;
  double y2;

 private:
  friend class mojo::internal::MessageFragment<CubicBezierTimingFunction_Data>;

  CubicBezierTimingFunction_Data();
  ~CubicBezierTimingFunction_Data() = delete;
};
static_assert(sizeof(CubicBezierTimingFunction_Data) == 40,
              "Bad sizeof(CubicBezierTimingFunction_Data)");
// Used by CubicBezierTimingFunction::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct CubicBezierTimingFunction_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  CubicBezierTimingFunction_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~CubicBezierTimingFunction_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<CubicBezierTimingFunction_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    CubicBezierTimingFunction_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  StepsTimingFunction_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint32_t num_steps;
  int32_t step_position;

 private:
  friend class mojo::internal::MessageFragment<StepsTimingFunction_Data>;

  StepsTimingFunction_Data();
  ~StepsTimingFunction_Data() = delete;
};
static_assert(sizeof(StepsTimingFunction_Data) == 16,
              "Bad sizeof(StepsTimingFunction_Data)");
// Used by StepsTimingFunction::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct StepsTimingFunction_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  StepsTimingFunction_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~StepsTimingFunction_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<StepsTimingFunction_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    StepsTimingFunction_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  LinearEasingPoint_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  double in;
  double out;

 private:
  friend class mojo::internal::MessageFragment<LinearEasingPoint_Data>;

  LinearEasingPoint_Data();
  ~LinearEasingPoint_Data() = delete;
};
static_assert(sizeof(LinearEasingPoint_Data) == 24,
              "Bad sizeof(LinearEasingPoint_Data)");
// Used by LinearEasingPoint::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct LinearEasingPoint_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  LinearEasingPoint_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~LinearEasingPoint_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<LinearEasingPoint_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    LinearEasingPoint_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  AxisAngle_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::gfx::mojom::internal::Vector3dF_Data> axis;
  float angle;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<AxisAngle_Data>;

  AxisAngle_Data();
  ~AxisAngle_Data() = delete;
};
static_assert(sizeof(AxisAngle_Data) == 24,
              "Bad sizeof(AxisAngle_Data)");
// Used by AxisAngle::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct AxisAngle_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  AxisAngle_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~AxisAngle_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<AxisAngle_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    AxisAngle_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  AnimationKeyframe_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  internal::AnimationKeyframeValue_Data value;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> start_time;
  internal::TimingFunction_Data timing_function;

 private:
  friend class mojo::internal::MessageFragment<AnimationKeyframe_Data>;

  AnimationKeyframe_Data();
  ~AnimationKeyframe_Data() = delete;
};
static_assert(sizeof(AnimationKeyframe_Data) == 48,
              "Bad sizeof(AnimationKeyframe_Data)");
// Used by AnimationKeyframe::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct AnimationKeyframe_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  AnimationKeyframe_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~AnimationKeyframe_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<AnimationKeyframe_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    AnimationKeyframe_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  AnimationKeyframeModel_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t id;
  int32_t group_id;
  int32_t target_property_type;
  int32_t direction;
  mojo::internal::Pointer<::cc::mojom::internal::ElementId_Data> element_id;
  internal::TimingFunction_Data timing_function;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::AnimationKeyframe_Data>>> keyframes;
  double scaled_duration;
  int32_t fill_mode;
  uint8_t pad8_[4];
  double playback_rate;
  double iterations;
  double iteration_start;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> time_offset;

 private:
  friend class mojo::internal::MessageFragment<AnimationKeyframeModel_Data>;

  AnimationKeyframeModel_Data();
  ~AnimationKeyframeModel_Data() = delete;
};
static_assert(sizeof(AnimationKeyframeModel_Data) == 104,
              "Bad sizeof(AnimationKeyframeModel_Data)");
// Used by AnimationKeyframeModel::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct AnimationKeyframeModel_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  AnimationKeyframeModel_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~AnimationKeyframeModel_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<AnimationKeyframeModel_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    AnimationKeyframeModel_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  Animation_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t id;
  uint8_t pad0_[4];
  mojo::internal::Pointer<::cc::mojom::internal::ElementId_Data> element_id;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::AnimationKeyframeModel_Data>>> keyframe_models;

 private:
  friend class mojo::internal::MessageFragment<Animation_Data>;

  Animation_Data();
  ~Animation_Data() = delete;
};
static_assert(sizeof(Animation_Data) == 32,
              "Bad sizeof(Animation_Data)");
// Used by Animation::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct Animation_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  Animation_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~Animation_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<Animation_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    Animation_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  AnimationTimeline_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t id;
  uint8_t pad0_[4];
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::Animation_Data>>> new_animations;
  mojo::internal::Pointer<mojo::internal::Array_Data<int32_t>> removed_animations;

 private:
  friend class mojo::internal::MessageFragment<AnimationTimeline_Data>;

  AnimationTimeline_Data();
  ~AnimationTimeline_Data() = delete;
};
static_assert(sizeof(AnimationTimeline_Data) == 32,
              "Bad sizeof(AnimationTimeline_Data)");
// Used by AnimationTimeline::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct AnimationTimeline_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  AnimationTimeline_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~AnimationTimeline_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<AnimationTimeline_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    AnimationTimeline_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};

#pragma pack(pop)

}  // namespace internal

}  // viz::mojom

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_ANIMATION_MOJOM_SHARED_INTERNAL_H_