// services/viz/public/mojom/compositing/animation.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_ANIMATION_MOJOM_SEND_VALIDATION_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_ANIMATION_MOJOM_SEND_VALIDATION_H_

#include "services/viz/public/mojom/compositing/animation.mojom-shared-internal.h"
#include "cc/mojom/element_id.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "skia/public/mojom/skcolor.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/transform.mojom-shared.h"

#include "services/viz/public/mojom/compositing/animation.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::viz::mojom::TimingStepPosition, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::viz::mojom::AnimationDirection, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::viz::mojom::AnimationFillMode, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::viz::mojom::CubicBezierTimingFunctionDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::CubicBezierTimingFunctionDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::CubicBezierTimingFunction_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->x1 = Traits::x1(input);

      fragment->y1 = Traits::y1(input);

      fragment->x2 = Traits::x2(input);

      fragment->y2 = Traits::y2(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::viz::mojom::StepsTimingFunctionDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::StepsTimingFunctionDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::StepsTimingFunction_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->num_steps = Traits::num_steps(input);

      
      mojo::internal::Serialize<::viz::mojom::TimingStepPosition>(
        Traits::step_position(input),
        &fragment->step_position);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::viz::mojom::LinearEasingPointDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::LinearEasingPointDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::LinearEasingPoint_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->in = Traits::in(input);

      fragment->out = Traits::out(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::viz::mojom::AxisAngleDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::AxisAngleDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::AxisAngle_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::axis(input)) in_axis = Traits::axis(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->axis)::BaseType> axis_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::Vector3dFDataView, send_validation>(
        in_axis,
        axis_fragment);

      fragment->axis.Set(
          axis_fragment.is_null() ? nullptr : axis_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->axis.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null axis in AxisAngle struct");

      fragment->angle = Traits::angle(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::viz::mojom::AnimationKeyframeDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::AnimationKeyframeDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::AnimationKeyframe_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::value(input)) in_value = Traits::value(input);
      mojo::internal::MessageFragment<decltype(fragment->value)>
          value_fragment(fragment.message());
      value_fragment.Claim(&fragment->value);
      
      mojo::internal::Serialize<::viz::mojom::AnimationKeyframeValueDataView, send_validation>(
        in_value,
        value_fragment,
        true);

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->value.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null value in AnimationKeyframe struct");

      decltype(Traits::start_time(input)) in_start_time = Traits::start_time(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->start_time)::BaseType> start_time_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_start_time,
        start_time_fragment);

      fragment->start_time.Set(
          start_time_fragment.is_null() ? nullptr : start_time_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->start_time.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null start_time in AnimationKeyframe struct");

      decltype(Traits::timing_function(input)) in_timing_function = Traits::timing_function(input);
      mojo::internal::MessageFragment<decltype(fragment->timing_function)>
          timing_function_fragment(fragment.message());
      timing_function_fragment.Claim(&fragment->timing_function);
      
      mojo::internal::Serialize<::viz::mojom::TimingFunctionDataView, send_validation>(
        in_timing_function,
        timing_function_fragment,
        true);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::viz::mojom::AnimationKeyframeModelDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::AnimationKeyframeModelDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::AnimationKeyframeModel_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->id = Traits::id(input);

      fragment->group_id = Traits::group_id(input);

      fragment->target_property_type = Traits::target_property_type(input);

      decltype(Traits::element_id(input)) in_element_id = Traits::element_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->element_id)::BaseType> element_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::cc::mojom::ElementIdDataView, send_validation>(
        in_element_id,
        element_id_fragment);

      fragment->element_id.Set(
          element_id_fragment.is_null() ? nullptr : element_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->element_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null element_id in AnimationKeyframeModel struct");

      decltype(Traits::timing_function(input)) in_timing_function = Traits::timing_function(input);
      mojo::internal::MessageFragment<decltype(fragment->timing_function)>
          timing_function_fragment(fragment.message());
      timing_function_fragment.Claim(&fragment->timing_function);
      
      mojo::internal::Serialize<::viz::mojom::TimingFunctionDataView, send_validation>(
        in_timing_function,
        timing_function_fragment,
        true);

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->timing_function.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null timing_function in AnimationKeyframeModel struct");

      decltype(Traits::keyframes(input)) in_keyframes = Traits::keyframes(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->keyframes)::BaseType>
          keyframes_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& keyframes_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::AnimationKeyframeDataView>, send_validation>(
        in_keyframes,
        keyframes_fragment,
        &keyframes_validate_params);

      fragment->keyframes.Set(
          keyframes_fragment.is_null() ? nullptr : keyframes_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->keyframes.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null keyframes in AnimationKeyframeModel struct");

      fragment->scaled_duration = Traits::scaled_duration(input);

      
      mojo::internal::Serialize<::viz::mojom::AnimationDirection>(
        Traits::direction(input),
        &fragment->direction);

      
      mojo::internal::Serialize<::viz::mojom::AnimationFillMode>(
        Traits::fill_mode(input),
        &fragment->fill_mode);

      fragment->playback_rate = Traits::playback_rate(input);

      fragment->iterations = Traits::iterations(input);

      fragment->iteration_start = Traits::iteration_start(input);

      decltype(Traits::time_offset(input)) in_time_offset = Traits::time_offset(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->time_offset)::BaseType> time_offset_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_time_offset,
        time_offset_fragment);

      fragment->time_offset.Set(
          time_offset_fragment.is_null() ? nullptr : time_offset_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->time_offset.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null time_offset in AnimationKeyframeModel struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::viz::mojom::AnimationDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::AnimationDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::Animation_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->id = Traits::id(input);

      decltype(Traits::element_id(input)) in_element_id = Traits::element_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->element_id)::BaseType> element_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::cc::mojom::ElementIdDataView, send_validation>(
        in_element_id,
        element_id_fragment);

      fragment->element_id.Set(
          element_id_fragment.is_null() ? nullptr : element_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->element_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null element_id in Animation struct");

      decltype(Traits::keyframe_models(input)) in_keyframe_models = Traits::keyframe_models(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->keyframe_models)::BaseType>
          keyframe_models_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& keyframe_models_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::AnimationKeyframeModelDataView>, send_validation>(
        in_keyframe_models,
        keyframe_models_fragment,
        &keyframe_models_validate_params);

      fragment->keyframe_models.Set(
          keyframe_models_fragment.is_null() ? nullptr : keyframe_models_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->keyframe_models.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null keyframe_models in Animation struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::viz::mojom::AnimationTimelineDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::AnimationTimelineDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::AnimationTimeline_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->id = Traits::id(input);

      decltype(Traits::new_animations(input)) in_new_animations = Traits::new_animations(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->new_animations)::BaseType>
          new_animations_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& new_animations_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::AnimationDataView>, send_validation>(
        in_new_animations,
        new_animations_fragment,
        &new_animations_validate_params);

      fragment->new_animations.Set(
          new_animations_fragment.is_null() ? nullptr : new_animations_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->new_animations.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null new_animations in AnimationTimeline struct");

      decltype(Traits::removed_animations(input)) in_removed_animations = Traits::removed_animations(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->removed_animations)::BaseType>
          removed_animations_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& removed_animations_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<int32_t>, send_validation>(
        in_removed_animations,
        removed_animations_fragment,
        &removed_animations_validate_params);

      fragment->removed_animations.Set(
          removed_animations_fragment.is_null() ? nullptr : removed_animations_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->removed_animations.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null removed_animations in AnimationTimeline struct");
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::viz::mojom::TimingFunctionDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::viz::mojom::TimingFunctionDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::viz::mojom::internal::TimingFunction_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::viz::mojom::TimingFunctionDataView::Tag::kCubicBezier: {
    decltype(Traits::cubic_bezier(input))
    in_cubic_bezier = Traits::cubic_bezier(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_cubic_bezier)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::viz::mojom::CubicBezierTimingFunctionDataView, send_validation>(
  in_cubic_bezier,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null cubic_bezier in TimingFunction union");
    fragment->data.f_cubic_bezier.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::viz::mojom::TimingFunctionDataView::Tag::kSteps: {
    decltype(Traits::steps(input))
    in_steps = Traits::steps(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_steps)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::viz::mojom::StepsTimingFunctionDataView, send_validation>(
  in_steps,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null steps in TimingFunction union");
    fragment->data.f_steps.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::viz::mojom::TimingFunctionDataView::Tag::kLinear: {
    decltype(Traits::linear(input))
    in_linear = Traits::linear(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_linear)::BaseType>
    value_fragment(fragment.message());
        constexpr const mojo::internal::ContainerValidateParams& linear_validate_params =
            mojo::internal::GetArrayValidator<0, false, nullptr>();
        
mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::LinearEasingPointDataView>, send_validation>(
  in_linear,
  value_fragment,
  &linear_validate_params);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null linear in TimingFunction union");
    fragment->data.f_linear.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::viz::mojom::TransformOperationDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::viz::mojom::TransformOperationDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::viz::mojom::internal::TransformOperation_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::viz::mojom::TransformOperationDataView::Tag::kIdentity: {
    decltype(Traits::identity(input))
    in_identity = Traits::identity(input);
    fragment->data.f_identity = in_identity;
    break;
  }
  case ::viz::mojom::TransformOperationDataView::Tag::kPerspectiveDepth: {
    decltype(Traits::perspective_depth(input))
    in_perspective_depth = Traits::perspective_depth(input);
    fragment->data.f_perspective_depth = in_perspective_depth;
    break;
  }
  case ::viz::mojom::TransformOperationDataView::Tag::kSkew: {
    decltype(Traits::skew(input))
    in_skew = Traits::skew(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_skew)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::gfx::mojom::Vector2dFDataView, send_validation>(
  in_skew,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null skew in TransformOperation union");
    fragment->data.f_skew.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::viz::mojom::TransformOperationDataView::Tag::kScale: {
    decltype(Traits::scale(input))
    in_scale = Traits::scale(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_scale)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::gfx::mojom::Vector3dFDataView, send_validation>(
  in_scale,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null scale in TransformOperation union");
    fragment->data.f_scale.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::viz::mojom::TransformOperationDataView::Tag::kTranslate: {
    decltype(Traits::translate(input))
    in_translate = Traits::translate(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_translate)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::gfx::mojom::Vector3dFDataView, send_validation>(
  in_translate,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null translate in TransformOperation union");
    fragment->data.f_translate.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::viz::mojom::TransformOperationDataView::Tag::kRotate: {
    decltype(Traits::rotate(input))
    in_rotate = Traits::rotate(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_rotate)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::viz::mojom::AxisAngleDataView, send_validation>(
  in_rotate,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null rotate in TransformOperation union");
    fragment->data.f_rotate.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::viz::mojom::TransformOperationDataView::Tag::kMatrix: {
    decltype(Traits::matrix(input))
    in_matrix = Traits::matrix(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_matrix)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::gfx::mojom::TransformDataView, send_validation>(
  in_matrix,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null matrix in TransformOperation union");
    fragment->data.f_matrix.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::viz::mojom::AnimationKeyframeValueDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::viz::mojom::AnimationKeyframeValueDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::viz::mojom::internal::AnimationKeyframeValue_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::viz::mojom::AnimationKeyframeValueDataView::Tag::kScalar: {
    decltype(Traits::scalar(input))
    in_scalar = Traits::scalar(input);
    fragment->data.f_scalar = in_scalar;
    break;
  }
  case ::viz::mojom::AnimationKeyframeValueDataView::Tag::kColor: {
    decltype(Traits::color(input))
    in_color = Traits::color(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_color)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::skia::mojom::SkColorDataView, send_validation>(
  in_color,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null color in AnimationKeyframeValue union");
    fragment->data.f_color.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::viz::mojom::AnimationKeyframeValueDataView::Tag::kSize: {
    decltype(Traits::size(input))
    in_size = Traits::size(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_size)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::gfx::mojom::SizeFDataView, send_validation>(
  in_size,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null size in AnimationKeyframeValue union");
    fragment->data.f_size.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::viz::mojom::AnimationKeyframeValueDataView::Tag::kRect: {
    decltype(Traits::rect(input))
    in_rect = Traits::rect(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_rect)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::gfx::mojom::RectDataView, send_validation>(
  in_rect,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null rect in AnimationKeyframeValue union");
    fragment->data.f_rect.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::viz::mojom::AnimationKeyframeValueDataView::Tag::kTransform: {
    decltype(Traits::transform(input))
    in_transform = Traits::transform(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_transform)::BaseType>
    value_fragment(fragment.message());
        constexpr const mojo::internal::ContainerValidateParams& transform_validate_params =
            mojo::internal::GetArrayValidator<0, false, nullptr>();
        
mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::TransformOperationDataView>, send_validation>(
  in_transform,
  value_fragment,
  &transform_validate_params);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null transform in AnimationKeyframeValue union");
    fragment->data.f_transform.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_ANIMATION_MOJOM_SEND_VALIDATION_H_