// services/viz/privileged/mojom/viz_main.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PRIVILEGED_MOJOM_VIZ_MAIN_MOJOM_SEND_VALIDATION_H_
#define SERVICES_VIZ_PRIVILEGED_MOJOM_VIZ_MAIN_MOJOM_SEND_VALIDATION_H_

#include "services/viz/privileged/mojom/viz_main.mojom-shared-internal.h"
#include "components/discardable_memory/public/mojom/discardable_shared_memory_manager.mojom-shared.h"
#include "components/viz/service/debugger/mojom/viz_debugger.mojom-shared.h"
#include "mojo/public/mojom/base/values.mojom-shared.h"
#include "mojo/public/mojom/base/shared_memory.mojom-shared.h"
#include "services/viz/public/mojom/compositing/compositing_mode_watcher.mojom-shared.h"
#include "services/viz/privileged/mojom/compositing/frame_sink_manager.mojom-shared.h"
#include "services/viz/privileged/mojom/compositing/renderer_settings.mojom-shared.h"
#include "services/viz/privileged/mojom/gl/gpu_host.mojom-shared.h"
#include "services/viz/privileged/mojom/gl/gpu_logging.mojom-shared.h"
#include "services/viz/privileged/mojom/gl/gpu_service.mojom-shared.h"
#include "ui/gfx/mojom/font_render_params.mojom-shared.h"

#include "services/viz/privileged/mojom/viz_main.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::viz::mojom::FrameSinkManagerParamsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::FrameSinkManagerParamsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::FrameSinkManagerParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->restart_id = Traits::restart_id(input);

      fragment->use_activation_deadline = Traits::use_activation_deadline(input);

      fragment->activation_deadline_in_frames = Traits::activation_deadline_in_frames(input);

      decltype(Traits::frame_sink_manager(input)) in_frame_sink_manager = Traits::frame_sink_manager(input);

      
      mojo::internal::Serialize<mojo::InterfaceRequestDataView<::viz::mojom::FrameSinkManagerInterfaceBase>>(
        in_frame_sink_manager,
        &fragment->frame_sink_manager,
        &fragment.message());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(!mojo::internal::IsHandleOrInterfaceValid(fragment->frame_sink_manager)),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid frame_sink_manager in FrameSinkManagerParams struct");

      decltype(Traits::frame_sink_manager_client(input)) in_frame_sink_manager_client = Traits::frame_sink_manager_client(input);

      
      mojo::internal::Serialize<mojo::InterfacePtrDataView<::viz::mojom::FrameSinkManagerClientInterfaceBase>>(
        in_frame_sink_manager_client,
        &fragment->frame_sink_manager_client,
        &fragment.message());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(!mojo::internal::IsHandleOrInterfaceValid(fragment->frame_sink_manager_client)),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid frame_sink_manager_client in FrameSinkManagerParams struct");

      decltype(Traits::debug_renderer_settings(input)) in_debug_renderer_settings = Traits::debug_renderer_settings(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->debug_renderer_settings)::BaseType> debug_renderer_settings_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::viz::mojom::DebugRendererSettingsDataView, send_validation>(
        in_debug_renderer_settings,
        debug_renderer_settings_fragment);

      fragment->debug_renderer_settings.Set(
          debug_renderer_settings_fragment.is_null() ? nullptr : debug_renderer_settings_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->debug_renderer_settings.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null debug_renderer_settings in FrameSinkManagerParams struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::viz::mojom::GpuServiceCreationParamsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::GpuServiceCreationParamsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::GpuServiceCreationParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_VIZ_PRIVILEGED_MOJOM_VIZ_MAIN_MOJOM_SEND_VALIDATION_H_