// services/viz/privileged/mojom/gl/gpu_service.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/viz/privileged/mojom/gl/gpu_service.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/viz/privileged/mojom/gl/gpu_service.mojom-params-data.h"
#include "services/viz/privileged/mojom/gl/gpu_service.mojom-shared-message-ids.h"

#include "services/viz/privileged/mojom/gl/gpu_service.mojom-import-headers.h"
#include "services/viz/privileged/mojom/gl/gpu_service.mojom-test-utils.h"


namespace viz::mojom {
// The declaration includes the definition on other builds.

GpuService::IPCStableHashFunction GpuService::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::GpuService>(message.name())) {
    case messages::GpuService::kEstablishGpuChannel: {
      return &GpuService::EstablishGpuChannel_Sym::IPCStableHash;
    }
    case messages::GpuService::kSetChannelClientPid: {
      return &GpuService::SetChannelClientPid_Sym::IPCStableHash;
    }
    case messages::GpuService::kSetChannelDiskCacheHandle: {
      return &GpuService::SetChannelDiskCacheHandle_Sym::IPCStableHash;
    }
    case messages::GpuService::kSetChannelPersistentCachePendingBackend: {
      return &GpuService::SetChannelPersistentCachePendingBackend_Sym::IPCStableHash;
    }
    case messages::GpuService::kOnDiskCacheHandleDestoyed: {
      return &GpuService::OnDiskCacheHandleDestoyed_Sym::IPCStableHash;
    }
    case messages::GpuService::kCloseChannel: {
      return &GpuService::CloseChannel_Sym::IPCStableHash;
    }
    case messages::GpuService::kCreateVideoEncodeAcceleratorProvider: {
      return &GpuService::CreateVideoEncodeAcceleratorProvider_Sym::IPCStableHash;
    }
    case messages::GpuService::kBindWebNNContextProvider: {
      return &GpuService::BindWebNNContextProvider_Sym::IPCStableHash;
    }
    case messages::GpuService::kGetVideoMemoryUsageStats: {
      return &GpuService::GetVideoMemoryUsageStats_Sym::IPCStableHash;
    }
    case messages::GpuService::kStartPeakMemoryMonitor: {
      return &GpuService::StartPeakMemoryMonitor_Sym::IPCStableHash;
    }
    case messages::GpuService::kGetPeakMemoryUsage: {
      return &GpuService::GetPeakMemoryUsage_Sym::IPCStableHash;
    }
    case messages::GpuService::kLoadedBlob: {
      return &GpuService::LoadedBlob_Sym::IPCStableHash;
    }
    case messages::GpuService::kWakeUpGpu: {
      return &GpuService::WakeUpGpu_Sym::IPCStableHash;
    }
    case messages::GpuService::kGpuSwitched: {
      return &GpuService::GpuSwitched_Sym::IPCStableHash;
    }
    case messages::GpuService::kDisplayAdded: {
      return &GpuService::DisplayAdded_Sym::IPCStableHash;
    }
    case messages::GpuService::kDisplayRemoved: {
      return &GpuService::DisplayRemoved_Sym::IPCStableHash;
    }
    case messages::GpuService::kDisplayMetricsChanged: {
      return &GpuService::DisplayMetricsChanged_Sym::IPCStableHash;
    }
    case messages::GpuService::kDestroyAllChannels: {
      return &GpuService::DestroyAllChannels_Sym::IPCStableHash;
    }
    case messages::GpuService::kOnBackgroundCleanup: {
      return &GpuService::OnBackgroundCleanup_Sym::IPCStableHash;
    }
    case messages::GpuService::kOnBackgrounded: {
      return &GpuService::OnBackgrounded_Sym::IPCStableHash;
    }
    case messages::GpuService::kOnForegrounded: {
      return &GpuService::OnForegrounded_Sym::IPCStableHash;
    }
    case messages::GpuService::kOnMemoryPressure: {
      return &GpuService::OnMemoryPressure_Sym::IPCStableHash;
    }
    case messages::GpuService::kBeginCATransaction: {
      return &GpuService::BeginCATransaction_Sym::IPCStableHash;
    }
    case messages::GpuService::kCommitCATransaction: {
      return &GpuService::CommitCATransaction_Sym::IPCStableHash;
    }
    case messages::GpuService::kGetDawnInfo: {
      return &GpuService::GetDawnInfo_Sym::IPCStableHash;
    }
    case messages::GpuService::kCrash: {
      return &GpuService::Crash_Sym::IPCStableHash;
    }
    case messages::GpuService::kHang: {
      return &GpuService::Hang_Sym::IPCStableHash;
    }
    case messages::GpuService::kThrowJavaException: {
      return &GpuService::ThrowJavaException_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* GpuService::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::GpuService>(message.name())) {
      case messages::GpuService::kEstablishGpuChannel:
            return "Receive viz::mojom::GpuService::EstablishGpuChannel";
      case messages::GpuService::kSetChannelClientPid:
            return "Receive viz::mojom::GpuService::SetChannelClientPid";
      case messages::GpuService::kSetChannelDiskCacheHandle:
            return "Receive viz::mojom::GpuService::SetChannelDiskCacheHandle";
      case messages::GpuService::kSetChannelPersistentCachePendingBackend:
            return "Receive viz::mojom::GpuService::SetChannelPersistentCachePendingBackend";
      case messages::GpuService::kOnDiskCacheHandleDestoyed:
            return "Receive viz::mojom::GpuService::OnDiskCacheHandleDestoyed";
      case messages::GpuService::kCloseChannel:
            return "Receive viz::mojom::GpuService::CloseChannel";
      case messages::GpuService::kCreateVideoEncodeAcceleratorProvider:
            return "Receive viz::mojom::GpuService::CreateVideoEncodeAcceleratorProvider";
      case messages::GpuService::kBindWebNNContextProvider:
            return "Receive viz::mojom::GpuService::BindWebNNContextProvider";
      case messages::GpuService::kGetVideoMemoryUsageStats:
            return "Receive viz::mojom::GpuService::GetVideoMemoryUsageStats";
      case messages::GpuService::kStartPeakMemoryMonitor:
            return "Receive viz::mojom::GpuService::StartPeakMemoryMonitor";
      case messages::GpuService::kGetPeakMemoryUsage:
            return "Receive viz::mojom::GpuService::GetPeakMemoryUsage";
      case messages::GpuService::kLoadedBlob:
            return "Receive viz::mojom::GpuService::LoadedBlob";
      case messages::GpuService::kWakeUpGpu:
            return "Receive viz::mojom::GpuService::WakeUpGpu";
      case messages::GpuService::kGpuSwitched:
            return "Receive viz::mojom::GpuService::GpuSwitched";
      case messages::GpuService::kDisplayAdded:
            return "Receive viz::mojom::GpuService::DisplayAdded";
      case messages::GpuService::kDisplayRemoved:
            return "Receive viz::mojom::GpuService::DisplayRemoved";
      case messages::GpuService::kDisplayMetricsChanged:
            return "Receive viz::mojom::GpuService::DisplayMetricsChanged";
      case messages::GpuService::kDestroyAllChannels:
            return "Receive viz::mojom::GpuService::DestroyAllChannels";
      case messages::GpuService::kOnBackgroundCleanup:
            return "Receive viz::mojom::GpuService::OnBackgroundCleanup";
      case messages::GpuService::kOnBackgrounded:
            return "Receive viz::mojom::GpuService::OnBackgrounded";
      case messages::GpuService::kOnForegrounded:
            return "Receive viz::mojom::GpuService::OnForegrounded";
      case messages::GpuService::kOnMemoryPressure:
            return "Receive viz::mojom::GpuService::OnMemoryPressure";
      case messages::GpuService::kBeginCATransaction:
            return "Receive viz::mojom::GpuService::BeginCATransaction";
      case messages::GpuService::kCommitCATransaction:
            return "Receive viz::mojom::GpuService::CommitCATransaction";
      case messages::GpuService::kGetDawnInfo:
            return "Receive viz::mojom::GpuService::GetDawnInfo";
      case messages::GpuService::kCrash:
            return "Receive viz::mojom::GpuService::Crash";
      case messages::GpuService::kHang:
            return "Receive viz::mojom::GpuService::Hang";
      case messages::GpuService::kThrowJavaException:
            return "Receive viz::mojom::GpuService::ThrowJavaException";
    }
  } else {
    switch (static_cast<messages::GpuService>(message.name())) {
      case messages::GpuService::kEstablishGpuChannel:
            return "Receive reply viz::mojom::GpuService::EstablishGpuChannel";
      case messages::GpuService::kSetChannelClientPid:
            return "Receive reply viz::mojom::GpuService::SetChannelClientPid";
      case messages::GpuService::kSetChannelDiskCacheHandle:
            return "Receive reply viz::mojom::GpuService::SetChannelDiskCacheHandle";
      case messages::GpuService::kSetChannelPersistentCachePendingBackend:
            return "Receive reply viz::mojom::GpuService::SetChannelPersistentCachePendingBackend";
      case messages::GpuService::kOnDiskCacheHandleDestoyed:
            return "Receive reply viz::mojom::GpuService::OnDiskCacheHandleDestoyed";
      case messages::GpuService::kCloseChannel:
            return "Receive reply viz::mojom::GpuService::CloseChannel";
      case messages::GpuService::kCreateVideoEncodeAcceleratorProvider:
            return "Receive reply viz::mojom::GpuService::CreateVideoEncodeAcceleratorProvider";
      case messages::GpuService::kBindWebNNContextProvider:
            return "Receive reply viz::mojom::GpuService::BindWebNNContextProvider";
      case messages::GpuService::kGetVideoMemoryUsageStats:
            return "Receive reply viz::mojom::GpuService::GetVideoMemoryUsageStats";
      case messages::GpuService::kStartPeakMemoryMonitor:
            return "Receive reply viz::mojom::GpuService::StartPeakMemoryMonitor";
      case messages::GpuService::kGetPeakMemoryUsage:
            return "Receive reply viz::mojom::GpuService::GetPeakMemoryUsage";
      case messages::GpuService::kLoadedBlob:
            return "Receive reply viz::mojom::GpuService::LoadedBlob";
      case messages::GpuService::kWakeUpGpu:
            return "Receive reply viz::mojom::GpuService::WakeUpGpu";
      case messages::GpuService::kGpuSwitched:
            return "Receive reply viz::mojom::GpuService::GpuSwitched";
      case messages::GpuService::kDisplayAdded:
            return "Receive reply viz::mojom::GpuService::DisplayAdded";
      case messages::GpuService::kDisplayRemoved:
            return "Receive reply viz::mojom::GpuService::DisplayRemoved";
      case messages::GpuService::kDisplayMetricsChanged:
            return "Receive reply viz::mojom::GpuService::DisplayMetricsChanged";
      case messages::GpuService::kDestroyAllChannels:
            return "Receive reply viz::mojom::GpuService::DestroyAllChannels";
      case messages::GpuService::kOnBackgroundCleanup:
            return "Receive reply viz::mojom::GpuService::OnBackgroundCleanup";
      case messages::GpuService::kOnBackgrounded:
            return "Receive reply viz::mojom::GpuService::OnBackgrounded";
      case messages::GpuService::kOnForegrounded:
            return "Receive reply viz::mojom::GpuService::OnForegrounded";
      case messages::GpuService::kOnMemoryPressure:
            return "Receive reply viz::mojom::GpuService::OnMemoryPressure";
      case messages::GpuService::kBeginCATransaction:
            return "Receive reply viz::mojom::GpuService::BeginCATransaction";
      case messages::GpuService::kCommitCATransaction:
            return "Receive reply viz::mojom::GpuService::CommitCATransaction";
      case messages::GpuService::kGetDawnInfo:
            return "Receive reply viz::mojom::GpuService::GetDawnInfo";
      case messages::GpuService::kCrash:
            return "Receive reply viz::mojom::GpuService::Crash";
      case messages::GpuService::kHang:
            return "Receive reply viz::mojom::GpuService::Hang";
      case messages::GpuService::kThrowJavaException:
            return "Receive reply viz::mojom::GpuService::ThrowJavaException";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t GpuService::EstablishGpuChannel_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x65b2aeb0;  // IPCStableHash for viz::mojom::GpuService::EstablishGpuChannel
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GpuService::SetChannelClientPid_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xad4d16e7;  // IPCStableHash for viz::mojom::GpuService::SetChannelClientPid
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GpuService::SetChannelDiskCacheHandle_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x37d38aaf;  // IPCStableHash for viz::mojom::GpuService::SetChannelDiskCacheHandle
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GpuService::SetChannelPersistentCachePendingBackend_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x22ecbcee;  // IPCStableHash for viz::mojom::GpuService::SetChannelPersistentCachePendingBackend
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GpuService::OnDiskCacheHandleDestoyed_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x94aa0ad7;  // IPCStableHash for viz::mojom::GpuService::OnDiskCacheHandleDestoyed
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GpuService::CloseChannel_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x70d16bc8;  // IPCStableHash for viz::mojom::GpuService::CloseChannel
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GpuService::CreateVideoEncodeAcceleratorProvider_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x32b622e6;  // IPCStableHash for viz::mojom::GpuService::CreateVideoEncodeAcceleratorProvider
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GpuService::BindWebNNContextProvider_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xad80536d;  // IPCStableHash for viz::mojom::GpuService::BindWebNNContextProvider
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GpuService::GetVideoMemoryUsageStats_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x42cffd3e;  // IPCStableHash for viz::mojom::GpuService::GetVideoMemoryUsageStats
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GpuService::StartPeakMemoryMonitor_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcc253e18;  // IPCStableHash for viz::mojom::GpuService::StartPeakMemoryMonitor
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GpuService::GetPeakMemoryUsage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfc8a0eab;  // IPCStableHash for viz::mojom::GpuService::GetPeakMemoryUsage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GpuService::LoadedBlob_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3a6a7677;  // IPCStableHash for viz::mojom::GpuService::LoadedBlob
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GpuService::WakeUpGpu_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf705f3b4;  // IPCStableHash for viz::mojom::GpuService::WakeUpGpu
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GpuService::GpuSwitched_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xeeb4f810;  // IPCStableHash for viz::mojom::GpuService::GpuSwitched
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GpuService::DisplayAdded_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6cb25589;  // IPCStableHash for viz::mojom::GpuService::DisplayAdded
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GpuService::DisplayRemoved_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x490c9901;  // IPCStableHash for viz::mojom::GpuService::DisplayRemoved
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GpuService::DisplayMetricsChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe94a0c80;  // IPCStableHash for viz::mojom::GpuService::DisplayMetricsChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GpuService::DestroyAllChannels_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x34f5bde3;  // IPCStableHash for viz::mojom::GpuService::DestroyAllChannels
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GpuService::OnBackgroundCleanup_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc6c1343c;  // IPCStableHash for viz::mojom::GpuService::OnBackgroundCleanup
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GpuService::OnBackgrounded_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6879d3be;  // IPCStableHash for viz::mojom::GpuService::OnBackgrounded
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GpuService::OnForegrounded_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4feb7221;  // IPCStableHash for viz::mojom::GpuService::OnForegrounded
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GpuService::OnMemoryPressure_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3780dd03;  // IPCStableHash for viz::mojom::GpuService::OnMemoryPressure
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GpuService::BeginCATransaction_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9d4e5cab;  // IPCStableHash for viz::mojom::GpuService::BeginCATransaction
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GpuService::CommitCATransaction_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4929d396;  // IPCStableHash for viz::mojom::GpuService::CommitCATransaction
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GpuService::GetDawnInfo_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x64008569;  // IPCStableHash for viz::mojom::GpuService::GetDawnInfo
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GpuService::Crash_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb53a4565;  // IPCStableHash for viz::mojom::GpuService::Crash
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GpuService::Hang_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3141e926;  // IPCStableHash for viz::mojom::GpuService::Hang
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GpuService::ThrowJavaException_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3d58507b;  // IPCStableHash for viz::mojom::GpuService::ThrowJavaException
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)
bool GpuService::EstablishGpuChannel(int32_t client_id, uint64_t client_tracing_id, bool is_gpu_host, bool enable_extra_handles_validation, ::mojo::ScopedMessagePipeHandle* out_channel_handle, ::gpu::GPUInfo* out_gpu_info, ::gpu::GpuFeatureInfo* out_gpu_feature_info, ::gpu::SharedImageCapabilities* out_shared_image_capabilities) {
  NOTREACHED();
}
class GpuService_EstablishGpuChannel_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  GpuService_EstablishGpuChannel_HandleSyncResponse(
      bool* result, ::mojo::ScopedMessagePipeHandle* out_channel_handle, ::gpu::GPUInfo* out_gpu_info, ::gpu::GpuFeatureInfo* out_gpu_feature_info, ::gpu::SharedImageCapabilities* out_shared_image_capabilities)
      : result_(result), out_channel_handle_(out_channel_handle), out_gpu_info_(out_gpu_info), out_gpu_feature_info_(out_gpu_feature_info), out_shared_image_capabilities_(out_shared_image_capabilities) {
    DCHECK(!*result_);
  }

  GpuService_EstablishGpuChannel_HandleSyncResponse(const GpuService_EstablishGpuChannel_HandleSyncResponse&) = delete;
  GpuService_EstablishGpuChannel_HandleSyncResponse& operator=(const GpuService_EstablishGpuChannel_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::mojo::ScopedMessagePipeHandle* out_channel_handle_;
  ::gpu::GPUInfo* out_gpu_info_;
  ::gpu::GpuFeatureInfo* out_gpu_feature_info_;
  ::gpu::SharedImageCapabilities* out_shared_image_capabilities_;};

class GpuService_EstablishGpuChannel_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  GpuService_EstablishGpuChannel_ForwardToCallback(
      GpuService::EstablishGpuChannelCallback callback
      ) : callback_(std::move(callback)) {
  }

  GpuService_EstablishGpuChannel_ForwardToCallback(const GpuService_EstablishGpuChannel_ForwardToCallback&) = delete;
  GpuService_EstablishGpuChannel_ForwardToCallback& operator=(const GpuService_EstablishGpuChannel_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  GpuService::EstablishGpuChannelCallback callback_;
};

class GpuService_GetVideoMemoryUsageStats_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  GpuService_GetVideoMemoryUsageStats_ForwardToCallback(
      GpuService::GetVideoMemoryUsageStatsCallback callback
      ) : callback_(std::move(callback)) {
  }

  GpuService_GetVideoMemoryUsageStats_ForwardToCallback(const GpuService_GetVideoMemoryUsageStats_ForwardToCallback&) = delete;
  GpuService_GetVideoMemoryUsageStats_ForwardToCallback& operator=(const GpuService_GetVideoMemoryUsageStats_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  GpuService::GetVideoMemoryUsageStatsCallback callback_;
};

class GpuService_GetPeakMemoryUsage_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  GpuService_GetPeakMemoryUsage_ForwardToCallback(
      GpuService::GetPeakMemoryUsageCallback callback
      ) : callback_(std::move(callback)) {
  }

  GpuService_GetPeakMemoryUsage_ForwardToCallback(const GpuService_GetPeakMemoryUsage_ForwardToCallback&) = delete;
  GpuService_GetPeakMemoryUsage_ForwardToCallback& operator=(const GpuService_GetPeakMemoryUsage_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  GpuService::GetPeakMemoryUsageCallback callback_;
};

class GpuService_CommitCATransaction_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  GpuService_CommitCATransaction_ForwardToCallback(
      GpuService::CommitCATransactionCallback callback
      ) : callback_(std::move(callback)) {
  }

  GpuService_CommitCATransaction_ForwardToCallback(const GpuService_CommitCATransaction_ForwardToCallback&) = delete;
  GpuService_CommitCATransaction_ForwardToCallback& operator=(const GpuService_CommitCATransaction_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  GpuService::CommitCATransactionCallback callback_;
};

class GpuService_GetDawnInfo_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  GpuService_GetDawnInfo_ForwardToCallback(
      GpuService::GetDawnInfoCallback callback
      ) : callback_(std::move(callback)) {
  }

  GpuService_GetDawnInfo_ForwardToCallback(const GpuService_GetDawnInfo_ForwardToCallback&) = delete;
  GpuService_GetDawnInfo_ForwardToCallback& operator=(const GpuService_GetDawnInfo_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  GpuService::GetDawnInfoCallback callback_;
};

GpuServiceProxy::GpuServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}
bool GpuServiceProxy::EstablishGpuChannel(
    int32_t param_client_id, uint64_t param_client_tracing_id, bool param_is_gpu_host, bool param_enable_extra_handles_validation, ::mojo::ScopedMessagePipeHandle* out_param_channel_handle, ::gpu::GPUInfo* out_param_gpu_info, ::gpu::GpuFeatureInfo* out_param_gpu_feature_info, ::gpu::SharedImageCapabilities* out_param_shared_image_capabilities) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call viz::mojom::GpuService::EstablishGpuChannel (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_id"), param_client_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_tracing_id"), param_client_tracing_id,
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_gpu_host"), param_is_gpu_host,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enable_extra_handles_validation"), param_enable_extra_handles_validation,
                        "<value of type bool>");
   });
#else
  TRACE_EVENT0("mojom", "GpuService::EstablishGpuChannel");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      false;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuService::kEstablishGpuChannel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuService_EstablishGpuChannel_Params_Data> params(
          message);
  params.Allocate();

  params->client_id = param_client_id;

  params->client_tracing_id = param_client_tracing_id;

  params->is_gpu_host = param_is_gpu_host;

  params->enable_extra_handles_validation = param_enable_extra_handles_validation;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("EstablishGpuChannel");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GpuService_EstablishGpuChannel_HandleSyncResponse(
          &result, out_param_channel_handle, out_param_gpu_info, out_param_gpu_feature_info, out_param_shared_image_capabilities));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "GpuService::EstablishGpuChannel", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("channel_handle"), out_param_channel_handle,
                        "<value of type ::mojo::ScopedMessagePipeHandle>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("gpu_info"), out_param_gpu_info,
                        "<value of type const ::gpu::GPUInfo&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("gpu_feature_info"), out_param_gpu_feature_info,
                        "<value of type const ::gpu::GpuFeatureInfo&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("shared_image_capabilities"), out_param_shared_image_capabilities,
                        "<value of type const ::gpu::SharedImageCapabilities&>");
   });
#endif
  return result;
}

void GpuServiceProxy::EstablishGpuChannel(
    int32_t in_client_id, uint64_t in_client_tracing_id, bool in_is_gpu_host, bool in_enable_extra_handles_validation, EstablishGpuChannelCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::GpuService::EstablishGpuChannel", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_id"), in_client_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_tracing_id"), in_client_tracing_id,
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_gpu_host"), in_is_gpu_host,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enable_extra_handles_validation"), in_enable_extra_handles_validation,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuService::kEstablishGpuChannel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuService_EstablishGpuChannel_Params_Data> params(
          message);
  params.Allocate();

  params->client_id = in_client_id;

  params->client_tracing_id = in_client_tracing_id;

  params->is_gpu_host = in_is_gpu_host;

  params->enable_extra_handles_validation = in_enable_extra_handles_validation;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("EstablishGpuChannel");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GpuService_EstablishGpuChannel_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void GpuServiceProxy::SetChannelClientPid(
    int32_t in_client_id, ::base::ProcessId in_client_pid) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::GpuService::SetChannelClientPid", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_id"), in_client_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_pid"), in_client_pid,
                        "<value of type ::base::ProcessId>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuService::kSetChannelClientPid), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuService_SetChannelClientPid_Params_Data> params(
          message);
  params.Allocate();

  params->client_id = in_client_id;
  mojo::internal::MessageFragment<
      typename decltype(params->client_pid)::BaseType> client_pid_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ProcessIdDataView>(
    in_client_pid,
    client_pid_fragment);

  params->client_pid.Set(
      client_pid_fragment.is_null() ? nullptr : client_pid_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->client_pid.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null client_pid in GpuService.SetChannelClientPid request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("SetChannelClientPid");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void GpuServiceProxy::SetChannelDiskCacheHandle(
    int32_t in_client_id, const ::gpu::GpuDiskCacheHandle& in_cache_handle) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::GpuService::SetChannelDiskCacheHandle", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_id"), in_client_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cache_handle"), in_cache_handle,
                        "<value of type const ::gpu::GpuDiskCacheHandle&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuService::kSetChannelDiskCacheHandle), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuService_SetChannelDiskCacheHandle_Params_Data> params(
          message);
  params.Allocate();

  params->client_id = in_client_id;
  mojo::internal::MessageFragment<decltype(params->cache_handle)>
      cache_handle_fragment(params.message());
  cache_handle_fragment.Claim(&params->cache_handle);
  
  mojo::internal::Serialize<::gpu::mojom::GpuDiskCacheHandleDataView>(
    in_cache_handle,
    cache_handle_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->cache_handle.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null cache_handle in GpuService.SetChannelDiskCacheHandle request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("SetChannelDiskCacheHandle");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void GpuServiceProxy::SetChannelPersistentCachePendingBackend(
    int32_t in_client_id, const ::gpu::GpuDiskCacheHandle& in_cache_handle, ::persistent_cache::PendingBackend in_pending_backend) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::GpuService::SetChannelPersistentCachePendingBackend", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_id"), in_client_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cache_handle"), in_cache_handle,
                        "<value of type const ::gpu::GpuDiskCacheHandle&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pending_backend"), in_pending_backend,
                        "<value of type ::persistent_cache::PendingBackend>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuService::kSetChannelPersistentCachePendingBackend), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuService_SetChannelPersistentCachePendingBackend_Params_Data> params(
          message);
  params.Allocate();

  params->client_id = in_client_id;
  mojo::internal::MessageFragment<decltype(params->cache_handle)>
      cache_handle_fragment(params.message());
  cache_handle_fragment.Claim(&params->cache_handle);
  
  mojo::internal::Serialize<::gpu::mojom::GpuDiskCacheHandleDataView>(
    in_cache_handle,
    cache_handle_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->cache_handle.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null cache_handle in GpuService.SetChannelPersistentCachePendingBackend request");
  mojo::internal::MessageFragment<
      typename decltype(params->pending_backend)::BaseType> pending_backend_fragment(
          params.message());
  
  mojo::internal::Serialize<::persistent_cache::mojom::PendingReadWriteBackendDataView>(
    in_pending_backend,
    pending_backend_fragment);

  params->pending_backend.Set(
      pending_backend_fragment.is_null() ? nullptr : pending_backend_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->pending_backend.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null pending_backend in GpuService.SetChannelPersistentCachePendingBackend request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("SetChannelPersistentCachePendingBackend");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void GpuServiceProxy::OnDiskCacheHandleDestoyed(
    const ::gpu::GpuDiskCacheHandle& in_cache_handle) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::GpuService::OnDiskCacheHandleDestoyed", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cache_handle"), in_cache_handle,
                        "<value of type const ::gpu::GpuDiskCacheHandle&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuService::kOnDiskCacheHandleDestoyed), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuService_OnDiskCacheHandleDestoyed_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->cache_handle)>
      cache_handle_fragment(params.message());
  cache_handle_fragment.Claim(&params->cache_handle);
  
  mojo::internal::Serialize<::gpu::mojom::GpuDiskCacheHandleDataView>(
    in_cache_handle,
    cache_handle_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->cache_handle.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null cache_handle in GpuService.OnDiskCacheHandleDestoyed request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("OnDiskCacheHandleDestoyed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void GpuServiceProxy::CloseChannel(
    int32_t in_client_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::GpuService::CloseChannel", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_id"), in_client_id,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuService::kCloseChannel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuService_CloseChannel_Params_Data> params(
          message);
  params.Allocate();

  params->client_id = in_client_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("CloseChannel");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void GpuServiceProxy::CreateVideoEncodeAcceleratorProvider(
    ::mojo::PendingReceiver<::media::mojom::VideoEncodeAcceleratorProvider> in_vea_provider) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::GpuService::CreateVideoEncodeAcceleratorProvider", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("vea_provider"), in_vea_provider,
                        "<value of type ::mojo::PendingReceiver<::media::mojom::VideoEncodeAcceleratorProvider>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuService::kCreateVideoEncodeAcceleratorProvider), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuService_CreateVideoEncodeAcceleratorProvider_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::mojom::VideoEncodeAcceleratorProviderInterfaceBase>>(
    in_vea_provider,
    &params->vea_provider,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->vea_provider)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid vea_provider in GpuService.CreateVideoEncodeAcceleratorProvider request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("CreateVideoEncodeAcceleratorProvider");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void GpuServiceProxy::BindWebNNContextProvider(
    ::mojo::PendingReceiver<::webnn::mojom::WebNNContextProvider> in_receiver, int32_t in_client_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::GpuService::BindWebNNContextProvider", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::webnn::mojom::WebNNContextProvider>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_id"), in_client_id,
                        "<value of type int32_t>");
   });
#endif

  CHECK(base::FeatureList::IsEnabled(::webnn::mojom::features::kWebMachineLearningNeuralNetwork));
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuService::kBindWebNNContextProvider), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuService_BindWebNNContextProvider_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::webnn::mojom::WebNNContextProviderInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  params->client_id = in_client_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("BindWebNNContextProvider");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void GpuServiceProxy::GetVideoMemoryUsageStats(
    GetVideoMemoryUsageStatsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send viz::mojom::GpuService::GetVideoMemoryUsageStats");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuService::kGetVideoMemoryUsageStats), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuService_GetVideoMemoryUsageStats_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("GetVideoMemoryUsageStats");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GpuService_GetVideoMemoryUsageStats_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void GpuServiceProxy::StartPeakMemoryMonitor(
    uint32_t in_sequence_num) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::GpuService::StartPeakMemoryMonitor", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sequence_num"), in_sequence_num,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuService::kStartPeakMemoryMonitor), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuService_StartPeakMemoryMonitor_Params_Data> params(
          message);
  params.Allocate();

  params->sequence_num = in_sequence_num;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("StartPeakMemoryMonitor");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void GpuServiceProxy::GetPeakMemoryUsage(
    uint32_t in_sequence_num, GetPeakMemoryUsageCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::GpuService::GetPeakMemoryUsage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sequence_num"), in_sequence_num,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuService::kGetPeakMemoryUsage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuService_GetPeakMemoryUsage_Params_Data> params(
          message);
  params.Allocate();

  params->sequence_num = in_sequence_num;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("GetPeakMemoryUsage");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GpuService_GetPeakMemoryUsage_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void GpuServiceProxy::LoadedBlob(
    const ::gpu::GpuDiskCacheHandle& in_cache_handle, const std::string& in_key, const std::string& in_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::GpuService::LoadedBlob", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cache_handle"), in_cache_handle,
                        "<value of type const ::gpu::GpuDiskCacheHandle&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key"), in_key,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuService::kLoadedBlob), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuService_LoadedBlob_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->cache_handle)>
      cache_handle_fragment(params.message());
  cache_handle_fragment.Claim(&params->cache_handle);
  
  mojo::internal::Serialize<::gpu::mojom::GpuDiskCacheHandleDataView>(
    in_cache_handle,
    cache_handle_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->cache_handle.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null cache_handle in GpuService.LoadedBlob request");
  mojo::internal::MessageFragment<
      typename decltype(params->key)::BaseType> key_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ByteStringDataView>(
    in_key,
    key_fragment);

  params->key.Set(
      key_fragment.is_null() ? nullptr : key_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->key.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null key in GpuService.LoadedBlob request");
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType> data_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ByteStringDataView>(
    in_data,
    data_fragment);

  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null data in GpuService.LoadedBlob request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("LoadedBlob");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void GpuServiceProxy::WakeUpGpu(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send viz::mojom::GpuService::WakeUpGpu");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuService::kWakeUpGpu), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuService_WakeUpGpu_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("WakeUpGpu");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void GpuServiceProxy::GpuSwitched(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send viz::mojom::GpuService::GpuSwitched");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuService::kGpuSwitched), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuService_GpuSwitched_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("GpuSwitched");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void GpuServiceProxy::DisplayAdded(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send viz::mojom::GpuService::DisplayAdded");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuService::kDisplayAdded), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuService_DisplayAdded_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("DisplayAdded");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void GpuServiceProxy::DisplayRemoved(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send viz::mojom::GpuService::DisplayRemoved");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuService::kDisplayRemoved), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuService_DisplayRemoved_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("DisplayRemoved");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void GpuServiceProxy::DisplayMetricsChanged(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send viz::mojom::GpuService::DisplayMetricsChanged");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuService::kDisplayMetricsChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuService_DisplayMetricsChanged_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("DisplayMetricsChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void GpuServiceProxy::DestroyAllChannels(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send viz::mojom::GpuService::DestroyAllChannels");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuService::kDestroyAllChannels), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuService_DestroyAllChannels_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("DestroyAllChannels");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void GpuServiceProxy::OnBackgroundCleanup(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send viz::mojom::GpuService::OnBackgroundCleanup");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuService::kOnBackgroundCleanup), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuService_OnBackgroundCleanup_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("OnBackgroundCleanup");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void GpuServiceProxy::OnBackgrounded(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send viz::mojom::GpuService::OnBackgrounded");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuService::kOnBackgrounded), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuService_OnBackgrounded_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("OnBackgrounded");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void GpuServiceProxy::OnForegrounded(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send viz::mojom::GpuService::OnForegrounded");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuService::kOnForegrounded), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuService_OnForegrounded_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("OnForegrounded");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void GpuServiceProxy::OnMemoryPressure(
    ::base::MemoryPressureLevel in_level) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::GpuService::OnMemoryPressure", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("level"), in_level,
                        "<value of type ::base::MemoryPressureLevel>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuService::kOnMemoryPressure), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuService_OnMemoryPressure_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::mojo_base::mojom::MemoryPressureLevel>(
    in_level,
    &params->level);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("OnMemoryPressure");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void GpuServiceProxy::BeginCATransaction(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send viz::mojom::GpuService::BeginCATransaction");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuService::kBeginCATransaction), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuService_BeginCATransaction_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("BeginCATransaction");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void GpuServiceProxy::CommitCATransaction(
    CommitCATransactionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send viz::mojom::GpuService::CommitCATransaction");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuService::kCommitCATransaction), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuService_CommitCATransaction_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("CommitCATransaction");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GpuService_CommitCATransaction_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void GpuServiceProxy::GetDawnInfo(
    bool in_collect_metrics, GetDawnInfoCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::GpuService::GetDawnInfo", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("collect_metrics"), in_collect_metrics,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuService::kGetDawnInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuService_GetDawnInfo_Params_Data> params(
          message);
  params.Allocate();

  params->collect_metrics = in_collect_metrics;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("GetDawnInfo");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GpuService_GetDawnInfo_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void GpuServiceProxy::Crash(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send viz::mojom::GpuService::Crash");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuService::kCrash), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuService_Crash_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("Crash");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void GpuServiceProxy::Hang(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send viz::mojom::GpuService::Hang");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuService::kHang), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuService_Hang_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("Hang");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void GpuServiceProxy::ThrowJavaException(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send viz::mojom::GpuService::ThrowJavaException");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuService::kThrowJavaException), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuService_ThrowJavaException_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("ThrowJavaException");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class GpuService_EstablishGpuChannel_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static GpuService::EstablishGpuChannelCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<GpuService_EstablishGpuChannel_ProxyToResponder> proxy(
        new GpuService_EstablishGpuChannel_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&GpuService_EstablishGpuChannel_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~GpuService_EstablishGpuChannel_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  GpuService_EstablishGpuChannel_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "GpuService::EstablishGpuChannelCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::mojo::ScopedMessagePipeHandle in_channel_handle, const ::gpu::GPUInfo& in_gpu_info, const ::gpu::GpuFeatureInfo& in_gpu_feature_info, const ::gpu::SharedImageCapabilities& in_shared_image_capabilities);
};

bool GpuService_EstablishGpuChannel_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::GpuService_EstablishGpuChannel_ResponseParams_Data* params =
      reinterpret_cast<
          internal::GpuService_EstablishGpuChannel_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for GpuService.0
  bool success = true;
  ::mojo::ScopedMessagePipeHandle p_channel_handle{};
  ::gpu::GPUInfo p_gpu_info{};
  ::gpu::GpuFeatureInfo p_gpu_feature_info{};
  ::gpu::SharedImageCapabilities p_shared_image_capabilities{};
  GpuService_EstablishGpuChannel_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_channel_handle = input_data_view.TakeChannelHandle();
  if (success && !input_data_view.ReadGpuInfo(&p_gpu_info))
    success = false;
  if (success && !input_data_view.ReadGpuFeatureInfo(&p_gpu_feature_info))
    success = false;
  if (success && !input_data_view.ReadSharedImageCapabilities(&p_shared_image_capabilities))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GpuService::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_channel_handle), 
std::move(p_gpu_info), 
std::move(p_gpu_feature_info), 
std::move(p_shared_image_capabilities));
  }
  return true;
}

void GpuService_EstablishGpuChannel_ProxyToResponder::Run(
    ::mojo::ScopedMessagePipeHandle in_channel_handle, const ::gpu::GPUInfo& in_gpu_info, const ::gpu::GpuFeatureInfo& in_gpu_feature_info, const ::gpu::SharedImageCapabilities& in_shared_image_capabilities) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply viz::mojom::GpuService::EstablishGpuChannel", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("channel_handle"), in_channel_handle,
                        "<value of type ::mojo::ScopedMessagePipeHandle>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("gpu_info"), in_gpu_info,
                        "<value of type const ::gpu::GPUInfo&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("gpu_feature_info"), in_gpu_feature_info,
                        "<value of type const ::gpu::GpuFeatureInfo&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("shared_image_capabilities"), in_shared_image_capabilities,
                        "<value of type const ::gpu::SharedImageCapabilities&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuService::kEstablishGpuChannel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuService_EstablishGpuChannel_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::ScopedMessagePipeHandle>(
    in_channel_handle,
    &params->channel_handle,
    &params.message());
  mojo::internal::MessageFragment<
      typename decltype(params->gpu_info)::BaseType> gpu_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::gpu::mojom::GpuInfoDataView>(
    in_gpu_info,
    gpu_info_fragment);

  params->gpu_info.Set(
      gpu_info_fragment.is_null() ? nullptr : gpu_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->gpu_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null gpu_info in ");
  mojo::internal::MessageFragment<
      typename decltype(params->gpu_feature_info)::BaseType> gpu_feature_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::gpu::mojom::GpuFeatureInfoDataView>(
    in_gpu_feature_info,
    gpu_feature_info_fragment);

  params->gpu_feature_info.Set(
      gpu_feature_info_fragment.is_null() ? nullptr : gpu_feature_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->gpu_feature_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null gpu_feature_info in ");
  mojo::internal::MessageFragment<
      typename decltype(params->shared_image_capabilities)::BaseType> shared_image_capabilities_fragment(
          params.message());
  
  mojo::internal::Serialize<::gpu::mojom::SharedImageCapabilitiesDataView>(
    in_shared_image_capabilities,
    shared_image_capabilities_fragment);

  params->shared_image_capabilities.Set(
      shared_image_capabilities_fragment.is_null() ? nullptr : shared_image_capabilities_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->shared_image_capabilities.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null shared_image_capabilities in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("EstablishGpuChannel");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool GpuService_EstablishGpuChannel_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::GpuService_EstablishGpuChannel_ResponseParams_Data* params =
      reinterpret_cast<internal::GpuService_EstablishGpuChannel_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for GpuService.0
  bool success = true;
  ::mojo::ScopedMessagePipeHandle p_channel_handle{};
  ::gpu::GPUInfo p_gpu_info{};
  ::gpu::GpuFeatureInfo p_gpu_feature_info{};
  ::gpu::SharedImageCapabilities p_shared_image_capabilities{};
  GpuService_EstablishGpuChannel_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_channel_handle = input_data_view.TakeChannelHandle();
  if (success && !input_data_view.ReadGpuInfo(&p_gpu_info))
    success = false;
  if (success && !input_data_view.ReadGpuFeatureInfo(&p_gpu_feature_info))
    success = false;
  if (success && !input_data_view.ReadSharedImageCapabilities(&p_shared_image_capabilities))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GpuService::Name_, 0, true);
    return false;
  }
  *out_channel_handle_ = std::move(p_channel_handle);
  *out_gpu_info_ = std::move(p_gpu_info);
  *out_gpu_feature_info_ = std::move(p_gpu_feature_info);
  *out_shared_image_capabilities_ = std::move(p_shared_image_capabilities);
  *result_ = true;
  return true;
}
class GpuService_GetVideoMemoryUsageStats_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static GpuService::GetVideoMemoryUsageStatsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<GpuService_GetVideoMemoryUsageStats_ProxyToResponder> proxy(
        new GpuService_GetVideoMemoryUsageStats_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&GpuService_GetVideoMemoryUsageStats_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~GpuService_GetVideoMemoryUsageStats_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  GpuService_GetVideoMemoryUsageStats_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "GpuService::GetVideoMemoryUsageStatsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::gpu::VideoMemoryUsageStats& in_stats);
};

bool GpuService_GetVideoMemoryUsageStats_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::GpuService_GetVideoMemoryUsageStats_ResponseParams_Data* params =
      reinterpret_cast<
          internal::GpuService_GetVideoMemoryUsageStats_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for GpuService.8
  bool success = true;
  ::gpu::VideoMemoryUsageStats p_stats{};
  GpuService_GetVideoMemoryUsageStats_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStats(&p_stats))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GpuService::Name_, 8, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_stats));
  }
  return true;
}

void GpuService_GetVideoMemoryUsageStats_ProxyToResponder::Run(
    const ::gpu::VideoMemoryUsageStats& in_stats) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply viz::mojom::GpuService::GetVideoMemoryUsageStats", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("stats"), in_stats,
                        "<value of type const ::gpu::VideoMemoryUsageStats&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuService::kGetVideoMemoryUsageStats), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuService_GetVideoMemoryUsageStats_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->stats)::BaseType> stats_fragment(
          params.message());
  
  mojo::internal::Serialize<::gpu::mojom::VideoMemoryUsageStatsDataView>(
    in_stats,
    stats_fragment);

  params->stats.Set(
      stats_fragment.is_null() ? nullptr : stats_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->stats.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null stats in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("GetVideoMemoryUsageStats");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class GpuService_GetPeakMemoryUsage_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static GpuService::GetPeakMemoryUsageCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<GpuService_GetPeakMemoryUsage_ProxyToResponder> proxy(
        new GpuService_GetPeakMemoryUsage_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&GpuService_GetPeakMemoryUsage_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~GpuService_GetPeakMemoryUsage_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  GpuService_GetPeakMemoryUsage_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "GpuService::GetPeakMemoryUsageCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      uint64_t in_memory_usage, const base::flat_map<::gpu::GpuPeakMemoryAllocationSource, uint64_t>& in_memory_per_allocation_source);
};

bool GpuService_GetPeakMemoryUsage_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::GpuService_GetPeakMemoryUsage_ResponseParams_Data* params =
      reinterpret_cast<
          internal::GpuService_GetPeakMemoryUsage_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for GpuService.10
  bool success = true;
  uint64_t p_memory_usage{};
  base::flat_map<::gpu::GpuPeakMemoryAllocationSource, uint64_t> p_memory_per_allocation_source{};
  GpuService_GetPeakMemoryUsage_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_memory_usage = input_data_view.memory_usage();
  if (success && !input_data_view.ReadMemoryPerAllocationSource(&p_memory_per_allocation_source))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GpuService::Name_, 10, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_memory_usage), 
std::move(p_memory_per_allocation_source));
  }
  return true;
}

void GpuService_GetPeakMemoryUsage_ProxyToResponder::Run(
    uint64_t in_memory_usage, const base::flat_map<::gpu::GpuPeakMemoryAllocationSource, uint64_t>& in_memory_per_allocation_source) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply viz::mojom::GpuService::GetPeakMemoryUsage", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("memory_usage"), in_memory_usage,
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("memory_per_allocation_source"), in_memory_per_allocation_source,
                        "<value of type const base::flat_map<::gpu::GpuPeakMemoryAllocationSource, uint64_t>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuService::kGetPeakMemoryUsage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuService_GetPeakMemoryUsage_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->memory_usage = in_memory_usage;
  mojo::internal::MessageFragment<
      typename decltype(params->memory_per_allocation_source)::BaseType>
      memory_per_allocation_source_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& memory_per_allocation_source_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayOfEnumsValidator<0, false, ::gpu::mojom::internal::GpuPeakMemoryAllocationSource_Data::Validate>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::MapDataView<::gpu::mojom::GpuPeakMemoryAllocationSource, uint64_t>>(
    in_memory_per_allocation_source,
    memory_per_allocation_source_fragment,
    &memory_per_allocation_source_validate_params);

  params->memory_per_allocation_source.Set(
      memory_per_allocation_source_fragment.is_null() ? nullptr : memory_per_allocation_source_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->memory_per_allocation_source.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null memory_per_allocation_source in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("GetPeakMemoryUsage");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class GpuService_CommitCATransaction_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static GpuService::CommitCATransactionCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<GpuService_CommitCATransaction_ProxyToResponder> proxy(
        new GpuService_CommitCATransaction_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&GpuService_CommitCATransaction_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~GpuService_CommitCATransaction_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  GpuService_CommitCATransaction_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "GpuService::CommitCATransactionCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool GpuService_CommitCATransaction_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::GpuService_CommitCATransaction_ResponseParams_Data* params =
      reinterpret_cast<
          internal::GpuService_CommitCATransaction_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for GpuService.23
  bool success = true;
  GpuService_CommitCATransaction_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GpuService::Name_, 23, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void GpuService_CommitCATransaction_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply viz::mojom::GpuService::CommitCATransaction");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuService::kCommitCATransaction), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuService_CommitCATransaction_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("CommitCATransaction");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class GpuService_GetDawnInfo_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static GpuService::GetDawnInfoCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<GpuService_GetDawnInfo_ProxyToResponder> proxy(
        new GpuService_GetDawnInfo_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&GpuService_GetDawnInfo_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~GpuService_GetDawnInfo_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  GpuService_GetDawnInfo_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "GpuService::GetDawnInfoCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::vector<std::string>& in_dawn_info_list);
};

bool GpuService_GetDawnInfo_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::GpuService_GetDawnInfo_ResponseParams_Data* params =
      reinterpret_cast<
          internal::GpuService_GetDawnInfo_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for GpuService.24
  bool success = true;
  std::vector<std::string> p_dawn_info_list{};
  GpuService_GetDawnInfo_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadDawnInfoList(&p_dawn_info_list))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GpuService::Name_, 24, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_dawn_info_list));
  }
  return true;
}

void GpuService_GetDawnInfo_ProxyToResponder::Run(
    const std::vector<std::string>& in_dawn_info_list) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply viz::mojom::GpuService::GetDawnInfo", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("dawn_info_list"), in_dawn_info_list,
                        "<value of type const std::vector<std::string>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GpuService::kGetDawnInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::GpuService_GetDawnInfo_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->dawn_info_list)::BaseType>
      dawn_info_list_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& dawn_info_list_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
    in_dawn_info_list,
    dawn_info_list_fragment,
    &dawn_info_list_validate_params);

  params->dawn_info_list.Set(
      dawn_info_list_fragment.is_null() ? nullptr : dawn_info_list_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->dawn_info_list.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null dawn_info_list in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("GetDawnInfo");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool GpuServiceStubDispatch::Accept(
    GpuService* impl,
    mojo::Message* message) {
  switch (static_cast<messages::GpuService>(message->header()->name)) {
    case messages::GpuService::kEstablishGpuChannel: {
      break;
    }
    case messages::GpuService::kSetChannelClientPid: {
      DCHECK(message->is_serialized());
      internal::GpuService_SetChannelClientPid_Params_Data* params =
          reinterpret_cast<internal::GpuService_SetChannelClientPid_Params_Data*>(
              message->mutable_payload());
      

      // Validation for GpuService.1
      bool success = true;
      int32_t p_client_id{};
      ::base::ProcessId p_client_pid{};
      GpuService_SetChannelClientPid_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_client_id = input_data_view.client_id();
      if (success && !input_data_view.ReadClientPid(&p_client_pid))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuService::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetChannelClientPid(        
        std::move(p_client_id), 
        std::move(p_client_pid));
      return true;
    }
    case messages::GpuService::kSetChannelDiskCacheHandle: {
      DCHECK(message->is_serialized());
      internal::GpuService_SetChannelDiskCacheHandle_Params_Data* params =
          reinterpret_cast<internal::GpuService_SetChannelDiskCacheHandle_Params_Data*>(
              message->mutable_payload());
      

      // Validation for GpuService.2
      bool success = true;
      int32_t p_client_id{};
      ::gpu::GpuDiskCacheHandle p_cache_handle{};
      GpuService_SetChannelDiskCacheHandle_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_client_id = input_data_view.client_id();
      if (success && !input_data_view.ReadCacheHandle(&p_cache_handle))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuService::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetChannelDiskCacheHandle(        
        std::move(p_client_id), 
        std::move(p_cache_handle));
      return true;
    }
    case messages::GpuService::kSetChannelPersistentCachePendingBackend: {
      DCHECK(message->is_serialized());
      internal::GpuService_SetChannelPersistentCachePendingBackend_Params_Data* params =
          reinterpret_cast<internal::GpuService_SetChannelPersistentCachePendingBackend_Params_Data*>(
              message->mutable_payload());
      

      // Validation for GpuService.3
      bool success = true;
      int32_t p_client_id{};
      ::gpu::GpuDiskCacheHandle p_cache_handle{};
      ::persistent_cache::PendingBackend p_pending_backend{};
      GpuService_SetChannelPersistentCachePendingBackend_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_client_id = input_data_view.client_id();
      if (success && !input_data_view.ReadCacheHandle(&p_cache_handle))
        success = false;
      if (success && !input_data_view.ReadPendingBackend(&p_pending_backend))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuService::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetChannelPersistentCachePendingBackend(        
        std::move(p_client_id), 
        std::move(p_cache_handle), 
        std::move(p_pending_backend));
      return true;
    }
    case messages::GpuService::kOnDiskCacheHandleDestoyed: {
      DCHECK(message->is_serialized());
      internal::GpuService_OnDiskCacheHandleDestoyed_Params_Data* params =
          reinterpret_cast<internal::GpuService_OnDiskCacheHandleDestoyed_Params_Data*>(
              message->mutable_payload());
      

      // Validation for GpuService.4
      bool success = true;
      ::gpu::GpuDiskCacheHandle p_cache_handle{};
      GpuService_OnDiskCacheHandleDestoyed_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCacheHandle(&p_cache_handle))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuService::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnDiskCacheHandleDestoyed(        
        std::move(p_cache_handle));
      return true;
    }
    case messages::GpuService::kCloseChannel: {
      DCHECK(message->is_serialized());
      internal::GpuService_CloseChannel_Params_Data* params =
          reinterpret_cast<internal::GpuService_CloseChannel_Params_Data*>(
              message->mutable_payload());
      

      // Validation for GpuService.5
      bool success = true;
      int32_t p_client_id{};
      GpuService_CloseChannel_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_client_id = input_data_view.client_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuService::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CloseChannel(        
        std::move(p_client_id));
      return true;
    }
    case messages::GpuService::kCreateVideoEncodeAcceleratorProvider: {
      DCHECK(message->is_serialized());
      internal::GpuService_CreateVideoEncodeAcceleratorProvider_Params_Data* params =
          reinterpret_cast<internal::GpuService_CreateVideoEncodeAcceleratorProvider_Params_Data*>(
              message->mutable_payload());
      

      // Validation for GpuService.6
      bool success = true;
      ::mojo::PendingReceiver<::media::mojom::VideoEncodeAcceleratorProvider> p_vea_provider{};
      GpuService_CreateVideoEncodeAcceleratorProvider_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_vea_provider =
            input_data_view.TakeVeaProvider<decltype(p_vea_provider)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuService::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateVideoEncodeAcceleratorProvider(        
        std::move(p_vea_provider));
      return true;
    }
    case messages::GpuService::kBindWebNNContextProvider: {
      DCHECK(message->is_serialized());
      internal::GpuService_BindWebNNContextProvider_Params_Data* params =
          reinterpret_cast<internal::GpuService_BindWebNNContextProvider_Params_Data*>(
              message->mutable_payload());
      

      // Validation for GpuService.7
      bool success = true;
      ::mojo::PendingReceiver<::webnn::mojom::WebNNContextProvider> p_receiver{};
      int32_t p_client_id{};
      GpuService_BindWebNNContextProvider_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (success)
        p_client_id = input_data_view.client_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuService::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindWebNNContextProvider(        
        std::move(p_receiver), 
        std::move(p_client_id));
      return true;
    }
    case messages::GpuService::kGetVideoMemoryUsageStats: {
      break;
    }
    case messages::GpuService::kStartPeakMemoryMonitor: {
      DCHECK(message->is_serialized());
      internal::GpuService_StartPeakMemoryMonitor_Params_Data* params =
          reinterpret_cast<internal::GpuService_StartPeakMemoryMonitor_Params_Data*>(
              message->mutable_payload());
      

      // Validation for GpuService.9
      bool success = true;
      uint32_t p_sequence_num{};
      GpuService_StartPeakMemoryMonitor_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_sequence_num = input_data_view.sequence_num();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuService::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartPeakMemoryMonitor(        
        std::move(p_sequence_num));
      return true;
    }
    case messages::GpuService::kGetPeakMemoryUsage: {
      break;
    }
    case messages::GpuService::kLoadedBlob: {
      DCHECK(message->is_serialized());
      internal::GpuService_LoadedBlob_Params_Data* params =
          reinterpret_cast<internal::GpuService_LoadedBlob_Params_Data*>(
              message->mutable_payload());
      

      // Validation for GpuService.11
      bool success = true;
      ::gpu::GpuDiskCacheHandle p_cache_handle{};
      std::string p_key{};
      std::string p_data{};
      GpuService_LoadedBlob_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCacheHandle(&p_cache_handle))
        success = false;
      if (success && !input_data_view.ReadKey(&p_key))
        success = false;
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuService::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->LoadedBlob(        
        std::move(p_cache_handle), 
        std::move(p_key), 
        std::move(p_data));
      return true;
    }
    case messages::GpuService::kWakeUpGpu: {
      DCHECK(message->is_serialized());
      internal::GpuService_WakeUpGpu_Params_Data* params =
          reinterpret_cast<internal::GpuService_WakeUpGpu_Params_Data*>(
              message->mutable_payload());
      

      // Validation for GpuService.12
      bool success = true;
      GpuService_WakeUpGpu_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuService::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WakeUpGpu(        );
      return true;
    }
    case messages::GpuService::kGpuSwitched: {
      DCHECK(message->is_serialized());
      internal::GpuService_GpuSwitched_Params_Data* params =
          reinterpret_cast<internal::GpuService_GpuSwitched_Params_Data*>(
              message->mutable_payload());
      

      // Validation for GpuService.13
      bool success = true;
      GpuService_GpuSwitched_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuService::Name_, 13, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GpuSwitched(        );
      return true;
    }
    case messages::GpuService::kDisplayAdded: {
      DCHECK(message->is_serialized());
      internal::GpuService_DisplayAdded_Params_Data* params =
          reinterpret_cast<internal::GpuService_DisplayAdded_Params_Data*>(
              message->mutable_payload());
      

      // Validation for GpuService.14
      bool success = true;
      GpuService_DisplayAdded_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuService::Name_, 14, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DisplayAdded(        );
      return true;
    }
    case messages::GpuService::kDisplayRemoved: {
      DCHECK(message->is_serialized());
      internal::GpuService_DisplayRemoved_Params_Data* params =
          reinterpret_cast<internal::GpuService_DisplayRemoved_Params_Data*>(
              message->mutable_payload());
      

      // Validation for GpuService.15
      bool success = true;
      GpuService_DisplayRemoved_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuService::Name_, 15, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DisplayRemoved(        );
      return true;
    }
    case messages::GpuService::kDisplayMetricsChanged: {
      DCHECK(message->is_serialized());
      internal::GpuService_DisplayMetricsChanged_Params_Data* params =
          reinterpret_cast<internal::GpuService_DisplayMetricsChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for GpuService.16
      bool success = true;
      GpuService_DisplayMetricsChanged_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuService::Name_, 16, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DisplayMetricsChanged(        );
      return true;
    }
    case messages::GpuService::kDestroyAllChannels: {
      DCHECK(message->is_serialized());
      internal::GpuService_DestroyAllChannels_Params_Data* params =
          reinterpret_cast<internal::GpuService_DestroyAllChannels_Params_Data*>(
              message->mutable_payload());
      

      // Validation for GpuService.17
      bool success = true;
      GpuService_DestroyAllChannels_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuService::Name_, 17, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DestroyAllChannels(        );
      return true;
    }
    case messages::GpuService::kOnBackgroundCleanup: {
      DCHECK(message->is_serialized());
      internal::GpuService_OnBackgroundCleanup_Params_Data* params =
          reinterpret_cast<internal::GpuService_OnBackgroundCleanup_Params_Data*>(
              message->mutable_payload());
      

      // Validation for GpuService.18
      bool success = true;
      GpuService_OnBackgroundCleanup_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuService::Name_, 18, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnBackgroundCleanup(        );
      return true;
    }
    case messages::GpuService::kOnBackgrounded: {
      DCHECK(message->is_serialized());
      internal::GpuService_OnBackgrounded_Params_Data* params =
          reinterpret_cast<internal::GpuService_OnBackgrounded_Params_Data*>(
              message->mutable_payload());
      

      // Validation for GpuService.19
      bool success = true;
      GpuService_OnBackgrounded_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuService::Name_, 19, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnBackgrounded(        );
      return true;
    }
    case messages::GpuService::kOnForegrounded: {
      DCHECK(message->is_serialized());
      internal::GpuService_OnForegrounded_Params_Data* params =
          reinterpret_cast<internal::GpuService_OnForegrounded_Params_Data*>(
              message->mutable_payload());
      

      // Validation for GpuService.20
      bool success = true;
      GpuService_OnForegrounded_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuService::Name_, 20, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnForegrounded(        );
      return true;
    }
    case messages::GpuService::kOnMemoryPressure: {
      DCHECK(message->is_serialized());
      internal::GpuService_OnMemoryPressure_Params_Data* params =
          reinterpret_cast<internal::GpuService_OnMemoryPressure_Params_Data*>(
              message->mutable_payload());
      

      // Validation for GpuService.21
      bool success = true;
      ::base::MemoryPressureLevel p_level{};
      GpuService_OnMemoryPressure_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLevel(&p_level))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuService::Name_, 21, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnMemoryPressure(        
        std::move(p_level));
      return true;
    }
    case messages::GpuService::kBeginCATransaction: {
      DCHECK(message->is_serialized());
      internal::GpuService_BeginCATransaction_Params_Data* params =
          reinterpret_cast<internal::GpuService_BeginCATransaction_Params_Data*>(
              message->mutable_payload());
      

      // Validation for GpuService.22
      bool success = true;
      GpuService_BeginCATransaction_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuService::Name_, 22, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BeginCATransaction(        );
      return true;
    }
    case messages::GpuService::kCommitCATransaction: {
      break;
    }
    case messages::GpuService::kGetDawnInfo: {
      break;
    }
    case messages::GpuService::kCrash: {
      DCHECK(message->is_serialized());
      internal::GpuService_Crash_Params_Data* params =
          reinterpret_cast<internal::GpuService_Crash_Params_Data*>(
              message->mutable_payload());
      

      // Validation for GpuService.25
      bool success = true;
      GpuService_Crash_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuService::Name_, 25, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Crash(        );
      return true;
    }
    case messages::GpuService::kHang: {
      DCHECK(message->is_serialized());
      internal::GpuService_Hang_Params_Data* params =
          reinterpret_cast<internal::GpuService_Hang_Params_Data*>(
              message->mutable_payload());
      

      // Validation for GpuService.26
      bool success = true;
      GpuService_Hang_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuService::Name_, 26, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Hang(        );
      return true;
    }
    case messages::GpuService::kThrowJavaException: {
      DCHECK(message->is_serialized());
      internal::GpuService_ThrowJavaException_Params_Data* params =
          reinterpret_cast<internal::GpuService_ThrowJavaException_Params_Data*>(
              message->mutable_payload());
      

      // Validation for GpuService.27
      bool success = true;
      GpuService_ThrowJavaException_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuService::Name_, 27, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ThrowJavaException(        );
      return true;
    }
  }
  return false;
}

// static
bool GpuServiceStubDispatch::AcceptWithResponder(
    GpuService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::GpuService>(message->header()->name)) {
    case messages::GpuService::kEstablishGpuChannel: {
      internal::GpuService_EstablishGpuChannel_Params_Data* params =
          reinterpret_cast<
              internal::GpuService_EstablishGpuChannel_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for GpuService.0
      bool success = true;
      int32_t p_client_id{};
      uint64_t p_client_tracing_id{};
      bool p_is_gpu_host{};
      bool p_enable_extra_handles_validation{};
      GpuService_EstablishGpuChannel_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_client_id = input_data_view.client_id();
      if (success)
        p_client_tracing_id = input_data_view.client_tracing_id();
      if (success)
        p_is_gpu_host = input_data_view.is_gpu_host();
      if (success)
        p_enable_extra_handles_validation = input_data_view.enable_extra_handles_validation();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuService::Name_, 0, false);
        return false;
      }
      auto callback =
          GpuService_EstablishGpuChannel_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EstablishGpuChannel(        
        std::move(p_client_id), 
        std::move(p_client_tracing_id), 
        std::move(p_is_gpu_host), 
        std::move(p_enable_extra_handles_validation), std::move(callback));
      return true;
    }
    case messages::GpuService::kSetChannelClientPid: {
      break;
    }
    case messages::GpuService::kSetChannelDiskCacheHandle: {
      break;
    }
    case messages::GpuService::kSetChannelPersistentCachePendingBackend: {
      break;
    }
    case messages::GpuService::kOnDiskCacheHandleDestoyed: {
      break;
    }
    case messages::GpuService::kCloseChannel: {
      break;
    }
    case messages::GpuService::kCreateVideoEncodeAcceleratorProvider: {
      break;
    }
    case messages::GpuService::kBindWebNNContextProvider: {
      break;
    }
    case messages::GpuService::kGetVideoMemoryUsageStats: {
      internal::GpuService_GetVideoMemoryUsageStats_Params_Data* params =
          reinterpret_cast<
              internal::GpuService_GetVideoMemoryUsageStats_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for GpuService.8
      bool success = true;
      GpuService_GetVideoMemoryUsageStats_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuService::Name_, 8, false);
        return false;
      }
      auto callback =
          GpuService_GetVideoMemoryUsageStats_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetVideoMemoryUsageStats(std::move(callback));
      return true;
    }
    case messages::GpuService::kStartPeakMemoryMonitor: {
      break;
    }
    case messages::GpuService::kGetPeakMemoryUsage: {
      internal::GpuService_GetPeakMemoryUsage_Params_Data* params =
          reinterpret_cast<
              internal::GpuService_GetPeakMemoryUsage_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for GpuService.10
      bool success = true;
      uint32_t p_sequence_num{};
      GpuService_GetPeakMemoryUsage_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_sequence_num = input_data_view.sequence_num();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuService::Name_, 10, false);
        return false;
      }
      auto callback =
          GpuService_GetPeakMemoryUsage_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetPeakMemoryUsage(        
        std::move(p_sequence_num), std::move(callback));
      return true;
    }
    case messages::GpuService::kLoadedBlob: {
      break;
    }
    case messages::GpuService::kWakeUpGpu: {
      break;
    }
    case messages::GpuService::kGpuSwitched: {
      break;
    }
    case messages::GpuService::kDisplayAdded: {
      break;
    }
    case messages::GpuService::kDisplayRemoved: {
      break;
    }
    case messages::GpuService::kDisplayMetricsChanged: {
      break;
    }
    case messages::GpuService::kDestroyAllChannels: {
      break;
    }
    case messages::GpuService::kOnBackgroundCleanup: {
      break;
    }
    case messages::GpuService::kOnBackgrounded: {
      break;
    }
    case messages::GpuService::kOnForegrounded: {
      break;
    }
    case messages::GpuService::kOnMemoryPressure: {
      break;
    }
    case messages::GpuService::kBeginCATransaction: {
      break;
    }
    case messages::GpuService::kCommitCATransaction: {
      internal::GpuService_CommitCATransaction_Params_Data* params =
          reinterpret_cast<
              internal::GpuService_CommitCATransaction_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for GpuService.23
      bool success = true;
      GpuService_CommitCATransaction_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuService::Name_, 23, false);
        return false;
      }
      auto callback =
          GpuService_CommitCATransaction_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CommitCATransaction(std::move(callback));
      return true;
    }
    case messages::GpuService::kGetDawnInfo: {
      internal::GpuService_GetDawnInfo_Params_Data* params =
          reinterpret_cast<
              internal::GpuService_GetDawnInfo_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for GpuService.24
      bool success = true;
      bool p_collect_metrics{};
      GpuService_GetDawnInfo_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_collect_metrics = input_data_view.collect_metrics();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuService::Name_, 24, false);
        return false;
      }
      auto callback =
          GpuService_GetDawnInfo_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetDawnInfo(        
        std::move(p_collect_metrics), std::move(callback));
      return true;
    }
    case messages::GpuService::kCrash: {
      break;
    }
    case messages::GpuService::kHang: {
      break;
    }
    case messages::GpuService::kThrowJavaException: {
      break;
    }
  }
  return false;
}
namespace {

bool ValidateWithRuntimeFeature_GpuService_BindWebNNContextProvider(
  const void* data, mojo::internal::ValidationContext* validation_context) {
  if (!base::FeatureList::IsEnabled(::webnn::mojom::features::kWebMachineLearningNeuralNetwork)) {
    return false;
  }
  return internal::GpuService_BindWebNNContextProvider_Params_Data::Validate(
    data, validation_context);
}
}  // namespace
static const mojo::internal::GenericValidationInfo kGpuServiceValidationInfo[] = {
    { &internal::GpuService_EstablishGpuChannel_Params_Data::Validate,
     &internal::GpuService_EstablishGpuChannel_ResponseParams_Data::Validate},
    { &internal::GpuService_SetChannelClientPid_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::GpuService_SetChannelDiskCacheHandle_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::GpuService_SetChannelPersistentCachePendingBackend_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::GpuService_OnDiskCacheHandleDestoyed_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::GpuService_CloseChannel_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::GpuService_CreateVideoEncodeAcceleratorProvider_Params_Data::Validate,
     nullptr /* no response */},
    { &ValidateWithRuntimeFeature_GpuService_BindWebNNContextProvider,
     nullptr /* no response */},
    { &internal::GpuService_GetVideoMemoryUsageStats_Params_Data::Validate,
     &internal::GpuService_GetVideoMemoryUsageStats_ResponseParams_Data::Validate},
    { &internal::GpuService_StartPeakMemoryMonitor_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::GpuService_GetPeakMemoryUsage_Params_Data::Validate,
     &internal::GpuService_GetPeakMemoryUsage_ResponseParams_Data::Validate},
    { &internal::GpuService_LoadedBlob_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::GpuService_WakeUpGpu_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::GpuService_GpuSwitched_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::GpuService_DisplayAdded_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::GpuService_DisplayRemoved_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::GpuService_DisplayMetricsChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::GpuService_DestroyAllChannels_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::GpuService_OnBackgroundCleanup_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::GpuService_OnBackgrounded_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::GpuService_OnForegrounded_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::GpuService_OnMemoryPressure_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::GpuService_BeginCATransaction_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::GpuService_CommitCATransaction_Params_Data::Validate,
     &internal::GpuService_CommitCATransaction_ResponseParams_Data::Validate},
    { &internal::GpuService_GetDawnInfo_Params_Data::Validate,
     &internal::GpuService_GetDawnInfo_ResponseParams_Data::Validate},
    { &internal::GpuService_Crash_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::GpuService_Hang_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::GpuService_ThrowJavaException_Params_Data::Validate,
     nullptr /* no response */},
};

bool GpuServiceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::viz::mojom::GpuService::Name_,
    kGpuServiceValidationInfo);
}

bool GpuServiceResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::viz::mojom::GpuService::Name_,
    kGpuServiceValidationInfo);
}


}  // viz::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace viz::mojom {


void GpuServiceInterceptorForTesting::EstablishGpuChannel(int32_t client_id, uint64_t client_tracing_id, bool is_gpu_host, bool enable_extra_handles_validation, EstablishGpuChannelCallback callback) {
  GetForwardingInterface()->EstablishGpuChannel(
    std::move(client_id)
    , 
    std::move(client_tracing_id)
    , 
    std::move(is_gpu_host)
    , 
    std::move(enable_extra_handles_validation)
    , std::move(callback));
}
void GpuServiceInterceptorForTesting::SetChannelClientPid(int32_t client_id, ::base::ProcessId client_pid) {
  GetForwardingInterface()->SetChannelClientPid(
    std::move(client_id)
    , 
    std::move(client_pid)
    );
}
void GpuServiceInterceptorForTesting::SetChannelDiskCacheHandle(int32_t client_id, const ::gpu::GpuDiskCacheHandle& cache_handle) {
  GetForwardingInterface()->SetChannelDiskCacheHandle(
    std::move(client_id)
    , 
    std::move(cache_handle)
    );
}
void GpuServiceInterceptorForTesting::SetChannelPersistentCachePendingBackend(int32_t client_id, const ::gpu::GpuDiskCacheHandle& cache_handle, ::persistent_cache::PendingBackend pending_backend) {
  GetForwardingInterface()->SetChannelPersistentCachePendingBackend(
    std::move(client_id)
    , 
    std::move(cache_handle)
    , 
    std::move(pending_backend)
    );
}
void GpuServiceInterceptorForTesting::OnDiskCacheHandleDestoyed(const ::gpu::GpuDiskCacheHandle& cache_handle) {
  GetForwardingInterface()->OnDiskCacheHandleDestoyed(
    std::move(cache_handle)
    );
}
void GpuServiceInterceptorForTesting::CloseChannel(int32_t client_id) {
  GetForwardingInterface()->CloseChannel(
    std::move(client_id)
    );
}
void GpuServiceInterceptorForTesting::CreateVideoEncodeAcceleratorProvider(::mojo::PendingReceiver<::media::mojom::VideoEncodeAcceleratorProvider> vea_provider) {
  GetForwardingInterface()->CreateVideoEncodeAcceleratorProvider(
    std::move(vea_provider)
    );
}
void GpuServiceInterceptorForTesting::BindWebNNContextProvider(::mojo::PendingReceiver<::webnn::mojom::WebNNContextProvider> receiver, int32_t client_id) {
  GetForwardingInterface()->BindWebNNContextProvider(
    std::move(receiver)
    , 
    std::move(client_id)
    );
}
void GpuServiceInterceptorForTesting::GetVideoMemoryUsageStats(GetVideoMemoryUsageStatsCallback callback) {
  GetForwardingInterface()->GetVideoMemoryUsageStats(std::move(callback));
}
void GpuServiceInterceptorForTesting::StartPeakMemoryMonitor(uint32_t sequence_num) {
  GetForwardingInterface()->StartPeakMemoryMonitor(
    std::move(sequence_num)
    );
}
void GpuServiceInterceptorForTesting::GetPeakMemoryUsage(uint32_t sequence_num, GetPeakMemoryUsageCallback callback) {
  GetForwardingInterface()->GetPeakMemoryUsage(
    std::move(sequence_num)
    , std::move(callback));
}
void GpuServiceInterceptorForTesting::LoadedBlob(const ::gpu::GpuDiskCacheHandle& cache_handle, const std::string& key, const std::string& data) {
  GetForwardingInterface()->LoadedBlob(
    std::move(cache_handle)
    , 
    std::move(key)
    , 
    std::move(data)
    );
}
void GpuServiceInterceptorForTesting::WakeUpGpu() {
  GetForwardingInterface()->WakeUpGpu();
}
void GpuServiceInterceptorForTesting::GpuSwitched() {
  GetForwardingInterface()->GpuSwitched();
}
void GpuServiceInterceptorForTesting::DisplayAdded() {
  GetForwardingInterface()->DisplayAdded();
}
void GpuServiceInterceptorForTesting::DisplayRemoved() {
  GetForwardingInterface()->DisplayRemoved();
}
void GpuServiceInterceptorForTesting::DisplayMetricsChanged() {
  GetForwardingInterface()->DisplayMetricsChanged();
}
void GpuServiceInterceptorForTesting::DestroyAllChannels() {
  GetForwardingInterface()->DestroyAllChannels();
}
void GpuServiceInterceptorForTesting::OnBackgroundCleanup() {
  GetForwardingInterface()->OnBackgroundCleanup();
}
void GpuServiceInterceptorForTesting::OnBackgrounded() {
  GetForwardingInterface()->OnBackgrounded();
}
void GpuServiceInterceptorForTesting::OnForegrounded() {
  GetForwardingInterface()->OnForegrounded();
}
void GpuServiceInterceptorForTesting::OnMemoryPressure(::base::MemoryPressureLevel level) {
  GetForwardingInterface()->OnMemoryPressure(
    std::move(level)
    );
}
void GpuServiceInterceptorForTesting::BeginCATransaction() {
  GetForwardingInterface()->BeginCATransaction();
}
void GpuServiceInterceptorForTesting::CommitCATransaction(CommitCATransactionCallback callback) {
  GetForwardingInterface()->CommitCATransaction(std::move(callback));
}
void GpuServiceInterceptorForTesting::GetDawnInfo(bool collect_metrics, GetDawnInfoCallback callback) {
  GetForwardingInterface()->GetDawnInfo(
    std::move(collect_metrics)
    , std::move(callback));
}
void GpuServiceInterceptorForTesting::Crash() {
  GetForwardingInterface()->Crash();
}
void GpuServiceInterceptorForTesting::Hang() {
  GetForwardingInterface()->Hang();
}
void GpuServiceInterceptorForTesting::ThrowJavaException() {
  GetForwardingInterface()->ThrowJavaException();
}
GpuServiceAsyncWaiter::GpuServiceAsyncWaiter(
    GpuService* proxy) : proxy_(proxy) {}

GpuServiceAsyncWaiter::~GpuServiceAsyncWaiter() = default;


void GpuServiceAsyncWaiter::EstablishGpuChannel(
    int32_t client_id, uint64_t client_tracing_id, bool is_gpu_host, bool enable_extra_handles_validation, ::mojo::ScopedMessagePipeHandle* out_channel_handle, ::gpu::GPUInfo* out_gpu_info, ::gpu::GpuFeatureInfo* out_gpu_feature_info, ::gpu::SharedImageCapabilities* out_shared_image_capabilities) {
  base::RunLoop loop;
  proxy_->EstablishGpuChannel(
      std::move(client_id),
      std::move(client_tracing_id),
      std::move(is_gpu_host),
      std::move(enable_extra_handles_validation),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::mojo::ScopedMessagePipeHandle* out_channel_handle
,
             ::gpu::GPUInfo* out_gpu_info
,
             ::gpu::GpuFeatureInfo* out_gpu_feature_info
,
             ::gpu::SharedImageCapabilities* out_shared_image_capabilities
,
             ::mojo::ScopedMessagePipeHandle channel_handle,
             const ::gpu::GPUInfo& gpu_info,
             const ::gpu::GpuFeatureInfo& gpu_feature_info,
             const ::gpu::SharedImageCapabilities& shared_image_capabilities) {*out_channel_handle = std::move(channel_handle);*out_gpu_info = std::move(gpu_info);*out_gpu_feature_info = std::move(gpu_feature_info);*out_shared_image_capabilities = std::move(shared_image_capabilities);
            loop->Quit();
          },
          &loop,
          out_channel_handle,
          out_gpu_info,
          out_gpu_feature_info,
          out_shared_image_capabilities));
  loop.Run();
}



void GpuServiceAsyncWaiter::GetVideoMemoryUsageStats(
    ::gpu::VideoMemoryUsageStats* out_stats) {
  base::RunLoop loop;
  proxy_->GetVideoMemoryUsageStats(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::gpu::VideoMemoryUsageStats* out_stats
,
             const ::gpu::VideoMemoryUsageStats& stats) {*out_stats = std::move(stats);
            loop->Quit();
          },
          &loop,
          out_stats));
  loop.Run();
}

::gpu::VideoMemoryUsageStats GpuServiceAsyncWaiter::GetVideoMemoryUsageStats(
    ) {
  ::gpu::VideoMemoryUsageStats async_wait_result;
  GetVideoMemoryUsageStats(&async_wait_result);
  return async_wait_result;
}

void GpuServiceAsyncWaiter::GetPeakMemoryUsage(
    uint32_t sequence_num, uint64_t* out_memory_usage, base::flat_map<::gpu::GpuPeakMemoryAllocationSource, uint64_t>* out_memory_per_allocation_source) {
  base::RunLoop loop;
  proxy_->GetPeakMemoryUsage(
      std::move(sequence_num),
      base::BindOnce(
          [](base::RunLoop* loop,
             uint64_t* out_memory_usage
,
             base::flat_map<::gpu::GpuPeakMemoryAllocationSource, uint64_t>* out_memory_per_allocation_source
,
             uint64_t memory_usage,
             const base::flat_map<::gpu::GpuPeakMemoryAllocationSource, uint64_t>& memory_per_allocation_source) {*out_memory_usage = std::move(memory_usage);*out_memory_per_allocation_source = std::move(memory_per_allocation_source);
            loop->Quit();
          },
          &loop,
          out_memory_usage,
          out_memory_per_allocation_source));
  loop.Run();
}



void GpuServiceAsyncWaiter::CommitCATransaction(
    ) {
  base::RunLoop loop;
  proxy_->CommitCATransaction(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void GpuServiceAsyncWaiter::GetDawnInfo(
    bool collect_metrics, std::vector<std::string>* out_dawn_info_list) {
  base::RunLoop loop;
  proxy_->GetDawnInfo(
      std::move(collect_metrics),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<std::string>* out_dawn_info_list
,
             const std::vector<std::string>& dawn_info_list) {*out_dawn_info_list = std::move(dawn_info_list);
            loop->Quit();
          },
          &loop,
          out_dawn_info_list));
  loop.Run();
}

std::vector<std::string> GpuServiceAsyncWaiter::GetDawnInfo(
    bool collect_metrics) {
  std::vector<std::string> async_wait_result;
  GetDawnInfo(std::move(collect_metrics),&async_wait_result);
  return async_wait_result;
}






}  // viz::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif