// services/viz/privileged/mojom/gl/gpu_service.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PRIVILEGED_MOJOM_GL_GPU_SERVICE_MOJOM_TEST_UTILS_H_
#define SERVICES_VIZ_PRIVILEGED_MOJOM_GL_GPU_SERVICE_MOJOM_TEST_UTILS_H_

#include "services/viz/privileged/mojom/gl/gpu_service.mojom.h"


namespace viz::mojom {


class  GpuServiceInterceptorForTesting : public GpuService {
  virtual GpuService* GetForwardingInterface() = 0;
  void EstablishGpuChannel(int32_t client_id, uint64_t client_tracing_id, bool is_gpu_host, bool enable_extra_handles_validation, EstablishGpuChannelCallback callback) override;
  void SetChannelClientPid(int32_t client_id, ::base::ProcessId client_pid) override;
  void SetChannelDiskCacheHandle(int32_t client_id, const ::gpu::GpuDiskCacheHandle& cache_handle) override;
  void SetChannelPersistentCachePendingBackend(int32_t client_id, const ::gpu::GpuDiskCacheHandle& cache_handle, ::persistent_cache::PendingBackend pending_backend) override;
  void OnDiskCacheHandleDestoyed(const ::gpu::GpuDiskCacheHandle& cache_handle) override;
  void CloseChannel(int32_t client_id) override;
  void CreateVideoEncodeAcceleratorProvider(::mojo::PendingReceiver<::media::mojom::VideoEncodeAcceleratorProvider> vea_provider) override;
  void BindWebNNContextProvider(::mojo::PendingReceiver<::webnn::mojom::WebNNContextProvider> receiver, int32_t client_id) override;
  void GetVideoMemoryUsageStats(GetVideoMemoryUsageStatsCallback callback) override;
  void StartPeakMemoryMonitor(uint32_t sequence_num) override;
  void GetPeakMemoryUsage(uint32_t sequence_num, GetPeakMemoryUsageCallback callback) override;
  void LoadedBlob(const ::gpu::GpuDiskCacheHandle& cache_handle, const std::string& key, const std::string& data) override;
  void WakeUpGpu() override;
  void GpuSwitched() override;
  void DisplayAdded() override;
  void DisplayRemoved() override;
  void DisplayMetricsChanged() override;
  void DestroyAllChannels() override;
  void OnBackgroundCleanup() override;
  void OnBackgrounded() override;
  void OnForegrounded() override;
  void OnMemoryPressure(::base::MemoryPressureLevel level) override;
  void BeginCATransaction() override;
  void CommitCATransaction(CommitCATransactionCallback callback) override;
  void GetDawnInfo(bool collect_metrics, GetDawnInfoCallback callback) override;
  void Crash() override;
  void Hang() override;
  void ThrowJavaException() override;
};
class  GpuServiceAsyncWaiter {
 public:
  explicit GpuServiceAsyncWaiter(GpuService* proxy);

  GpuServiceAsyncWaiter(const GpuServiceAsyncWaiter&) = delete;
  GpuServiceAsyncWaiter& operator=(const GpuServiceAsyncWaiter&) = delete;

  ~GpuServiceAsyncWaiter();
  void EstablishGpuChannel(
      int32_t client_id, uint64_t client_tracing_id, bool is_gpu_host, bool enable_extra_handles_validation, ::mojo::ScopedMessagePipeHandle* out_channel_handle, ::gpu::GPUInfo* out_gpu_info, ::gpu::GpuFeatureInfo* out_gpu_feature_info, ::gpu::SharedImageCapabilities* out_shared_image_capabilities);
  
  void GetVideoMemoryUsageStats(
      ::gpu::VideoMemoryUsageStats* out_stats);
  ::gpu::VideoMemoryUsageStats GetVideoMemoryUsageStats();
  void GetPeakMemoryUsage(
      uint32_t sequence_num, uint64_t* out_memory_usage, base::flat_map<::gpu::GpuPeakMemoryAllocationSource, uint64_t>* out_memory_per_allocation_source);
  
  void CommitCATransaction(
      );
  
  void GetDawnInfo(
      bool collect_metrics, std::vector<std::string>* out_dawn_info_list);
  std::vector<std::string> GetDawnInfo(bool collect_metrics);

 private:
  GpuService* const proxy_;
};




}  // viz::mojom

#endif  // SERVICES_VIZ_PRIVILEGED_MOJOM_GL_GPU_SERVICE_MOJOM_TEST_UTILS_H_