// services/viz/privileged/mojom/gl/gpu_service.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PRIVILEGED_MOJOM_GL_GPU_SERVICE_MOJOM_PARAMS_DATA_H_
#define SERVICES_VIZ_PRIVILEGED_MOJOM_GL_GPU_SERVICE_MOJOM_PARAMS_DATA_H_
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace viz::mojom {
namespace internal {
class  GpuService_EstablishGpuChannel_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t client_id;
  uint8_t is_gpu_host : 1;
  uint8_t enable_extra_handles_validation : 1;
  uint8_t pad2_[3];
  uint64_t client_tracing_id;

 private:
  friend class mojo::internal::MessageFragment<GpuService_EstablishGpuChannel_Params_Data>;

  GpuService_EstablishGpuChannel_Params_Data();
  ~GpuService_EstablishGpuChannel_Params_Data() = delete;
};
static_assert(sizeof(GpuService_EstablishGpuChannel_Params_Data) == 24,
              "Bad sizeof(GpuService_EstablishGpuChannel_Params_Data)");
class  GpuService_EstablishGpuChannel_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Handle_Data channel_handle;
  uint8_t pad0_[4];
  mojo::internal::Pointer<::gpu::mojom::internal::GpuInfo_Data> gpu_info;
  mojo::internal::Pointer<::gpu::mojom::internal::GpuFeatureInfo_Data> gpu_feature_info;
  mojo::internal::Pointer<::gpu::mojom::internal::SharedImageCapabilities_Data> shared_image_capabilities;

 private:
  friend class mojo::internal::MessageFragment<GpuService_EstablishGpuChannel_ResponseParams_Data>;

  GpuService_EstablishGpuChannel_ResponseParams_Data();
  ~GpuService_EstablishGpuChannel_ResponseParams_Data() = delete;
};
static_assert(sizeof(GpuService_EstablishGpuChannel_ResponseParams_Data) == 40,
              "Bad sizeof(GpuService_EstablishGpuChannel_ResponseParams_Data)");
class  GpuService_SetChannelClientPid_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t client_id;
  uint8_t pad0_[4];
  mojo::internal::Pointer<::mojo_base::mojom::internal::ProcessId_Data> client_pid;

 private:
  friend class mojo::internal::MessageFragment<GpuService_SetChannelClientPid_Params_Data>;

  GpuService_SetChannelClientPid_Params_Data();
  ~GpuService_SetChannelClientPid_Params_Data() = delete;
};
static_assert(sizeof(GpuService_SetChannelClientPid_Params_Data) == 24,
              "Bad sizeof(GpuService_SetChannelClientPid_Params_Data)");
class  GpuService_SetChannelDiskCacheHandle_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t client_id;
  uint8_t pad0_[4];
  ::gpu::mojom::internal::GpuDiskCacheHandle_Data cache_handle;

 private:
  friend class mojo::internal::MessageFragment<GpuService_SetChannelDiskCacheHandle_Params_Data>;

  GpuService_SetChannelDiskCacheHandle_Params_Data();
  ~GpuService_SetChannelDiskCacheHandle_Params_Data() = delete;
};
static_assert(sizeof(GpuService_SetChannelDiskCacheHandle_Params_Data) == 32,
              "Bad sizeof(GpuService_SetChannelDiskCacheHandle_Params_Data)");
class  GpuService_SetChannelPersistentCachePendingBackend_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t client_id;
  uint8_t pad0_[4];
  ::gpu::mojom::internal::GpuDiskCacheHandle_Data cache_handle;
  mojo::internal::Pointer<::persistent_cache::mojom::internal::PendingReadWriteBackend_Data> pending_backend;

 private:
  friend class mojo::internal::MessageFragment<GpuService_SetChannelPersistentCachePendingBackend_Params_Data>;

  GpuService_SetChannelPersistentCachePendingBackend_Params_Data();
  ~GpuService_SetChannelPersistentCachePendingBackend_Params_Data() = delete;
};
static_assert(sizeof(GpuService_SetChannelPersistentCachePendingBackend_Params_Data) == 40,
              "Bad sizeof(GpuService_SetChannelPersistentCachePendingBackend_Params_Data)");
class  GpuService_OnDiskCacheHandleDestoyed_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  ::gpu::mojom::internal::GpuDiskCacheHandle_Data cache_handle;

 private:
  friend class mojo::internal::MessageFragment<GpuService_OnDiskCacheHandleDestoyed_Params_Data>;

  GpuService_OnDiskCacheHandleDestoyed_Params_Data();
  ~GpuService_OnDiskCacheHandleDestoyed_Params_Data() = delete;
};
static_assert(sizeof(GpuService_OnDiskCacheHandleDestoyed_Params_Data) == 24,
              "Bad sizeof(GpuService_OnDiskCacheHandleDestoyed_Params_Data)");
class  GpuService_CloseChannel_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t client_id;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<GpuService_CloseChannel_Params_Data>;

  GpuService_CloseChannel_Params_Data();
  ~GpuService_CloseChannel_Params_Data() = delete;
};
static_assert(sizeof(GpuService_CloseChannel_Params_Data) == 16,
              "Bad sizeof(GpuService_CloseChannel_Params_Data)");
class  GpuService_CreateVideoEncodeAcceleratorProvider_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Handle_Data vea_provider;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<GpuService_CreateVideoEncodeAcceleratorProvider_Params_Data>;

  GpuService_CreateVideoEncodeAcceleratorProvider_Params_Data();
  ~GpuService_CreateVideoEncodeAcceleratorProvider_Params_Data() = delete;
};
static_assert(sizeof(GpuService_CreateVideoEncodeAcceleratorProvider_Params_Data) == 16,
              "Bad sizeof(GpuService_CreateVideoEncodeAcceleratorProvider_Params_Data)");
class  GpuService_BindWebNNContextProvider_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Handle_Data receiver;
  int32_t client_id;

 private:
  friend class mojo::internal::MessageFragment<GpuService_BindWebNNContextProvider_Params_Data>;

  GpuService_BindWebNNContextProvider_Params_Data();
  ~GpuService_BindWebNNContextProvider_Params_Data() = delete;
};
static_assert(sizeof(GpuService_BindWebNNContextProvider_Params_Data) == 16,
              "Bad sizeof(GpuService_BindWebNNContextProvider_Params_Data)");
class  GpuService_GetVideoMemoryUsageStats_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<GpuService_GetVideoMemoryUsageStats_Params_Data>;

  GpuService_GetVideoMemoryUsageStats_Params_Data();
  ~GpuService_GetVideoMemoryUsageStats_Params_Data() = delete;
};
static_assert(sizeof(GpuService_GetVideoMemoryUsageStats_Params_Data) == 8,
              "Bad sizeof(GpuService_GetVideoMemoryUsageStats_Params_Data)");
class  GpuService_GetVideoMemoryUsageStats_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::gpu::mojom::internal::VideoMemoryUsageStats_Data> stats;

 private:
  friend class mojo::internal::MessageFragment<GpuService_GetVideoMemoryUsageStats_ResponseParams_Data>;

  GpuService_GetVideoMemoryUsageStats_ResponseParams_Data();
  ~GpuService_GetVideoMemoryUsageStats_ResponseParams_Data() = delete;
};
static_assert(sizeof(GpuService_GetVideoMemoryUsageStats_ResponseParams_Data) == 16,
              "Bad sizeof(GpuService_GetVideoMemoryUsageStats_ResponseParams_Data)");
class  GpuService_StartPeakMemoryMonitor_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint32_t sequence_num;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<GpuService_StartPeakMemoryMonitor_Params_Data>;

  GpuService_StartPeakMemoryMonitor_Params_Data();
  ~GpuService_StartPeakMemoryMonitor_Params_Data() = delete;
};
static_assert(sizeof(GpuService_StartPeakMemoryMonitor_Params_Data) == 16,
              "Bad sizeof(GpuService_StartPeakMemoryMonitor_Params_Data)");
class  GpuService_GetPeakMemoryUsage_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint32_t sequence_num;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<GpuService_GetPeakMemoryUsage_Params_Data>;

  GpuService_GetPeakMemoryUsage_Params_Data();
  ~GpuService_GetPeakMemoryUsage_Params_Data() = delete;
};
static_assert(sizeof(GpuService_GetPeakMemoryUsage_Params_Data) == 16,
              "Bad sizeof(GpuService_GetPeakMemoryUsage_Params_Data)");
class  GpuService_GetPeakMemoryUsage_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint64_t memory_usage;
  mojo::internal::Pointer<mojo::internal::Map_Data<int32_t, uint64_t>> memory_per_allocation_source;

 private:
  friend class mojo::internal::MessageFragment<GpuService_GetPeakMemoryUsage_ResponseParams_Data>;

  GpuService_GetPeakMemoryUsage_ResponseParams_Data();
  ~GpuService_GetPeakMemoryUsage_ResponseParams_Data() = delete;
};
static_assert(sizeof(GpuService_GetPeakMemoryUsage_ResponseParams_Data) == 24,
              "Bad sizeof(GpuService_GetPeakMemoryUsage_ResponseParams_Data)");
class  GpuService_LoadedBlob_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  ::gpu::mojom::internal::GpuDiskCacheHandle_Data cache_handle;
  mojo::internal::Pointer<::mojo_base::mojom::internal::ByteString_Data> key;
  mojo::internal::Pointer<::mojo_base::mojom::internal::ByteString_Data> data;

 private:
  friend class mojo::internal::MessageFragment<GpuService_LoadedBlob_Params_Data>;

  GpuService_LoadedBlob_Params_Data();
  ~GpuService_LoadedBlob_Params_Data() = delete;
};
static_assert(sizeof(GpuService_LoadedBlob_Params_Data) == 40,
              "Bad sizeof(GpuService_LoadedBlob_Params_Data)");
class  GpuService_WakeUpGpu_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<GpuService_WakeUpGpu_Params_Data>;

  GpuService_WakeUpGpu_Params_Data();
  ~GpuService_WakeUpGpu_Params_Data() = delete;
};
static_assert(sizeof(GpuService_WakeUpGpu_Params_Data) == 8,
              "Bad sizeof(GpuService_WakeUpGpu_Params_Data)");
class  GpuService_GpuSwitched_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<GpuService_GpuSwitched_Params_Data>;

  GpuService_GpuSwitched_Params_Data();
  ~GpuService_GpuSwitched_Params_Data() = delete;
};
static_assert(sizeof(GpuService_GpuSwitched_Params_Data) == 8,
              "Bad sizeof(GpuService_GpuSwitched_Params_Data)");
class  GpuService_DisplayAdded_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<GpuService_DisplayAdded_Params_Data>;

  GpuService_DisplayAdded_Params_Data();
  ~GpuService_DisplayAdded_Params_Data() = delete;
};
static_assert(sizeof(GpuService_DisplayAdded_Params_Data) == 8,
              "Bad sizeof(GpuService_DisplayAdded_Params_Data)");
class  GpuService_DisplayRemoved_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<GpuService_DisplayRemoved_Params_Data>;

  GpuService_DisplayRemoved_Params_Data();
  ~GpuService_DisplayRemoved_Params_Data() = delete;
};
static_assert(sizeof(GpuService_DisplayRemoved_Params_Data) == 8,
              "Bad sizeof(GpuService_DisplayRemoved_Params_Data)");
class  GpuService_DisplayMetricsChanged_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<GpuService_DisplayMetricsChanged_Params_Data>;

  GpuService_DisplayMetricsChanged_Params_Data();
  ~GpuService_DisplayMetricsChanged_Params_Data() = delete;
};
static_assert(sizeof(GpuService_DisplayMetricsChanged_Params_Data) == 8,
              "Bad sizeof(GpuService_DisplayMetricsChanged_Params_Data)");
class  GpuService_DestroyAllChannels_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<GpuService_DestroyAllChannels_Params_Data>;

  GpuService_DestroyAllChannels_Params_Data();
  ~GpuService_DestroyAllChannels_Params_Data() = delete;
};
static_assert(sizeof(GpuService_DestroyAllChannels_Params_Data) == 8,
              "Bad sizeof(GpuService_DestroyAllChannels_Params_Data)");
class  GpuService_OnBackgroundCleanup_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<GpuService_OnBackgroundCleanup_Params_Data>;

  GpuService_OnBackgroundCleanup_Params_Data();
  ~GpuService_OnBackgroundCleanup_Params_Data() = delete;
};
static_assert(sizeof(GpuService_OnBackgroundCleanup_Params_Data) == 8,
              "Bad sizeof(GpuService_OnBackgroundCleanup_Params_Data)");
class  GpuService_OnBackgrounded_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<GpuService_OnBackgrounded_Params_Data>;

  GpuService_OnBackgrounded_Params_Data();
  ~GpuService_OnBackgrounded_Params_Data() = delete;
};
static_assert(sizeof(GpuService_OnBackgrounded_Params_Data) == 8,
              "Bad sizeof(GpuService_OnBackgrounded_Params_Data)");
class  GpuService_OnForegrounded_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<GpuService_OnForegrounded_Params_Data>;

  GpuService_OnForegrounded_Params_Data();
  ~GpuService_OnForegrounded_Params_Data() = delete;
};
static_assert(sizeof(GpuService_OnForegrounded_Params_Data) == 8,
              "Bad sizeof(GpuService_OnForegrounded_Params_Data)");
class  GpuService_OnMemoryPressure_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t level;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<GpuService_OnMemoryPressure_Params_Data>;

  GpuService_OnMemoryPressure_Params_Data();
  ~GpuService_OnMemoryPressure_Params_Data() = delete;
};
static_assert(sizeof(GpuService_OnMemoryPressure_Params_Data) == 16,
              "Bad sizeof(GpuService_OnMemoryPressure_Params_Data)");
class  GpuService_BeginCATransaction_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<GpuService_BeginCATransaction_Params_Data>;

  GpuService_BeginCATransaction_Params_Data();
  ~GpuService_BeginCATransaction_Params_Data() = delete;
};
static_assert(sizeof(GpuService_BeginCATransaction_Params_Data) == 8,
              "Bad sizeof(GpuService_BeginCATransaction_Params_Data)");
class  GpuService_CommitCATransaction_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<GpuService_CommitCATransaction_Params_Data>;

  GpuService_CommitCATransaction_Params_Data();
  ~GpuService_CommitCATransaction_Params_Data() = delete;
};
static_assert(sizeof(GpuService_CommitCATransaction_Params_Data) == 8,
              "Bad sizeof(GpuService_CommitCATransaction_Params_Data)");
class  GpuService_CommitCATransaction_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<GpuService_CommitCATransaction_ResponseParams_Data>;

  GpuService_CommitCATransaction_ResponseParams_Data();
  ~GpuService_CommitCATransaction_ResponseParams_Data() = delete;
};
static_assert(sizeof(GpuService_CommitCATransaction_ResponseParams_Data) == 8,
              "Bad sizeof(GpuService_CommitCATransaction_ResponseParams_Data)");
class  GpuService_GetDawnInfo_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t collect_metrics : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<GpuService_GetDawnInfo_Params_Data>;

  GpuService_GetDawnInfo_Params_Data();
  ~GpuService_GetDawnInfo_Params_Data() = delete;
};
static_assert(sizeof(GpuService_GetDawnInfo_Params_Data) == 16,
              "Bad sizeof(GpuService_GetDawnInfo_Params_Data)");
class  GpuService_GetDawnInfo_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<mojo::internal::String_Data>>> dawn_info_list;

 private:
  friend class mojo::internal::MessageFragment<GpuService_GetDawnInfo_ResponseParams_Data>;

  GpuService_GetDawnInfo_ResponseParams_Data();
  ~GpuService_GetDawnInfo_ResponseParams_Data() = delete;
};
static_assert(sizeof(GpuService_GetDawnInfo_ResponseParams_Data) == 16,
              "Bad sizeof(GpuService_GetDawnInfo_ResponseParams_Data)");
class  GpuService_Crash_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<GpuService_Crash_Params_Data>;

  GpuService_Crash_Params_Data();
  ~GpuService_Crash_Params_Data() = delete;
};
static_assert(sizeof(GpuService_Crash_Params_Data) == 8,
              "Bad sizeof(GpuService_Crash_Params_Data)");
class  GpuService_Hang_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<GpuService_Hang_Params_Data>;

  GpuService_Hang_Params_Data();
  ~GpuService_Hang_Params_Data() = delete;
};
static_assert(sizeof(GpuService_Hang_Params_Data) == 8,
              "Bad sizeof(GpuService_Hang_Params_Data)");
class  GpuService_ThrowJavaException_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<GpuService_ThrowJavaException_Params_Data>;

  GpuService_ThrowJavaException_Params_Data();
  ~GpuService_ThrowJavaException_Params_Data() = delete;
};
static_assert(sizeof(GpuService_ThrowJavaException_Params_Data) == 8,
              "Bad sizeof(GpuService_ThrowJavaException_Params_Data)");

}  // namespace internal


class GpuService_EstablishGpuChannel_ParamsDataView {
 public:
  GpuService_EstablishGpuChannel_ParamsDataView() = default;

  GpuService_EstablishGpuChannel_ParamsDataView(
      internal::GpuService_EstablishGpuChannel_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t client_id() const {
    return data_->client_id;
  }
  uint64_t client_tracing_id() const {
    return data_->client_tracing_id;
  }
  bool is_gpu_host() const {
    return data_->is_gpu_host;
  }
  bool enable_extra_handles_validation() const {
    return data_->enable_extra_handles_validation;
  }
 private:
  internal::GpuService_EstablishGpuChannel_Params_Data* data_ = nullptr;
};


class GpuService_EstablishGpuChannel_ResponseParamsDataView {
 public:
  GpuService_EstablishGpuChannel_ResponseParamsDataView() = default;

  GpuService_EstablishGpuChannel_ResponseParamsDataView(
      internal::GpuService_EstablishGpuChannel_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  mojo::ScopedMessagePipeHandle TakeChannelHandle() {
    mojo::ScopedMessagePipeHandle result;
    bool ret =
        mojo::internal::Deserialize<mojo::ScopedMessagePipeHandle>(
            &data_->channel_handle, &result, message_);
    DCHECK(ret);
    return result;
  }
  inline void GetGpuInfoDataView(
      ::gpu::mojom::GpuInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGpuInfo(UserType* output) {
    
    auto* pointer = data_->gpu_info.Get();
    return mojo::internal::Deserialize<::gpu::mojom::GpuInfoDataView>(
        pointer, output, message_);
  }
  inline void GetGpuFeatureInfoDataView(
      ::gpu::mojom::GpuFeatureInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGpuFeatureInfo(UserType* output) {
    
    auto* pointer = data_->gpu_feature_info.Get();
    return mojo::internal::Deserialize<::gpu::mojom::GpuFeatureInfoDataView>(
        pointer, output, message_);
  }
  inline void GetSharedImageCapabilitiesDataView(
      ::gpu::mojom::SharedImageCapabilitiesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSharedImageCapabilities(UserType* output) {
    
    auto* pointer = data_->shared_image_capabilities.Get();
    return mojo::internal::Deserialize<::gpu::mojom::SharedImageCapabilitiesDataView>(
        pointer, output, message_);
  }
 private:
  internal::GpuService_EstablishGpuChannel_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GpuService_SetChannelClientPid_ParamsDataView {
 public:
  GpuService_SetChannelClientPid_ParamsDataView() = default;

  GpuService_SetChannelClientPid_ParamsDataView(
      internal::GpuService_SetChannelClientPid_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t client_id() const {
    return data_->client_id;
  }
  inline void GetClientPidDataView(
      ::mojo_base::mojom::ProcessIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadClientPid(UserType* output) {
    
    auto* pointer = data_->client_pid.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ProcessIdDataView>(
        pointer, output, message_);
  }
 private:
  internal::GpuService_SetChannelClientPid_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GpuService_SetChannelDiskCacheHandle_ParamsDataView {
 public:
  GpuService_SetChannelDiskCacheHandle_ParamsDataView() = default;

  GpuService_SetChannelDiskCacheHandle_ParamsDataView(
      internal::GpuService_SetChannelDiskCacheHandle_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t client_id() const {
    return data_->client_id;
  }
  inline void GetCacheHandleDataView(
      ::gpu::mojom::GpuDiskCacheHandleDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCacheHandle(UserType* output) {
    
    auto* pointer = !data_->cache_handle.is_null() ? &data_->cache_handle : nullptr;
    return mojo::internal::Deserialize<::gpu::mojom::GpuDiskCacheHandleDataView>(
        pointer, output, message_);
  }
 private:
  internal::GpuService_SetChannelDiskCacheHandle_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GpuService_SetChannelPersistentCachePendingBackend_ParamsDataView {
 public:
  GpuService_SetChannelPersistentCachePendingBackend_ParamsDataView() = default;

  GpuService_SetChannelPersistentCachePendingBackend_ParamsDataView(
      internal::GpuService_SetChannelPersistentCachePendingBackend_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t client_id() const {
    return data_->client_id;
  }
  inline void GetCacheHandleDataView(
      ::gpu::mojom::GpuDiskCacheHandleDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCacheHandle(UserType* output) {
    
    auto* pointer = !data_->cache_handle.is_null() ? &data_->cache_handle : nullptr;
    return mojo::internal::Deserialize<::gpu::mojom::GpuDiskCacheHandleDataView>(
        pointer, output, message_);
  }
  inline void GetPendingBackendDataView(
      ::persistent_cache::mojom::PendingReadWriteBackendDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPendingBackend(UserType* output) {
    
    auto* pointer = data_->pending_backend.Get();
    return mojo::internal::Deserialize<::persistent_cache::mojom::PendingReadWriteBackendDataView>(
        pointer, output, message_);
  }
 private:
  internal::GpuService_SetChannelPersistentCachePendingBackend_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GpuService_OnDiskCacheHandleDestoyed_ParamsDataView {
 public:
  GpuService_OnDiskCacheHandleDestoyed_ParamsDataView() = default;

  GpuService_OnDiskCacheHandleDestoyed_ParamsDataView(
      internal::GpuService_OnDiskCacheHandleDestoyed_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetCacheHandleDataView(
      ::gpu::mojom::GpuDiskCacheHandleDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCacheHandle(UserType* output) {
    
    auto* pointer = !data_->cache_handle.is_null() ? &data_->cache_handle : nullptr;
    return mojo::internal::Deserialize<::gpu::mojom::GpuDiskCacheHandleDataView>(
        pointer, output, message_);
  }
 private:
  internal::GpuService_OnDiskCacheHandleDestoyed_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GpuService_CloseChannel_ParamsDataView {
 public:
  GpuService_CloseChannel_ParamsDataView() = default;

  GpuService_CloseChannel_ParamsDataView(
      internal::GpuService_CloseChannel_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t client_id() const {
    return data_->client_id;
  }
 private:
  internal::GpuService_CloseChannel_Params_Data* data_ = nullptr;
};


class GpuService_CreateVideoEncodeAcceleratorProvider_ParamsDataView {
 public:
  GpuService_CreateVideoEncodeAcceleratorProvider_ParamsDataView() = default;

  GpuService_CreateVideoEncodeAcceleratorProvider_ParamsDataView(
      internal::GpuService_CreateVideoEncodeAcceleratorProvider_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeVeaProvider() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::media::mojom::VideoEncodeAcceleratorProviderInterfaceBase>>(
            &data_->vea_provider, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::GpuService_CreateVideoEncodeAcceleratorProvider_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GpuService_BindWebNNContextProvider_ParamsDataView {
 public:
  GpuService_BindWebNNContextProvider_ParamsDataView() = default;

  GpuService_BindWebNNContextProvider_ParamsDataView(
      internal::GpuService_BindWebNNContextProvider_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::webnn::mojom::WebNNContextProviderInterfaceBase>>(
            &data_->receiver, &result, message_);
    DCHECK(ret);
    return result;
  }
  int32_t client_id() const {
    return data_->client_id;
  }
 private:
  internal::GpuService_BindWebNNContextProvider_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GpuService_GetVideoMemoryUsageStats_ParamsDataView {
 public:
  GpuService_GetVideoMemoryUsageStats_ParamsDataView() = default;

  GpuService_GetVideoMemoryUsageStats_ParamsDataView(
      internal::GpuService_GetVideoMemoryUsageStats_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::GpuService_GetVideoMemoryUsageStats_Params_Data* data_ = nullptr;
};


class GpuService_GetVideoMemoryUsageStats_ResponseParamsDataView {
 public:
  GpuService_GetVideoMemoryUsageStats_ResponseParamsDataView() = default;

  GpuService_GetVideoMemoryUsageStats_ResponseParamsDataView(
      internal::GpuService_GetVideoMemoryUsageStats_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetStatsDataView(
      ::gpu::mojom::VideoMemoryUsageStatsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStats(UserType* output) {
    
    auto* pointer = data_->stats.Get();
    return mojo::internal::Deserialize<::gpu::mojom::VideoMemoryUsageStatsDataView>(
        pointer, output, message_);
  }
 private:
  internal::GpuService_GetVideoMemoryUsageStats_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GpuService_StartPeakMemoryMonitor_ParamsDataView {
 public:
  GpuService_StartPeakMemoryMonitor_ParamsDataView() = default;

  GpuService_StartPeakMemoryMonitor_ParamsDataView(
      internal::GpuService_StartPeakMemoryMonitor_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint32_t sequence_num() const {
    return data_->sequence_num;
  }
 private:
  internal::GpuService_StartPeakMemoryMonitor_Params_Data* data_ = nullptr;
};


class GpuService_GetPeakMemoryUsage_ParamsDataView {
 public:
  GpuService_GetPeakMemoryUsage_ParamsDataView() = default;

  GpuService_GetPeakMemoryUsage_ParamsDataView(
      internal::GpuService_GetPeakMemoryUsage_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint32_t sequence_num() const {
    return data_->sequence_num;
  }
 private:
  internal::GpuService_GetPeakMemoryUsage_Params_Data* data_ = nullptr;
};


class GpuService_GetPeakMemoryUsage_ResponseParamsDataView {
 public:
  GpuService_GetPeakMemoryUsage_ResponseParamsDataView() = default;

  GpuService_GetPeakMemoryUsage_ResponseParamsDataView(
      internal::GpuService_GetPeakMemoryUsage_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint64_t memory_usage() const {
    return data_->memory_usage;
  }
  inline void GetMemoryPerAllocationSourceDataView(
      mojo::MapDataView<::gpu::mojom::GpuPeakMemoryAllocationSource, uint64_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMemoryPerAllocationSource(UserType* output) {
    
    auto* pointer = data_->memory_per_allocation_source.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::gpu::mojom::GpuPeakMemoryAllocationSource, uint64_t>>(
        pointer, output, message_);
  }
 private:
  internal::GpuService_GetPeakMemoryUsage_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GpuService_LoadedBlob_ParamsDataView {
 public:
  GpuService_LoadedBlob_ParamsDataView() = default;

  GpuService_LoadedBlob_ParamsDataView(
      internal::GpuService_LoadedBlob_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetCacheHandleDataView(
      ::gpu::mojom::GpuDiskCacheHandleDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCacheHandle(UserType* output) {
    
    auto* pointer = !data_->cache_handle.is_null() ? &data_->cache_handle : nullptr;
    return mojo::internal::Deserialize<::gpu::mojom::GpuDiskCacheHandleDataView>(
        pointer, output, message_);
  }
  inline void GetKeyDataView(
      ::mojo_base::mojom::ByteStringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadKey(UserType* output) {
    
    auto* pointer = data_->key.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ByteStringDataView>(
        pointer, output, message_);
  }
  inline void GetDataDataView(
      ::mojo_base::mojom::ByteStringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadData(UserType* output) {
    
    auto* pointer = data_->data.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ByteStringDataView>(
        pointer, output, message_);
  }
 private:
  internal::GpuService_LoadedBlob_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GpuService_WakeUpGpu_ParamsDataView {
 public:
  GpuService_WakeUpGpu_ParamsDataView() = default;

  GpuService_WakeUpGpu_ParamsDataView(
      internal::GpuService_WakeUpGpu_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::GpuService_WakeUpGpu_Params_Data* data_ = nullptr;
};


class GpuService_GpuSwitched_ParamsDataView {
 public:
  GpuService_GpuSwitched_ParamsDataView() = default;

  GpuService_GpuSwitched_ParamsDataView(
      internal::GpuService_GpuSwitched_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::GpuService_GpuSwitched_Params_Data* data_ = nullptr;
};


class GpuService_DisplayAdded_ParamsDataView {
 public:
  GpuService_DisplayAdded_ParamsDataView() = default;

  GpuService_DisplayAdded_ParamsDataView(
      internal::GpuService_DisplayAdded_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::GpuService_DisplayAdded_Params_Data* data_ = nullptr;
};


class GpuService_DisplayRemoved_ParamsDataView {
 public:
  GpuService_DisplayRemoved_ParamsDataView() = default;

  GpuService_DisplayRemoved_ParamsDataView(
      internal::GpuService_DisplayRemoved_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::GpuService_DisplayRemoved_Params_Data* data_ = nullptr;
};


class GpuService_DisplayMetricsChanged_ParamsDataView {
 public:
  GpuService_DisplayMetricsChanged_ParamsDataView() = default;

  GpuService_DisplayMetricsChanged_ParamsDataView(
      internal::GpuService_DisplayMetricsChanged_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::GpuService_DisplayMetricsChanged_Params_Data* data_ = nullptr;
};


class GpuService_DestroyAllChannels_ParamsDataView {
 public:
  GpuService_DestroyAllChannels_ParamsDataView() = default;

  GpuService_DestroyAllChannels_ParamsDataView(
      internal::GpuService_DestroyAllChannels_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::GpuService_DestroyAllChannels_Params_Data* data_ = nullptr;
};


class GpuService_OnBackgroundCleanup_ParamsDataView {
 public:
  GpuService_OnBackgroundCleanup_ParamsDataView() = default;

  GpuService_OnBackgroundCleanup_ParamsDataView(
      internal::GpuService_OnBackgroundCleanup_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::GpuService_OnBackgroundCleanup_Params_Data* data_ = nullptr;
};


class GpuService_OnBackgrounded_ParamsDataView {
 public:
  GpuService_OnBackgrounded_ParamsDataView() = default;

  GpuService_OnBackgrounded_ParamsDataView(
      internal::GpuService_OnBackgrounded_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::GpuService_OnBackgrounded_Params_Data* data_ = nullptr;
};


class GpuService_OnForegrounded_ParamsDataView {
 public:
  GpuService_OnForegrounded_ParamsDataView() = default;

  GpuService_OnForegrounded_ParamsDataView(
      internal::GpuService_OnForegrounded_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::GpuService_OnForegrounded_Params_Data* data_ = nullptr;
};


class GpuService_OnMemoryPressure_ParamsDataView {
 public:
  GpuService_OnMemoryPressure_ParamsDataView() = default;

  GpuService_OnMemoryPressure_ParamsDataView(
      internal::GpuService_OnMemoryPressure_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadLevel(UserType* output) const {
    auto data_value = data_->level;
    return mojo::internal::Deserialize<::mojo_base::mojom::MemoryPressureLevel>(
        data_value, output);
  }
  ::mojo_base::mojom::MemoryPressureLevel level() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::mojo_base::mojom::MemoryPressureLevel>(data_->level));
  }
 private:
  internal::GpuService_OnMemoryPressure_Params_Data* data_ = nullptr;
};


class GpuService_BeginCATransaction_ParamsDataView {
 public:
  GpuService_BeginCATransaction_ParamsDataView() = default;

  GpuService_BeginCATransaction_ParamsDataView(
      internal::GpuService_BeginCATransaction_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::GpuService_BeginCATransaction_Params_Data* data_ = nullptr;
};


class GpuService_CommitCATransaction_ParamsDataView {
 public:
  GpuService_CommitCATransaction_ParamsDataView() = default;

  GpuService_CommitCATransaction_ParamsDataView(
      internal::GpuService_CommitCATransaction_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::GpuService_CommitCATransaction_Params_Data* data_ = nullptr;
};


class GpuService_CommitCATransaction_ResponseParamsDataView {
 public:
  GpuService_CommitCATransaction_ResponseParamsDataView() = default;

  GpuService_CommitCATransaction_ResponseParamsDataView(
      internal::GpuService_CommitCATransaction_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::GpuService_CommitCATransaction_ResponseParams_Data* data_ = nullptr;
};


class GpuService_GetDawnInfo_ParamsDataView {
 public:
  GpuService_GetDawnInfo_ParamsDataView() = default;

  GpuService_GetDawnInfo_ParamsDataView(
      internal::GpuService_GetDawnInfo_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool collect_metrics() const {
    return data_->collect_metrics;
  }
 private:
  internal::GpuService_GetDawnInfo_Params_Data* data_ = nullptr;
};


class GpuService_GetDawnInfo_ResponseParamsDataView {
 public:
  GpuService_GetDawnInfo_ResponseParamsDataView() = default;

  GpuService_GetDawnInfo_ResponseParamsDataView(
      internal::GpuService_GetDawnInfo_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDawnInfoListDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDawnInfoList(UserType* output) {
    
    auto* pointer = data_->dawn_info_list.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
 private:
  internal::GpuService_GetDawnInfo_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GpuService_Crash_ParamsDataView {
 public:
  GpuService_Crash_ParamsDataView() = default;

  GpuService_Crash_ParamsDataView(
      internal::GpuService_Crash_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::GpuService_Crash_Params_Data* data_ = nullptr;
};


class GpuService_Hang_ParamsDataView {
 public:
  GpuService_Hang_ParamsDataView() = default;

  GpuService_Hang_ParamsDataView(
      internal::GpuService_Hang_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::GpuService_Hang_Params_Data* data_ = nullptr;
};


class GpuService_ThrowJavaException_ParamsDataView {
 public:
  GpuService_ThrowJavaException_ParamsDataView() = default;

  GpuService_ThrowJavaException_ParamsDataView(
      internal::GpuService_ThrowJavaException_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::GpuService_ThrowJavaException_Params_Data* data_ = nullptr;
};



inline void GpuService_EstablishGpuChannel_ResponseParamsDataView::GetGpuInfoDataView(
    ::gpu::mojom::GpuInfoDataView* output) {
  auto pointer = data_->gpu_info.Get();
  *output = ::gpu::mojom::GpuInfoDataView(pointer, message_);
}
inline void GpuService_EstablishGpuChannel_ResponseParamsDataView::GetGpuFeatureInfoDataView(
    ::gpu::mojom::GpuFeatureInfoDataView* output) {
  auto pointer = data_->gpu_feature_info.Get();
  *output = ::gpu::mojom::GpuFeatureInfoDataView(pointer, message_);
}
inline void GpuService_EstablishGpuChannel_ResponseParamsDataView::GetSharedImageCapabilitiesDataView(
    ::gpu::mojom::SharedImageCapabilitiesDataView* output) {
  auto pointer = data_->shared_image_capabilities.Get();
  *output = ::gpu::mojom::SharedImageCapabilitiesDataView(pointer, message_);
}


inline void GpuService_SetChannelClientPid_ParamsDataView::GetClientPidDataView(
    ::mojo_base::mojom::ProcessIdDataView* output) {
  auto pointer = data_->client_pid.Get();
  *output = ::mojo_base::mojom::ProcessIdDataView(pointer, message_);
}


inline void GpuService_SetChannelDiskCacheHandle_ParamsDataView::GetCacheHandleDataView(
    ::gpu::mojom::GpuDiskCacheHandleDataView* output) {
  auto pointer = &data_->cache_handle;
  *output = ::gpu::mojom::GpuDiskCacheHandleDataView(pointer, message_);
}


inline void GpuService_SetChannelPersistentCachePendingBackend_ParamsDataView::GetCacheHandleDataView(
    ::gpu::mojom::GpuDiskCacheHandleDataView* output) {
  auto pointer = &data_->cache_handle;
  *output = ::gpu::mojom::GpuDiskCacheHandleDataView(pointer, message_);
}
inline void GpuService_SetChannelPersistentCachePendingBackend_ParamsDataView::GetPendingBackendDataView(
    ::persistent_cache::mojom::PendingReadWriteBackendDataView* output) {
  auto pointer = data_->pending_backend.Get();
  *output = ::persistent_cache::mojom::PendingReadWriteBackendDataView(pointer, message_);
}


inline void GpuService_OnDiskCacheHandleDestoyed_ParamsDataView::GetCacheHandleDataView(
    ::gpu::mojom::GpuDiskCacheHandleDataView* output) {
  auto pointer = &data_->cache_handle;
  *output = ::gpu::mojom::GpuDiskCacheHandleDataView(pointer, message_);
}










inline void GpuService_GetVideoMemoryUsageStats_ResponseParamsDataView::GetStatsDataView(
    ::gpu::mojom::VideoMemoryUsageStatsDataView* output) {
  auto pointer = data_->stats.Get();
  *output = ::gpu::mojom::VideoMemoryUsageStatsDataView(pointer, message_);
}






inline void GpuService_GetPeakMemoryUsage_ResponseParamsDataView::GetMemoryPerAllocationSourceDataView(
    mojo::MapDataView<::gpu::mojom::GpuPeakMemoryAllocationSource, uint64_t>* output) {
  auto pointer = data_->memory_per_allocation_source.Get();
  *output = mojo::MapDataView<::gpu::mojom::GpuPeakMemoryAllocationSource, uint64_t>(pointer, message_);
}


inline void GpuService_LoadedBlob_ParamsDataView::GetCacheHandleDataView(
    ::gpu::mojom::GpuDiskCacheHandleDataView* output) {
  auto pointer = &data_->cache_handle;
  *output = ::gpu::mojom::GpuDiskCacheHandleDataView(pointer, message_);
}
inline void GpuService_LoadedBlob_ParamsDataView::GetKeyDataView(
    ::mojo_base::mojom::ByteStringDataView* output) {
  auto pointer = data_->key.Get();
  *output = ::mojo_base::mojom::ByteStringDataView(pointer, message_);
}
inline void GpuService_LoadedBlob_ParamsDataView::GetDataDataView(
    ::mojo_base::mojom::ByteStringDataView* output) {
  auto pointer = data_->data.Get();
  *output = ::mojo_base::mojom::ByteStringDataView(pointer, message_);
}






























inline void GpuService_GetDawnInfo_ResponseParamsDataView::GetDawnInfoListDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->dawn_info_list.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}









}  // viz::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // SERVICES_VIZ_PRIVILEGED_MOJOM_GL_GPU_SERVICE_MOJOM_PARAMS_DATA_H_