// services/viz/privileged/mojom/compositing/frame_sink_video_capture.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PRIVILEGED_MOJOM_COMPOSITING_FRAME_SINK_VIDEO_CAPTURE_MOJOM_DATA_VIEW_H_
#define SERVICES_VIZ_PRIVILEGED_MOJOM_COMPOSITING_FRAME_SINK_VIDEO_CAPTURE_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "services/viz/privileged/mojom/compositing/frame_sink_video_capture.mojom-shared-internal.h"
#include "media/capture/mojom/video_capture_buffer.mojom-shared.h"
#include "media/capture/mojom/video_capture_types.mojom-shared.h"
#include "media/mojo/mojom/media_types.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/token.mojom-shared.h"
#include "services/viz/public/mojom/compositing/frame_sink_id.mojom-shared.h"
#include "services/viz/public/mojom/compositing/subtree_capture_id.mojom-shared.h"
#include "skia/public/mojom/bitmap.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"


namespace viz::mojom {
class VideoCaptureTargetDataView;

class VideoCaptureSubTargetDataView;


}  // viz::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::viz::mojom::VideoCaptureTargetDataView> {
  using Data = ::viz::mojom::internal::VideoCaptureTarget_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::VideoCaptureSubTargetDataView> {
  using Data = ::viz::mojom::internal::VideoCaptureSubTarget_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace viz::mojom {


enum class BufferFormatPreference : int32_t {
  
  kDefault = 0,
  
  kPreferGpuMemoryBuffer = 1,
  
  kPreferSharedImageWithNativeHandle = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, BufferFormatPreference value);
inline bool IsKnownEnumValue(BufferFormatPreference value) {
  return internal::BufferFormatPreference_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class FrameSinkVideoConsumerFrameCallbacksInterfaceBase {};

using FrameSinkVideoConsumerFrameCallbacksPtrDataView =
    mojo::InterfacePtrDataView<FrameSinkVideoConsumerFrameCallbacksInterfaceBase>;
using FrameSinkVideoConsumerFrameCallbacksRequestDataView =
    mojo::InterfaceRequestDataView<FrameSinkVideoConsumerFrameCallbacksInterfaceBase>;
using FrameSinkVideoConsumerFrameCallbacksAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<FrameSinkVideoConsumerFrameCallbacksInterfaceBase>;
using FrameSinkVideoConsumerFrameCallbacksAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<FrameSinkVideoConsumerFrameCallbacksInterfaceBase>;
class FrameSinkVideoConsumerInterfaceBase {};

using FrameSinkVideoConsumerPtrDataView =
    mojo::InterfacePtrDataView<FrameSinkVideoConsumerInterfaceBase>;
using FrameSinkVideoConsumerRequestDataView =
    mojo::InterfaceRequestDataView<FrameSinkVideoConsumerInterfaceBase>;
using FrameSinkVideoConsumerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<FrameSinkVideoConsumerInterfaceBase>;
using FrameSinkVideoConsumerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<FrameSinkVideoConsumerInterfaceBase>;
class FrameSinkVideoCapturerInterfaceBase {};

using FrameSinkVideoCapturerPtrDataView =
    mojo::InterfacePtrDataView<FrameSinkVideoCapturerInterfaceBase>;
using FrameSinkVideoCapturerRequestDataView =
    mojo::InterfaceRequestDataView<FrameSinkVideoCapturerInterfaceBase>;
using FrameSinkVideoCapturerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<FrameSinkVideoCapturerInterfaceBase>;
using FrameSinkVideoCapturerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<FrameSinkVideoCapturerInterfaceBase>;
class FrameSinkVideoCaptureOverlayInterfaceBase {};

using FrameSinkVideoCaptureOverlayPtrDataView =
    mojo::InterfacePtrDataView<FrameSinkVideoCaptureOverlayInterfaceBase>;
using FrameSinkVideoCaptureOverlayRequestDataView =
    mojo::InterfaceRequestDataView<FrameSinkVideoCaptureOverlayInterfaceBase>;
using FrameSinkVideoCaptureOverlayAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<FrameSinkVideoCaptureOverlayInterfaceBase>;
using FrameSinkVideoCaptureOverlayAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<FrameSinkVideoCaptureOverlayInterfaceBase>;


class VideoCaptureTargetDataView {
 public:
  VideoCaptureTargetDataView() = default;

  VideoCaptureTargetDataView(
      internal::VideoCaptureTarget_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFrameSinkIdDataView(
      ::viz::mojom::FrameSinkIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrameSinkId(UserType* output) {
    
    auto* pointer = data_->frame_sink_id.Get();
    return mojo::internal::Deserialize<::viz::mojom::FrameSinkIdDataView>(
        pointer, output, message_);
  }
  inline void GetSubTargetDataView(
      VideoCaptureSubTargetDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSubTarget(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::viz::mojom::VideoCaptureSubTargetDataView, UserType>(),
    "Attempting to read the optional `sub_target` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSubTarget` instead "
    "of `ReadSubTarget if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->sub_target.is_null() ? &data_->sub_target : nullptr;
    return mojo::internal::Deserialize<::viz::mojom::VideoCaptureSubTargetDataView>(
        pointer, output, message_);
  }
 private:
  internal::VideoCaptureTarget_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class VideoCaptureSubTargetDataView {
 public:
  using Tag = internal::VideoCaptureSubTarget_Data::VideoCaptureSubTarget_Tag;

  VideoCaptureSubTargetDataView() = default;

  VideoCaptureSubTargetDataView(
      internal::VideoCaptureSubTarget_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_subtree_capture_id() const { return data_->tag == Tag::kSubtreeCaptureId; }
  inline void GetSubtreeCaptureIdDataView(
      ::viz::mojom::SubtreeCaptureIdDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSubtreeCaptureId(UserType* output) const {
    
    CHECK(is_subtree_capture_id());
    return mojo::internal::Deserialize<::viz::mojom::SubtreeCaptureIdDataView>(
        data_->data.f_subtree_capture_id.Get(), output, message_);
  }
  bool is_region_capture_crop_id() const { return data_->tag == Tag::kRegionCaptureCropId; }
  inline void GetRegionCaptureCropIdDataView(
      ::mojo_base::mojom::TokenDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadRegionCaptureCropId(UserType* output) const {
    
    CHECK(is_region_capture_crop_id());
    return mojo::internal::Deserialize<::mojo_base::mojom::TokenDataView>(
        data_->data.f_region_capture_crop_id.Get(), output, message_);
  }

 private:
  internal::VideoCaptureSubTarget_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // viz::mojom

#endif  // SERVICES_VIZ_PRIVILEGED_MOJOM_COMPOSITING_FRAME_SINK_VIDEO_CAPTURE_MOJOM_DATA_VIEW_H_