// services/viz/privileged/mojom/compositing/frame_sink_manager.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/viz/privileged/mojom/compositing/frame_sink_manager.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/viz/privileged/mojom/compositing/frame_sink_manager.mojom-params-data.h"
#include "services/viz/privileged/mojom/compositing/frame_sink_manager.mojom-shared-message-ids.h"

#include "services/viz/privileged/mojom/compositing/frame_sink_manager.mojom-import-headers.h"
#include "services/viz/privileged/mojom/compositing/frame_sink_manager.mojom-test-utils.h"


namespace viz::mojom {
RootCompositorFrameSinkParams::RootCompositorFrameSinkParams()
    : frame_sink_id(),
      widget(),
      gpu_compositing(true),
      renderer_settings(),
      send_swap_size_notifications(false),
      disable_frame_rate_limit(false),
      compositor_frame_sink(),
      compositor_frame_sink_client(),
      display_private(),
      display_client(),
      external_begin_frame_controller(),
      external_begin_frame_controller_client() {}

RootCompositorFrameSinkParams::RootCompositorFrameSinkParams(
    const ::viz::FrameSinkId& frame_sink_id_in,
    ::gpu::SurfaceHandle widget_in,
    bool gpu_compositing_in,
    const ::viz::RendererSettings& renderer_settings_in,
    bool send_swap_size_notifications_in,
    bool disable_frame_rate_limit_in,
    ::mojo::PendingAssociatedReceiver<::viz::mojom::CompositorFrameSink> compositor_frame_sink_in,
    ::mojo::PendingRemote<::viz::mojom::CompositorFrameSinkClient> compositor_frame_sink_client_in,
    ::mojo::PendingAssociatedReceiver<::viz::mojom::DisplayPrivate> display_private_in,
    ::mojo::PendingRemote<::viz::mojom::DisplayClient> display_client_in,
    ::mojo::PendingAssociatedReceiver<::viz::mojom::ExternalBeginFrameController> external_begin_frame_controller_in,
    ::mojo::PendingAssociatedRemote<::viz::mojom::ExternalBeginFrameControllerClient> external_begin_frame_controller_client_in)
    : frame_sink_id(std::move(frame_sink_id_in)),
      widget(std::move(widget_in)),
      gpu_compositing(std::move(gpu_compositing_in)),
      renderer_settings(std::move(renderer_settings_in)),
      send_swap_size_notifications(std::move(send_swap_size_notifications_in)),
      disable_frame_rate_limit(std::move(disable_frame_rate_limit_in)),
      compositor_frame_sink(std::move(compositor_frame_sink_in)),
      compositor_frame_sink_client(std::move(compositor_frame_sink_client_in)),
      display_private(std::move(display_private_in)),
      display_client(std::move(display_client_in)),
      external_begin_frame_controller(std::move(external_begin_frame_controller_in)),
      external_begin_frame_controller_client(std::move(external_begin_frame_controller_client_in)) {}

RootCompositorFrameSinkParams::~RootCompositorFrameSinkParams() = default;

void RootCompositorFrameSinkParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_sink_id"), this->frame_sink_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::viz::FrameSinkId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "widget"), this->widget,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::gpu::SurfaceHandle>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "gpu_compositing"), this->gpu_compositing,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "renderer_settings"), this->renderer_settings,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::viz::RendererSettings&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "send_swap_size_notifications"), this->send_swap_size_notifications,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "disable_frame_rate_limit"), this->disable_frame_rate_limit,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "compositor_frame_sink"), this->compositor_frame_sink,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingAssociatedReceiver<::viz::mojom::CompositorFrameSink>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "compositor_frame_sink_client"), this->compositor_frame_sink_client,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<::viz::mojom::CompositorFrameSinkClient>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "display_private"), this->display_private,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingAssociatedReceiver<::viz::mojom::DisplayPrivate>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "display_client"), this->display_client,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<::viz::mojom::DisplayClient>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "external_begin_frame_controller"), this->external_begin_frame_controller,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingAssociatedReceiver<::viz::mojom::ExternalBeginFrameController>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "external_begin_frame_controller_client"), this->external_begin_frame_controller_client,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingAssociatedRemote<::viz::mojom::ExternalBeginFrameControllerClient>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool RootCompositorFrameSinkParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

FrameSinkManager::IPCStableHashFunction FrameSinkManager::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::FrameSinkManager>(message.name())) {
    case messages::FrameSinkManager::kRegisterFrameSinkId: {
      return &FrameSinkManager::RegisterFrameSinkId_Sym::IPCStableHash;
    }
    case messages::FrameSinkManager::kInvalidateFrameSinkId: {
      return &FrameSinkManager::InvalidateFrameSinkId_Sym::IPCStableHash;
    }
    case messages::FrameSinkManager::kSetFrameSinkDebugLabel: {
      return &FrameSinkManager::SetFrameSinkDebugLabel_Sym::IPCStableHash;
    }
    case messages::FrameSinkManager::kCreateRootCompositorFrameSink: {
      return &FrameSinkManager::CreateRootCompositorFrameSink_Sym::IPCStableHash;
    }
    case messages::FrameSinkManager::kCreateFrameSinkBundle: {
      return &FrameSinkManager::CreateFrameSinkBundle_Sym::IPCStableHash;
    }
    case messages::FrameSinkManager::kCreateCompositorFrameSink: {
      return &FrameSinkManager::CreateCompositorFrameSink_Sym::IPCStableHash;
    }
    case messages::FrameSinkManager::kDestroyCompositorFrameSink: {
      return &FrameSinkManager::DestroyCompositorFrameSink_Sym::IPCStableHash;
    }
    case messages::FrameSinkManager::kRegisterFrameSinkHierarchy: {
      return &FrameSinkManager::RegisterFrameSinkHierarchy_Sym::IPCStableHash;
    }
    case messages::FrameSinkManager::kUnregisterFrameSinkHierarchy: {
      return &FrameSinkManager::UnregisterFrameSinkHierarchy_Sym::IPCStableHash;
    }
    case messages::FrameSinkManager::kAddVideoDetectorObserver: {
      return &FrameSinkManager::AddVideoDetectorObserver_Sym::IPCStableHash;
    }
    case messages::FrameSinkManager::kCreateVideoCapturer: {
      return &FrameSinkManager::CreateVideoCapturer_Sym::IPCStableHash;
    }
    case messages::FrameSinkManager::kEvictSurfaces: {
      return &FrameSinkManager::EvictSurfaces_Sym::IPCStableHash;
    }
    case messages::FrameSinkManager::kThrottle: {
      return &FrameSinkManager::Throttle_Sym::IPCStableHash;
    }
    case messages::FrameSinkManager::kStartThrottlingAllFrameSinks: {
      return &FrameSinkManager::StartThrottlingAllFrameSinks_Sym::IPCStableHash;
    }
    case messages::FrameSinkManager::kStopThrottlingAllFrameSinks: {
      return &FrameSinkManager::StopThrottlingAllFrameSinks_Sym::IPCStableHash;
    }
    case messages::FrameSinkManager::kRequestCopyOfOutput: {
      return &FrameSinkManager::RequestCopyOfOutput_Sym::IPCStableHash;
    }
    case messages::FrameSinkManager::kUpdateDebugRendererSettings: {
      return &FrameSinkManager::UpdateDebugRendererSettings_Sym::IPCStableHash;
    }
    case messages::FrameSinkManager::kClearUnclaimedViewTransitionResources: {
      return &FrameSinkManager::ClearUnclaimedViewTransitionResources_Sym::IPCStableHash;
    }
    case messages::FrameSinkManager::kCreateMetricsRecorderForTest: {
      return &FrameSinkManager::CreateMetricsRecorderForTest_Sym::IPCStableHash;
    }
    case messages::FrameSinkManager::kEnableFrameSinkManagerTestApi: {
      return &FrameSinkManager::EnableFrameSinkManagerTestApi_Sym::IPCStableHash;
    }
    case messages::FrameSinkManager::kSetupRendererInputRouterDelegateRegistry: {
      return &FrameSinkManager::SetupRendererInputRouterDelegateRegistry_Sym::IPCStableHash;
    }
    case messages::FrameSinkManager::kNotifyRendererBlockStateChanged: {
      return &FrameSinkManager::NotifyRendererBlockStateChanged_Sym::IPCStableHash;
    }
    case messages::FrameSinkManager::kRequestInputBack: {
      return &FrameSinkManager::RequestInputBack_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* FrameSinkManager::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::FrameSinkManager>(message.name())) {
      case messages::FrameSinkManager::kRegisterFrameSinkId:
            return "Receive viz::mojom::FrameSinkManager::RegisterFrameSinkId";
      case messages::FrameSinkManager::kInvalidateFrameSinkId:
            return "Receive viz::mojom::FrameSinkManager::InvalidateFrameSinkId";
      case messages::FrameSinkManager::kSetFrameSinkDebugLabel:
            return "Receive viz::mojom::FrameSinkManager::SetFrameSinkDebugLabel";
      case messages::FrameSinkManager::kCreateRootCompositorFrameSink:
            return "Receive viz::mojom::FrameSinkManager::CreateRootCompositorFrameSink";
      case messages::FrameSinkManager::kCreateFrameSinkBundle:
            return "Receive viz::mojom::FrameSinkManager::CreateFrameSinkBundle";
      case messages::FrameSinkManager::kCreateCompositorFrameSink:
            return "Receive viz::mojom::FrameSinkManager::CreateCompositorFrameSink";
      case messages::FrameSinkManager::kDestroyCompositorFrameSink:
            return "Receive viz::mojom::FrameSinkManager::DestroyCompositorFrameSink";
      case messages::FrameSinkManager::kRegisterFrameSinkHierarchy:
            return "Receive viz::mojom::FrameSinkManager::RegisterFrameSinkHierarchy";
      case messages::FrameSinkManager::kUnregisterFrameSinkHierarchy:
            return "Receive viz::mojom::FrameSinkManager::UnregisterFrameSinkHierarchy";
      case messages::FrameSinkManager::kAddVideoDetectorObserver:
            return "Receive viz::mojom::FrameSinkManager::AddVideoDetectorObserver";
      case messages::FrameSinkManager::kCreateVideoCapturer:
            return "Receive viz::mojom::FrameSinkManager::CreateVideoCapturer";
      case messages::FrameSinkManager::kEvictSurfaces:
            return "Receive viz::mojom::FrameSinkManager::EvictSurfaces";
      case messages::FrameSinkManager::kThrottle:
            return "Receive viz::mojom::FrameSinkManager::Throttle";
      case messages::FrameSinkManager::kStartThrottlingAllFrameSinks:
            return "Receive viz::mojom::FrameSinkManager::StartThrottlingAllFrameSinks";
      case messages::FrameSinkManager::kStopThrottlingAllFrameSinks:
            return "Receive viz::mojom::FrameSinkManager::StopThrottlingAllFrameSinks";
      case messages::FrameSinkManager::kRequestCopyOfOutput:
            return "Receive viz::mojom::FrameSinkManager::RequestCopyOfOutput";
      case messages::FrameSinkManager::kUpdateDebugRendererSettings:
            return "Receive viz::mojom::FrameSinkManager::UpdateDebugRendererSettings";
      case messages::FrameSinkManager::kClearUnclaimedViewTransitionResources:
            return "Receive viz::mojom::FrameSinkManager::ClearUnclaimedViewTransitionResources";
      case messages::FrameSinkManager::kCreateMetricsRecorderForTest:
            return "Receive viz::mojom::FrameSinkManager::CreateMetricsRecorderForTest";
      case messages::FrameSinkManager::kEnableFrameSinkManagerTestApi:
            return "Receive viz::mojom::FrameSinkManager::EnableFrameSinkManagerTestApi";
      case messages::FrameSinkManager::kSetupRendererInputRouterDelegateRegistry:
            return "Receive viz::mojom::FrameSinkManager::SetupRendererInputRouterDelegateRegistry";
      case messages::FrameSinkManager::kNotifyRendererBlockStateChanged:
            return "Receive viz::mojom::FrameSinkManager::NotifyRendererBlockStateChanged";
      case messages::FrameSinkManager::kRequestInputBack:
            return "Receive viz::mojom::FrameSinkManager::RequestInputBack";
    }
  } else {
    switch (static_cast<messages::FrameSinkManager>(message.name())) {
      case messages::FrameSinkManager::kRegisterFrameSinkId:
            return "Receive reply viz::mojom::FrameSinkManager::RegisterFrameSinkId";
      case messages::FrameSinkManager::kInvalidateFrameSinkId:
            return "Receive reply viz::mojom::FrameSinkManager::InvalidateFrameSinkId";
      case messages::FrameSinkManager::kSetFrameSinkDebugLabel:
            return "Receive reply viz::mojom::FrameSinkManager::SetFrameSinkDebugLabel";
      case messages::FrameSinkManager::kCreateRootCompositorFrameSink:
            return "Receive reply viz::mojom::FrameSinkManager::CreateRootCompositorFrameSink";
      case messages::FrameSinkManager::kCreateFrameSinkBundle:
            return "Receive reply viz::mojom::FrameSinkManager::CreateFrameSinkBundle";
      case messages::FrameSinkManager::kCreateCompositorFrameSink:
            return "Receive reply viz::mojom::FrameSinkManager::CreateCompositorFrameSink";
      case messages::FrameSinkManager::kDestroyCompositorFrameSink:
            return "Receive reply viz::mojom::FrameSinkManager::DestroyCompositorFrameSink";
      case messages::FrameSinkManager::kRegisterFrameSinkHierarchy:
            return "Receive reply viz::mojom::FrameSinkManager::RegisterFrameSinkHierarchy";
      case messages::FrameSinkManager::kUnregisterFrameSinkHierarchy:
            return "Receive reply viz::mojom::FrameSinkManager::UnregisterFrameSinkHierarchy";
      case messages::FrameSinkManager::kAddVideoDetectorObserver:
            return "Receive reply viz::mojom::FrameSinkManager::AddVideoDetectorObserver";
      case messages::FrameSinkManager::kCreateVideoCapturer:
            return "Receive reply viz::mojom::FrameSinkManager::CreateVideoCapturer";
      case messages::FrameSinkManager::kEvictSurfaces:
            return "Receive reply viz::mojom::FrameSinkManager::EvictSurfaces";
      case messages::FrameSinkManager::kThrottle:
            return "Receive reply viz::mojom::FrameSinkManager::Throttle";
      case messages::FrameSinkManager::kStartThrottlingAllFrameSinks:
            return "Receive reply viz::mojom::FrameSinkManager::StartThrottlingAllFrameSinks";
      case messages::FrameSinkManager::kStopThrottlingAllFrameSinks:
            return "Receive reply viz::mojom::FrameSinkManager::StopThrottlingAllFrameSinks";
      case messages::FrameSinkManager::kRequestCopyOfOutput:
            return "Receive reply viz::mojom::FrameSinkManager::RequestCopyOfOutput";
      case messages::FrameSinkManager::kUpdateDebugRendererSettings:
            return "Receive reply viz::mojom::FrameSinkManager::UpdateDebugRendererSettings";
      case messages::FrameSinkManager::kClearUnclaimedViewTransitionResources:
            return "Receive reply viz::mojom::FrameSinkManager::ClearUnclaimedViewTransitionResources";
      case messages::FrameSinkManager::kCreateMetricsRecorderForTest:
            return "Receive reply viz::mojom::FrameSinkManager::CreateMetricsRecorderForTest";
      case messages::FrameSinkManager::kEnableFrameSinkManagerTestApi:
            return "Receive reply viz::mojom::FrameSinkManager::EnableFrameSinkManagerTestApi";
      case messages::FrameSinkManager::kSetupRendererInputRouterDelegateRegistry:
            return "Receive reply viz::mojom::FrameSinkManager::SetupRendererInputRouterDelegateRegistry";
      case messages::FrameSinkManager::kNotifyRendererBlockStateChanged:
            return "Receive reply viz::mojom::FrameSinkManager::NotifyRendererBlockStateChanged";
      case messages::FrameSinkManager::kRequestInputBack:
            return "Receive reply viz::mojom::FrameSinkManager::RequestInputBack";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t FrameSinkManager::RegisterFrameSinkId_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9d07ad7b;  // IPCStableHash for viz::mojom::FrameSinkManager::RegisterFrameSinkId
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameSinkManager::InvalidateFrameSinkId_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbb1989fc;  // IPCStableHash for viz::mojom::FrameSinkManager::InvalidateFrameSinkId
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameSinkManager::SetFrameSinkDebugLabel_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x320143c4;  // IPCStableHash for viz::mojom::FrameSinkManager::SetFrameSinkDebugLabel
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameSinkManager::CreateRootCompositorFrameSink_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd6d8fc22;  // IPCStableHash for viz::mojom::FrameSinkManager::CreateRootCompositorFrameSink
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameSinkManager::CreateFrameSinkBundle_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x057068df;  // IPCStableHash for viz::mojom::FrameSinkManager::CreateFrameSinkBundle
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameSinkManager::CreateCompositorFrameSink_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xafac4956;  // IPCStableHash for viz::mojom::FrameSinkManager::CreateCompositorFrameSink
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameSinkManager::DestroyCompositorFrameSink_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfe295389;  // IPCStableHash for viz::mojom::FrameSinkManager::DestroyCompositorFrameSink
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameSinkManager::RegisterFrameSinkHierarchy_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcdb53512;  // IPCStableHash for viz::mojom::FrameSinkManager::RegisterFrameSinkHierarchy
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameSinkManager::UnregisterFrameSinkHierarchy_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb609c301;  // IPCStableHash for viz::mojom::FrameSinkManager::UnregisterFrameSinkHierarchy
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameSinkManager::AddVideoDetectorObserver_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xaaaef1db;  // IPCStableHash for viz::mojom::FrameSinkManager::AddVideoDetectorObserver
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameSinkManager::CreateVideoCapturer_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x23699a56;  // IPCStableHash for viz::mojom::FrameSinkManager::CreateVideoCapturer
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameSinkManager::EvictSurfaces_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1236c456;  // IPCStableHash for viz::mojom::FrameSinkManager::EvictSurfaces
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameSinkManager::Throttle_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf832edc3;  // IPCStableHash for viz::mojom::FrameSinkManager::Throttle
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameSinkManager::StartThrottlingAllFrameSinks_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x68960af7;  // IPCStableHash for viz::mojom::FrameSinkManager::StartThrottlingAllFrameSinks
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameSinkManager::StopThrottlingAllFrameSinks_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1a591979;  // IPCStableHash for viz::mojom::FrameSinkManager::StopThrottlingAllFrameSinks
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameSinkManager::RequestCopyOfOutput_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xee60b28b;  // IPCStableHash for viz::mojom::FrameSinkManager::RequestCopyOfOutput
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameSinkManager::UpdateDebugRendererSettings_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1e0aa9bf;  // IPCStableHash for viz::mojom::FrameSinkManager::UpdateDebugRendererSettings
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameSinkManager::ClearUnclaimedViewTransitionResources_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe2b008b8;  // IPCStableHash for viz::mojom::FrameSinkManager::ClearUnclaimedViewTransitionResources
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameSinkManager::CreateMetricsRecorderForTest_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x59be0d0e;  // IPCStableHash for viz::mojom::FrameSinkManager::CreateMetricsRecorderForTest
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameSinkManager::EnableFrameSinkManagerTestApi_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x11cf2ad8;  // IPCStableHash for viz::mojom::FrameSinkManager::EnableFrameSinkManagerTestApi
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameSinkManager::SetupRendererInputRouterDelegateRegistry_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xedd6fba3;  // IPCStableHash for viz::mojom::FrameSinkManager::SetupRendererInputRouterDelegateRegistry
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameSinkManager::NotifyRendererBlockStateChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x954188bc;  // IPCStableHash for viz::mojom::FrameSinkManager::NotifyRendererBlockStateChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameSinkManager::RequestInputBack_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc8813817;  // IPCStableHash for viz::mojom::FrameSinkManager::RequestInputBack
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)
bool FrameSinkManager::DestroyCompositorFrameSink(const ::viz::FrameSinkId& frame_sink_id) {
  NOTREACHED();
}

class FrameSinkManager_InvalidateFrameSinkId_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FrameSinkManager_InvalidateFrameSinkId_ForwardToCallback(
      FrameSinkManager::InvalidateFrameSinkIdCallback callback
      ) : callback_(std::move(callback)) {
  }

  FrameSinkManager_InvalidateFrameSinkId_ForwardToCallback(const FrameSinkManager_InvalidateFrameSinkId_ForwardToCallback&) = delete;
  FrameSinkManager_InvalidateFrameSinkId_ForwardToCallback& operator=(const FrameSinkManager_InvalidateFrameSinkId_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FrameSinkManager::InvalidateFrameSinkIdCallback callback_;
};
class FrameSinkManager_DestroyCompositorFrameSink_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  FrameSinkManager_DestroyCompositorFrameSink_HandleSyncResponse(
      bool* result)
      : result_(result) {
    DCHECK(!*result_);
  }

  FrameSinkManager_DestroyCompositorFrameSink_HandleSyncResponse(const FrameSinkManager_DestroyCompositorFrameSink_HandleSyncResponse&) = delete;
  FrameSinkManager_DestroyCompositorFrameSink_HandleSyncResponse& operator=(const FrameSinkManager_DestroyCompositorFrameSink_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;};

class FrameSinkManager_DestroyCompositorFrameSink_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FrameSinkManager_DestroyCompositorFrameSink_ForwardToCallback(
      FrameSinkManager::DestroyCompositorFrameSinkCallback callback
      ) : callback_(std::move(callback)) {
  }

  FrameSinkManager_DestroyCompositorFrameSink_ForwardToCallback(const FrameSinkManager_DestroyCompositorFrameSink_ForwardToCallback&) = delete;
  FrameSinkManager_DestroyCompositorFrameSink_ForwardToCallback& operator=(const FrameSinkManager_DestroyCompositorFrameSink_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FrameSinkManager::DestroyCompositorFrameSinkCallback callback_;
};

FrameSinkManagerProxy::FrameSinkManagerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FrameSinkManagerProxy::RegisterFrameSinkId(
    const ::viz::FrameSinkId& in_frame_sink_id, bool in_report_activation) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::FrameSinkManager::RegisterFrameSinkId", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_sink_id"), in_frame_sink_id,
                        "<value of type const ::viz::FrameSinkId&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("report_activation"), in_report_activation,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameSinkManager::kRegisterFrameSinkId), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkManager_RegisterFrameSinkId_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->frame_sink_id)::BaseType> frame_sink_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::viz::mojom::FrameSinkIdDataView>(
    in_frame_sink_id,
    frame_sink_id_fragment);

  params->frame_sink_id.Set(
      frame_sink_id_fragment.is_null() ? nullptr : frame_sink_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->frame_sink_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null frame_sink_id in FrameSinkManager.RegisterFrameSinkId request");

  params->report_activation = in_report_activation;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkManager::Name_);
  message.set_method_name("RegisterFrameSinkId");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameSinkManagerProxy::InvalidateFrameSinkId(
    const ::viz::FrameSinkId& in_frame_sink_id, InvalidateFrameSinkIdCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::FrameSinkManager::InvalidateFrameSinkId", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_sink_id"), in_frame_sink_id,
                        "<value of type const ::viz::FrameSinkId&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameSinkManager::kInvalidateFrameSinkId), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkManager_InvalidateFrameSinkId_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->frame_sink_id)::BaseType> frame_sink_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::viz::mojom::FrameSinkIdDataView>(
    in_frame_sink_id,
    frame_sink_id_fragment);

  params->frame_sink_id.Set(
      frame_sink_id_fragment.is_null() ? nullptr : frame_sink_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->frame_sink_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null frame_sink_id in FrameSinkManager.InvalidateFrameSinkId request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkManager::Name_);
  message.set_method_name("InvalidateFrameSinkId");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FrameSinkManager_InvalidateFrameSinkId_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FrameSinkManagerProxy::SetFrameSinkDebugLabel(
    const ::viz::FrameSinkId& in_frame_sink_id, const std::string& in_debug_label) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::FrameSinkManager::SetFrameSinkDebugLabel", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_sink_id"), in_frame_sink_id,
                        "<value of type const ::viz::FrameSinkId&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("debug_label"), in_debug_label,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameSinkManager::kSetFrameSinkDebugLabel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkManager_SetFrameSinkDebugLabel_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->frame_sink_id)::BaseType> frame_sink_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::viz::mojom::FrameSinkIdDataView>(
    in_frame_sink_id,
    frame_sink_id_fragment);

  params->frame_sink_id.Set(
      frame_sink_id_fragment.is_null() ? nullptr : frame_sink_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->frame_sink_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null frame_sink_id in FrameSinkManager.SetFrameSinkDebugLabel request");
  mojo::internal::MessageFragment<
      typename decltype(params->debug_label)::BaseType> debug_label_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_debug_label,
    debug_label_fragment);

  params->debug_label.Set(
      debug_label_fragment.is_null() ? nullptr : debug_label_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->debug_label.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null debug_label in FrameSinkManager.SetFrameSinkDebugLabel request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkManager::Name_);
  message.set_method_name("SetFrameSinkDebugLabel");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameSinkManagerProxy::CreateRootCompositorFrameSink(
    RootCompositorFrameSinkParamsPtr in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::FrameSinkManager::CreateRootCompositorFrameSink", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type RootCompositorFrameSinkParamsPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameSinkManager::kCreateRootCompositorFrameSink), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkManager_CreateRootCompositorFrameSink_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  
  mojo::internal::Serialize<::viz::mojom::RootCompositorFrameSinkParamsDataView>(
    in_params,
    params_fragment);

  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null params in FrameSinkManager.CreateRootCompositorFrameSink request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkManager::Name_);
  message.set_method_name("CreateRootCompositorFrameSink");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameSinkManagerProxy::CreateFrameSinkBundle(
    const ::viz::FrameSinkBundleId& in_bundle_id, ::mojo::PendingReceiver<::viz::mojom::FrameSinkBundle> in_receiver, ::mojo::PendingRemote<::viz::mojom::FrameSinkBundleClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::FrameSinkManager::CreateFrameSinkBundle", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bundle_id"), in_bundle_id,
                        "<value of type const ::viz::FrameSinkBundleId&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::viz::mojom::FrameSinkBundle>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<::viz::mojom::FrameSinkBundleClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameSinkManager::kCreateFrameSinkBundle), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkManager_CreateFrameSinkBundle_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->bundle_id)::BaseType> bundle_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::viz::mojom::FrameSinkBundleIdDataView>(
    in_bundle_id,
    bundle_id_fragment);

  params->bundle_id.Set(
      bundle_id_fragment.is_null() ? nullptr : bundle_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->bundle_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null bundle_id in FrameSinkManager.CreateFrameSinkBundle request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::viz::mojom::FrameSinkBundleInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in FrameSinkManager.CreateFrameSinkBundle request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::viz::mojom::FrameSinkBundleClientInterfaceBase>>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid client in FrameSinkManager.CreateFrameSinkBundle request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkManager::Name_);
  message.set_method_name("CreateFrameSinkBundle");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameSinkManagerProxy::CreateCompositorFrameSink(
    const ::viz::FrameSinkId& in_frame_sink_id, const std::optional<::viz::FrameSinkBundleId>& in_bundle_id, ::mojo::PendingReceiver<::viz::mojom::CompositorFrameSink> in_compositor_frame_sink, ::mojo::PendingRemote<::viz::mojom::CompositorFrameSinkClient> in_compositor_frame_sink_client, ::input::mojom::RenderInputRouterConfigPtr in_config) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::FrameSinkManager::CreateCompositorFrameSink", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_sink_id"), in_frame_sink_id,
                        "<value of type const ::viz::FrameSinkId&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bundle_id"), in_bundle_id,
                        "<value of type const std::optional<::viz::FrameSinkBundleId>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("compositor_frame_sink"), in_compositor_frame_sink,
                        "<value of type ::mojo::PendingReceiver<::viz::mojom::CompositorFrameSink>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("compositor_frame_sink_client"), in_compositor_frame_sink_client,
                        "<value of type ::mojo::PendingRemote<::viz::mojom::CompositorFrameSinkClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("config"), in_config,
                        "<value of type ::input::mojom::RenderInputRouterConfigPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameSinkManager::kCreateCompositorFrameSink), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkManager_CreateCompositorFrameSink_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->frame_sink_id)::BaseType> frame_sink_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::viz::mojom::FrameSinkIdDataView>(
    in_frame_sink_id,
    frame_sink_id_fragment);

  params->frame_sink_id.Set(
      frame_sink_id_fragment.is_null() ? nullptr : frame_sink_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->frame_sink_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null frame_sink_id in FrameSinkManager.CreateCompositorFrameSink request");
  mojo::internal::MessageFragment<
      typename decltype(params->bundle_id)::BaseType> bundle_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::viz::mojom::FrameSinkBundleIdDataView>(
    in_bundle_id,
    bundle_id_fragment);

  params->bundle_id.Set(
      bundle_id_fragment.is_null() ? nullptr : bundle_id_fragment.data());

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::viz::mojom::CompositorFrameSinkInterfaceBase>>(
    in_compositor_frame_sink,
    &params->compositor_frame_sink,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->compositor_frame_sink)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid compositor_frame_sink in FrameSinkManager.CreateCompositorFrameSink request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::viz::mojom::CompositorFrameSinkClientInterfaceBase>>(
    in_compositor_frame_sink_client,
    &params->compositor_frame_sink_client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->compositor_frame_sink_client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid compositor_frame_sink_client in FrameSinkManager.CreateCompositorFrameSink request");
  mojo::internal::MessageFragment<
      typename decltype(params->config)::BaseType> config_fragment(
          params.message());
  
  mojo::internal::Serialize<::input::mojom::RenderInputRouterConfigDataView>(
    in_config,
    config_fragment);

  params->config.Set(
      config_fragment.is_null() ? nullptr : config_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkManager::Name_);
  message.set_method_name("CreateCompositorFrameSink");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
bool FrameSinkManagerProxy::DestroyCompositorFrameSink(
    const ::viz::FrameSinkId& param_frame_sink_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call viz::mojom::FrameSinkManager::DestroyCompositorFrameSink (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_sink_id"), param_frame_sink_id,
                        "<value of type const ::viz::FrameSinkId&>");
   });
#else
  TRACE_EVENT0("mojom", "FrameSinkManager::DestroyCompositorFrameSink");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      false;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameSinkManager::kDestroyCompositorFrameSink), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkManager_DestroyCompositorFrameSink_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->frame_sink_id)::BaseType> frame_sink_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::viz::mojom::FrameSinkIdDataView>(
    param_frame_sink_id,
    frame_sink_id_fragment);

  params->frame_sink_id.Set(
      frame_sink_id_fragment.is_null() ? nullptr : frame_sink_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->frame_sink_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null frame_sink_id in FrameSinkManager.DestroyCompositorFrameSink request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkManager::Name_);
  message.set_method_name("DestroyCompositorFrameSink");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FrameSinkManager_DestroyCompositorFrameSink_HandleSyncResponse(
          &result));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END0("mojom", "FrameSinkManager::DestroyCompositorFrameSink");
#endif
  return result;
}

void FrameSinkManagerProxy::DestroyCompositorFrameSink(
    const ::viz::FrameSinkId& in_frame_sink_id, DestroyCompositorFrameSinkCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::FrameSinkManager::DestroyCompositorFrameSink", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_sink_id"), in_frame_sink_id,
                        "<value of type const ::viz::FrameSinkId&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameSinkManager::kDestroyCompositorFrameSink), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkManager_DestroyCompositorFrameSink_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->frame_sink_id)::BaseType> frame_sink_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::viz::mojom::FrameSinkIdDataView>(
    in_frame_sink_id,
    frame_sink_id_fragment);

  params->frame_sink_id.Set(
      frame_sink_id_fragment.is_null() ? nullptr : frame_sink_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->frame_sink_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null frame_sink_id in FrameSinkManager.DestroyCompositorFrameSink request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkManager::Name_);
  message.set_method_name("DestroyCompositorFrameSink");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FrameSinkManager_DestroyCompositorFrameSink_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FrameSinkManagerProxy::RegisterFrameSinkHierarchy(
    const ::viz::FrameSinkId& in_parent_frame_sink_id, const ::viz::FrameSinkId& in_child_frame_sink_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::FrameSinkManager::RegisterFrameSinkHierarchy", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("parent_frame_sink_id"), in_parent_frame_sink_id,
                        "<value of type const ::viz::FrameSinkId&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("child_frame_sink_id"), in_child_frame_sink_id,
                        "<value of type const ::viz::FrameSinkId&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameSinkManager::kRegisterFrameSinkHierarchy), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkManager_RegisterFrameSinkHierarchy_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->parent_frame_sink_id)::BaseType> parent_frame_sink_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::viz::mojom::FrameSinkIdDataView>(
    in_parent_frame_sink_id,
    parent_frame_sink_id_fragment);

  params->parent_frame_sink_id.Set(
      parent_frame_sink_id_fragment.is_null() ? nullptr : parent_frame_sink_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->parent_frame_sink_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null parent_frame_sink_id in FrameSinkManager.RegisterFrameSinkHierarchy request");
  mojo::internal::MessageFragment<
      typename decltype(params->child_frame_sink_id)::BaseType> child_frame_sink_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::viz::mojom::FrameSinkIdDataView>(
    in_child_frame_sink_id,
    child_frame_sink_id_fragment);

  params->child_frame_sink_id.Set(
      child_frame_sink_id_fragment.is_null() ? nullptr : child_frame_sink_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->child_frame_sink_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null child_frame_sink_id in FrameSinkManager.RegisterFrameSinkHierarchy request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkManager::Name_);
  message.set_method_name("RegisterFrameSinkHierarchy");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameSinkManagerProxy::UnregisterFrameSinkHierarchy(
    const ::viz::FrameSinkId& in_parent_frame_sink_id, const ::viz::FrameSinkId& in_child_frame_sink_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::FrameSinkManager::UnregisterFrameSinkHierarchy", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("parent_frame_sink_id"), in_parent_frame_sink_id,
                        "<value of type const ::viz::FrameSinkId&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("child_frame_sink_id"), in_child_frame_sink_id,
                        "<value of type const ::viz::FrameSinkId&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameSinkManager::kUnregisterFrameSinkHierarchy), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkManager_UnregisterFrameSinkHierarchy_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->parent_frame_sink_id)::BaseType> parent_frame_sink_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::viz::mojom::FrameSinkIdDataView>(
    in_parent_frame_sink_id,
    parent_frame_sink_id_fragment);

  params->parent_frame_sink_id.Set(
      parent_frame_sink_id_fragment.is_null() ? nullptr : parent_frame_sink_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->parent_frame_sink_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null parent_frame_sink_id in FrameSinkManager.UnregisterFrameSinkHierarchy request");
  mojo::internal::MessageFragment<
      typename decltype(params->child_frame_sink_id)::BaseType> child_frame_sink_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::viz::mojom::FrameSinkIdDataView>(
    in_child_frame_sink_id,
    child_frame_sink_id_fragment);

  params->child_frame_sink_id.Set(
      child_frame_sink_id_fragment.is_null() ? nullptr : child_frame_sink_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->child_frame_sink_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null child_frame_sink_id in FrameSinkManager.UnregisterFrameSinkHierarchy request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkManager::Name_);
  message.set_method_name("UnregisterFrameSinkHierarchy");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameSinkManagerProxy::AddVideoDetectorObserver(
    ::mojo::PendingRemote<::viz::mojom::VideoDetectorObserver> in_observer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::FrameSinkManager::AddVideoDetectorObserver", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer,
                        "<value of type ::mojo::PendingRemote<::viz::mojom::VideoDetectorObserver>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameSinkManager::kAddVideoDetectorObserver), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkManager_AddVideoDetectorObserver_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::viz::mojom::VideoDetectorObserverInterfaceBase>>(
    in_observer,
    &params->observer,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->observer)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid observer in FrameSinkManager.AddVideoDetectorObserver request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkManager::Name_);
  message.set_method_name("AddVideoDetectorObserver");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameSinkManagerProxy::CreateVideoCapturer(
    ::mojo::PendingReceiver<::viz::mojom::FrameSinkVideoCapturer> in_receiver, uint32_t in_capture_version_source) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::FrameSinkManager::CreateVideoCapturer", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::viz::mojom::FrameSinkVideoCapturer>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("capture_version_source"), in_capture_version_source,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameSinkManager::kCreateVideoCapturer), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkManager_CreateVideoCapturer_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::viz::mojom::FrameSinkVideoCapturerInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in FrameSinkManager.CreateVideoCapturer request");

  params->capture_version_source = in_capture_version_source;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkManager::Name_);
  message.set_method_name("CreateVideoCapturer");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameSinkManagerProxy::EvictSurfaces(
    const std::vector<::viz::SurfaceId>& in_surface_ids) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::FrameSinkManager::EvictSurfaces", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("surface_ids"), in_surface_ids,
                        "<value of type const std::vector<::viz::SurfaceId>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameSinkManager::kEvictSurfaces), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkManager_EvictSurfaces_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->surface_ids)::BaseType>
      surface_ids_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& surface_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::SurfaceIdDataView>>(
    in_surface_ids,
    surface_ids_fragment,
    &surface_ids_validate_params);

  params->surface_ids.Set(
      surface_ids_fragment.is_null() ? nullptr : surface_ids_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->surface_ids.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null surface_ids in FrameSinkManager.EvictSurfaces request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkManager::Name_);
  message.set_method_name("EvictSurfaces");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameSinkManagerProxy::Throttle(
    const std::vector<::viz::FrameSinkId>& in_frame_sink_ids, ::base::TimeDelta in_interval) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::FrameSinkManager::Throttle", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_sink_ids"), in_frame_sink_ids,
                        "<value of type const std::vector<::viz::FrameSinkId>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("interval"), in_interval,
                        "<value of type ::base::TimeDelta>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameSinkManager::kThrottle), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkManager_Throttle_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->frame_sink_ids)::BaseType>
      frame_sink_ids_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& frame_sink_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::FrameSinkIdDataView>>(
    in_frame_sink_ids,
    frame_sink_ids_fragment,
    &frame_sink_ids_validate_params);

  params->frame_sink_ids.Set(
      frame_sink_ids_fragment.is_null() ? nullptr : frame_sink_ids_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->frame_sink_ids.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null frame_sink_ids in FrameSinkManager.Throttle request");
  mojo::internal::MessageFragment<
      typename decltype(params->interval)::BaseType> interval_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
    in_interval,
    interval_fragment);

  params->interval.Set(
      interval_fragment.is_null() ? nullptr : interval_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->interval.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null interval in FrameSinkManager.Throttle request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkManager::Name_);
  message.set_method_name("Throttle");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameSinkManagerProxy::StartThrottlingAllFrameSinks(
    ::base::TimeDelta in_interval) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::FrameSinkManager::StartThrottlingAllFrameSinks", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("interval"), in_interval,
                        "<value of type ::base::TimeDelta>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameSinkManager::kStartThrottlingAllFrameSinks), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkManager_StartThrottlingAllFrameSinks_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->interval)::BaseType> interval_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
    in_interval,
    interval_fragment);

  params->interval.Set(
      interval_fragment.is_null() ? nullptr : interval_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->interval.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null interval in FrameSinkManager.StartThrottlingAllFrameSinks request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkManager::Name_);
  message.set_method_name("StartThrottlingAllFrameSinks");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameSinkManagerProxy::StopThrottlingAllFrameSinks(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send viz::mojom::FrameSinkManager::StopThrottlingAllFrameSinks");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameSinkManager::kStopThrottlingAllFrameSinks), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkManager_StopThrottlingAllFrameSinks_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkManager::Name_);
  message.set_method_name("StopThrottlingAllFrameSinks");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameSinkManagerProxy::RequestCopyOfOutput(
    const ::viz::SurfaceId& in_surface_id, ::std::unique_ptr<::viz::CopyOutputRequest> in_request, bool in_capture_exact_surface_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::FrameSinkManager::RequestCopyOfOutput", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("surface_id"), in_surface_id,
                        "<value of type const ::viz::SurfaceId&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request"), in_request,
                        "<value of type ::std::unique_ptr<::viz::CopyOutputRequest>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("capture_exact_surface_id"), in_capture_exact_surface_id,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameSinkManager::kRequestCopyOfOutput), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkManager_RequestCopyOfOutput_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->surface_id)::BaseType> surface_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::viz::mojom::SurfaceIdDataView>(
    in_surface_id,
    surface_id_fragment);

  params->surface_id.Set(
      surface_id_fragment.is_null() ? nullptr : surface_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->surface_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null surface_id in FrameSinkManager.RequestCopyOfOutput request");
  mojo::internal::MessageFragment<
      typename decltype(params->request)::BaseType> request_fragment(
          params.message());
  
  mojo::internal::Serialize<::viz::mojom::CopyOutputRequestDataView>(
    in_request,
    request_fragment);

  params->request.Set(
      request_fragment.is_null() ? nullptr : request_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->request.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null request in FrameSinkManager.RequestCopyOfOutput request");

  params->capture_exact_surface_id = in_capture_exact_surface_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkManager::Name_);
  message.set_method_name("RequestCopyOfOutput");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameSinkManagerProxy::UpdateDebugRendererSettings(
    const ::viz::DebugRendererSettings& in_debug_settings) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::FrameSinkManager::UpdateDebugRendererSettings", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("debug_settings"), in_debug_settings,
                        "<value of type const ::viz::DebugRendererSettings&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameSinkManager::kUpdateDebugRendererSettings), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkManager_UpdateDebugRendererSettings_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->debug_settings)::BaseType> debug_settings_fragment(
          params.message());
  
  mojo::internal::Serialize<::viz::mojom::DebugRendererSettingsDataView>(
    in_debug_settings,
    debug_settings_fragment);

  params->debug_settings.Set(
      debug_settings_fragment.is_null() ? nullptr : debug_settings_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->debug_settings.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null debug_settings in FrameSinkManager.UpdateDebugRendererSettings request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkManager::Name_);
  message.set_method_name("UpdateDebugRendererSettings");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameSinkManagerProxy::ClearUnclaimedViewTransitionResources(
    const ::blink::ViewTransitionToken& in_transition_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::FrameSinkManager::ClearUnclaimedViewTransitionResources", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("transition_token"), in_transition_token,
                        "<value of type const ::blink::ViewTransitionToken&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameSinkManager::kClearUnclaimedViewTransitionResources), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkManager_ClearUnclaimedViewTransitionResources_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->transition_token)::BaseType> transition_token_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::ViewTransitionTokenDataView>(
    in_transition_token,
    transition_token_fragment);

  params->transition_token.Set(
      transition_token_fragment.is_null() ? nullptr : transition_token_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->transition_token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null transition_token in FrameSinkManager.ClearUnclaimedViewTransitionResources request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkManager::Name_);
  message.set_method_name("ClearUnclaimedViewTransitionResources");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameSinkManagerProxy::CreateMetricsRecorderForTest(
    ::mojo::PendingReceiver<::viz::mojom::FrameSinksMetricsRecorder> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::FrameSinkManager::CreateMetricsRecorderForTest", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::viz::mojom::FrameSinksMetricsRecorder>>");
   });
#endif

  CHECK(base::FeatureList::IsEnabled(::viz::mojom::EnableVizTestApis));
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameSinkManager::kCreateMetricsRecorderForTest), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkManager_CreateMetricsRecorderForTest_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::viz::mojom::FrameSinksMetricsRecorderInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in FrameSinkManager.CreateMetricsRecorderForTest request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkManager::Name_);
  message.set_method_name("CreateMetricsRecorderForTest");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameSinkManagerProxy::EnableFrameSinkManagerTestApi(
    ::mojo::PendingReceiver<::viz::mojom::FrameSinkManagerTestApi> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::FrameSinkManager::EnableFrameSinkManagerTestApi", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::viz::mojom::FrameSinkManagerTestApi>>");
   });
#endif

  CHECK(base::FeatureList::IsEnabled(::viz::mojom::EnableVizTestApis));
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameSinkManager::kEnableFrameSinkManagerTestApi), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkManager_EnableFrameSinkManagerTestApi_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::viz::mojom::FrameSinkManagerTestApiInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in FrameSinkManager.EnableFrameSinkManagerTestApi request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkManager::Name_);
  message.set_method_name("EnableFrameSinkManagerTestApi");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameSinkManagerProxy::SetupRendererInputRouterDelegateRegistry(
    ::mojo::PendingReceiver<RendererInputRouterDelegateRegistry> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::FrameSinkManager::SetupRendererInputRouterDelegateRegistry", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<RendererInputRouterDelegateRegistry>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameSinkManager::kSetupRendererInputRouterDelegateRegistry), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkManager_SetupRendererInputRouterDelegateRegistry_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::viz::mojom::RendererInputRouterDelegateRegistryInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in FrameSinkManager.SetupRendererInputRouterDelegateRegistry request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkManager::Name_);
  message.set_method_name("SetupRendererInputRouterDelegateRegistry");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameSinkManagerProxy::NotifyRendererBlockStateChanged(
    bool in_blocked, const std::vector<::viz::FrameSinkId>& in_render_input_routers) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::FrameSinkManager::NotifyRendererBlockStateChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("blocked"), in_blocked,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("render_input_routers"), in_render_input_routers,
                        "<value of type const std::vector<::viz::FrameSinkId>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameSinkManager::kNotifyRendererBlockStateChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkManager_NotifyRendererBlockStateChanged_Params_Data> params(
          message);
  params.Allocate();

  params->blocked = in_blocked;
  mojo::internal::MessageFragment<
      typename decltype(params->render_input_routers)::BaseType>
      render_input_routers_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& render_input_routers_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::FrameSinkIdDataView>>(
    in_render_input_routers,
    render_input_routers_fragment,
    &render_input_routers_validate_params);

  params->render_input_routers.Set(
      render_input_routers_fragment.is_null() ? nullptr : render_input_routers_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->render_input_routers.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null render_input_routers in FrameSinkManager.NotifyRendererBlockStateChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkManager::Name_);
  message.set_method_name("NotifyRendererBlockStateChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameSinkManagerProxy::RequestInputBack(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send viz::mojom::FrameSinkManager::RequestInputBack");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameSinkManager::kRequestInputBack), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkManager_RequestInputBack_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkManager::Name_);
  message.set_method_name("RequestInputBack");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class FrameSinkManager_InvalidateFrameSinkId_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FrameSinkManager::InvalidateFrameSinkIdCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FrameSinkManager_InvalidateFrameSinkId_ProxyToResponder> proxy(
        new FrameSinkManager_InvalidateFrameSinkId_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FrameSinkManager_InvalidateFrameSinkId_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FrameSinkManager_InvalidateFrameSinkId_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FrameSinkManager_InvalidateFrameSinkId_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FrameSinkManager::InvalidateFrameSinkIdCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool FrameSinkManager_InvalidateFrameSinkId_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FrameSinkManager_InvalidateFrameSinkId_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FrameSinkManager_InvalidateFrameSinkId_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FrameSinkManager.1
  bool success = true;
  FrameSinkManager_InvalidateFrameSinkId_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FrameSinkManager::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void FrameSinkManager_InvalidateFrameSinkId_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply viz::mojom::FrameSinkManager::InvalidateFrameSinkId");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameSinkManager::kInvalidateFrameSinkId), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkManager_InvalidateFrameSinkId_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkManager::Name_);
  message.set_method_name("InvalidateFrameSinkId");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FrameSinkManager_DestroyCompositorFrameSink_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FrameSinkManager::DestroyCompositorFrameSinkCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FrameSinkManager_DestroyCompositorFrameSink_ProxyToResponder> proxy(
        new FrameSinkManager_DestroyCompositorFrameSink_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FrameSinkManager_DestroyCompositorFrameSink_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FrameSinkManager_DestroyCompositorFrameSink_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FrameSinkManager_DestroyCompositorFrameSink_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FrameSinkManager::DestroyCompositorFrameSinkCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool FrameSinkManager_DestroyCompositorFrameSink_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FrameSinkManager_DestroyCompositorFrameSink_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FrameSinkManager_DestroyCompositorFrameSink_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FrameSinkManager.6
  bool success = true;
  FrameSinkManager_DestroyCompositorFrameSink_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FrameSinkManager::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void FrameSinkManager_DestroyCompositorFrameSink_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply viz::mojom::FrameSinkManager::DestroyCompositorFrameSink");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameSinkManager::kDestroyCompositorFrameSink), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkManager_DestroyCompositorFrameSink_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkManager::Name_);
  message.set_method_name("DestroyCompositorFrameSink");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool FrameSinkManager_DestroyCompositorFrameSink_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FrameSinkManager_DestroyCompositorFrameSink_ResponseParams_Data* params =
      reinterpret_cast<internal::FrameSinkManager_DestroyCompositorFrameSink_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for FrameSinkManager.6
  bool success = true;
  FrameSinkManager_DestroyCompositorFrameSink_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FrameSinkManager::Name_, 6, true);
    return false;
  }
  *result_ = true;
  return true;
}

// static
bool FrameSinkManagerStubDispatch::Accept(
    FrameSinkManager* impl,
    mojo::Message* message) {
  switch (static_cast<messages::FrameSinkManager>(message->header()->name)) {
    case messages::FrameSinkManager::kRegisterFrameSinkId: {
      DCHECK(message->is_serialized());
      internal::FrameSinkManager_RegisterFrameSinkId_Params_Data* params =
          reinterpret_cast<internal::FrameSinkManager_RegisterFrameSinkId_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameSinkManager.0
      bool success = true;
      ::viz::FrameSinkId p_frame_sink_id{};
      bool p_report_activation{};
      FrameSinkManager_RegisterFrameSinkId_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFrameSinkId(&p_frame_sink_id))
        success = false;
      if (success)
        p_report_activation = input_data_view.report_activation();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkManager::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RegisterFrameSinkId(        
        std::move(p_frame_sink_id), 
        std::move(p_report_activation));
      return true;
    }
    case messages::FrameSinkManager::kInvalidateFrameSinkId: {
      break;
    }
    case messages::FrameSinkManager::kSetFrameSinkDebugLabel: {
      DCHECK(message->is_serialized());
      internal::FrameSinkManager_SetFrameSinkDebugLabel_Params_Data* params =
          reinterpret_cast<internal::FrameSinkManager_SetFrameSinkDebugLabel_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameSinkManager.2
      bool success = true;
      ::viz::FrameSinkId p_frame_sink_id{};
      std::string p_debug_label{};
      FrameSinkManager_SetFrameSinkDebugLabel_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFrameSinkId(&p_frame_sink_id))
        success = false;
      if (success && !input_data_view.ReadDebugLabel(&p_debug_label))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkManager::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetFrameSinkDebugLabel(        
        std::move(p_frame_sink_id), 
        std::move(p_debug_label));
      return true;
    }
    case messages::FrameSinkManager::kCreateRootCompositorFrameSink: {
      DCHECK(message->is_serialized());
      internal::FrameSinkManager_CreateRootCompositorFrameSink_Params_Data* params =
          reinterpret_cast<internal::FrameSinkManager_CreateRootCompositorFrameSink_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameSinkManager.3
      bool success = true;
      RootCompositorFrameSinkParamsPtr p_params{};
      FrameSinkManager_CreateRootCompositorFrameSink_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkManager::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateRootCompositorFrameSink(        
        std::move(p_params));
      return true;
    }
    case messages::FrameSinkManager::kCreateFrameSinkBundle: {
      DCHECK(message->is_serialized());
      internal::FrameSinkManager_CreateFrameSinkBundle_Params_Data* params =
          reinterpret_cast<internal::FrameSinkManager_CreateFrameSinkBundle_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameSinkManager.4
      bool success = true;
      ::viz::FrameSinkBundleId p_bundle_id{};
      ::mojo::PendingReceiver<::viz::mojom::FrameSinkBundle> p_receiver{};
      ::mojo::PendingRemote<::viz::mojom::FrameSinkBundleClient> p_client{};
      FrameSinkManager_CreateFrameSinkBundle_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBundleId(&p_bundle_id))
        success = false;
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkManager::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateFrameSinkBundle(        
        std::move(p_bundle_id), 
        std::move(p_receiver), 
        std::move(p_client));
      return true;
    }
    case messages::FrameSinkManager::kCreateCompositorFrameSink: {
      DCHECK(message->is_serialized());
      internal::FrameSinkManager_CreateCompositorFrameSink_Params_Data* params =
          reinterpret_cast<internal::FrameSinkManager_CreateCompositorFrameSink_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameSinkManager.5
      bool success = true;
      ::viz::FrameSinkId p_frame_sink_id{};
      std::optional<::viz::FrameSinkBundleId> p_bundle_id{};
      ::mojo::PendingReceiver<::viz::mojom::CompositorFrameSink> p_compositor_frame_sink{};
      ::mojo::PendingRemote<::viz::mojom::CompositorFrameSinkClient> p_compositor_frame_sink_client{};
      ::input::mojom::RenderInputRouterConfigPtr p_config{};
      FrameSinkManager_CreateCompositorFrameSink_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFrameSinkId(&p_frame_sink_id))
        success = false;
      if (success && !input_data_view.ReadBundleId(&p_bundle_id))
        success = false;
      if (success) {
        p_compositor_frame_sink =
            input_data_view.TakeCompositorFrameSink<decltype(p_compositor_frame_sink)>();
      }
      if (success) {
        p_compositor_frame_sink_client =
            input_data_view.TakeCompositorFrameSinkClient<decltype(p_compositor_frame_sink_client)>();
      }
      if (success && !input_data_view.ReadConfig(&p_config))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkManager::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateCompositorFrameSink(        
        std::move(p_frame_sink_id), 
        std::move(p_bundle_id), 
        std::move(p_compositor_frame_sink), 
        std::move(p_compositor_frame_sink_client), 
        std::move(p_config));
      return true;
    }
    case messages::FrameSinkManager::kDestroyCompositorFrameSink: {
      break;
    }
    case messages::FrameSinkManager::kRegisterFrameSinkHierarchy: {
      DCHECK(message->is_serialized());
      internal::FrameSinkManager_RegisterFrameSinkHierarchy_Params_Data* params =
          reinterpret_cast<internal::FrameSinkManager_RegisterFrameSinkHierarchy_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameSinkManager.7
      bool success = true;
      ::viz::FrameSinkId p_parent_frame_sink_id{};
      ::viz::FrameSinkId p_child_frame_sink_id{};
      FrameSinkManager_RegisterFrameSinkHierarchy_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParentFrameSinkId(&p_parent_frame_sink_id))
        success = false;
      if (success && !input_data_view.ReadChildFrameSinkId(&p_child_frame_sink_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkManager::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RegisterFrameSinkHierarchy(        
        std::move(p_parent_frame_sink_id), 
        std::move(p_child_frame_sink_id));
      return true;
    }
    case messages::FrameSinkManager::kUnregisterFrameSinkHierarchy: {
      DCHECK(message->is_serialized());
      internal::FrameSinkManager_UnregisterFrameSinkHierarchy_Params_Data* params =
          reinterpret_cast<internal::FrameSinkManager_UnregisterFrameSinkHierarchy_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameSinkManager.8
      bool success = true;
      ::viz::FrameSinkId p_parent_frame_sink_id{};
      ::viz::FrameSinkId p_child_frame_sink_id{};
      FrameSinkManager_UnregisterFrameSinkHierarchy_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParentFrameSinkId(&p_parent_frame_sink_id))
        success = false;
      if (success && !input_data_view.ReadChildFrameSinkId(&p_child_frame_sink_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkManager::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UnregisterFrameSinkHierarchy(        
        std::move(p_parent_frame_sink_id), 
        std::move(p_child_frame_sink_id));
      return true;
    }
    case messages::FrameSinkManager::kAddVideoDetectorObserver: {
      DCHECK(message->is_serialized());
      internal::FrameSinkManager_AddVideoDetectorObserver_Params_Data* params =
          reinterpret_cast<internal::FrameSinkManager_AddVideoDetectorObserver_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameSinkManager.9
      bool success = true;
      ::mojo::PendingRemote<::viz::mojom::VideoDetectorObserver> p_observer{};
      FrameSinkManager_AddVideoDetectorObserver_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkManager::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddVideoDetectorObserver(        
        std::move(p_observer));
      return true;
    }
    case messages::FrameSinkManager::kCreateVideoCapturer: {
      DCHECK(message->is_serialized());
      internal::FrameSinkManager_CreateVideoCapturer_Params_Data* params =
          reinterpret_cast<internal::FrameSinkManager_CreateVideoCapturer_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameSinkManager.10
      bool success = true;
      ::mojo::PendingReceiver<::viz::mojom::FrameSinkVideoCapturer> p_receiver{};
      uint32_t p_capture_version_source{};
      FrameSinkManager_CreateVideoCapturer_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (success)
        p_capture_version_source = input_data_view.capture_version_source();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkManager::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateVideoCapturer(        
        std::move(p_receiver), 
        std::move(p_capture_version_source));
      return true;
    }
    case messages::FrameSinkManager::kEvictSurfaces: {
      DCHECK(message->is_serialized());
      internal::FrameSinkManager_EvictSurfaces_Params_Data* params =
          reinterpret_cast<internal::FrameSinkManager_EvictSurfaces_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameSinkManager.11
      bool success = true;
      std::vector<::viz::SurfaceId> p_surface_ids{};
      FrameSinkManager_EvictSurfaces_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSurfaceIds(&p_surface_ids))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkManager::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EvictSurfaces(        
        std::move(p_surface_ids));
      return true;
    }
    case messages::FrameSinkManager::kThrottle: {
      DCHECK(message->is_serialized());
      internal::FrameSinkManager_Throttle_Params_Data* params =
          reinterpret_cast<internal::FrameSinkManager_Throttle_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameSinkManager.12
      bool success = true;
      std::vector<::viz::FrameSinkId> p_frame_sink_ids{};
      ::base::TimeDelta p_interval{};
      FrameSinkManager_Throttle_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFrameSinkIds(&p_frame_sink_ids))
        success = false;
      if (success && !input_data_view.ReadInterval(&p_interval))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkManager::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Throttle(        
        std::move(p_frame_sink_ids), 
        std::move(p_interval));
      return true;
    }
    case messages::FrameSinkManager::kStartThrottlingAllFrameSinks: {
      DCHECK(message->is_serialized());
      internal::FrameSinkManager_StartThrottlingAllFrameSinks_Params_Data* params =
          reinterpret_cast<internal::FrameSinkManager_StartThrottlingAllFrameSinks_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameSinkManager.13
      bool success = true;
      ::base::TimeDelta p_interval{};
      FrameSinkManager_StartThrottlingAllFrameSinks_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadInterval(&p_interval))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkManager::Name_, 13, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartThrottlingAllFrameSinks(        
        std::move(p_interval));
      return true;
    }
    case messages::FrameSinkManager::kStopThrottlingAllFrameSinks: {
      DCHECK(message->is_serialized());
      internal::FrameSinkManager_StopThrottlingAllFrameSinks_Params_Data* params =
          reinterpret_cast<internal::FrameSinkManager_StopThrottlingAllFrameSinks_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameSinkManager.14
      bool success = true;
      FrameSinkManager_StopThrottlingAllFrameSinks_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkManager::Name_, 14, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StopThrottlingAllFrameSinks(        );
      return true;
    }
    case messages::FrameSinkManager::kRequestCopyOfOutput: {
      DCHECK(message->is_serialized());
      internal::FrameSinkManager_RequestCopyOfOutput_Params_Data* params =
          reinterpret_cast<internal::FrameSinkManager_RequestCopyOfOutput_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameSinkManager.15
      bool success = true;
      ::viz::SurfaceId p_surface_id{};
      ::std::unique_ptr<::viz::CopyOutputRequest> p_request{};
      bool p_capture_exact_surface_id{};
      FrameSinkManager_RequestCopyOfOutput_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSurfaceId(&p_surface_id))
        success = false;
      if (success && !input_data_view.ReadRequest(&p_request))
        success = false;
      if (success)
        p_capture_exact_surface_id = input_data_view.capture_exact_surface_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkManager::Name_, 15, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestCopyOfOutput(        
        std::move(p_surface_id), 
        std::move(p_request), 
        std::move(p_capture_exact_surface_id));
      return true;
    }
    case messages::FrameSinkManager::kUpdateDebugRendererSettings: {
      DCHECK(message->is_serialized());
      internal::FrameSinkManager_UpdateDebugRendererSettings_Params_Data* params =
          reinterpret_cast<internal::FrameSinkManager_UpdateDebugRendererSettings_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameSinkManager.16
      bool success = true;
      ::viz::DebugRendererSettings p_debug_settings{};
      FrameSinkManager_UpdateDebugRendererSettings_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDebugSettings(&p_debug_settings))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkManager::Name_, 16, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateDebugRendererSettings(        
        std::move(p_debug_settings));
      return true;
    }
    case messages::FrameSinkManager::kClearUnclaimedViewTransitionResources: {
      DCHECK(message->is_serialized());
      internal::FrameSinkManager_ClearUnclaimedViewTransitionResources_Params_Data* params =
          reinterpret_cast<internal::FrameSinkManager_ClearUnclaimedViewTransitionResources_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameSinkManager.17
      bool success = true;
      ::blink::ViewTransitionToken p_transition_token{};
      FrameSinkManager_ClearUnclaimedViewTransitionResources_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTransitionToken(&p_transition_token))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkManager::Name_, 17, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearUnclaimedViewTransitionResources(        
        std::move(p_transition_token));
      return true;
    }
    case messages::FrameSinkManager::kCreateMetricsRecorderForTest: {
      DCHECK(message->is_serialized());
      internal::FrameSinkManager_CreateMetricsRecorderForTest_Params_Data* params =
          reinterpret_cast<internal::FrameSinkManager_CreateMetricsRecorderForTest_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameSinkManager.18
      bool success = true;
      ::mojo::PendingReceiver<::viz::mojom::FrameSinksMetricsRecorder> p_receiver{};
      FrameSinkManager_CreateMetricsRecorderForTest_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkManager::Name_, 18, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateMetricsRecorderForTest(        
        std::move(p_receiver));
      return true;
    }
    case messages::FrameSinkManager::kEnableFrameSinkManagerTestApi: {
      DCHECK(message->is_serialized());
      internal::FrameSinkManager_EnableFrameSinkManagerTestApi_Params_Data* params =
          reinterpret_cast<internal::FrameSinkManager_EnableFrameSinkManagerTestApi_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameSinkManager.19
      bool success = true;
      ::mojo::PendingReceiver<::viz::mojom::FrameSinkManagerTestApi> p_receiver{};
      FrameSinkManager_EnableFrameSinkManagerTestApi_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkManager::Name_, 19, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EnableFrameSinkManagerTestApi(        
        std::move(p_receiver));
      return true;
    }
    case messages::FrameSinkManager::kSetupRendererInputRouterDelegateRegistry: {
      DCHECK(message->is_serialized());
      internal::FrameSinkManager_SetupRendererInputRouterDelegateRegistry_Params_Data* params =
          reinterpret_cast<internal::FrameSinkManager_SetupRendererInputRouterDelegateRegistry_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameSinkManager.20
      bool success = true;
      ::mojo::PendingReceiver<RendererInputRouterDelegateRegistry> p_receiver{};
      FrameSinkManager_SetupRendererInputRouterDelegateRegistry_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkManager::Name_, 20, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetupRendererInputRouterDelegateRegistry(        
        std::move(p_receiver));
      return true;
    }
    case messages::FrameSinkManager::kNotifyRendererBlockStateChanged: {
      DCHECK(message->is_serialized());
      internal::FrameSinkManager_NotifyRendererBlockStateChanged_Params_Data* params =
          reinterpret_cast<internal::FrameSinkManager_NotifyRendererBlockStateChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameSinkManager.21
      bool success = true;
      bool p_blocked{};
      std::vector<::viz::FrameSinkId> p_render_input_routers{};
      FrameSinkManager_NotifyRendererBlockStateChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_blocked = input_data_view.blocked();
      if (success && !input_data_view.ReadRenderInputRouters(&p_render_input_routers))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkManager::Name_, 21, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyRendererBlockStateChanged(        
        std::move(p_blocked), 
        std::move(p_render_input_routers));
      return true;
    }
    case messages::FrameSinkManager::kRequestInputBack: {
      DCHECK(message->is_serialized());
      internal::FrameSinkManager_RequestInputBack_Params_Data* params =
          reinterpret_cast<internal::FrameSinkManager_RequestInputBack_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameSinkManager.22
      bool success = true;
      FrameSinkManager_RequestInputBack_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkManager::Name_, 22, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestInputBack(        );
      return true;
    }
  }
  return false;
}

// static
bool FrameSinkManagerStubDispatch::AcceptWithResponder(
    FrameSinkManager* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::FrameSinkManager>(message->header()->name)) {
    case messages::FrameSinkManager::kRegisterFrameSinkId: {
      break;
    }
    case messages::FrameSinkManager::kInvalidateFrameSinkId: {
      internal::FrameSinkManager_InvalidateFrameSinkId_Params_Data* params =
          reinterpret_cast<
              internal::FrameSinkManager_InvalidateFrameSinkId_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FrameSinkManager.1
      bool success = true;
      ::viz::FrameSinkId p_frame_sink_id{};
      FrameSinkManager_InvalidateFrameSinkId_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFrameSinkId(&p_frame_sink_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkManager::Name_, 1, false);
        return false;
      }
      auto callback =
          FrameSinkManager_InvalidateFrameSinkId_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->InvalidateFrameSinkId(        
        std::move(p_frame_sink_id), std::move(callback));
      return true;
    }
    case messages::FrameSinkManager::kSetFrameSinkDebugLabel: {
      break;
    }
    case messages::FrameSinkManager::kCreateRootCompositorFrameSink: {
      break;
    }
    case messages::FrameSinkManager::kCreateFrameSinkBundle: {
      break;
    }
    case messages::FrameSinkManager::kCreateCompositorFrameSink: {
      break;
    }
    case messages::FrameSinkManager::kDestroyCompositorFrameSink: {
      internal::FrameSinkManager_DestroyCompositorFrameSink_Params_Data* params =
          reinterpret_cast<
              internal::FrameSinkManager_DestroyCompositorFrameSink_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FrameSinkManager.6
      bool success = true;
      ::viz::FrameSinkId p_frame_sink_id{};
      FrameSinkManager_DestroyCompositorFrameSink_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFrameSinkId(&p_frame_sink_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkManager::Name_, 6, false);
        return false;
      }
      auto callback =
          FrameSinkManager_DestroyCompositorFrameSink_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DestroyCompositorFrameSink(        
        std::move(p_frame_sink_id), std::move(callback));
      return true;
    }
    case messages::FrameSinkManager::kRegisterFrameSinkHierarchy: {
      break;
    }
    case messages::FrameSinkManager::kUnregisterFrameSinkHierarchy: {
      break;
    }
    case messages::FrameSinkManager::kAddVideoDetectorObserver: {
      break;
    }
    case messages::FrameSinkManager::kCreateVideoCapturer: {
      break;
    }
    case messages::FrameSinkManager::kEvictSurfaces: {
      break;
    }
    case messages::FrameSinkManager::kThrottle: {
      break;
    }
    case messages::FrameSinkManager::kStartThrottlingAllFrameSinks: {
      break;
    }
    case messages::FrameSinkManager::kStopThrottlingAllFrameSinks: {
      break;
    }
    case messages::FrameSinkManager::kRequestCopyOfOutput: {
      break;
    }
    case messages::FrameSinkManager::kUpdateDebugRendererSettings: {
      break;
    }
    case messages::FrameSinkManager::kClearUnclaimedViewTransitionResources: {
      break;
    }
    case messages::FrameSinkManager::kCreateMetricsRecorderForTest: {
      break;
    }
    case messages::FrameSinkManager::kEnableFrameSinkManagerTestApi: {
      break;
    }
    case messages::FrameSinkManager::kSetupRendererInputRouterDelegateRegistry: {
      break;
    }
    case messages::FrameSinkManager::kNotifyRendererBlockStateChanged: {
      break;
    }
    case messages::FrameSinkManager::kRequestInputBack: {
      break;
    }
  }
  return false;
}
namespace {

bool ValidateWithRuntimeFeature_FrameSinkManager_CreateMetricsRecorderForTest(
  const void* data, mojo::internal::ValidationContext* validation_context) {
  if (!base::FeatureList::IsEnabled(::viz::mojom::EnableVizTestApis)) {
    return false;
  }
  return internal::FrameSinkManager_CreateMetricsRecorderForTest_Params_Data::Validate(
    data, validation_context);
}

bool ValidateWithRuntimeFeature_FrameSinkManager_EnableFrameSinkManagerTestApi(
  const void* data, mojo::internal::ValidationContext* validation_context) {
  if (!base::FeatureList::IsEnabled(::viz::mojom::EnableVizTestApis)) {
    return false;
  }
  return internal::FrameSinkManager_EnableFrameSinkManagerTestApi_Params_Data::Validate(
    data, validation_context);
}
}  // namespace
static const mojo::internal::GenericValidationInfo kFrameSinkManagerValidationInfo[] = {
    { &internal::FrameSinkManager_RegisterFrameSinkId_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FrameSinkManager_InvalidateFrameSinkId_Params_Data::Validate,
     &internal::FrameSinkManager_InvalidateFrameSinkId_ResponseParams_Data::Validate},
    { &internal::FrameSinkManager_SetFrameSinkDebugLabel_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FrameSinkManager_CreateRootCompositorFrameSink_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FrameSinkManager_CreateFrameSinkBundle_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FrameSinkManager_CreateCompositorFrameSink_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FrameSinkManager_DestroyCompositorFrameSink_Params_Data::Validate,
     &internal::FrameSinkManager_DestroyCompositorFrameSink_ResponseParams_Data::Validate},
    { &internal::FrameSinkManager_RegisterFrameSinkHierarchy_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FrameSinkManager_UnregisterFrameSinkHierarchy_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FrameSinkManager_AddVideoDetectorObserver_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FrameSinkManager_CreateVideoCapturer_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FrameSinkManager_EvictSurfaces_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FrameSinkManager_Throttle_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FrameSinkManager_StartThrottlingAllFrameSinks_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FrameSinkManager_StopThrottlingAllFrameSinks_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FrameSinkManager_RequestCopyOfOutput_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FrameSinkManager_UpdateDebugRendererSettings_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FrameSinkManager_ClearUnclaimedViewTransitionResources_Params_Data::Validate,
     nullptr /* no response */},
    { &ValidateWithRuntimeFeature_FrameSinkManager_CreateMetricsRecorderForTest,
     nullptr /* no response */},
    { &ValidateWithRuntimeFeature_FrameSinkManager_EnableFrameSinkManagerTestApi,
     nullptr /* no response */},
    { &internal::FrameSinkManager_SetupRendererInputRouterDelegateRegistry_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FrameSinkManager_NotifyRendererBlockStateChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FrameSinkManager_RequestInputBack_Params_Data::Validate,
     nullptr /* no response */},
};

bool FrameSinkManagerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::viz::mojom::FrameSinkManager::Name_,
    kFrameSinkManagerValidationInfo);
}

bool FrameSinkManagerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::viz::mojom::FrameSinkManager::Name_,
    kFrameSinkManagerValidationInfo);
}
// The declaration includes the definition on other builds.

FrameSinkManagerClient::IPCStableHashFunction FrameSinkManagerClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::FrameSinkManagerClient>(message.name())) {
    case messages::FrameSinkManagerClient::kOnFirstSurfaceActivation: {
      return &FrameSinkManagerClient::OnFirstSurfaceActivation_Sym::IPCStableHash;
    }
    case messages::FrameSinkManagerClient::kOnAggregatedHitTestRegionListUpdated: {
      return &FrameSinkManagerClient::OnAggregatedHitTestRegionListUpdated_Sym::IPCStableHash;
    }
    case messages::FrameSinkManagerClient::kOnFrameTokenChanged: {
      return &FrameSinkManagerClient::OnFrameTokenChanged_Sym::IPCStableHash;
    }
    case messages::FrameSinkManagerClient::kOnScreenshotCaptured: {
      return &FrameSinkManagerClient::OnScreenshotCaptured_Sym::IPCStableHash;
    }
    case messages::FrameSinkManagerClient::kOnVizTouchStateAvailable: {
      return &FrameSinkManagerClient::OnVizTouchStateAvailable_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* FrameSinkManagerClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::FrameSinkManagerClient>(message.name())) {
      case messages::FrameSinkManagerClient::kOnFirstSurfaceActivation:
            return "Receive viz::mojom::FrameSinkManagerClient::OnFirstSurfaceActivation";
      case messages::FrameSinkManagerClient::kOnAggregatedHitTestRegionListUpdated:
            return "Receive viz::mojom::FrameSinkManagerClient::OnAggregatedHitTestRegionListUpdated";
      case messages::FrameSinkManagerClient::kOnFrameTokenChanged:
            return "Receive viz::mojom::FrameSinkManagerClient::OnFrameTokenChanged";
      case messages::FrameSinkManagerClient::kOnScreenshotCaptured:
            return "Receive viz::mojom::FrameSinkManagerClient::OnScreenshotCaptured";
      case messages::FrameSinkManagerClient::kOnVizTouchStateAvailable:
            return "Receive viz::mojom::FrameSinkManagerClient::OnVizTouchStateAvailable";
    }
  } else {
    switch (static_cast<messages::FrameSinkManagerClient>(message.name())) {
      case messages::FrameSinkManagerClient::kOnFirstSurfaceActivation:
            return "Receive reply viz::mojom::FrameSinkManagerClient::OnFirstSurfaceActivation";
      case messages::FrameSinkManagerClient::kOnAggregatedHitTestRegionListUpdated:
            return "Receive reply viz::mojom::FrameSinkManagerClient::OnAggregatedHitTestRegionListUpdated";
      case messages::FrameSinkManagerClient::kOnFrameTokenChanged:
            return "Receive reply viz::mojom::FrameSinkManagerClient::OnFrameTokenChanged";
      case messages::FrameSinkManagerClient::kOnScreenshotCaptured:
            return "Receive reply viz::mojom::FrameSinkManagerClient::OnScreenshotCaptured";
      case messages::FrameSinkManagerClient::kOnVizTouchStateAvailable:
            return "Receive reply viz::mojom::FrameSinkManagerClient::OnVizTouchStateAvailable";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t FrameSinkManagerClient::OnFirstSurfaceActivation_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4862aa43;  // IPCStableHash for viz::mojom::FrameSinkManagerClient::OnFirstSurfaceActivation
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameSinkManagerClient::OnAggregatedHitTestRegionListUpdated_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x397430d1;  // IPCStableHash for viz::mojom::FrameSinkManagerClient::OnAggregatedHitTestRegionListUpdated
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameSinkManagerClient::OnFrameTokenChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x26f29bb4;  // IPCStableHash for viz::mojom::FrameSinkManagerClient::OnFrameTokenChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameSinkManagerClient::OnScreenshotCaptured_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x694f2312;  // IPCStableHash for viz::mojom::FrameSinkManagerClient::OnScreenshotCaptured
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameSinkManagerClient::OnVizTouchStateAvailable_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x28fdbe74;  // IPCStableHash for viz::mojom::FrameSinkManagerClient::OnVizTouchStateAvailable
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

FrameSinkManagerClientProxy::FrameSinkManagerClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FrameSinkManagerClientProxy::OnFirstSurfaceActivation(
    const ::viz::SurfaceInfo& in_surface_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::FrameSinkManagerClient::OnFirstSurfaceActivation", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("surface_info"), in_surface_info,
                        "<value of type const ::viz::SurfaceInfo&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameSinkManagerClient::kOnFirstSurfaceActivation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkManagerClient_OnFirstSurfaceActivation_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->surface_info)::BaseType> surface_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::viz::mojom::SurfaceInfoDataView>(
    in_surface_info,
    surface_info_fragment);

  params->surface_info.Set(
      surface_info_fragment.is_null() ? nullptr : surface_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->surface_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null surface_info in FrameSinkManagerClient.OnFirstSurfaceActivation request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkManagerClient::Name_);
  message.set_method_name("OnFirstSurfaceActivation");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameSinkManagerClientProxy::OnAggregatedHitTestRegionListUpdated(
    const ::viz::FrameSinkId& in_frame_sink_id, const std::vector<::viz::AggregatedHitTestRegion>& in_hit_test_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::FrameSinkManagerClient::OnAggregatedHitTestRegionListUpdated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_sink_id"), in_frame_sink_id,
                        "<value of type const ::viz::FrameSinkId&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("hit_test_data"), in_hit_test_data,
                        "<value of type const std::vector<::viz::AggregatedHitTestRegion>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameSinkManagerClient::kOnAggregatedHitTestRegionListUpdated), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkManagerClient_OnAggregatedHitTestRegionListUpdated_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->frame_sink_id)::BaseType> frame_sink_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::viz::mojom::FrameSinkIdDataView>(
    in_frame_sink_id,
    frame_sink_id_fragment);

  params->frame_sink_id.Set(
      frame_sink_id_fragment.is_null() ? nullptr : frame_sink_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->frame_sink_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null frame_sink_id in FrameSinkManagerClient.OnAggregatedHitTestRegionListUpdated request");
  mojo::internal::MessageFragment<
      typename decltype(params->hit_test_data)::BaseType>
      hit_test_data_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& hit_test_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::AggregatedHitTestRegionDataView>>(
    in_hit_test_data,
    hit_test_data_fragment,
    &hit_test_data_validate_params);

  params->hit_test_data.Set(
      hit_test_data_fragment.is_null() ? nullptr : hit_test_data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->hit_test_data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null hit_test_data in FrameSinkManagerClient.OnAggregatedHitTestRegionListUpdated request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkManagerClient::Name_);
  message.set_method_name("OnAggregatedHitTestRegionListUpdated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameSinkManagerClientProxy::OnFrameTokenChanged(
    const ::viz::FrameSinkId& in_frame_sink_id, uint32_t in_frame_token, ::base::TimeTicks in_activation_time) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::FrameSinkManagerClient::OnFrameTokenChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_sink_id"), in_frame_sink_id,
                        "<value of type const ::viz::FrameSinkId&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_token"), in_frame_token,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("activation_time"), in_activation_time,
                        "<value of type ::base::TimeTicks>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameSinkManagerClient::kOnFrameTokenChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkManagerClient_OnFrameTokenChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->frame_sink_id)::BaseType> frame_sink_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::viz::mojom::FrameSinkIdDataView>(
    in_frame_sink_id,
    frame_sink_id_fragment);

  params->frame_sink_id.Set(
      frame_sink_id_fragment.is_null() ? nullptr : frame_sink_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->frame_sink_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null frame_sink_id in FrameSinkManagerClient.OnFrameTokenChanged request");

  params->frame_token = in_frame_token;
  mojo::internal::MessageFragment<
      typename decltype(params->activation_time)::BaseType> activation_time_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
    in_activation_time,
    activation_time_fragment);

  params->activation_time.Set(
      activation_time_fragment.is_null() ? nullptr : activation_time_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->activation_time.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null activation_time in FrameSinkManagerClient.OnFrameTokenChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkManagerClient::Name_);
  message.set_method_name("OnFrameTokenChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameSinkManagerClientProxy::OnScreenshotCaptured(
    const ::blink::SameDocNavigationScreenshotDestinationToken& in_destination_token, ::std::unique_ptr<::viz::CopyOutputResult> in_copy_output_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::FrameSinkManagerClient::OnScreenshotCaptured", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("destination_token"), in_destination_token,
                        "<value of type const ::blink::SameDocNavigationScreenshotDestinationToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("copy_output_result"), in_copy_output_result,
                        "<value of type ::std::unique_ptr<::viz::CopyOutputResult>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameSinkManagerClient::kOnScreenshotCaptured), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkManagerClient_OnScreenshotCaptured_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->destination_token)::BaseType> destination_token_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::SameDocNavigationScreenshotDestinationTokenDataView>(
    in_destination_token,
    destination_token_fragment);

  params->destination_token.Set(
      destination_token_fragment.is_null() ? nullptr : destination_token_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->destination_token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null destination_token in FrameSinkManagerClient.OnScreenshotCaptured request");
  mojo::internal::MessageFragment<
      typename decltype(params->copy_output_result)::BaseType> copy_output_result_fragment(
          params.message());
  
  mojo::internal::Serialize<::viz::mojom::CopyOutputResultDataView>(
    in_copy_output_result,
    copy_output_result_fragment);

  params->copy_output_result.Set(
      copy_output_result_fragment.is_null() ? nullptr : copy_output_result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->copy_output_result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null copy_output_result in FrameSinkManagerClient.OnScreenshotCaptured request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkManagerClient::Name_);
  message.set_method_name("OnScreenshotCaptured");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameSinkManagerClientProxy::OnVizTouchStateAvailable(
    ::base::ReadOnlySharedMemoryRegion in_region) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::FrameSinkManagerClient::OnVizTouchStateAvailable", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("region"), in_region,
                        "<value of type ::base::ReadOnlySharedMemoryRegion>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameSinkManagerClient::kOnVizTouchStateAvailable), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkManagerClient_OnVizTouchStateAvailable_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->region)::BaseType> region_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>(
    in_region,
    region_fragment);

  params->region.Set(
      region_fragment.is_null() ? nullptr : region_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->region.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null region in FrameSinkManagerClient.OnVizTouchStateAvailable request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkManagerClient::Name_);
  message.set_method_name("OnVizTouchStateAvailable");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool FrameSinkManagerClientStubDispatch::Accept(
    FrameSinkManagerClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::FrameSinkManagerClient>(message->header()->name)) {
    case messages::FrameSinkManagerClient::kOnFirstSurfaceActivation: {
      DCHECK(message->is_serialized());
      internal::FrameSinkManagerClient_OnFirstSurfaceActivation_Params_Data* params =
          reinterpret_cast<internal::FrameSinkManagerClient_OnFirstSurfaceActivation_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameSinkManagerClient.0
      bool success = true;
      ::viz::SurfaceInfo p_surface_info{};
      FrameSinkManagerClient_OnFirstSurfaceActivation_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSurfaceInfo(&p_surface_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkManagerClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnFirstSurfaceActivation(        
        std::move(p_surface_info));
      return true;
    }
    case messages::FrameSinkManagerClient::kOnAggregatedHitTestRegionListUpdated: {
      DCHECK(message->is_serialized());
      internal::FrameSinkManagerClient_OnAggregatedHitTestRegionListUpdated_Params_Data* params =
          reinterpret_cast<internal::FrameSinkManagerClient_OnAggregatedHitTestRegionListUpdated_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameSinkManagerClient.1
      bool success = true;
      ::viz::FrameSinkId p_frame_sink_id{};
      std::vector<::viz::AggregatedHitTestRegion> p_hit_test_data{};
      FrameSinkManagerClient_OnAggregatedHitTestRegionListUpdated_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFrameSinkId(&p_frame_sink_id))
        success = false;
      if (success && !input_data_view.ReadHitTestData(&p_hit_test_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkManagerClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnAggregatedHitTestRegionListUpdated(        
        std::move(p_frame_sink_id), 
        std::move(p_hit_test_data));
      return true;
    }
    case messages::FrameSinkManagerClient::kOnFrameTokenChanged: {
      DCHECK(message->is_serialized());
      internal::FrameSinkManagerClient_OnFrameTokenChanged_Params_Data* params =
          reinterpret_cast<internal::FrameSinkManagerClient_OnFrameTokenChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameSinkManagerClient.2
      bool success = true;
      ::viz::FrameSinkId p_frame_sink_id{};
      uint32_t p_frame_token{};
      ::base::TimeTicks p_activation_time{};
      FrameSinkManagerClient_OnFrameTokenChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFrameSinkId(&p_frame_sink_id))
        success = false;
      if (success)
        p_frame_token = input_data_view.frame_token();
      if (success && !input_data_view.ReadActivationTime(&p_activation_time))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkManagerClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnFrameTokenChanged(        
        std::move(p_frame_sink_id), 
        std::move(p_frame_token), 
        std::move(p_activation_time));
      return true;
    }
    case messages::FrameSinkManagerClient::kOnScreenshotCaptured: {
      DCHECK(message->is_serialized());
      internal::FrameSinkManagerClient_OnScreenshotCaptured_Params_Data* params =
          reinterpret_cast<internal::FrameSinkManagerClient_OnScreenshotCaptured_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameSinkManagerClient.3
      bool success = true;
      ::blink::SameDocNavigationScreenshotDestinationToken p_destination_token{};
      ::std::unique_ptr<::viz::CopyOutputResult> p_copy_output_result{};
      FrameSinkManagerClient_OnScreenshotCaptured_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDestinationToken(&p_destination_token))
        success = false;
      if (success && !input_data_view.ReadCopyOutputResult(&p_copy_output_result))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkManagerClient::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnScreenshotCaptured(        
        std::move(p_destination_token), 
        std::move(p_copy_output_result));
      return true;
    }
    case messages::FrameSinkManagerClient::kOnVizTouchStateAvailable: {
      DCHECK(message->is_serialized());
      internal::FrameSinkManagerClient_OnVizTouchStateAvailable_Params_Data* params =
          reinterpret_cast<internal::FrameSinkManagerClient_OnVizTouchStateAvailable_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameSinkManagerClient.4
      bool success = true;
      ::base::ReadOnlySharedMemoryRegion p_region{};
      FrameSinkManagerClient_OnVizTouchStateAvailable_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRegion(&p_region))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkManagerClient::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnVizTouchStateAvailable(        
        std::move(p_region));
      return true;
    }
  }
  return false;
}

// static
bool FrameSinkManagerClientStubDispatch::AcceptWithResponder(
    FrameSinkManagerClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::FrameSinkManagerClient>(message->header()->name)) {
    case messages::FrameSinkManagerClient::kOnFirstSurfaceActivation: {
      break;
    }
    case messages::FrameSinkManagerClient::kOnAggregatedHitTestRegionListUpdated: {
      break;
    }
    case messages::FrameSinkManagerClient::kOnFrameTokenChanged: {
      break;
    }
    case messages::FrameSinkManagerClient::kOnScreenshotCaptured: {
      break;
    }
    case messages::FrameSinkManagerClient::kOnVizTouchStateAvailable: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kFrameSinkManagerClientValidationInfo[] = {
    { &internal::FrameSinkManagerClient_OnFirstSurfaceActivation_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FrameSinkManagerClient_OnAggregatedHitTestRegionListUpdated_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FrameSinkManagerClient_OnFrameTokenChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FrameSinkManagerClient_OnScreenshotCaptured_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FrameSinkManagerClient_OnVizTouchStateAvailable_Params_Data::Validate,
     nullptr /* no response */},
};

bool FrameSinkManagerClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::viz::mojom::FrameSinkManagerClient::Name_,
    kFrameSinkManagerClientValidationInfo);
}

// The declaration includes the definition on other builds.

RendererInputRouterDelegateRegistry::IPCStableHashFunction RendererInputRouterDelegateRegistry::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::RendererInputRouterDelegateRegistry>(message.name())) {
    case messages::RendererInputRouterDelegateRegistry::kSetupRenderInputRouterDelegateConnection: {
      return &RendererInputRouterDelegateRegistry::SetupRenderInputRouterDelegateConnection_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* RendererInputRouterDelegateRegistry::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::RendererInputRouterDelegateRegistry>(message.name())) {
      case messages::RendererInputRouterDelegateRegistry::kSetupRenderInputRouterDelegateConnection:
            return "Receive viz::mojom::RendererInputRouterDelegateRegistry::SetupRenderInputRouterDelegateConnection";
    }
  } else {
    switch (static_cast<messages::RendererInputRouterDelegateRegistry>(message.name())) {
      case messages::RendererInputRouterDelegateRegistry::kSetupRenderInputRouterDelegateConnection:
            return "Receive reply viz::mojom::RendererInputRouterDelegateRegistry::SetupRenderInputRouterDelegateConnection";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t RendererInputRouterDelegateRegistry::SetupRenderInputRouterDelegateConnection_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0e51927e;  // IPCStableHash for viz::mojom::RendererInputRouterDelegateRegistry::SetupRenderInputRouterDelegateConnection
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

RendererInputRouterDelegateRegistryProxy::RendererInputRouterDelegateRegistryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void RendererInputRouterDelegateRegistryProxy::SetupRenderInputRouterDelegateConnection(
    const ::viz::FrameSinkId& in_id, ::mojo::PendingAssociatedRemote<::input::mojom::RenderInputRouterDelegateClient> in_rir_delegate_client_remote, ::mojo::PendingAssociatedReceiver<::input::mojom::RenderInputRouterDelegate> in_rir_delegate_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::RendererInputRouterDelegateRegistry::SetupRenderInputRouterDelegateConnection", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type const ::viz::FrameSinkId&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("rir_delegate_client_remote"), in_rir_delegate_client_remote,
                        "<value of type ::mojo::PendingAssociatedRemote<::input::mojom::RenderInputRouterDelegateClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("rir_delegate_receiver"), in_rir_delegate_receiver,
                        "<value of type ::mojo::PendingAssociatedReceiver<::input::mojom::RenderInputRouterDelegate>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RendererInputRouterDelegateRegistry::kSetupRenderInputRouterDelegateConnection), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::RendererInputRouterDelegateRegistry_SetupRenderInputRouterDelegateConnection_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  
  mojo::internal::Serialize<::viz::mojom::FrameSinkIdDataView>(
    in_id,
    id_fragment);

  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null id in RendererInputRouterDelegateRegistry.SetupRenderInputRouterDelegateConnection request");

  
  mojo::internal::Serialize<::input::mojom::RenderInputRouterDelegateClientAssociatedPtrInfoDataView>(
    in_rir_delegate_client_remote,
    &params->rir_delegate_client_remote,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->rir_delegate_client_remote)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid rir_delegate_client_remote in RendererInputRouterDelegateRegistry.SetupRenderInputRouterDelegateConnection request");

  
  mojo::internal::Serialize<::input::mojom::RenderInputRouterDelegateAssociatedRequestDataView>(
    in_rir_delegate_receiver,
    &params->rir_delegate_receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->rir_delegate_receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid rir_delegate_receiver in RendererInputRouterDelegateRegistry.SetupRenderInputRouterDelegateConnection request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RendererInputRouterDelegateRegistry::Name_);
  message.set_method_name("SetupRenderInputRouterDelegateConnection");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool RendererInputRouterDelegateRegistryStubDispatch::Accept(
    RendererInputRouterDelegateRegistry* impl,
    mojo::Message* message) {
  switch (static_cast<messages::RendererInputRouterDelegateRegistry>(message->header()->name)) {
    case messages::RendererInputRouterDelegateRegistry::kSetupRenderInputRouterDelegateConnection: {
      DCHECK(message->is_serialized());
      internal::RendererInputRouterDelegateRegistry_SetupRenderInputRouterDelegateConnection_Params_Data* params =
          reinterpret_cast<internal::RendererInputRouterDelegateRegistry_SetupRenderInputRouterDelegateConnection_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RendererInputRouterDelegateRegistry.0
      bool success = true;
      ::viz::FrameSinkId p_id{};
      ::mojo::PendingAssociatedRemote<::input::mojom::RenderInputRouterDelegateClient> p_rir_delegate_client_remote{};
      ::mojo::PendingAssociatedReceiver<::input::mojom::RenderInputRouterDelegate> p_rir_delegate_receiver{};
      RendererInputRouterDelegateRegistry_SetupRenderInputRouterDelegateConnection_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadId(&p_id))
        success = false;
      if (success) {
        p_rir_delegate_client_remote =
            input_data_view.TakeRirDelegateClientRemote<decltype(p_rir_delegate_client_remote)>();
      }
      if (success) {
        p_rir_delegate_receiver =
            input_data_view.TakeRirDelegateReceiver<decltype(p_rir_delegate_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RendererInputRouterDelegateRegistry::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetupRenderInputRouterDelegateConnection(        
        std::move(p_id), 
        std::move(p_rir_delegate_client_remote), 
        std::move(p_rir_delegate_receiver));
      return true;
    }
  }
  return false;
}

// static
bool RendererInputRouterDelegateRegistryStubDispatch::AcceptWithResponder(
    RendererInputRouterDelegateRegistry* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::RendererInputRouterDelegateRegistry>(message->header()->name)) {
    case messages::RendererInputRouterDelegateRegistry::kSetupRenderInputRouterDelegateConnection: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kRendererInputRouterDelegateRegistryValidationInfo[] = {
    { &internal::RendererInputRouterDelegateRegistry_SetupRenderInputRouterDelegateConnection_Params_Data::Validate,
     nullptr /* no response */},
};

bool RendererInputRouterDelegateRegistryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::viz::mojom::RendererInputRouterDelegateRegistry::Name_,
    kRendererInputRouterDelegateRegistryValidationInfo);
}



}  // viz::mojom


namespace mojo {


// static
bool StructTraits<::viz::mojom::RootCompositorFrameSinkParams::DataView, ::viz::mojom::RootCompositorFrameSinkParamsPtr>::Read(
    ::viz::mojom::RootCompositorFrameSinkParams::DataView input,
    ::viz::mojom::RootCompositorFrameSinkParamsPtr* output) {
  bool success = true;
  ::viz::mojom::RootCompositorFrameSinkParamsPtr result(::viz::mojom::RootCompositorFrameSinkParams::New());
  
      if (success && !input.ReadFrameSinkId(&result->frame_sink_id))
        success = false;
      if (success && !input.ReadWidget(&result->widget))
        success = false;
      if (success)
        result->gpu_compositing = input.gpu_compositing();
      if (success && !input.ReadRendererSettings(&result->renderer_settings))
        success = false;
      if (success)
        result->send_swap_size_notifications = input.send_swap_size_notifications();
      if (success)
        result->disable_frame_rate_limit = input.disable_frame_rate_limit();
      if (success) {
        result->compositor_frame_sink =
            input.TakeCompositorFrameSink<decltype(result->compositor_frame_sink)>();
      }
      if (success) {
        result->compositor_frame_sink_client =
            input.TakeCompositorFrameSinkClient<decltype(result->compositor_frame_sink_client)>();
      }
      if (success) {
        result->display_private =
            input.TakeDisplayPrivate<decltype(result->display_private)>();
      }
      if (success) {
        result->display_client =
            input.TakeDisplayClient<decltype(result->display_client)>();
      }
      if (success) {
        result->external_begin_frame_controller =
            input.TakeExternalBeginFrameController<decltype(result->external_begin_frame_controller)>();
      }
      if (success) {
        result->external_begin_frame_controller_client =
            input.TakeExternalBeginFrameControllerClient<decltype(result->external_begin_frame_controller_client)>();
      }
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace viz::mojom {


void FrameSinkManagerInterceptorForTesting::RegisterFrameSinkId(const ::viz::FrameSinkId& frame_sink_id, bool report_activation) {
  GetForwardingInterface()->RegisterFrameSinkId(
    std::move(frame_sink_id)
    , 
    std::move(report_activation)
    );
}
void FrameSinkManagerInterceptorForTesting::InvalidateFrameSinkId(const ::viz::FrameSinkId& frame_sink_id, InvalidateFrameSinkIdCallback callback) {
  GetForwardingInterface()->InvalidateFrameSinkId(
    std::move(frame_sink_id)
    , std::move(callback));
}
void FrameSinkManagerInterceptorForTesting::SetFrameSinkDebugLabel(const ::viz::FrameSinkId& frame_sink_id, const std::string& debug_label) {
  GetForwardingInterface()->SetFrameSinkDebugLabel(
    std::move(frame_sink_id)
    , 
    std::move(debug_label)
    );
}
void FrameSinkManagerInterceptorForTesting::CreateRootCompositorFrameSink(RootCompositorFrameSinkParamsPtr params) {
  GetForwardingInterface()->CreateRootCompositorFrameSink(
    std::move(params)
    );
}
void FrameSinkManagerInterceptorForTesting::CreateFrameSinkBundle(const ::viz::FrameSinkBundleId& bundle_id, ::mojo::PendingReceiver<::viz::mojom::FrameSinkBundle> receiver, ::mojo::PendingRemote<::viz::mojom::FrameSinkBundleClient> client) {
  GetForwardingInterface()->CreateFrameSinkBundle(
    std::move(bundle_id)
    , 
    std::move(receiver)
    , 
    std::move(client)
    );
}
void FrameSinkManagerInterceptorForTesting::CreateCompositorFrameSink(const ::viz::FrameSinkId& frame_sink_id, const std::optional<::viz::FrameSinkBundleId>& bundle_id, ::mojo::PendingReceiver<::viz::mojom::CompositorFrameSink> compositor_frame_sink, ::mojo::PendingRemote<::viz::mojom::CompositorFrameSinkClient> compositor_frame_sink_client, ::input::mojom::RenderInputRouterConfigPtr config) {
  GetForwardingInterface()->CreateCompositorFrameSink(
    std::move(frame_sink_id)
    , 
    std::move(bundle_id)
    , 
    std::move(compositor_frame_sink)
    , 
    std::move(compositor_frame_sink_client)
    , 
    std::move(config)
    );
}
void FrameSinkManagerInterceptorForTesting::DestroyCompositorFrameSink(const ::viz::FrameSinkId& frame_sink_id, DestroyCompositorFrameSinkCallback callback) {
  GetForwardingInterface()->DestroyCompositorFrameSink(
    std::move(frame_sink_id)
    , std::move(callback));
}
void FrameSinkManagerInterceptorForTesting::RegisterFrameSinkHierarchy(const ::viz::FrameSinkId& parent_frame_sink_id, const ::viz::FrameSinkId& child_frame_sink_id) {
  GetForwardingInterface()->RegisterFrameSinkHierarchy(
    std::move(parent_frame_sink_id)
    , 
    std::move(child_frame_sink_id)
    );
}
void FrameSinkManagerInterceptorForTesting::UnregisterFrameSinkHierarchy(const ::viz::FrameSinkId& parent_frame_sink_id, const ::viz::FrameSinkId& child_frame_sink_id) {
  GetForwardingInterface()->UnregisterFrameSinkHierarchy(
    std::move(parent_frame_sink_id)
    , 
    std::move(child_frame_sink_id)
    );
}
void FrameSinkManagerInterceptorForTesting::AddVideoDetectorObserver(::mojo::PendingRemote<::viz::mojom::VideoDetectorObserver> observer) {
  GetForwardingInterface()->AddVideoDetectorObserver(
    std::move(observer)
    );
}
void FrameSinkManagerInterceptorForTesting::CreateVideoCapturer(::mojo::PendingReceiver<::viz::mojom::FrameSinkVideoCapturer> receiver, uint32_t capture_version_source) {
  GetForwardingInterface()->CreateVideoCapturer(
    std::move(receiver)
    , 
    std::move(capture_version_source)
    );
}
void FrameSinkManagerInterceptorForTesting::EvictSurfaces(const std::vector<::viz::SurfaceId>& surface_ids) {
  GetForwardingInterface()->EvictSurfaces(
    std::move(surface_ids)
    );
}
void FrameSinkManagerInterceptorForTesting::Throttle(const std::vector<::viz::FrameSinkId>& frame_sink_ids, ::base::TimeDelta interval) {
  GetForwardingInterface()->Throttle(
    std::move(frame_sink_ids)
    , 
    std::move(interval)
    );
}
void FrameSinkManagerInterceptorForTesting::StartThrottlingAllFrameSinks(::base::TimeDelta interval) {
  GetForwardingInterface()->StartThrottlingAllFrameSinks(
    std::move(interval)
    );
}
void FrameSinkManagerInterceptorForTesting::StopThrottlingAllFrameSinks() {
  GetForwardingInterface()->StopThrottlingAllFrameSinks();
}
void FrameSinkManagerInterceptorForTesting::RequestCopyOfOutput(const ::viz::SurfaceId& surface_id, ::std::unique_ptr<::viz::CopyOutputRequest> request, bool capture_exact_surface_id) {
  GetForwardingInterface()->RequestCopyOfOutput(
    std::move(surface_id)
    , 
    std::move(request)
    , 
    std::move(capture_exact_surface_id)
    );
}
void FrameSinkManagerInterceptorForTesting::UpdateDebugRendererSettings(const ::viz::DebugRendererSettings& debug_settings) {
  GetForwardingInterface()->UpdateDebugRendererSettings(
    std::move(debug_settings)
    );
}
void FrameSinkManagerInterceptorForTesting::ClearUnclaimedViewTransitionResources(const ::blink::ViewTransitionToken& transition_token) {
  GetForwardingInterface()->ClearUnclaimedViewTransitionResources(
    std::move(transition_token)
    );
}
void FrameSinkManagerInterceptorForTesting::CreateMetricsRecorderForTest(::mojo::PendingReceiver<::viz::mojom::FrameSinksMetricsRecorder> receiver) {
  GetForwardingInterface()->CreateMetricsRecorderForTest(
    std::move(receiver)
    );
}
void FrameSinkManagerInterceptorForTesting::EnableFrameSinkManagerTestApi(::mojo::PendingReceiver<::viz::mojom::FrameSinkManagerTestApi> receiver) {
  GetForwardingInterface()->EnableFrameSinkManagerTestApi(
    std::move(receiver)
    );
}
void FrameSinkManagerInterceptorForTesting::SetupRendererInputRouterDelegateRegistry(::mojo::PendingReceiver<RendererInputRouterDelegateRegistry> receiver) {
  GetForwardingInterface()->SetupRendererInputRouterDelegateRegistry(
    std::move(receiver)
    );
}
void FrameSinkManagerInterceptorForTesting::NotifyRendererBlockStateChanged(bool blocked, const std::vector<::viz::FrameSinkId>& render_input_routers) {
  GetForwardingInterface()->NotifyRendererBlockStateChanged(
    std::move(blocked)
    , 
    std::move(render_input_routers)
    );
}
void FrameSinkManagerInterceptorForTesting::RequestInputBack() {
  GetForwardingInterface()->RequestInputBack();
}
FrameSinkManagerAsyncWaiter::FrameSinkManagerAsyncWaiter(
    FrameSinkManager* proxy) : proxy_(proxy) {}

FrameSinkManagerAsyncWaiter::~FrameSinkManagerAsyncWaiter() = default;


void FrameSinkManagerAsyncWaiter::InvalidateFrameSinkId(
    const ::viz::FrameSinkId& frame_sink_id) {
  base::RunLoop loop;
  proxy_->InvalidateFrameSinkId(
      std::move(frame_sink_id),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void FrameSinkManagerAsyncWaiter::DestroyCompositorFrameSink(
    const ::viz::FrameSinkId& frame_sink_id) {
  base::RunLoop loop;
  proxy_->DestroyCompositorFrameSink(
      std::move(frame_sink_id),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}






void FrameSinkManagerClientInterceptorForTesting::OnFirstSurfaceActivation(const ::viz::SurfaceInfo& surface_info) {
  GetForwardingInterface()->OnFirstSurfaceActivation(
    std::move(surface_info)
    );
}
void FrameSinkManagerClientInterceptorForTesting::OnAggregatedHitTestRegionListUpdated(const ::viz::FrameSinkId& frame_sink_id, const std::vector<::viz::AggregatedHitTestRegion>& hit_test_data) {
  GetForwardingInterface()->OnAggregatedHitTestRegionListUpdated(
    std::move(frame_sink_id)
    , 
    std::move(hit_test_data)
    );
}
void FrameSinkManagerClientInterceptorForTesting::OnFrameTokenChanged(const ::viz::FrameSinkId& frame_sink_id, uint32_t frame_token, ::base::TimeTicks activation_time) {
  GetForwardingInterface()->OnFrameTokenChanged(
    std::move(frame_sink_id)
    , 
    std::move(frame_token)
    , 
    std::move(activation_time)
    );
}
void FrameSinkManagerClientInterceptorForTesting::OnScreenshotCaptured(const ::blink::SameDocNavigationScreenshotDestinationToken& destination_token, ::std::unique_ptr<::viz::CopyOutputResult> copy_output_result) {
  GetForwardingInterface()->OnScreenshotCaptured(
    std::move(destination_token)
    , 
    std::move(copy_output_result)
    );
}
void FrameSinkManagerClientInterceptorForTesting::OnVizTouchStateAvailable(::base::ReadOnlySharedMemoryRegion region) {
  GetForwardingInterface()->OnVizTouchStateAvailable(
    std::move(region)
    );
}
FrameSinkManagerClientAsyncWaiter::FrameSinkManagerClientAsyncWaiter(
    FrameSinkManagerClient* proxy) : proxy_(proxy) {}

FrameSinkManagerClientAsyncWaiter::~FrameSinkManagerClientAsyncWaiter() = default;





void RendererInputRouterDelegateRegistryInterceptorForTesting::SetupRenderInputRouterDelegateConnection(const ::viz::FrameSinkId& id, ::mojo::PendingAssociatedRemote<::input::mojom::RenderInputRouterDelegateClient> rir_delegate_client_remote, ::mojo::PendingAssociatedReceiver<::input::mojom::RenderInputRouterDelegate> rir_delegate_receiver) {
  GetForwardingInterface()->SetupRenderInputRouterDelegateConnection(
    std::move(id)
    , 
    std::move(rir_delegate_client_remote)
    , 
    std::move(rir_delegate_receiver)
    );
}
RendererInputRouterDelegateRegistryAsyncWaiter::RendererInputRouterDelegateRegistryAsyncWaiter(
    RendererInputRouterDelegateRegistry* proxy) : proxy_(proxy) {}

RendererInputRouterDelegateRegistryAsyncWaiter::~RendererInputRouterDelegateRegistryAsyncWaiter() = default;







}  // viz::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif