// services/viz/privileged/mojom/compositing/frame_sink_manager.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PRIVILEGED_MOJOM_COMPOSITING_FRAME_SINK_MANAGER_MOJOM_TEST_UTILS_H_
#define SERVICES_VIZ_PRIVILEGED_MOJOM_COMPOSITING_FRAME_SINK_MANAGER_MOJOM_TEST_UTILS_H_

#include "services/viz/privileged/mojom/compositing/frame_sink_manager.mojom.h"


namespace viz::mojom {


class  FrameSinkManagerInterceptorForTesting : public FrameSinkManager {
  virtual FrameSinkManager* GetForwardingInterface() = 0;
  void RegisterFrameSinkId(const ::viz::FrameSinkId& frame_sink_id, bool report_activation) override;
  void InvalidateFrameSinkId(const ::viz::FrameSinkId& frame_sink_id, InvalidateFrameSinkIdCallback callback) override;
  void SetFrameSinkDebugLabel(const ::viz::FrameSinkId& frame_sink_id, const std::string& debug_label) override;
  void CreateRootCompositorFrameSink(RootCompositorFrameSinkParamsPtr params) override;
  void CreateFrameSinkBundle(const ::viz::FrameSinkBundleId& bundle_id, ::mojo::PendingReceiver<::viz::mojom::FrameSinkBundle> receiver, ::mojo::PendingRemote<::viz::mojom::FrameSinkBundleClient> client) override;
  void CreateCompositorFrameSink(const ::viz::FrameSinkId& frame_sink_id, const std::optional<::viz::FrameSinkBundleId>& bundle_id, ::mojo::PendingReceiver<::viz::mojom::CompositorFrameSink> compositor_frame_sink, ::mojo::PendingRemote<::viz::mojom::CompositorFrameSinkClient> compositor_frame_sink_client, ::input::mojom::RenderInputRouterConfigPtr config) override;
  void DestroyCompositorFrameSink(const ::viz::FrameSinkId& frame_sink_id, DestroyCompositorFrameSinkCallback callback) override;
  void RegisterFrameSinkHierarchy(const ::viz::FrameSinkId& parent_frame_sink_id, const ::viz::FrameSinkId& child_frame_sink_id) override;
  void UnregisterFrameSinkHierarchy(const ::viz::FrameSinkId& parent_frame_sink_id, const ::viz::FrameSinkId& child_frame_sink_id) override;
  void AddVideoDetectorObserver(::mojo::PendingRemote<::viz::mojom::VideoDetectorObserver> observer) override;
  void CreateVideoCapturer(::mojo::PendingReceiver<::viz::mojom::FrameSinkVideoCapturer> receiver, uint32_t capture_version_source) override;
  void EvictSurfaces(const std::vector<::viz::SurfaceId>& surface_ids) override;
  void Throttle(const std::vector<::viz::FrameSinkId>& frame_sink_ids, ::base::TimeDelta interval) override;
  void StartThrottlingAllFrameSinks(::base::TimeDelta interval) override;
  void StopThrottlingAllFrameSinks() override;
  void RequestCopyOfOutput(const ::viz::SurfaceId& surface_id, ::std::unique_ptr<::viz::CopyOutputRequest> request, bool capture_exact_surface_id) override;
  void UpdateDebugRendererSettings(const ::viz::DebugRendererSettings& debug_settings) override;
  void ClearUnclaimedViewTransitionResources(const ::blink::ViewTransitionToken& transition_token) override;
  void CreateMetricsRecorderForTest(::mojo::PendingReceiver<::viz::mojom::FrameSinksMetricsRecorder> receiver) override;
  void EnableFrameSinkManagerTestApi(::mojo::PendingReceiver<::viz::mojom::FrameSinkManagerTestApi> receiver) override;
  void SetupRendererInputRouterDelegateRegistry(::mojo::PendingReceiver<RendererInputRouterDelegateRegistry> receiver) override;
  void NotifyRendererBlockStateChanged(bool blocked, const std::vector<::viz::FrameSinkId>& render_input_routers) override;
  void RequestInputBack() override;
};
class  FrameSinkManagerAsyncWaiter {
 public:
  explicit FrameSinkManagerAsyncWaiter(FrameSinkManager* proxy);

  FrameSinkManagerAsyncWaiter(const FrameSinkManagerAsyncWaiter&) = delete;
  FrameSinkManagerAsyncWaiter& operator=(const FrameSinkManagerAsyncWaiter&) = delete;

  ~FrameSinkManagerAsyncWaiter();
  void InvalidateFrameSinkId(
      const ::viz::FrameSinkId& frame_sink_id);
  
  void DestroyCompositorFrameSink(
      const ::viz::FrameSinkId& frame_sink_id);
  

 private:
  FrameSinkManager* const proxy_;
};


class  FrameSinkManagerClientInterceptorForTesting : public FrameSinkManagerClient {
  virtual FrameSinkManagerClient* GetForwardingInterface() = 0;
  void OnFirstSurfaceActivation(const ::viz::SurfaceInfo& surface_info) override;
  void OnAggregatedHitTestRegionListUpdated(const ::viz::FrameSinkId& frame_sink_id, const std::vector<::viz::AggregatedHitTestRegion>& hit_test_data) override;
  void OnFrameTokenChanged(const ::viz::FrameSinkId& frame_sink_id, uint32_t frame_token, ::base::TimeTicks activation_time) override;
  void OnScreenshotCaptured(const ::blink::SameDocNavigationScreenshotDestinationToken& destination_token, ::std::unique_ptr<::viz::CopyOutputResult> copy_output_result) override;
  void OnVizTouchStateAvailable(::base::ReadOnlySharedMemoryRegion region) override;
};
class  FrameSinkManagerClientAsyncWaiter {
 public:
  explicit FrameSinkManagerClientAsyncWaiter(FrameSinkManagerClient* proxy);

  FrameSinkManagerClientAsyncWaiter(const FrameSinkManagerClientAsyncWaiter&) = delete;
  FrameSinkManagerClientAsyncWaiter& operator=(const FrameSinkManagerClientAsyncWaiter&) = delete;

  ~FrameSinkManagerClientAsyncWaiter();

 private:
  FrameSinkManagerClient* const proxy_;
};


class  RendererInputRouterDelegateRegistryInterceptorForTesting : public RendererInputRouterDelegateRegistry {
  virtual RendererInputRouterDelegateRegistry* GetForwardingInterface() = 0;
  void SetupRenderInputRouterDelegateConnection(const ::viz::FrameSinkId& id, ::mojo::PendingAssociatedRemote<::input::mojom::RenderInputRouterDelegateClient> rir_delegate_client_remote, ::mojo::PendingAssociatedReceiver<::input::mojom::RenderInputRouterDelegate> rir_delegate_receiver) override;
};
class  RendererInputRouterDelegateRegistryAsyncWaiter {
 public:
  explicit RendererInputRouterDelegateRegistryAsyncWaiter(RendererInputRouterDelegateRegistry* proxy);

  RendererInputRouterDelegateRegistryAsyncWaiter(const RendererInputRouterDelegateRegistryAsyncWaiter&) = delete;
  RendererInputRouterDelegateRegistryAsyncWaiter& operator=(const RendererInputRouterDelegateRegistryAsyncWaiter&) = delete;

  ~RendererInputRouterDelegateRegistryAsyncWaiter();

 private:
  RendererInputRouterDelegateRegistry* const proxy_;
};




}  // viz::mojom

#endif  // SERVICES_VIZ_PRIVILEGED_MOJOM_COMPOSITING_FRAME_SINK_MANAGER_MOJOM_TEST_UTILS_H_