// services/viz/privileged/mojom/compositing/frame_sink_manager.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PRIVILEGED_MOJOM_COMPOSITING_FRAME_SINK_MANAGER_MOJOM_DATA_VIEW_H_
#define SERVICES_VIZ_PRIVILEGED_MOJOM_COMPOSITING_FRAME_SINK_MANAGER_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "services/viz/privileged/mojom/compositing/frame_sink_manager.mojom-shared-internal.h"
#include "gpu/ipc/common/surface_handle.mojom-shared.h"
#include "mojo/public/mojom/base/shared_memory.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "services/viz/privileged/mojom/compositing/display_private.mojom-shared.h"
#include "services/viz/privileged/mojom/compositing/external_begin_frame_controller.mojom-shared.h"
#include "services/viz/privileged/mojom/compositing/features.mojom-shared.h"
#include "services/viz/privileged/mojom/compositing/frame_sink_manager_test_api.mojom-shared.h"
#include "services/viz/privileged/mojom/compositing/frame_sink_video_capture.mojom-shared.h"
#include "services/viz/privileged/mojom/compositing/frame_sinks_metrics_recorder.mojom-shared.h"
#include "services/viz/privileged/mojom/compositing/renderer_settings.mojom-shared.h"
#include "services/viz/public/mojom/compositing/compositor_frame_sink.mojom-shared.h"
#include "services/viz/public/mojom/compositing/copy_output_request.mojom-shared.h"
#include "services/viz/public/mojom/compositing/copy_output_result.mojom-shared.h"
#include "services/viz/public/mojom/compositing/frame_sink_bundle.mojom-shared.h"
#include "services/viz/public/mojom/compositing/frame_sink_bundle_id.mojom-shared.h"
#include "services/viz/public/mojom/compositing/frame_sink_id.mojom-shared.h"
#include "services/viz/public/mojom/compositing/local_surface_id.mojom-shared.h"
#include "services/viz/public/mojom/compositing/surface_id.mojom-shared.h"
#include "services/viz/public/mojom/compositing/surface_info.mojom-shared.h"
#include "services/viz/public/mojom/compositing/video_detector_observer.mojom-shared.h"
#include "services/viz/public/mojom/hit_test/aggregated_hit_test_region.mojom-shared.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom-shared.h"
#include "third_party/blink/public/mojom/widget/platform_widget.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "components/input/render_input_router.mojom-shared.h"


namespace viz::mojom {
class RootCompositorFrameSinkParamsDataView;



}  // viz::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::viz::mojom::RootCompositorFrameSinkParamsDataView> {
  using Data = ::viz::mojom::internal::RootCompositorFrameSinkParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace viz::mojom {
// Interface base classes. They are used for type safety check.
class FrameSinkManagerInterfaceBase {};

using FrameSinkManagerPtrDataView =
    mojo::InterfacePtrDataView<FrameSinkManagerInterfaceBase>;
using FrameSinkManagerRequestDataView =
    mojo::InterfaceRequestDataView<FrameSinkManagerInterfaceBase>;
using FrameSinkManagerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<FrameSinkManagerInterfaceBase>;
using FrameSinkManagerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<FrameSinkManagerInterfaceBase>;
class FrameSinkManagerClientInterfaceBase {};

using FrameSinkManagerClientPtrDataView =
    mojo::InterfacePtrDataView<FrameSinkManagerClientInterfaceBase>;
using FrameSinkManagerClientRequestDataView =
    mojo::InterfaceRequestDataView<FrameSinkManagerClientInterfaceBase>;
using FrameSinkManagerClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<FrameSinkManagerClientInterfaceBase>;
using FrameSinkManagerClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<FrameSinkManagerClientInterfaceBase>;
class RendererInputRouterDelegateRegistryInterfaceBase {};

using RendererInputRouterDelegateRegistryPtrDataView =
    mojo::InterfacePtrDataView<RendererInputRouterDelegateRegistryInterfaceBase>;
using RendererInputRouterDelegateRegistryRequestDataView =
    mojo::InterfaceRequestDataView<RendererInputRouterDelegateRegistryInterfaceBase>;
using RendererInputRouterDelegateRegistryAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<RendererInputRouterDelegateRegistryInterfaceBase>;
using RendererInputRouterDelegateRegistryAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<RendererInputRouterDelegateRegistryInterfaceBase>;


class RootCompositorFrameSinkParamsDataView {
 public:
  RootCompositorFrameSinkParamsDataView() = default;

  RootCompositorFrameSinkParamsDataView(
      internal::RootCompositorFrameSinkParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFrameSinkIdDataView(
      ::viz::mojom::FrameSinkIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrameSinkId(UserType* output) {
    
    auto* pointer = data_->frame_sink_id.Get();
    return mojo::internal::Deserialize<::viz::mojom::FrameSinkIdDataView>(
        pointer, output, message_);
  }
  inline void GetWidgetDataView(
      ::gpu::mojom::SurfaceHandleDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWidget(UserType* output) {
    
    auto* pointer = data_->widget.Get();
    return mojo::internal::Deserialize<::gpu::mojom::SurfaceHandleDataView>(
        pointer, output, message_);
  }
  bool gpu_compositing() const {
    return data_->gpu_compositing;
  }
  inline void GetRendererSettingsDataView(
      ::viz::mojom::RendererSettingsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRendererSettings(UserType* output) {
    
    auto* pointer = data_->renderer_settings.Get();
    return mojo::internal::Deserialize<::viz::mojom::RendererSettingsDataView>(
        pointer, output, message_);
  }
  bool send_swap_size_notifications() const {
    return data_->send_swap_size_notifications;
  }
  bool disable_frame_rate_limit() const {
    return data_->disable_frame_rate_limit;
  }
  template <typename UserType>
  UserType TakeCompositorFrameSink() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::viz::mojom::CompositorFrameSinkAssociatedRequestDataView>(
            &data_->compositor_frame_sink, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeCompositorFrameSinkClient() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::viz::mojom::CompositorFrameSinkClientInterfaceBase>>(
            &data_->compositor_frame_sink_client, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeDisplayPrivate() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::viz::mojom::DisplayPrivateAssociatedRequestDataView>(
            &data_->display_private, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeDisplayClient() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::viz::mojom::DisplayClientInterfaceBase>>(
            &data_->display_client, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeExternalBeginFrameController() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::viz::mojom::ExternalBeginFrameControllerAssociatedRequestDataView>(
            &data_->external_begin_frame_controller, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeExternalBeginFrameControllerClient() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::viz::mojom::ExternalBeginFrameControllerClientAssociatedPtrInfoDataView>(
            &data_->external_begin_frame_controller_client, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::RootCompositorFrameSinkParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // viz::mojom

#endif  // SERVICES_VIZ_PRIVILEGED_MOJOM_COMPOSITING_FRAME_SINK_MANAGER_MOJOM_DATA_VIEW_H_