// services/viz/privileged/mojom/compositing/display_private.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/viz/privileged/mojom/compositing/display_private.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/viz/privileged/mojom/compositing/display_private.mojom-params-data.h"
#include "services/viz/privileged/mojom/compositing/display_private.mojom-shared-message-ids.h"

#include "services/viz/privileged/mojom/compositing/display_private.mojom-import-headers.h"
#include "services/viz/privileged/mojom/compositing/display_private.mojom-test-utils.h"


namespace viz::mojom {
// The declaration includes the definition on other builds.

DisplayPrivate::IPCStableHashFunction DisplayPrivate::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::DisplayPrivate>(message.name())) {
    case messages::DisplayPrivate::kSetDisplayVisible: {
      return &DisplayPrivate::SetDisplayVisible_Sym::IPCStableHash;
    }
    case messages::DisplayPrivate::kResize: {
      return &DisplayPrivate::Resize_Sym::IPCStableHash;
    }
    case messages::DisplayPrivate::kSetDisplayColorMatrix: {
      return &DisplayPrivate::SetDisplayColorMatrix_Sym::IPCStableHash;
    }
    case messages::DisplayPrivate::kSetDisplayColorSpaces: {
      return &DisplayPrivate::SetDisplayColorSpaces_Sym::IPCStableHash;
    }
    case messages::DisplayPrivate::kSetOutputIsSecure: {
      return &DisplayPrivate::SetOutputIsSecure_Sym::IPCStableHash;
    }
    case messages::DisplayPrivate::kSetVSyncDisplayID: {
      return &DisplayPrivate::SetVSyncDisplayID_Sym::IPCStableHash;
    }
    case messages::DisplayPrivate::kSetDisplayVSyncParameters: {
      return &DisplayPrivate::SetDisplayVSyncParameters_Sym::IPCStableHash;
    }
    case messages::DisplayPrivate::kForceImmediateDrawAndSwapIfPossible: {
      return &DisplayPrivate::ForceImmediateDrawAndSwapIfPossible_Sym::IPCStableHash;
    }
    case messages::DisplayPrivate::kAddVSyncParameterObserver: {
      return &DisplayPrivate::AddVSyncParameterObserver_Sym::IPCStableHash;
    }
    case messages::DisplayPrivate::kSetDelegatedInkPointRenderer: {
      return &DisplayPrivate::SetDelegatedInkPointRenderer_Sym::IPCStableHash;
    }
    case messages::DisplayPrivate::kSetStandaloneBeginFrameObserver: {
      return &DisplayPrivate::SetStandaloneBeginFrameObserver_Sym::IPCStableHash;
    }
    case messages::DisplayPrivate::kSetMaxVSyncAndVrr: {
      return &DisplayPrivate::SetMaxVSyncAndVrr_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* DisplayPrivate::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::DisplayPrivate>(message.name())) {
      case messages::DisplayPrivate::kSetDisplayVisible:
            return "Receive viz::mojom::DisplayPrivate::SetDisplayVisible";
      case messages::DisplayPrivate::kResize:
            return "Receive viz::mojom::DisplayPrivate::Resize";
      case messages::DisplayPrivate::kSetDisplayColorMatrix:
            return "Receive viz::mojom::DisplayPrivate::SetDisplayColorMatrix";
      case messages::DisplayPrivate::kSetDisplayColorSpaces:
            return "Receive viz::mojom::DisplayPrivate::SetDisplayColorSpaces";
      case messages::DisplayPrivate::kSetOutputIsSecure:
            return "Receive viz::mojom::DisplayPrivate::SetOutputIsSecure";
      case messages::DisplayPrivate::kSetVSyncDisplayID:
            return "Receive viz::mojom::DisplayPrivate::SetVSyncDisplayID";
      case messages::DisplayPrivate::kSetDisplayVSyncParameters:
            return "Receive viz::mojom::DisplayPrivate::SetDisplayVSyncParameters";
      case messages::DisplayPrivate::kForceImmediateDrawAndSwapIfPossible:
            return "Receive viz::mojom::DisplayPrivate::ForceImmediateDrawAndSwapIfPossible";
      case messages::DisplayPrivate::kAddVSyncParameterObserver:
            return "Receive viz::mojom::DisplayPrivate::AddVSyncParameterObserver";
      case messages::DisplayPrivate::kSetDelegatedInkPointRenderer:
            return "Receive viz::mojom::DisplayPrivate::SetDelegatedInkPointRenderer";
      case messages::DisplayPrivate::kSetStandaloneBeginFrameObserver:
            return "Receive viz::mojom::DisplayPrivate::SetStandaloneBeginFrameObserver";
      case messages::DisplayPrivate::kSetMaxVSyncAndVrr:
            return "Receive viz::mojom::DisplayPrivate::SetMaxVSyncAndVrr";
    }
  } else {
    switch (static_cast<messages::DisplayPrivate>(message.name())) {
      case messages::DisplayPrivate::kSetDisplayVisible:
            return "Receive reply viz::mojom::DisplayPrivate::SetDisplayVisible";
      case messages::DisplayPrivate::kResize:
            return "Receive reply viz::mojom::DisplayPrivate::Resize";
      case messages::DisplayPrivate::kSetDisplayColorMatrix:
            return "Receive reply viz::mojom::DisplayPrivate::SetDisplayColorMatrix";
      case messages::DisplayPrivate::kSetDisplayColorSpaces:
            return "Receive reply viz::mojom::DisplayPrivate::SetDisplayColorSpaces";
      case messages::DisplayPrivate::kSetOutputIsSecure:
            return "Receive reply viz::mojom::DisplayPrivate::SetOutputIsSecure";
      case messages::DisplayPrivate::kSetVSyncDisplayID:
            return "Receive reply viz::mojom::DisplayPrivate::SetVSyncDisplayID";
      case messages::DisplayPrivate::kSetDisplayVSyncParameters:
            return "Receive reply viz::mojom::DisplayPrivate::SetDisplayVSyncParameters";
      case messages::DisplayPrivate::kForceImmediateDrawAndSwapIfPossible:
            return "Receive reply viz::mojom::DisplayPrivate::ForceImmediateDrawAndSwapIfPossible";
      case messages::DisplayPrivate::kAddVSyncParameterObserver:
            return "Receive reply viz::mojom::DisplayPrivate::AddVSyncParameterObserver";
      case messages::DisplayPrivate::kSetDelegatedInkPointRenderer:
            return "Receive reply viz::mojom::DisplayPrivate::SetDelegatedInkPointRenderer";
      case messages::DisplayPrivate::kSetStandaloneBeginFrameObserver:
            return "Receive reply viz::mojom::DisplayPrivate::SetStandaloneBeginFrameObserver";
      case messages::DisplayPrivate::kSetMaxVSyncAndVrr:
            return "Receive reply viz::mojom::DisplayPrivate::SetMaxVSyncAndVrr";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t DisplayPrivate::SetDisplayVisible_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0078aa52;  // IPCStableHash for viz::mojom::DisplayPrivate::SetDisplayVisible
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DisplayPrivate::Resize_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x127447a6;  // IPCStableHash for viz::mojom::DisplayPrivate::Resize
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DisplayPrivate::SetDisplayColorMatrix_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd9403e7a;  // IPCStableHash for viz::mojom::DisplayPrivate::SetDisplayColorMatrix
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DisplayPrivate::SetDisplayColorSpaces_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x35edbd33;  // IPCStableHash for viz::mojom::DisplayPrivate::SetDisplayColorSpaces
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DisplayPrivate::SetOutputIsSecure_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9bffdc20;  // IPCStableHash for viz::mojom::DisplayPrivate::SetOutputIsSecure
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DisplayPrivate::SetVSyncDisplayID_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa1bf0741;  // IPCStableHash for viz::mojom::DisplayPrivate::SetVSyncDisplayID
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DisplayPrivate::SetDisplayVSyncParameters_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcd533c75;  // IPCStableHash for viz::mojom::DisplayPrivate::SetDisplayVSyncParameters
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DisplayPrivate::ForceImmediateDrawAndSwapIfPossible_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcc992753;  // IPCStableHash for viz::mojom::DisplayPrivate::ForceImmediateDrawAndSwapIfPossible
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DisplayPrivate::AddVSyncParameterObserver_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5df96bd0;  // IPCStableHash for viz::mojom::DisplayPrivate::AddVSyncParameterObserver
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DisplayPrivate::SetDelegatedInkPointRenderer_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1ee1a1ce;  // IPCStableHash for viz::mojom::DisplayPrivate::SetDelegatedInkPointRenderer
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DisplayPrivate::SetStandaloneBeginFrameObserver_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1edc648e;  // IPCStableHash for viz::mojom::DisplayPrivate::SetStandaloneBeginFrameObserver
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DisplayPrivate::SetMaxVSyncAndVrr_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x16383765;  // IPCStableHash for viz::mojom::DisplayPrivate::SetMaxVSyncAndVrr
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

DisplayPrivateProxy::DisplayPrivateProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DisplayPrivateProxy::SetDisplayVisible(
    bool in_visible) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::DisplayPrivate::SetDisplayVisible", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("visible"), in_visible,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DisplayPrivate::kSetDisplayVisible), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::DisplayPrivate_SetDisplayVisible_Params_Data> params(
          message);
  params.Allocate();

  params->visible = in_visible;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DisplayPrivate::Name_);
  message.set_method_name("SetDisplayVisible");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DisplayPrivateProxy::Resize(
    const ::gfx::Size& in_size) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::DisplayPrivate::Resize", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("size"), in_size,
                        "<value of type const ::gfx::Size&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DisplayPrivate::kResize), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::DisplayPrivate_Resize_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->size)::BaseType> size_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
    in_size,
    size_fragment);

  params->size.Set(
      size_fragment.is_null() ? nullptr : size_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->size.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null size in DisplayPrivate.Resize request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DisplayPrivate::Name_);
  message.set_method_name("Resize");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DisplayPrivateProxy::SetDisplayColorMatrix(
    const ::gfx::Transform& in_color_matrix) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::DisplayPrivate::SetDisplayColorMatrix", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("color_matrix"), in_color_matrix,
                        "<value of type const ::gfx::Transform&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DisplayPrivate::kSetDisplayColorMatrix), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::DisplayPrivate_SetDisplayColorMatrix_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->color_matrix)::BaseType> color_matrix_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::TransformDataView>(
    in_color_matrix,
    color_matrix_fragment);

  params->color_matrix.Set(
      color_matrix_fragment.is_null() ? nullptr : color_matrix_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->color_matrix.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null color_matrix in DisplayPrivate.SetDisplayColorMatrix request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DisplayPrivate::Name_);
  message.set_method_name("SetDisplayColorMatrix");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DisplayPrivateProxy::SetDisplayColorSpaces(
    const ::gfx::DisplayColorSpaces& in_display_color_spaces) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::DisplayPrivate::SetDisplayColorSpaces", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("display_color_spaces"), in_display_color_spaces,
                        "<value of type const ::gfx::DisplayColorSpaces&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DisplayPrivate::kSetDisplayColorSpaces), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::DisplayPrivate_SetDisplayColorSpaces_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->display_color_spaces)::BaseType> display_color_spaces_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::DisplayColorSpacesDataView>(
    in_display_color_spaces,
    display_color_spaces_fragment);

  params->display_color_spaces.Set(
      display_color_spaces_fragment.is_null() ? nullptr : display_color_spaces_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->display_color_spaces.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null display_color_spaces in DisplayPrivate.SetDisplayColorSpaces request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DisplayPrivate::Name_);
  message.set_method_name("SetDisplayColorSpaces");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DisplayPrivateProxy::SetOutputIsSecure(
    bool in_secure) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::DisplayPrivate::SetOutputIsSecure", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("secure"), in_secure,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DisplayPrivate::kSetOutputIsSecure), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::DisplayPrivate_SetOutputIsSecure_Params_Data> params(
          message);
  params.Allocate();

  params->secure = in_secure;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DisplayPrivate::Name_);
  message.set_method_name("SetOutputIsSecure");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DisplayPrivateProxy::SetVSyncDisplayID(
    int64_t in_display_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::DisplayPrivate::SetVSyncDisplayID", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("display_id"), in_display_id,
                        "<value of type int64_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DisplayPrivate::kSetVSyncDisplayID), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::DisplayPrivate_SetVSyncDisplayID_Params_Data> params(
          message);
  params.Allocate();

  params->display_id = in_display_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DisplayPrivate::Name_);
  message.set_method_name("SetVSyncDisplayID");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DisplayPrivateProxy::SetDisplayVSyncParameters(
    ::base::TimeTicks in_timebase, ::base::TimeDelta in_interval) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::DisplayPrivate::SetDisplayVSyncParameters", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("timebase"), in_timebase,
                        "<value of type ::base::TimeTicks>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("interval"), in_interval,
                        "<value of type ::base::TimeDelta>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DisplayPrivate::kSetDisplayVSyncParameters), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::DisplayPrivate_SetDisplayVSyncParameters_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->timebase)::BaseType> timebase_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
    in_timebase,
    timebase_fragment);

  params->timebase.Set(
      timebase_fragment.is_null() ? nullptr : timebase_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->timebase.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null timebase in DisplayPrivate.SetDisplayVSyncParameters request");
  mojo::internal::MessageFragment<
      typename decltype(params->interval)::BaseType> interval_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
    in_interval,
    interval_fragment);

  params->interval.Set(
      interval_fragment.is_null() ? nullptr : interval_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->interval.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null interval in DisplayPrivate.SetDisplayVSyncParameters request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DisplayPrivate::Name_);
  message.set_method_name("SetDisplayVSyncParameters");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DisplayPrivateProxy::ForceImmediateDrawAndSwapIfPossible(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send viz::mojom::DisplayPrivate::ForceImmediateDrawAndSwapIfPossible");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DisplayPrivate::kForceImmediateDrawAndSwapIfPossible), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::DisplayPrivate_ForceImmediateDrawAndSwapIfPossible_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DisplayPrivate::Name_);
  message.set_method_name("ForceImmediateDrawAndSwapIfPossible");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DisplayPrivateProxy::AddVSyncParameterObserver(
    ::mojo::PendingRemote<::viz::mojom::VSyncParameterObserver> in_observer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::DisplayPrivate::AddVSyncParameterObserver", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer,
                        "<value of type ::mojo::PendingRemote<::viz::mojom::VSyncParameterObserver>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DisplayPrivate::kAddVSyncParameterObserver), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::DisplayPrivate_AddVSyncParameterObserver_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::viz::mojom::VSyncParameterObserverInterfaceBase>>(
    in_observer,
    &params->observer,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->observer)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid observer in DisplayPrivate.AddVSyncParameterObserver request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DisplayPrivate::Name_);
  message.set_method_name("AddVSyncParameterObserver");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DisplayPrivateProxy::SetDelegatedInkPointRenderer(
    ::mojo::PendingReceiver<::gfx::mojom::DelegatedInkPointRenderer> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::DisplayPrivate::SetDelegatedInkPointRenderer", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::gfx::mojom::DelegatedInkPointRenderer>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DisplayPrivate::kSetDelegatedInkPointRenderer), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::DisplayPrivate_SetDelegatedInkPointRenderer_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::gfx::mojom::DelegatedInkPointRendererInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in DisplayPrivate.SetDelegatedInkPointRenderer request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DisplayPrivate::Name_);
  message.set_method_name("SetDelegatedInkPointRenderer");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DisplayPrivateProxy::SetStandaloneBeginFrameObserver(
    ::mojo::PendingRemote<::viz::mojom::BeginFrameObserver> in_observer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::DisplayPrivate::SetStandaloneBeginFrameObserver", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer,
                        "<value of type ::mojo::PendingRemote<::viz::mojom::BeginFrameObserver>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DisplayPrivate::kSetStandaloneBeginFrameObserver), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::DisplayPrivate_SetStandaloneBeginFrameObserver_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::viz::mojom::BeginFrameObserverInterfaceBase>>(
    in_observer,
    &params->observer,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->observer)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid observer in DisplayPrivate.SetStandaloneBeginFrameObserver request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DisplayPrivate::Name_);
  message.set_method_name("SetStandaloneBeginFrameObserver");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DisplayPrivateProxy::SetMaxVSyncAndVrr(
    std::optional<::base::TimeDelta> in_max_vsync_interval, ::display::VariableRefreshRateState in_vrr_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::DisplayPrivate::SetMaxVSyncAndVrr", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("max_vsync_interval"), in_max_vsync_interval,
                        "<value of type std::optional<::base::TimeDelta>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("vrr_state"), in_vrr_state,
                        "<value of type ::display::VariableRefreshRateState>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DisplayPrivate::kSetMaxVSyncAndVrr), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::DisplayPrivate_SetMaxVSyncAndVrr_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->max_vsync_interval)::BaseType> max_vsync_interval_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
    in_max_vsync_interval,
    max_vsync_interval_fragment);

  params->max_vsync_interval.Set(
      max_vsync_interval_fragment.is_null() ? nullptr : max_vsync_interval_fragment.data());

  
  mojo::internal::Serialize<::display::mojom::VariableRefreshRateState>(
    in_vrr_state,
    &params->vrr_state);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DisplayPrivate::Name_);
  message.set_method_name("SetMaxVSyncAndVrr");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool DisplayPrivateStubDispatch::Accept(
    DisplayPrivate* impl,
    mojo::Message* message) {
  switch (static_cast<messages::DisplayPrivate>(message->header()->name)) {
    case messages::DisplayPrivate::kSetDisplayVisible: {
      DCHECK(message->is_serialized());
      internal::DisplayPrivate_SetDisplayVisible_Params_Data* params =
          reinterpret_cast<internal::DisplayPrivate_SetDisplayVisible_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DisplayPrivate.0
      bool success = true;
      bool p_visible{};
      DisplayPrivate_SetDisplayVisible_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_visible = input_data_view.visible();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DisplayPrivate::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetDisplayVisible(        
        std::move(p_visible));
      return true;
    }
    case messages::DisplayPrivate::kResize: {
      DCHECK(message->is_serialized());
      internal::DisplayPrivate_Resize_Params_Data* params =
          reinterpret_cast<internal::DisplayPrivate_Resize_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DisplayPrivate.1
      bool success = true;
      ::gfx::Size p_size{};
      DisplayPrivate_Resize_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSize(&p_size))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DisplayPrivate::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Resize(        
        std::move(p_size));
      return true;
    }
    case messages::DisplayPrivate::kSetDisplayColorMatrix: {
      DCHECK(message->is_serialized());
      internal::DisplayPrivate_SetDisplayColorMatrix_Params_Data* params =
          reinterpret_cast<internal::DisplayPrivate_SetDisplayColorMatrix_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DisplayPrivate.2
      bool success = true;
      ::gfx::Transform p_color_matrix{};
      DisplayPrivate_SetDisplayColorMatrix_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadColorMatrix(&p_color_matrix))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DisplayPrivate::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetDisplayColorMatrix(        
        std::move(p_color_matrix));
      return true;
    }
    case messages::DisplayPrivate::kSetDisplayColorSpaces: {
      DCHECK(message->is_serialized());
      internal::DisplayPrivate_SetDisplayColorSpaces_Params_Data* params =
          reinterpret_cast<internal::DisplayPrivate_SetDisplayColorSpaces_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DisplayPrivate.3
      bool success = true;
      ::gfx::DisplayColorSpaces p_display_color_spaces{};
      DisplayPrivate_SetDisplayColorSpaces_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDisplayColorSpaces(&p_display_color_spaces))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DisplayPrivate::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetDisplayColorSpaces(        
        std::move(p_display_color_spaces));
      return true;
    }
    case messages::DisplayPrivate::kSetOutputIsSecure: {
      DCHECK(message->is_serialized());
      internal::DisplayPrivate_SetOutputIsSecure_Params_Data* params =
          reinterpret_cast<internal::DisplayPrivate_SetOutputIsSecure_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DisplayPrivate.4
      bool success = true;
      bool p_secure{};
      DisplayPrivate_SetOutputIsSecure_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_secure = input_data_view.secure();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DisplayPrivate::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetOutputIsSecure(        
        std::move(p_secure));
      return true;
    }
    case messages::DisplayPrivate::kSetVSyncDisplayID: {
      DCHECK(message->is_serialized());
      internal::DisplayPrivate_SetVSyncDisplayID_Params_Data* params =
          reinterpret_cast<internal::DisplayPrivate_SetVSyncDisplayID_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DisplayPrivate.5
      bool success = true;
      int64_t p_display_id{};
      DisplayPrivate_SetVSyncDisplayID_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_display_id = input_data_view.display_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DisplayPrivate::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetVSyncDisplayID(        
        std::move(p_display_id));
      return true;
    }
    case messages::DisplayPrivate::kSetDisplayVSyncParameters: {
      DCHECK(message->is_serialized());
      internal::DisplayPrivate_SetDisplayVSyncParameters_Params_Data* params =
          reinterpret_cast<internal::DisplayPrivate_SetDisplayVSyncParameters_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DisplayPrivate.6
      bool success = true;
      ::base::TimeTicks p_timebase{};
      ::base::TimeDelta p_interval{};
      DisplayPrivate_SetDisplayVSyncParameters_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTimebase(&p_timebase))
        success = false;
      if (success && !input_data_view.ReadInterval(&p_interval))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DisplayPrivate::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetDisplayVSyncParameters(        
        std::move(p_timebase), 
        std::move(p_interval));
      return true;
    }
    case messages::DisplayPrivate::kForceImmediateDrawAndSwapIfPossible: {
      DCHECK(message->is_serialized());
      internal::DisplayPrivate_ForceImmediateDrawAndSwapIfPossible_Params_Data* params =
          reinterpret_cast<internal::DisplayPrivate_ForceImmediateDrawAndSwapIfPossible_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DisplayPrivate.7
      bool success = true;
      DisplayPrivate_ForceImmediateDrawAndSwapIfPossible_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DisplayPrivate::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ForceImmediateDrawAndSwapIfPossible(        );
      return true;
    }
    case messages::DisplayPrivate::kAddVSyncParameterObserver: {
      DCHECK(message->is_serialized());
      internal::DisplayPrivate_AddVSyncParameterObserver_Params_Data* params =
          reinterpret_cast<internal::DisplayPrivate_AddVSyncParameterObserver_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DisplayPrivate.8
      bool success = true;
      ::mojo::PendingRemote<::viz::mojom::VSyncParameterObserver> p_observer{};
      DisplayPrivate_AddVSyncParameterObserver_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DisplayPrivate::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddVSyncParameterObserver(        
        std::move(p_observer));
      return true;
    }
    case messages::DisplayPrivate::kSetDelegatedInkPointRenderer: {
      DCHECK(message->is_serialized());
      internal::DisplayPrivate_SetDelegatedInkPointRenderer_Params_Data* params =
          reinterpret_cast<internal::DisplayPrivate_SetDelegatedInkPointRenderer_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DisplayPrivate.9
      bool success = true;
      ::mojo::PendingReceiver<::gfx::mojom::DelegatedInkPointRenderer> p_receiver{};
      DisplayPrivate_SetDelegatedInkPointRenderer_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DisplayPrivate::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetDelegatedInkPointRenderer(        
        std::move(p_receiver));
      return true;
    }
    case messages::DisplayPrivate::kSetStandaloneBeginFrameObserver: {
      DCHECK(message->is_serialized());
      internal::DisplayPrivate_SetStandaloneBeginFrameObserver_Params_Data* params =
          reinterpret_cast<internal::DisplayPrivate_SetStandaloneBeginFrameObserver_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DisplayPrivate.10
      bool success = true;
      ::mojo::PendingRemote<::viz::mojom::BeginFrameObserver> p_observer{};
      DisplayPrivate_SetStandaloneBeginFrameObserver_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DisplayPrivate::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetStandaloneBeginFrameObserver(        
        std::move(p_observer));
      return true;
    }
    case messages::DisplayPrivate::kSetMaxVSyncAndVrr: {
      DCHECK(message->is_serialized());
      internal::DisplayPrivate_SetMaxVSyncAndVrr_Params_Data* params =
          reinterpret_cast<internal::DisplayPrivate_SetMaxVSyncAndVrr_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DisplayPrivate.11
      bool success = true;
      std::optional<::base::TimeDelta> p_max_vsync_interval{};
      ::display::VariableRefreshRateState p_vrr_state{};
      DisplayPrivate_SetMaxVSyncAndVrr_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMaxVsyncInterval(&p_max_vsync_interval))
        success = false;
      if (success && !input_data_view.ReadVrrState(&p_vrr_state))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DisplayPrivate::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetMaxVSyncAndVrr(        
        std::move(p_max_vsync_interval), 
        std::move(p_vrr_state));
      return true;
    }
  }
  return false;
}

// static
bool DisplayPrivateStubDispatch::AcceptWithResponder(
    DisplayPrivate* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::DisplayPrivate>(message->header()->name)) {
    case messages::DisplayPrivate::kSetDisplayVisible: {
      break;
    }
    case messages::DisplayPrivate::kResize: {
      break;
    }
    case messages::DisplayPrivate::kSetDisplayColorMatrix: {
      break;
    }
    case messages::DisplayPrivate::kSetDisplayColorSpaces: {
      break;
    }
    case messages::DisplayPrivate::kSetOutputIsSecure: {
      break;
    }
    case messages::DisplayPrivate::kSetVSyncDisplayID: {
      break;
    }
    case messages::DisplayPrivate::kSetDisplayVSyncParameters: {
      break;
    }
    case messages::DisplayPrivate::kForceImmediateDrawAndSwapIfPossible: {
      break;
    }
    case messages::DisplayPrivate::kAddVSyncParameterObserver: {
      break;
    }
    case messages::DisplayPrivate::kSetDelegatedInkPointRenderer: {
      break;
    }
    case messages::DisplayPrivate::kSetStandaloneBeginFrameObserver: {
      break;
    }
    case messages::DisplayPrivate::kSetMaxVSyncAndVrr: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kDisplayPrivateValidationInfo[] = {
    { &internal::DisplayPrivate_SetDisplayVisible_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::DisplayPrivate_Resize_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::DisplayPrivate_SetDisplayColorMatrix_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::DisplayPrivate_SetDisplayColorSpaces_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::DisplayPrivate_SetOutputIsSecure_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::DisplayPrivate_SetVSyncDisplayID_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::DisplayPrivate_SetDisplayVSyncParameters_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::DisplayPrivate_ForceImmediateDrawAndSwapIfPossible_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::DisplayPrivate_AddVSyncParameterObserver_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::DisplayPrivate_SetDelegatedInkPointRenderer_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::DisplayPrivate_SetStandaloneBeginFrameObserver_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::DisplayPrivate_SetMaxVSyncAndVrr_Params_Data::Validate,
     nullptr /* no response */},
};

bool DisplayPrivateRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::viz::mojom::DisplayPrivate::Name_,
    kDisplayPrivateValidationInfo);
}

// The declaration includes the definition on other builds.

DisplayClient::IPCStableHashFunction DisplayClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::DisplayClient>(message.name())) {
    case messages::DisplayClient::kOnDisplayReceivedCALayerParams: {
      return &DisplayClient::OnDisplayReceivedCALayerParams_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* DisplayClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::DisplayClient>(message.name())) {
      case messages::DisplayClient::kOnDisplayReceivedCALayerParams:
            return "Receive viz::mojom::DisplayClient::OnDisplayReceivedCALayerParams";
    }
  } else {
    switch (static_cast<messages::DisplayClient>(message.name())) {
      case messages::DisplayClient::kOnDisplayReceivedCALayerParams:
            return "Receive reply viz::mojom::DisplayClient::OnDisplayReceivedCALayerParams";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t DisplayClient::OnDisplayReceivedCALayerParams_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x37928925;  // IPCStableHash for viz::mojom::DisplayClient::OnDisplayReceivedCALayerParams
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

DisplayClientProxy::DisplayClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DisplayClientProxy::OnDisplayReceivedCALayerParams(
    const ::gfx::CALayerParams& in_ca_layer_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::DisplayClient::OnDisplayReceivedCALayerParams", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ca_layer_params"), in_ca_layer_params,
                        "<value of type const ::gfx::CALayerParams&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DisplayClient::kOnDisplayReceivedCALayerParams), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::DisplayClient_OnDisplayReceivedCALayerParams_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->ca_layer_params)::BaseType> ca_layer_params_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::CALayerParamsDataView>(
    in_ca_layer_params,
    ca_layer_params_fragment);

  params->ca_layer_params.Set(
      ca_layer_params_fragment.is_null() ? nullptr : ca_layer_params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->ca_layer_params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null ca_layer_params in DisplayClient.OnDisplayReceivedCALayerParams request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DisplayClient::Name_);
  message.set_method_name("OnDisplayReceivedCALayerParams");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool DisplayClientStubDispatch::Accept(
    DisplayClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::DisplayClient>(message->header()->name)) {
    case messages::DisplayClient::kOnDisplayReceivedCALayerParams: {
      DCHECK(message->is_serialized());
      internal::DisplayClient_OnDisplayReceivedCALayerParams_Params_Data* params =
          reinterpret_cast<internal::DisplayClient_OnDisplayReceivedCALayerParams_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DisplayClient.0
      bool success = true;
      ::gfx::CALayerParams p_ca_layer_params{};
      DisplayClient_OnDisplayReceivedCALayerParams_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCaLayerParams(&p_ca_layer_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DisplayClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnDisplayReceivedCALayerParams(        
        std::move(p_ca_layer_params));
      return true;
    }
  }
  return false;
}

// static
bool DisplayClientStubDispatch::AcceptWithResponder(
    DisplayClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::DisplayClient>(message->header()->name)) {
    case messages::DisplayClient::kOnDisplayReceivedCALayerParams: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kDisplayClientValidationInfo[] = {
    { &internal::DisplayClient_OnDisplayReceivedCALayerParams_Params_Data::Validate,
     nullptr /* no response */},
};

bool DisplayClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::viz::mojom::DisplayClient::Name_,
    kDisplayClientValidationInfo);
}



}  // viz::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace viz::mojom {


void DisplayPrivateInterceptorForTesting::SetDisplayVisible(bool visible) {
  GetForwardingInterface()->SetDisplayVisible(
    std::move(visible)
    );
}
void DisplayPrivateInterceptorForTesting::Resize(const ::gfx::Size& size) {
  GetForwardingInterface()->Resize(
    std::move(size)
    );
}
void DisplayPrivateInterceptorForTesting::SetDisplayColorMatrix(const ::gfx::Transform& color_matrix) {
  GetForwardingInterface()->SetDisplayColorMatrix(
    std::move(color_matrix)
    );
}
void DisplayPrivateInterceptorForTesting::SetDisplayColorSpaces(const ::gfx::DisplayColorSpaces& display_color_spaces) {
  GetForwardingInterface()->SetDisplayColorSpaces(
    std::move(display_color_spaces)
    );
}
void DisplayPrivateInterceptorForTesting::SetOutputIsSecure(bool secure) {
  GetForwardingInterface()->SetOutputIsSecure(
    std::move(secure)
    );
}
void DisplayPrivateInterceptorForTesting::SetVSyncDisplayID(int64_t display_id) {
  GetForwardingInterface()->SetVSyncDisplayID(
    std::move(display_id)
    );
}
void DisplayPrivateInterceptorForTesting::SetDisplayVSyncParameters(::base::TimeTicks timebase, ::base::TimeDelta interval) {
  GetForwardingInterface()->SetDisplayVSyncParameters(
    std::move(timebase)
    , 
    std::move(interval)
    );
}
void DisplayPrivateInterceptorForTesting::ForceImmediateDrawAndSwapIfPossible() {
  GetForwardingInterface()->ForceImmediateDrawAndSwapIfPossible();
}
void DisplayPrivateInterceptorForTesting::AddVSyncParameterObserver(::mojo::PendingRemote<::viz::mojom::VSyncParameterObserver> observer) {
  GetForwardingInterface()->AddVSyncParameterObserver(
    std::move(observer)
    );
}
void DisplayPrivateInterceptorForTesting::SetDelegatedInkPointRenderer(::mojo::PendingReceiver<::gfx::mojom::DelegatedInkPointRenderer> receiver) {
  GetForwardingInterface()->SetDelegatedInkPointRenderer(
    std::move(receiver)
    );
}
void DisplayPrivateInterceptorForTesting::SetStandaloneBeginFrameObserver(::mojo::PendingRemote<::viz::mojom::BeginFrameObserver> observer) {
  GetForwardingInterface()->SetStandaloneBeginFrameObserver(
    std::move(observer)
    );
}
void DisplayPrivateInterceptorForTesting::SetMaxVSyncAndVrr(std::optional<::base::TimeDelta> max_vsync_interval, ::display::VariableRefreshRateState vrr_state) {
  GetForwardingInterface()->SetMaxVSyncAndVrr(
    std::move(max_vsync_interval)
    , 
    std::move(vrr_state)
    );
}
DisplayPrivateAsyncWaiter::DisplayPrivateAsyncWaiter(
    DisplayPrivate* proxy) : proxy_(proxy) {}

DisplayPrivateAsyncWaiter::~DisplayPrivateAsyncWaiter() = default;





void DisplayClientInterceptorForTesting::OnDisplayReceivedCALayerParams(const ::gfx::CALayerParams& ca_layer_params) {
  GetForwardingInterface()->OnDisplayReceivedCALayerParams(
    std::move(ca_layer_params)
    );
}
DisplayClientAsyncWaiter::DisplayClientAsyncWaiter(
    DisplayClient* proxy) : proxy_(proxy) {}

DisplayClientAsyncWaiter::~DisplayClientAsyncWaiter() = default;







}  // viz::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif