// services/video_capture/public/mojom/virtual_device.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_VIRTUAL_DEVICE_MOJOM_PARAMS_DATA_H_
#define SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_VIRTUAL_DEVICE_MOJOM_PARAMS_DATA_H_
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace video_capture::mojom {
namespace internal {
class  SharedMemoryVirtualDevice_RequestFrameBuffer_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::gfx::mojom::internal::Size_Data> dimension;
  int32_t pixel_format;
  uint8_t pad1_[4];
  mojo::internal::Pointer<::media::mojom::internal::PlaneStrides_Data> strides;

 private:
  friend class mojo::internal::MessageFragment<SharedMemoryVirtualDevice_RequestFrameBuffer_Params_Data>;

  SharedMemoryVirtualDevice_RequestFrameBuffer_Params_Data();
  ~SharedMemoryVirtualDevice_RequestFrameBuffer_Params_Data() = delete;
};
static_assert(sizeof(SharedMemoryVirtualDevice_RequestFrameBuffer_Params_Data) == 32,
              "Bad sizeof(SharedMemoryVirtualDevice_RequestFrameBuffer_Params_Data)");
class  SharedMemoryVirtualDevice_RequestFrameBuffer_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t buffer_id;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<SharedMemoryVirtualDevice_RequestFrameBuffer_ResponseParams_Data>;

  SharedMemoryVirtualDevice_RequestFrameBuffer_ResponseParams_Data();
  ~SharedMemoryVirtualDevice_RequestFrameBuffer_ResponseParams_Data() = delete;
};
static_assert(sizeof(SharedMemoryVirtualDevice_RequestFrameBuffer_ResponseParams_Data) == 16,
              "Bad sizeof(SharedMemoryVirtualDevice_RequestFrameBuffer_ResponseParams_Data)");
class  SharedMemoryVirtualDevice_OnFrameReadyInBuffer_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t buffer_id;
  uint8_t pad0_[4];
  mojo::internal::Pointer<::media::mojom::internal::VideoFrameInfo_Data> frame_info;

 private:
  friend class mojo::internal::MessageFragment<SharedMemoryVirtualDevice_OnFrameReadyInBuffer_Params_Data>;

  SharedMemoryVirtualDevice_OnFrameReadyInBuffer_Params_Data();
  ~SharedMemoryVirtualDevice_OnFrameReadyInBuffer_Params_Data() = delete;
};
static_assert(sizeof(SharedMemoryVirtualDevice_OnFrameReadyInBuffer_Params_Data) == 24,
              "Bad sizeof(SharedMemoryVirtualDevice_OnFrameReadyInBuffer_Params_Data)");
class  TextureVirtualDevice_OnNewSharedImageBufferHandle_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t buffer_id;
  uint8_t pad0_[4];
  mojo::internal::Pointer<::media::mojom::internal::SharedImageBufferHandleSet_Data> shared_image_handle;

 private:
  friend class mojo::internal::MessageFragment<TextureVirtualDevice_OnNewSharedImageBufferHandle_Params_Data>;

  TextureVirtualDevice_OnNewSharedImageBufferHandle_Params_Data();
  ~TextureVirtualDevice_OnNewSharedImageBufferHandle_Params_Data() = delete;
};
static_assert(sizeof(TextureVirtualDevice_OnNewSharedImageBufferHandle_Params_Data) == 24,
              "Bad sizeof(TextureVirtualDevice_OnNewSharedImageBufferHandle_Params_Data)");
class  TextureVirtualDevice_OnFrameAccessHandlerReady_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Interface_Data frame_access_handler;

 private:
  friend class mojo::internal::MessageFragment<TextureVirtualDevice_OnFrameAccessHandlerReady_Params_Data>;

  TextureVirtualDevice_OnFrameAccessHandlerReady_Params_Data();
  ~TextureVirtualDevice_OnFrameAccessHandlerReady_Params_Data() = delete;
};
static_assert(sizeof(TextureVirtualDevice_OnFrameAccessHandlerReady_Params_Data) == 16,
              "Bad sizeof(TextureVirtualDevice_OnFrameAccessHandlerReady_Params_Data)");
class  TextureVirtualDevice_OnFrameReadyInBuffer_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t buffer_id;
  uint8_t pad0_[4];
  mojo::internal::Pointer<::media::mojom::internal::VideoFrameInfo_Data> frame_info;

 private:
  friend class mojo::internal::MessageFragment<TextureVirtualDevice_OnFrameReadyInBuffer_Params_Data>;

  TextureVirtualDevice_OnFrameReadyInBuffer_Params_Data();
  ~TextureVirtualDevice_OnFrameReadyInBuffer_Params_Data() = delete;
};
static_assert(sizeof(TextureVirtualDevice_OnFrameReadyInBuffer_Params_Data) == 24,
              "Bad sizeof(TextureVirtualDevice_OnFrameReadyInBuffer_Params_Data)");
class  TextureVirtualDevice_OnBufferRetired_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t buffer_id;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<TextureVirtualDevice_OnBufferRetired_Params_Data>;

  TextureVirtualDevice_OnBufferRetired_Params_Data();
  ~TextureVirtualDevice_OnBufferRetired_Params_Data() = delete;
};
static_assert(sizeof(TextureVirtualDevice_OnBufferRetired_Params_Data) == 16,
              "Bad sizeof(TextureVirtualDevice_OnBufferRetired_Params_Data)");
class  GpuMemoryBufferVirtualDevice_OnNewGpuMemoryBufferHandle_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t buffer_id;
  uint8_t pad0_[4];
  mojo::internal::Pointer<::gfx::mojom::internal::GpuMemoryBufferHandle_Data> gmb_handle;

 private:
  friend class mojo::internal::MessageFragment<GpuMemoryBufferVirtualDevice_OnNewGpuMemoryBufferHandle_Params_Data>;

  GpuMemoryBufferVirtualDevice_OnNewGpuMemoryBufferHandle_Params_Data();
  ~GpuMemoryBufferVirtualDevice_OnNewGpuMemoryBufferHandle_Params_Data() = delete;
};
static_assert(sizeof(GpuMemoryBufferVirtualDevice_OnNewGpuMemoryBufferHandle_Params_Data) == 24,
              "Bad sizeof(GpuMemoryBufferVirtualDevice_OnNewGpuMemoryBufferHandle_Params_Data)");
class  GpuMemoryBufferVirtualDevice_OnFrameAccessHandlerReady_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Interface_Data frame_access_handler;

 private:
  friend class mojo::internal::MessageFragment<GpuMemoryBufferVirtualDevice_OnFrameAccessHandlerReady_Params_Data>;

  GpuMemoryBufferVirtualDevice_OnFrameAccessHandlerReady_Params_Data();
  ~GpuMemoryBufferVirtualDevice_OnFrameAccessHandlerReady_Params_Data() = delete;
};
static_assert(sizeof(GpuMemoryBufferVirtualDevice_OnFrameAccessHandlerReady_Params_Data) == 16,
              "Bad sizeof(GpuMemoryBufferVirtualDevice_OnFrameAccessHandlerReady_Params_Data)");
class  GpuMemoryBufferVirtualDevice_OnFrameReadyInBuffer_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t buffer_id;
  uint8_t pad0_[4];
  mojo::internal::Pointer<::media::mojom::internal::VideoFrameInfo_Data> frame_info;

 private:
  friend class mojo::internal::MessageFragment<GpuMemoryBufferVirtualDevice_OnFrameReadyInBuffer_Params_Data>;

  GpuMemoryBufferVirtualDevice_OnFrameReadyInBuffer_Params_Data();
  ~GpuMemoryBufferVirtualDevice_OnFrameReadyInBuffer_Params_Data() = delete;
};
static_assert(sizeof(GpuMemoryBufferVirtualDevice_OnFrameReadyInBuffer_Params_Data) == 24,
              "Bad sizeof(GpuMemoryBufferVirtualDevice_OnFrameReadyInBuffer_Params_Data)");
class  GpuMemoryBufferVirtualDevice_OnBufferRetired_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t buffer_id;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<GpuMemoryBufferVirtualDevice_OnBufferRetired_Params_Data>;

  GpuMemoryBufferVirtualDevice_OnBufferRetired_Params_Data();
  ~GpuMemoryBufferVirtualDevice_OnBufferRetired_Params_Data() = delete;
};
static_assert(sizeof(GpuMemoryBufferVirtualDevice_OnBufferRetired_Params_Data) == 16,
              "Bad sizeof(GpuMemoryBufferVirtualDevice_OnBufferRetired_Params_Data)");

}  // namespace internal


class SharedMemoryVirtualDevice_RequestFrameBuffer_ParamsDataView {
 public:
  SharedMemoryVirtualDevice_RequestFrameBuffer_ParamsDataView() = default;

  SharedMemoryVirtualDevice_RequestFrameBuffer_ParamsDataView(
      internal::SharedMemoryVirtualDevice_RequestFrameBuffer_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDimensionDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDimension(UserType* output) {
    
    auto* pointer = data_->dimension.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadPixelFormat(UserType* output) const {
    auto data_value = data_->pixel_format;
    return mojo::internal::Deserialize<::media::mojom::VideoCapturePixelFormat>(
        data_value, output);
  }
  ::media::mojom::VideoCapturePixelFormat pixel_format() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::VideoCapturePixelFormat>(data_->pixel_format));
  }
  inline void GetStridesDataView(
      ::media::mojom::PlaneStridesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStrides(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media::mojom::PlaneStridesDataView, UserType>(),
    "Attempting to read the optional `strides` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadStrides` instead "
    "of `ReadStrides if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->strides.Get();
    return mojo::internal::Deserialize<::media::mojom::PlaneStridesDataView>(
        pointer, output, message_);
  }
 private:
  internal::SharedMemoryVirtualDevice_RequestFrameBuffer_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SharedMemoryVirtualDevice_RequestFrameBuffer_ResponseParamsDataView {
 public:
  SharedMemoryVirtualDevice_RequestFrameBuffer_ResponseParamsDataView() = default;

  SharedMemoryVirtualDevice_RequestFrameBuffer_ResponseParamsDataView(
      internal::SharedMemoryVirtualDevice_RequestFrameBuffer_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t buffer_id() const {
    return data_->buffer_id;
  }
 private:
  internal::SharedMemoryVirtualDevice_RequestFrameBuffer_ResponseParams_Data* data_ = nullptr;
};


class SharedMemoryVirtualDevice_OnFrameReadyInBuffer_ParamsDataView {
 public:
  SharedMemoryVirtualDevice_OnFrameReadyInBuffer_ParamsDataView() = default;

  SharedMemoryVirtualDevice_OnFrameReadyInBuffer_ParamsDataView(
      internal::SharedMemoryVirtualDevice_OnFrameReadyInBuffer_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t buffer_id() const {
    return data_->buffer_id;
  }
  inline void GetFrameInfoDataView(
      ::media::mojom::VideoFrameInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrameInfo(UserType* output) {
    
    auto* pointer = data_->frame_info.Get();
    return mojo::internal::Deserialize<::media::mojom::VideoFrameInfoDataView>(
        pointer, output, message_);
  }
 private:
  internal::SharedMemoryVirtualDevice_OnFrameReadyInBuffer_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TextureVirtualDevice_OnNewSharedImageBufferHandle_ParamsDataView {
 public:
  TextureVirtualDevice_OnNewSharedImageBufferHandle_ParamsDataView() = default;

  TextureVirtualDevice_OnNewSharedImageBufferHandle_ParamsDataView(
      internal::TextureVirtualDevice_OnNewSharedImageBufferHandle_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t buffer_id() const {
    return data_->buffer_id;
  }
  inline void GetSharedImageHandleDataView(
      ::media::mojom::SharedImageBufferHandleSetDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSharedImageHandle(UserType* output) {
    
    auto* pointer = data_->shared_image_handle.Get();
    return mojo::internal::Deserialize<::media::mojom::SharedImageBufferHandleSetDataView>(
        pointer, output, message_);
  }
 private:
  internal::TextureVirtualDevice_OnNewSharedImageBufferHandle_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TextureVirtualDevice_OnFrameAccessHandlerReady_ParamsDataView {
 public:
  TextureVirtualDevice_OnFrameAccessHandlerReady_ParamsDataView() = default;

  TextureVirtualDevice_OnFrameAccessHandlerReady_ParamsDataView(
      internal::TextureVirtualDevice_OnFrameAccessHandlerReady_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeFrameAccessHandler() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::video_capture::mojom::VideoFrameAccessHandlerInterfaceBase>>(
            &data_->frame_access_handler, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::TextureVirtualDevice_OnFrameAccessHandlerReady_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TextureVirtualDevice_OnFrameReadyInBuffer_ParamsDataView {
 public:
  TextureVirtualDevice_OnFrameReadyInBuffer_ParamsDataView() = default;

  TextureVirtualDevice_OnFrameReadyInBuffer_ParamsDataView(
      internal::TextureVirtualDevice_OnFrameReadyInBuffer_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t buffer_id() const {
    return data_->buffer_id;
  }
  inline void GetFrameInfoDataView(
      ::media::mojom::VideoFrameInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrameInfo(UserType* output) {
    
    auto* pointer = data_->frame_info.Get();
    return mojo::internal::Deserialize<::media::mojom::VideoFrameInfoDataView>(
        pointer, output, message_);
  }
 private:
  internal::TextureVirtualDevice_OnFrameReadyInBuffer_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TextureVirtualDevice_OnBufferRetired_ParamsDataView {
 public:
  TextureVirtualDevice_OnBufferRetired_ParamsDataView() = default;

  TextureVirtualDevice_OnBufferRetired_ParamsDataView(
      internal::TextureVirtualDevice_OnBufferRetired_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t buffer_id() const {
    return data_->buffer_id;
  }
 private:
  internal::TextureVirtualDevice_OnBufferRetired_Params_Data* data_ = nullptr;
};


class GpuMemoryBufferVirtualDevice_OnNewGpuMemoryBufferHandle_ParamsDataView {
 public:
  GpuMemoryBufferVirtualDevice_OnNewGpuMemoryBufferHandle_ParamsDataView() = default;

  GpuMemoryBufferVirtualDevice_OnNewGpuMemoryBufferHandle_ParamsDataView(
      internal::GpuMemoryBufferVirtualDevice_OnNewGpuMemoryBufferHandle_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t buffer_id() const {
    return data_->buffer_id;
  }
  inline void GetGmbHandleDataView(
      ::gfx::mojom::GpuMemoryBufferHandleDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGmbHandle(UserType* output) {
    
    auto* pointer = data_->gmb_handle.Get();
    return mojo::internal::Deserialize<::gfx::mojom::GpuMemoryBufferHandleDataView>(
        pointer, output, message_);
  }
 private:
  internal::GpuMemoryBufferVirtualDevice_OnNewGpuMemoryBufferHandle_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GpuMemoryBufferVirtualDevice_OnFrameAccessHandlerReady_ParamsDataView {
 public:
  GpuMemoryBufferVirtualDevice_OnFrameAccessHandlerReady_ParamsDataView() = default;

  GpuMemoryBufferVirtualDevice_OnFrameAccessHandlerReady_ParamsDataView(
      internal::GpuMemoryBufferVirtualDevice_OnFrameAccessHandlerReady_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeFrameAccessHandler() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::video_capture::mojom::VideoFrameAccessHandlerInterfaceBase>>(
            &data_->frame_access_handler, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::GpuMemoryBufferVirtualDevice_OnFrameAccessHandlerReady_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GpuMemoryBufferVirtualDevice_OnFrameReadyInBuffer_ParamsDataView {
 public:
  GpuMemoryBufferVirtualDevice_OnFrameReadyInBuffer_ParamsDataView() = default;

  GpuMemoryBufferVirtualDevice_OnFrameReadyInBuffer_ParamsDataView(
      internal::GpuMemoryBufferVirtualDevice_OnFrameReadyInBuffer_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t buffer_id() const {
    return data_->buffer_id;
  }
  inline void GetFrameInfoDataView(
      ::media::mojom::VideoFrameInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrameInfo(UserType* output) {
    
    auto* pointer = data_->frame_info.Get();
    return mojo::internal::Deserialize<::media::mojom::VideoFrameInfoDataView>(
        pointer, output, message_);
  }
 private:
  internal::GpuMemoryBufferVirtualDevice_OnFrameReadyInBuffer_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GpuMemoryBufferVirtualDevice_OnBufferRetired_ParamsDataView {
 public:
  GpuMemoryBufferVirtualDevice_OnBufferRetired_ParamsDataView() = default;

  GpuMemoryBufferVirtualDevice_OnBufferRetired_ParamsDataView(
      internal::GpuMemoryBufferVirtualDevice_OnBufferRetired_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t buffer_id() const {
    return data_->buffer_id;
  }
 private:
  internal::GpuMemoryBufferVirtualDevice_OnBufferRetired_Params_Data* data_ = nullptr;
};

inline void SharedMemoryVirtualDevice_RequestFrameBuffer_ParamsDataView::GetDimensionDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->dimension.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}
inline void SharedMemoryVirtualDevice_RequestFrameBuffer_ParamsDataView::GetStridesDataView(
    ::media::mojom::PlaneStridesDataView* output) {
  auto pointer = data_->strides.Get();
  *output = ::media::mojom::PlaneStridesDataView(pointer, message_);
}




inline void SharedMemoryVirtualDevice_OnFrameReadyInBuffer_ParamsDataView::GetFrameInfoDataView(
    ::media::mojom::VideoFrameInfoDataView* output) {
  auto pointer = data_->frame_info.Get();
  *output = ::media::mojom::VideoFrameInfoDataView(pointer, message_);
}


inline void TextureVirtualDevice_OnNewSharedImageBufferHandle_ParamsDataView::GetSharedImageHandleDataView(
    ::media::mojom::SharedImageBufferHandleSetDataView* output) {
  auto pointer = data_->shared_image_handle.Get();
  *output = ::media::mojom::SharedImageBufferHandleSetDataView(pointer, message_);
}




inline void TextureVirtualDevice_OnFrameReadyInBuffer_ParamsDataView::GetFrameInfoDataView(
    ::media::mojom::VideoFrameInfoDataView* output) {
  auto pointer = data_->frame_info.Get();
  *output = ::media::mojom::VideoFrameInfoDataView(pointer, message_);
}




inline void GpuMemoryBufferVirtualDevice_OnNewGpuMemoryBufferHandle_ParamsDataView::GetGmbHandleDataView(
    ::gfx::mojom::GpuMemoryBufferHandleDataView* output) {
  auto pointer = data_->gmb_handle.Get();
  *output = ::gfx::mojom::GpuMemoryBufferHandleDataView(pointer, message_);
}




inline void GpuMemoryBufferVirtualDevice_OnFrameReadyInBuffer_ParamsDataView::GetFrameInfoDataView(
    ::media::mojom::VideoFrameInfoDataView* output) {
  auto pointer = data_->frame_info.Get();
  *output = ::media::mojom::VideoFrameInfoDataView(pointer, message_);
}





}  // video_capture::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_VIRTUAL_DEVICE_MOJOM_PARAMS_DATA_H_