// services/video_capture/public/mojom/video_source_provider.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/video_capture/public/mojom/video_source_provider.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/video_capture/public/mojom/video_source_provider.mojom-params-data.h"
#include "services/video_capture/public/mojom/video_source_provider.mojom-shared-message-ids.h"

#include "services/video_capture/public/mojom/video_source_provider.mojom-import-headers.h"
#include "services/video_capture/public/mojom/video_source_provider.mojom-test-utils.h"


namespace video_capture::mojom {
// The declaration includes the definition on other builds.

VideoSourceProvider::IPCStableHashFunction VideoSourceProvider::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::VideoSourceProvider>(message.name())) {
    case messages::VideoSourceProvider::kGetSourceInfos: {
      return &VideoSourceProvider::GetSourceInfos_Sym::IPCStableHash;
    }
    case messages::VideoSourceProvider::kGetVideoSource: {
      return &VideoSourceProvider::GetVideoSource_Sym::IPCStableHash;
    }
    case messages::VideoSourceProvider::kAddSharedMemoryVirtualDevice: {
      return &VideoSourceProvider::AddSharedMemoryVirtualDevice_Sym::IPCStableHash;
    }
    case messages::VideoSourceProvider::kAddTextureVirtualDevice: {
      return &VideoSourceProvider::AddTextureVirtualDevice_Sym::IPCStableHash;
    }
    case messages::VideoSourceProvider::kRegisterVirtualDevicesChangedObserver: {
      return &VideoSourceProvider::RegisterVirtualDevicesChangedObserver_Sym::IPCStableHash;
    }
    case messages::VideoSourceProvider::kRegisterDevicesChangedObserver: {
      return &VideoSourceProvider::RegisterDevicesChangedObserver_Sym::IPCStableHash;
    }
    case messages::VideoSourceProvider::kClose: {
      return &VideoSourceProvider::Close_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* VideoSourceProvider::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::VideoSourceProvider>(message.name())) {
      case messages::VideoSourceProvider::kGetSourceInfos:
            return "Receive video_capture::mojom::VideoSourceProvider::GetSourceInfos";
      case messages::VideoSourceProvider::kGetVideoSource:
            return "Receive video_capture::mojom::VideoSourceProvider::GetVideoSource";
      case messages::VideoSourceProvider::kAddSharedMemoryVirtualDevice:
            return "Receive video_capture::mojom::VideoSourceProvider::AddSharedMemoryVirtualDevice";
      case messages::VideoSourceProvider::kAddTextureVirtualDevice:
            return "Receive video_capture::mojom::VideoSourceProvider::AddTextureVirtualDevice";
      case messages::VideoSourceProvider::kRegisterVirtualDevicesChangedObserver:
            return "Receive video_capture::mojom::VideoSourceProvider::RegisterVirtualDevicesChangedObserver";
      case messages::VideoSourceProvider::kRegisterDevicesChangedObserver:
            return "Receive video_capture::mojom::VideoSourceProvider::RegisterDevicesChangedObserver";
      case messages::VideoSourceProvider::kClose:
            return "Receive video_capture::mojom::VideoSourceProvider::Close";
    }
  } else {
    switch (static_cast<messages::VideoSourceProvider>(message.name())) {
      case messages::VideoSourceProvider::kGetSourceInfos:
            return "Receive reply video_capture::mojom::VideoSourceProvider::GetSourceInfos";
      case messages::VideoSourceProvider::kGetVideoSource:
            return "Receive reply video_capture::mojom::VideoSourceProvider::GetVideoSource";
      case messages::VideoSourceProvider::kAddSharedMemoryVirtualDevice:
            return "Receive reply video_capture::mojom::VideoSourceProvider::AddSharedMemoryVirtualDevice";
      case messages::VideoSourceProvider::kAddTextureVirtualDevice:
            return "Receive reply video_capture::mojom::VideoSourceProvider::AddTextureVirtualDevice";
      case messages::VideoSourceProvider::kRegisterVirtualDevicesChangedObserver:
            return "Receive reply video_capture::mojom::VideoSourceProvider::RegisterVirtualDevicesChangedObserver";
      case messages::VideoSourceProvider::kRegisterDevicesChangedObserver:
            return "Receive reply video_capture::mojom::VideoSourceProvider::RegisterDevicesChangedObserver";
      case messages::VideoSourceProvider::kClose:
            return "Receive reply video_capture::mojom::VideoSourceProvider::Close";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t VideoSourceProvider::GetSourceInfos_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6411d2c1;  // IPCStableHash for video_capture::mojom::VideoSourceProvider::GetSourceInfos
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t VideoSourceProvider::GetVideoSource_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xadb9b217;  // IPCStableHash for video_capture::mojom::VideoSourceProvider::GetVideoSource
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t VideoSourceProvider::AddSharedMemoryVirtualDevice_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x42deeb71;  // IPCStableHash for video_capture::mojom::VideoSourceProvider::AddSharedMemoryVirtualDevice
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t VideoSourceProvider::AddTextureVirtualDevice_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x80246293;  // IPCStableHash for video_capture::mojom::VideoSourceProvider::AddTextureVirtualDevice
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t VideoSourceProvider::RegisterVirtualDevicesChangedObserver_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x527bb78c;  // IPCStableHash for video_capture::mojom::VideoSourceProvider::RegisterVirtualDevicesChangedObserver
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t VideoSourceProvider::RegisterDevicesChangedObserver_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x13988f92;  // IPCStableHash for video_capture::mojom::VideoSourceProvider::RegisterDevicesChangedObserver
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t VideoSourceProvider::Close_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa7b017ac;  // IPCStableHash for video_capture::mojom::VideoSourceProvider::Close
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class VideoSourceProvider_GetSourceInfos_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  VideoSourceProvider_GetSourceInfos_ForwardToCallback(
      VideoSourceProvider::GetSourceInfosCallback callback
      ) : callback_(std::move(callback)) {
  }

  VideoSourceProvider_GetSourceInfos_ForwardToCallback(const VideoSourceProvider_GetSourceInfos_ForwardToCallback&) = delete;
  VideoSourceProvider_GetSourceInfos_ForwardToCallback& operator=(const VideoSourceProvider_GetSourceInfos_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  VideoSourceProvider::GetSourceInfosCallback callback_;
};

class VideoSourceProvider_Close_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  VideoSourceProvider_Close_ForwardToCallback(
      VideoSourceProvider::CloseCallback callback
      ) : callback_(std::move(callback)) {
  }

  VideoSourceProvider_Close_ForwardToCallback(const VideoSourceProvider_Close_ForwardToCallback&) = delete;
  VideoSourceProvider_Close_ForwardToCallback& operator=(const VideoSourceProvider_Close_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  VideoSourceProvider::CloseCallback callback_;
};

VideoSourceProviderProxy::VideoSourceProviderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void VideoSourceProviderProxy::GetSourceInfos(
    GetSourceInfosCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send video_capture::mojom::VideoSourceProvider::GetSourceInfos");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoSourceProvider::kGetSourceInfos), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::VideoSourceProvider_GetSourceInfos_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoSourceProvider::Name_);
  message.set_method_name("GetSourceInfos");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new VideoSourceProvider_GetSourceInfos_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void VideoSourceProviderProxy::GetVideoSource(
    const std::string& in_source_id, ::mojo::PendingReceiver<::video_capture::mojom::VideoSource> in_stream) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send video_capture::mojom::VideoSourceProvider::GetVideoSource", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_id"), in_source_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("stream"), in_stream,
                        "<value of type ::mojo::PendingReceiver<::video_capture::mojom::VideoSource>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoSourceProvider::kGetVideoSource), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::VideoSourceProvider_GetVideoSource_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->source_id)::BaseType> source_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_source_id,
    source_id_fragment);

  params->source_id.Set(
      source_id_fragment.is_null() ? nullptr : source_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->source_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null source_id in VideoSourceProvider.GetVideoSource request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::video_capture::mojom::VideoSourceInterfaceBase>>(
    in_stream,
    &params->stream,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->stream)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid stream in VideoSourceProvider.GetVideoSource request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoSourceProvider::Name_);
  message.set_method_name("GetVideoSource");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void VideoSourceProviderProxy::AddSharedMemoryVirtualDevice(
    const ::media::VideoCaptureDeviceInfo& in_device_info, ::mojo::PendingRemote<::video_capture::mojom::Producer> in_producer, ::mojo::PendingReceiver<::video_capture::mojom::SharedMemoryVirtualDevice> in_virtual_device_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send video_capture::mojom::VideoSourceProvider::AddSharedMemoryVirtualDevice", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_info"), in_device_info,
                        "<value of type const ::media::VideoCaptureDeviceInfo&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("producer"), in_producer,
                        "<value of type ::mojo::PendingRemote<::video_capture::mojom::Producer>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("virtual_device_receiver"), in_virtual_device_receiver,
                        "<value of type ::mojo::PendingReceiver<::video_capture::mojom::SharedMemoryVirtualDevice>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoSourceProvider::kAddSharedMemoryVirtualDevice), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::VideoSourceProvider_AddSharedMemoryVirtualDevice_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->device_info)::BaseType> device_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::VideoCaptureDeviceInfoDataView>(
    in_device_info,
    device_info_fragment);

  params->device_info.Set(
      device_info_fragment.is_null() ? nullptr : device_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->device_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null device_info in VideoSourceProvider.AddSharedMemoryVirtualDevice request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::video_capture::mojom::ProducerInterfaceBase>>(
    in_producer,
    &params->producer,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->producer)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid producer in VideoSourceProvider.AddSharedMemoryVirtualDevice request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::video_capture::mojom::SharedMemoryVirtualDeviceInterfaceBase>>(
    in_virtual_device_receiver,
    &params->virtual_device_receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->virtual_device_receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid virtual_device_receiver in VideoSourceProvider.AddSharedMemoryVirtualDevice request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoSourceProvider::Name_);
  message.set_method_name("AddSharedMemoryVirtualDevice");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void VideoSourceProviderProxy::AddTextureVirtualDevice(
    const ::media::VideoCaptureDeviceInfo& in_device_info, ::mojo::PendingReceiver<::video_capture::mojom::TextureVirtualDevice> in_virtual_device_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send video_capture::mojom::VideoSourceProvider::AddTextureVirtualDevice", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_info"), in_device_info,
                        "<value of type const ::media::VideoCaptureDeviceInfo&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("virtual_device_receiver"), in_virtual_device_receiver,
                        "<value of type ::mojo::PendingReceiver<::video_capture::mojom::TextureVirtualDevice>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoSourceProvider::kAddTextureVirtualDevice), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::VideoSourceProvider_AddTextureVirtualDevice_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->device_info)::BaseType> device_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::VideoCaptureDeviceInfoDataView>(
    in_device_info,
    device_info_fragment);

  params->device_info.Set(
      device_info_fragment.is_null() ? nullptr : device_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->device_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null device_info in VideoSourceProvider.AddTextureVirtualDevice request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::video_capture::mojom::TextureVirtualDeviceInterfaceBase>>(
    in_virtual_device_receiver,
    &params->virtual_device_receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->virtual_device_receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid virtual_device_receiver in VideoSourceProvider.AddTextureVirtualDevice request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoSourceProvider::Name_);
  message.set_method_name("AddTextureVirtualDevice");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void VideoSourceProviderProxy::RegisterVirtualDevicesChangedObserver(
    ::mojo::PendingRemote<::video_capture::mojom::DevicesChangedObserver> in_observer, bool in_raise_event_if_virtual_devices_already_present) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send video_capture::mojom::VideoSourceProvider::RegisterVirtualDevicesChangedObserver", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer,
                        "<value of type ::mojo::PendingRemote<::video_capture::mojom::DevicesChangedObserver>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("raise_event_if_virtual_devices_already_present"), in_raise_event_if_virtual_devices_already_present,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoSourceProvider::kRegisterVirtualDevicesChangedObserver), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::VideoSourceProvider_RegisterVirtualDevicesChangedObserver_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::video_capture::mojom::DevicesChangedObserverInterfaceBase>>(
    in_observer,
    &params->observer,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->observer)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid observer in VideoSourceProvider.RegisterVirtualDevicesChangedObserver request");

  params->raise_event_if_virtual_devices_already_present = in_raise_event_if_virtual_devices_already_present;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoSourceProvider::Name_);
  message.set_method_name("RegisterVirtualDevicesChangedObserver");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void VideoSourceProviderProxy::RegisterDevicesChangedObserver(
    ::mojo::PendingRemote<::video_capture::mojom::DevicesChangedObserver> in_observer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send video_capture::mojom::VideoSourceProvider::RegisterDevicesChangedObserver", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer,
                        "<value of type ::mojo::PendingRemote<::video_capture::mojom::DevicesChangedObserver>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoSourceProvider::kRegisterDevicesChangedObserver), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::VideoSourceProvider_RegisterDevicesChangedObserver_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::video_capture::mojom::DevicesChangedObserverInterfaceBase>>(
    in_observer,
    &params->observer,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->observer)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid observer in VideoSourceProvider.RegisterDevicesChangedObserver request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoSourceProvider::Name_);
  message.set_method_name("RegisterDevicesChangedObserver");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void VideoSourceProviderProxy::Close(
    CloseCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send video_capture::mojom::VideoSourceProvider::Close");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoSourceProvider::kClose), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::VideoSourceProvider_Close_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoSourceProvider::Name_);
  message.set_method_name("Close");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new VideoSourceProvider_Close_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class VideoSourceProvider_GetSourceInfos_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static VideoSourceProvider::GetSourceInfosCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<VideoSourceProvider_GetSourceInfos_ProxyToResponder> proxy(
        new VideoSourceProvider_GetSourceInfos_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&VideoSourceProvider_GetSourceInfos_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~VideoSourceProvider_GetSourceInfos_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  VideoSourceProvider_GetSourceInfos_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "VideoSourceProvider::GetSourceInfosCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      VideoSourceProvider::GetSourceInfosResult in_result, const std::vector<::media::VideoCaptureDeviceInfo>& in_source_infos);
};

bool VideoSourceProvider_GetSourceInfos_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::VideoSourceProvider_GetSourceInfos_ResponseParams_Data* params =
      reinterpret_cast<
          internal::VideoSourceProvider_GetSourceInfos_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for VideoSourceProvider.0
  bool success = true;
  VideoSourceProvider::GetSourceInfosResult p_result{};
  std::vector<::media::VideoCaptureDeviceInfo> p_source_infos{};
  VideoSourceProvider_GetSourceInfos_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success && !input_data_view.ReadSourceInfos(&p_source_infos))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        VideoSourceProvider::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_source_infos));
  }
  return true;
}

void VideoSourceProvider_GetSourceInfos_ProxyToResponder::Run(
    VideoSourceProvider::GetSourceInfosResult in_result, const std::vector<::media::VideoCaptureDeviceInfo>& in_source_infos) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply video_capture::mojom::VideoSourceProvider::GetSourceInfos", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type VideoSourceProvider::GetSourceInfosResult>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_infos"), in_source_infos,
                        "<value of type const std::vector<::media::VideoCaptureDeviceInfo>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoSourceProvider::kGetSourceInfos), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::VideoSourceProvider_GetSourceInfos_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::video_capture::mojom::VideoSourceProvider_GetSourceInfosResult>(
    in_result,
    &params->result);
  mojo::internal::MessageFragment<
      typename decltype(params->source_infos)::BaseType>
      source_infos_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& source_infos_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::media::mojom::VideoCaptureDeviceInfoDataView>>(
    in_source_infos,
    source_infos_fragment,
    &source_infos_validate_params);

  params->source_infos.Set(
      source_infos_fragment.is_null() ? nullptr : source_infos_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->source_infos.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null source_infos in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoSourceProvider::Name_);
  message.set_method_name("GetSourceInfos");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class VideoSourceProvider_Close_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static VideoSourceProvider::CloseCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<VideoSourceProvider_Close_ProxyToResponder> proxy(
        new VideoSourceProvider_Close_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&VideoSourceProvider_Close_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~VideoSourceProvider_Close_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  VideoSourceProvider_Close_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "VideoSourceProvider::CloseCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool VideoSourceProvider_Close_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::VideoSourceProvider_Close_ResponseParams_Data* params =
      reinterpret_cast<
          internal::VideoSourceProvider_Close_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for VideoSourceProvider.6
  bool success = true;
  VideoSourceProvider_Close_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        VideoSourceProvider::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void VideoSourceProvider_Close_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply video_capture::mojom::VideoSourceProvider::Close");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoSourceProvider::kClose), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::VideoSourceProvider_Close_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoSourceProvider::Name_);
  message.set_method_name("Close");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool VideoSourceProviderStubDispatch::Accept(
    VideoSourceProvider* impl,
    mojo::Message* message) {
  switch (static_cast<messages::VideoSourceProvider>(message->header()->name)) {
    case messages::VideoSourceProvider::kGetSourceInfos: {
      break;
    }
    case messages::VideoSourceProvider::kGetVideoSource: {
      DCHECK(message->is_serialized());
      internal::VideoSourceProvider_GetVideoSource_Params_Data* params =
          reinterpret_cast<internal::VideoSourceProvider_GetVideoSource_Params_Data*>(
              message->mutable_payload());
      

      // Validation for VideoSourceProvider.1
      bool success = true;
      std::string p_source_id{};
      ::mojo::PendingReceiver<::video_capture::mojom::VideoSource> p_stream{};
      VideoSourceProvider_GetVideoSource_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSourceId(&p_source_id))
        success = false;
      if (success) {
        p_stream =
            input_data_view.TakeStream<decltype(p_stream)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoSourceProvider::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetVideoSource(        
        std::move(p_source_id), 
        std::move(p_stream));
      return true;
    }
    case messages::VideoSourceProvider::kAddSharedMemoryVirtualDevice: {
      DCHECK(message->is_serialized());
      internal::VideoSourceProvider_AddSharedMemoryVirtualDevice_Params_Data* params =
          reinterpret_cast<internal::VideoSourceProvider_AddSharedMemoryVirtualDevice_Params_Data*>(
              message->mutable_payload());
      

      // Validation for VideoSourceProvider.2
      bool success = true;
      ::media::VideoCaptureDeviceInfo p_device_info{};
      ::mojo::PendingRemote<::video_capture::mojom::Producer> p_producer{};
      ::mojo::PendingReceiver<::video_capture::mojom::SharedMemoryVirtualDevice> p_virtual_device_receiver{};
      VideoSourceProvider_AddSharedMemoryVirtualDevice_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDeviceInfo(&p_device_info))
        success = false;
      if (success) {
        p_producer =
            input_data_view.TakeProducer<decltype(p_producer)>();
      }
      if (success) {
        p_virtual_device_receiver =
            input_data_view.TakeVirtualDeviceReceiver<decltype(p_virtual_device_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoSourceProvider::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddSharedMemoryVirtualDevice(        
        std::move(p_device_info), 
        std::move(p_producer), 
        std::move(p_virtual_device_receiver));
      return true;
    }
    case messages::VideoSourceProvider::kAddTextureVirtualDevice: {
      DCHECK(message->is_serialized());
      internal::VideoSourceProvider_AddTextureVirtualDevice_Params_Data* params =
          reinterpret_cast<internal::VideoSourceProvider_AddTextureVirtualDevice_Params_Data*>(
              message->mutable_payload());
      

      // Validation for VideoSourceProvider.3
      bool success = true;
      ::media::VideoCaptureDeviceInfo p_device_info{};
      ::mojo::PendingReceiver<::video_capture::mojom::TextureVirtualDevice> p_virtual_device_receiver{};
      VideoSourceProvider_AddTextureVirtualDevice_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDeviceInfo(&p_device_info))
        success = false;
      if (success) {
        p_virtual_device_receiver =
            input_data_view.TakeVirtualDeviceReceiver<decltype(p_virtual_device_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoSourceProvider::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddTextureVirtualDevice(        
        std::move(p_device_info), 
        std::move(p_virtual_device_receiver));
      return true;
    }
    case messages::VideoSourceProvider::kRegisterVirtualDevicesChangedObserver: {
      DCHECK(message->is_serialized());
      internal::VideoSourceProvider_RegisterVirtualDevicesChangedObserver_Params_Data* params =
          reinterpret_cast<internal::VideoSourceProvider_RegisterVirtualDevicesChangedObserver_Params_Data*>(
              message->mutable_payload());
      

      // Validation for VideoSourceProvider.4
      bool success = true;
      ::mojo::PendingRemote<::video_capture::mojom::DevicesChangedObserver> p_observer{};
      bool p_raise_event_if_virtual_devices_already_present{};
      VideoSourceProvider_RegisterVirtualDevicesChangedObserver_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (success)
        p_raise_event_if_virtual_devices_already_present = input_data_view.raise_event_if_virtual_devices_already_present();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoSourceProvider::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RegisterVirtualDevicesChangedObserver(        
        std::move(p_observer), 
        std::move(p_raise_event_if_virtual_devices_already_present));
      return true;
    }
    case messages::VideoSourceProvider::kRegisterDevicesChangedObserver: {
      DCHECK(message->is_serialized());
      internal::VideoSourceProvider_RegisterDevicesChangedObserver_Params_Data* params =
          reinterpret_cast<internal::VideoSourceProvider_RegisterDevicesChangedObserver_Params_Data*>(
              message->mutable_payload());
      

      // Validation for VideoSourceProvider.5
      bool success = true;
      ::mojo::PendingRemote<::video_capture::mojom::DevicesChangedObserver> p_observer{};
      VideoSourceProvider_RegisterDevicesChangedObserver_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoSourceProvider::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RegisterDevicesChangedObserver(        
        std::move(p_observer));
      return true;
    }
    case messages::VideoSourceProvider::kClose: {
      break;
    }
  }
  return false;
}

// static
bool VideoSourceProviderStubDispatch::AcceptWithResponder(
    VideoSourceProvider* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::VideoSourceProvider>(message->header()->name)) {
    case messages::VideoSourceProvider::kGetSourceInfos: {
      internal::VideoSourceProvider_GetSourceInfos_Params_Data* params =
          reinterpret_cast<
              internal::VideoSourceProvider_GetSourceInfos_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for VideoSourceProvider.0
      bool success = true;
      VideoSourceProvider_GetSourceInfos_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoSourceProvider::Name_, 0, false);
        return false;
      }
      auto callback =
          VideoSourceProvider_GetSourceInfos_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetSourceInfos(std::move(callback));
      return true;
    }
    case messages::VideoSourceProvider::kGetVideoSource: {
      break;
    }
    case messages::VideoSourceProvider::kAddSharedMemoryVirtualDevice: {
      break;
    }
    case messages::VideoSourceProvider::kAddTextureVirtualDevice: {
      break;
    }
    case messages::VideoSourceProvider::kRegisterVirtualDevicesChangedObserver: {
      break;
    }
    case messages::VideoSourceProvider::kRegisterDevicesChangedObserver: {
      break;
    }
    case messages::VideoSourceProvider::kClose: {
      internal::VideoSourceProvider_Close_Params_Data* params =
          reinterpret_cast<
              internal::VideoSourceProvider_Close_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for VideoSourceProvider.6
      bool success = true;
      VideoSourceProvider_Close_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoSourceProvider::Name_, 6, false);
        return false;
      }
      auto callback =
          VideoSourceProvider_Close_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Close(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kVideoSourceProviderValidationInfo[] = {
    { &internal::VideoSourceProvider_GetSourceInfos_Params_Data::Validate,
     &internal::VideoSourceProvider_GetSourceInfos_ResponseParams_Data::Validate},
    { &internal::VideoSourceProvider_GetVideoSource_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::VideoSourceProvider_AddSharedMemoryVirtualDevice_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::VideoSourceProvider_AddTextureVirtualDevice_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::VideoSourceProvider_RegisterVirtualDevicesChangedObserver_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::VideoSourceProvider_RegisterDevicesChangedObserver_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::VideoSourceProvider_Close_Params_Data::Validate,
     &internal::VideoSourceProvider_Close_ResponseParams_Data::Validate},
};

bool VideoSourceProviderRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::video_capture::mojom::VideoSourceProvider::Name_,
    kVideoSourceProviderValidationInfo);
}

bool VideoSourceProviderResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::video_capture::mojom::VideoSourceProvider::Name_,
    kVideoSourceProviderValidationInfo);
}


}  // video_capture::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace video_capture::mojom {


void VideoSourceProviderInterceptorForTesting::GetSourceInfos(GetSourceInfosCallback callback) {
  GetForwardingInterface()->GetSourceInfos(std::move(callback));
}
void VideoSourceProviderInterceptorForTesting::GetVideoSource(const std::string& source_id, ::mojo::PendingReceiver<::video_capture::mojom::VideoSource> stream) {
  GetForwardingInterface()->GetVideoSource(
    std::move(source_id)
    , 
    std::move(stream)
    );
}
void VideoSourceProviderInterceptorForTesting::AddSharedMemoryVirtualDevice(const ::media::VideoCaptureDeviceInfo& device_info, ::mojo::PendingRemote<::video_capture::mojom::Producer> producer, ::mojo::PendingReceiver<::video_capture::mojom::SharedMemoryVirtualDevice> virtual_device_receiver) {
  GetForwardingInterface()->AddSharedMemoryVirtualDevice(
    std::move(device_info)
    , 
    std::move(producer)
    , 
    std::move(virtual_device_receiver)
    );
}
void VideoSourceProviderInterceptorForTesting::AddTextureVirtualDevice(const ::media::VideoCaptureDeviceInfo& device_info, ::mojo::PendingReceiver<::video_capture::mojom::TextureVirtualDevice> virtual_device_receiver) {
  GetForwardingInterface()->AddTextureVirtualDevice(
    std::move(device_info)
    , 
    std::move(virtual_device_receiver)
    );
}
void VideoSourceProviderInterceptorForTesting::RegisterVirtualDevicesChangedObserver(::mojo::PendingRemote<::video_capture::mojom::DevicesChangedObserver> observer, bool raise_event_if_virtual_devices_already_present) {
  GetForwardingInterface()->RegisterVirtualDevicesChangedObserver(
    std::move(observer)
    , 
    std::move(raise_event_if_virtual_devices_already_present)
    );
}
void VideoSourceProviderInterceptorForTesting::RegisterDevicesChangedObserver(::mojo::PendingRemote<::video_capture::mojom::DevicesChangedObserver> observer) {
  GetForwardingInterface()->RegisterDevicesChangedObserver(
    std::move(observer)
    );
}
void VideoSourceProviderInterceptorForTesting::Close(CloseCallback callback) {
  GetForwardingInterface()->Close(std::move(callback));
}
VideoSourceProviderAsyncWaiter::VideoSourceProviderAsyncWaiter(
    VideoSourceProvider* proxy) : proxy_(proxy) {}

VideoSourceProviderAsyncWaiter::~VideoSourceProviderAsyncWaiter() = default;


void VideoSourceProviderAsyncWaiter::GetSourceInfos(
    VideoSourceProvider::GetSourceInfosResult* out_result, std::vector<::media::VideoCaptureDeviceInfo>* out_source_infos) {
  base::RunLoop loop;
  proxy_->GetSourceInfos(
      base::BindOnce(
          [](base::RunLoop* loop,
             VideoSourceProvider::GetSourceInfosResult* out_result
,
             std::vector<::media::VideoCaptureDeviceInfo>* out_source_infos
,
             VideoSourceProvider::GetSourceInfosResult result,
             const std::vector<::media::VideoCaptureDeviceInfo>& source_infos) {*out_result = std::move(result);*out_source_infos = std::move(source_infos);
            loop->Quit();
          },
          &loop,
          out_result,
          out_source_infos));
  loop.Run();
}



void VideoSourceProviderAsyncWaiter::Close(
    ) {
  base::RunLoop loop;
  proxy_->Close(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}








}  // video_capture::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif