// services/video_capture/public/mojom/video_frame_handler.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_VIDEO_FRAME_HANDLER_MOJOM_H_
#define SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_VIDEO_FRAME_HANDLER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/video_capture/public/mojom/video_frame_handler.mojom-features.h"  // IWYU pragma: export
#include "services/video_capture/public/mojom/video_frame_handler.mojom-shared.h"  // IWYU pragma: export
#include "services/video_capture/public/mojom/video_frame_handler.mojom-forward.h"  // IWYU pragma: export
#include "media/capture/mojom/video_capture_buffer.mojom.h"
#include "media/capture/mojom/video_capture_types.mojom.h"
#include "media/mojo/mojom/media_types.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace video_capture::mojom {

class VideoFrameAccessHandlerProxy;

template <typename ImplRefTraits>
class VideoFrameAccessHandlerStub;

class VideoFrameAccessHandlerRequestValidator;


class VideoFrameAccessHandler
    : public VideoFrameAccessHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "video_capture.mojom.VideoFrameAccessHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = VideoFrameAccessHandlerInterfaceBase;
  using Proxy_ = VideoFrameAccessHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = VideoFrameAccessHandlerStub<ImplRefTraits>;

  using RequestValidator_ = VideoFrameAccessHandlerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnFinishedConsumingBufferMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnFinishedConsumingBuffer_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~VideoFrameAccessHandler() = default;

  virtual void OnFinishedConsumingBuffer(int32_t buffer_id) = 0;
};

class VideoFrameHandlerProxy;

template <typename ImplRefTraits>
class VideoFrameHandlerStub;

class VideoFrameHandlerRequestValidator;


class VideoFrameHandler
    : public VideoFrameHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "video_capture.mojom.VideoFrameHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = VideoFrameHandlerInterfaceBase;
  using Proxy_ = VideoFrameHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = VideoFrameHandlerStub<ImplRefTraits>;

  using RequestValidator_ = VideoFrameHandlerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnCaptureConfigurationChangedMinVersion = 0,
    kOnNewBufferMinVersion = 0,
    kOnFrameAccessHandlerReadyMinVersion = 0,
    kOnFrameReadyInBufferMinVersion = 0,
    kOnBufferRetiredMinVersion = 0,
    kOnErrorMinVersion = 0,
    kOnFrameDroppedMinVersion = 0,
    kOnNewCaptureVersionMinVersion = 0,
    kOnFrameWithEmptyRegionCaptureMinVersion = 0,
    kOnLogMinVersion = 0,
    kOnStartedMinVersion = 0,
    kOnStartedUsingGpuDecodeMinVersion = 0,
    kOnStoppedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnCaptureConfigurationChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnNewBuffer_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnFrameAccessHandlerReady_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnFrameReadyInBuffer_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnBufferRetired_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnError_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnFrameDropped_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnNewCaptureVersion_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnFrameWithEmptyRegionCapture_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnLog_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnStarted_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnStartedUsingGpuDecode_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnStopped_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~VideoFrameHandler() = default;

  virtual void OnCaptureConfigurationChanged() = 0;

  virtual void OnNewBuffer(int32_t buffer_id, ::media::mojom::VideoBufferHandlePtr buffer_handle) = 0;

  virtual void OnFrameAccessHandlerReady(::mojo::PendingRemote<VideoFrameAccessHandler> frame_access_handler) = 0;

  virtual void OnFrameReadyInBuffer(ReadyFrameInBufferPtr buffer) = 0;

  virtual void OnBufferRetired(int32_t buffer_id) = 0;

  virtual void OnError(::media::VideoCaptureError error) = 0;

  virtual void OnFrameDropped(::media::VideoCaptureFrameDropReason reason) = 0;

  virtual void OnNewCaptureVersion(const ::media::CaptureVersion& capture_version) = 0;

  virtual void OnFrameWithEmptyRegionCapture() = 0;

  virtual void OnLog(const std::string& message) = 0;

  virtual void OnStarted() = 0;

  virtual void OnStartedUsingGpuDecode() = 0;

  virtual void OnStopped() = 0;
};



class  VideoFrameAccessHandlerProxy
    : public VideoFrameAccessHandler {
 public:
  using InterfaceType = VideoFrameAccessHandler;

  explicit VideoFrameAccessHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnFinishedConsumingBuffer(int32_t buffer_id) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  VideoFrameHandlerProxy
    : public VideoFrameHandler {
 public:
  using InterfaceType = VideoFrameHandler;

  explicit VideoFrameHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnCaptureConfigurationChanged() final;
  
  void OnNewBuffer(int32_t buffer_id, ::media::mojom::VideoBufferHandlePtr buffer_handle) final;
  
  void OnFrameAccessHandlerReady(::mojo::PendingRemote<VideoFrameAccessHandler> frame_access_handler) final;
  
  void OnFrameReadyInBuffer(ReadyFrameInBufferPtr buffer) final;
  
  void OnBufferRetired(int32_t buffer_id) final;
  
  void OnError(::media::VideoCaptureError error) final;
  
  void OnFrameDropped(::media::VideoCaptureFrameDropReason reason) final;
  
  void OnNewCaptureVersion(const ::media::CaptureVersion& capture_version) final;
  
  void OnFrameWithEmptyRegionCapture() final;
  
  void OnLog(const std::string& message) final;
  
  void OnStarted() final;
  
  void OnStartedUsingGpuDecode() final;
  
  void OnStopped() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  VideoFrameAccessHandlerStubDispatch {
 public:
  static bool Accept(VideoFrameAccessHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      VideoFrameAccessHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<VideoFrameAccessHandler>>
class VideoFrameAccessHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  VideoFrameAccessHandlerStub() = default;
  ~VideoFrameAccessHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return VideoFrameAccessHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return VideoFrameAccessHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  VideoFrameHandlerStubDispatch {
 public:
  static bool Accept(VideoFrameHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      VideoFrameHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<VideoFrameHandler>>
class VideoFrameHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  VideoFrameHandlerStub() = default;
  ~VideoFrameHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return VideoFrameHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return VideoFrameHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  VideoFrameAccessHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  VideoFrameHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class  ReadyFrameInBuffer {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ReadyFrameInBuffer, T>::value>;
  using DataView = ReadyFrameInBufferDataView;
  using Data_ = internal::ReadyFrameInBuffer_Data;

  template <typename... Args>
  static ReadyFrameInBufferPtr New(Args&&... args) {
    return ReadyFrameInBufferPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ReadyFrameInBufferPtr From(const U& u) {
    return mojo::TypeConverter<ReadyFrameInBufferPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ReadyFrameInBuffer>::Convert(*this);
  }


  ReadyFrameInBuffer();

  ReadyFrameInBuffer(
      int32_t buffer_id,
      int32_t frame_feedback_id,
      ::media::mojom::VideoFrameInfoPtr frame_info);

ReadyFrameInBuffer(const ReadyFrameInBuffer&) = delete;
ReadyFrameInBuffer& operator=(const ReadyFrameInBuffer&) = delete;

  ~ReadyFrameInBuffer();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ReadyFrameInBufferPtr>
  ReadyFrameInBufferPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ReadyFrameInBuffer::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ReadyFrameInBuffer::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ReadyFrameInBuffer::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ReadyFrameInBuffer::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ReadyFrameInBuffer::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ReadyFrameInBuffer::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ReadyFrameInBuffer_UnserializedMessageContext<
            UserType, ReadyFrameInBuffer::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ReadyFrameInBuffer::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ReadyFrameInBuffer::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ReadyFrameInBuffer_UnserializedMessageContext<
            UserType, ReadyFrameInBuffer::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ReadyFrameInBuffer::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t buffer_id;
  
  int32_t frame_feedback_id;
  
  ::media::mojom::VideoFrameInfoPtr frame_info;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ReadyFrameInBuffer::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ReadyFrameInBuffer::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ReadyFrameInBuffer::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ReadyFrameInBuffer::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ReadyFrameInBufferPtr ReadyFrameInBuffer::Clone() const {
  return New(
      mojo::Clone(buffer_id),
      mojo::Clone(frame_feedback_id),
      mojo::Clone(frame_info)
  );
}

template <typename T, ReadyFrameInBuffer::EnableIfSame<T>*>
bool ReadyFrameInBuffer::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->buffer_id, other_struct.buffer_id))
    return false;
  if (!mojo::Equals(this->frame_feedback_id, other_struct.frame_feedback_id))
    return false;
  if (!mojo::Equals(this->frame_info, other_struct.frame_info))
    return false;
  return true;
}

template <typename T, ReadyFrameInBuffer::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.buffer_id < rhs.buffer_id)
    return true;
  if (rhs.buffer_id < lhs.buffer_id)
    return false;
  if (lhs.frame_feedback_id < rhs.frame_feedback_id)
    return true;
  if (rhs.frame_feedback_id < lhs.frame_feedback_id)
    return false;
  if (lhs.frame_info < rhs.frame_info)
    return true;
  if (rhs.frame_info < lhs.frame_info)
    return false;
  return false;
}


}  // video_capture::mojom

namespace mojo {


template <>
struct  StructTraits<::video_capture::mojom::ReadyFrameInBuffer::DataView,
                                         ::video_capture::mojom::ReadyFrameInBufferPtr> {
  static bool IsNull(const ::video_capture::mojom::ReadyFrameInBufferPtr& input) { return !input; }
  static void SetToNull(::video_capture::mojom::ReadyFrameInBufferPtr* output) { output->reset(); }

  static decltype(::video_capture::mojom::ReadyFrameInBuffer::buffer_id) buffer_id(
      const ::video_capture::mojom::ReadyFrameInBufferPtr& input) {
    return input->buffer_id;
  }

  static decltype(::video_capture::mojom::ReadyFrameInBuffer::frame_feedback_id) frame_feedback_id(
      const ::video_capture::mojom::ReadyFrameInBufferPtr& input) {
    return input->frame_feedback_id;
  }

  static const decltype(::video_capture::mojom::ReadyFrameInBuffer::frame_info)& frame_info(
      const ::video_capture::mojom::ReadyFrameInBufferPtr& input) {
    return input->frame_info;
  }

  static bool Read(::video_capture::mojom::ReadyFrameInBuffer::DataView input, ::video_capture::mojom::ReadyFrameInBufferPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_VIDEO_FRAME_HANDLER_MOJOM_H_