// services/tracing/public/mojom/perfetto_service.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_TRACING_PUBLIC_MOJOM_PERFETTO_SERVICE_MOJOM_TEST_UTILS_H_
#define SERVICES_TRACING_PUBLIC_MOJOM_PERFETTO_SERVICE_MOJOM_TEST_UTILS_H_

#include "services/tracing/public/mojom/perfetto_service.mojom.h"
#include "base/component_export.h"


namespace tracing::mojom {


class COMPONENT_EXPORT(TRACING_MOJOM) ProducerHostInterceptorForTesting : public ProducerHost {
  virtual ProducerHost* GetForwardingInterface() = 0;
  void CommitData(const ::perfetto::CommitDataRequest& data_request, CommitDataCallback callback) override;
  void RegisterDataSource(const ::perfetto::DataSourceDescriptor& registration_info) override;
  void UpdateDataSource(const ::perfetto::DataSourceDescriptor& registration_info) override;
  void RegisterTraceWriter(uint32_t writer_id, uint32_t target_buffer) override;
  void UnregisterTraceWriter(uint32_t writer_id) override;
};
class COMPONENT_EXPORT(TRACING_MOJOM) ProducerHostAsyncWaiter {
 public:
  explicit ProducerHostAsyncWaiter(ProducerHost* proxy);

  ProducerHostAsyncWaiter(const ProducerHostAsyncWaiter&) = delete;
  ProducerHostAsyncWaiter& operator=(const ProducerHostAsyncWaiter&) = delete;

  ~ProducerHostAsyncWaiter();
  void CommitData(
      const ::perfetto::CommitDataRequest& data_request);
  

 private:
  ProducerHost* const proxy_;
};


class COMPONENT_EXPORT(TRACING_MOJOM) ProducerClientInterceptorForTesting : public ProducerClient {
  virtual ProducerClient* GetForwardingInterface() = 0;
  void OnTracingStart() override;
  void StartDataSource(uint64_t id, const ::perfetto::DataSourceConfig& data_source_config, StartDataSourceCallback callback) override;
  void StopDataSource(uint64_t id, StopDataSourceCallback callback) override;
  void Flush(uint64_t flush_request_id, const std::vector<uint64_t>& data_source_ids) override;
  void ClearIncrementalState() override;
};
class COMPONENT_EXPORT(TRACING_MOJOM) ProducerClientAsyncWaiter {
 public:
  explicit ProducerClientAsyncWaiter(ProducerClient* proxy);

  ProducerClientAsyncWaiter(const ProducerClientAsyncWaiter&) = delete;
  ProducerClientAsyncWaiter& operator=(const ProducerClientAsyncWaiter&) = delete;

  ~ProducerClientAsyncWaiter();
  void StartDataSource(
      uint64_t id, const ::perfetto::DataSourceConfig& data_source_config);
  
  void StopDataSource(
      uint64_t id);
  

 private:
  ProducerClient* const proxy_;
};


class COMPONENT_EXPORT(TRACING_MOJOM) PerfettoServiceInterceptorForTesting : public PerfettoService {
  virtual PerfettoService* GetForwardingInterface() = 0;
  void ConnectToProducerHost(::mojo::PendingRemote<ProducerClient> producer_client, ::mojo::PendingReceiver<ProducerHost> producer_host_receiver, ::base::UnsafeSharedMemoryRegion shared_memory, uint64_t shared_memory_buffer_page_size_bytes) override;
};
class COMPONENT_EXPORT(TRACING_MOJOM) PerfettoServiceAsyncWaiter {
 public:
  explicit PerfettoServiceAsyncWaiter(PerfettoService* proxy);

  PerfettoServiceAsyncWaiter(const PerfettoServiceAsyncWaiter&) = delete;
  PerfettoServiceAsyncWaiter& operator=(const PerfettoServiceAsyncWaiter&) = delete;

  ~PerfettoServiceAsyncWaiter();

 private:
  PerfettoService* const proxy_;
};


class COMPONENT_EXPORT(TRACING_MOJOM) ConsumerHostInterceptorForTesting : public ConsumerHost {
  virtual ConsumerHost* GetForwardingInterface() = 0;
  void EnableTracing(::mojo::PendingReceiver<TracingSessionHost> tracing_session_host, ::mojo::PendingRemote<TracingSessionClient> tracing_session_client, const ::perfetto::TraceConfig& config, ::base::File output_file) override;
  void CloneSession(::mojo::PendingReceiver<TracingSessionHost> tracing_session_host, ::mojo::PendingRemote<TracingSessionClient> tracing_session_client, const ::base::UnguessableToken& unguessable_name, bool privacy_filtering_enabled, CloneSessionCallback callback) override;
};
class COMPONENT_EXPORT(TRACING_MOJOM) ConsumerHostAsyncWaiter {
 public:
  explicit ConsumerHostAsyncWaiter(ConsumerHost* proxy);

  ConsumerHostAsyncWaiter(const ConsumerHostAsyncWaiter&) = delete;
  ConsumerHostAsyncWaiter& operator=(const ConsumerHostAsyncWaiter&) = delete;

  ~ConsumerHostAsyncWaiter();
  void CloneSession(
      ::mojo::PendingReceiver<TracingSessionHost> tracing_session_host, ::mojo::PendingRemote<TracingSessionClient> tracing_session_client, const ::base::UnguessableToken& unguessable_name, bool privacy_filtering_enabled, bool* out_success, std::string* out_error, ::base::Token* out_uuid);
  

 private:
  ConsumerHost* const proxy_;
};


class COMPONENT_EXPORT(TRACING_MOJOM) TracingSessionHostInterceptorForTesting : public TracingSessionHost {
  virtual TracingSessionHost* GetForwardingInterface() = 0;
  void ChangeTraceConfig(const ::perfetto::TraceConfig& config) override;
  void DisableTracing() override;
  void ReadBuffers(::mojo::ScopedDataPipeProducerHandle stream, ReadBuffersCallback callback) override;
  void RequestBufferUsage(RequestBufferUsageCallback callback) override;
  void DisableTracingAndEmitJson(const std::string& agent_label_filter, ::mojo::ScopedDataPipeProducerHandle stream, bool privacy_filtering_enabled, DisableTracingAndEmitJsonCallback callback) override;
};
class COMPONENT_EXPORT(TRACING_MOJOM) TracingSessionHostAsyncWaiter {
 public:
  explicit TracingSessionHostAsyncWaiter(TracingSessionHost* proxy);

  TracingSessionHostAsyncWaiter(const TracingSessionHostAsyncWaiter&) = delete;
  TracingSessionHostAsyncWaiter& operator=(const TracingSessionHostAsyncWaiter&) = delete;

  ~TracingSessionHostAsyncWaiter();
  void ReadBuffers(
      ::mojo::ScopedDataPipeProducerHandle stream);
  
  void RequestBufferUsage(
      bool* out_success, float* out_percent_full, bool* out_data_loss);
  
  void DisableTracingAndEmitJson(
      const std::string& agent_label_filter, ::mojo::ScopedDataPipeProducerHandle stream, bool privacy_filtering_enabled);
  

 private:
  TracingSessionHost* const proxy_;
};


class COMPONENT_EXPORT(TRACING_MOJOM) TracingSessionClientInterceptorForTesting : public TracingSessionClient {
  virtual TracingSessionClient* GetForwardingInterface() = 0;
  void OnTracingEnabled() override;
  void OnTracingDisabled(bool tracing_succeeded) override;
};
class COMPONENT_EXPORT(TRACING_MOJOM) TracingSessionClientAsyncWaiter {
 public:
  explicit TracingSessionClientAsyncWaiter(TracingSessionClient* proxy);

  TracingSessionClientAsyncWaiter(const TracingSessionClientAsyncWaiter&) = delete;
  TracingSessionClientAsyncWaiter& operator=(const TracingSessionClientAsyncWaiter&) = delete;

  ~TracingSessionClientAsyncWaiter();

 private:
  TracingSessionClient* const proxy_;
};




}  // tracing::mojom

#endif  // SERVICES_TRACING_PUBLIC_MOJOM_PERFETTO_SERVICE_MOJOM_TEST_UTILS_H_