// services/tracing/public/mojom/background_tracing_agent.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_TRACING_PUBLIC_MOJOM_BACKGROUND_TRACING_AGENT_MOJOM_H_
#define SERVICES_TRACING_PUBLIC_MOJOM_BACKGROUND_TRACING_AGENT_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/tracing/public/mojom/background_tracing_agent.mojom-features.h"  // IWYU pragma: export
#include "services/tracing/public/mojom/background_tracing_agent.mojom-shared.h"  // IWYU pragma: export
#include "services/tracing/public/mojom/background_tracing_agent.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "base/component_export.h"




namespace tracing::mojom {

class BackgroundTracingAgentClientProxy;

template <typename ImplRefTraits>
class BackgroundTracingAgentClientStub;

class BackgroundTracingAgentClientRequestValidator;


class COMPONENT_EXPORT(TRACING_MOJOM) BackgroundTracingAgentClient
    : public BackgroundTracingAgentClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "tracing.mojom.BackgroundTracingAgentClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = BackgroundTracingAgentClientInterfaceBase;
  using Proxy_ = BackgroundTracingAgentClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = BackgroundTracingAgentClientStub<ImplRefTraits>;

  using RequestValidator_ = BackgroundTracingAgentClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnInitializedMinVersion = 0,
    kOnTriggerBackgroundTraceMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnInitialized_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnTriggerBackgroundTrace_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~BackgroundTracingAgentClient() = default;

  virtual void OnInitialized() = 0;

  virtual void OnTriggerBackgroundTrace(BackgroundTracingRulePtr rule, std::optional<int32_t> histogram_value, uint64_t flow_id) = 0;
};

class BackgroundTracingAgentProxy;

template <typename ImplRefTraits>
class BackgroundTracingAgentStub;

class BackgroundTracingAgentRequestValidator;


class COMPONENT_EXPORT(TRACING_MOJOM) BackgroundTracingAgent
    : public BackgroundTracingAgentInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "tracing.mojom.BackgroundTracingAgent";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = BackgroundTracingAgentInterfaceBase;
  using Proxy_ = BackgroundTracingAgentProxy;

  template <typename ImplRefTraits>
  using Stub_ = BackgroundTracingAgentStub<ImplRefTraits>;

  using RequestValidator_ = BackgroundTracingAgentRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSetUMACallbackMinVersion = 0,
    kClearUMACallbackMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetUMACallback_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ClearUMACallback_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~BackgroundTracingAgent() = default;

  virtual void SetUMACallback(BackgroundTracingRulePtr rule, const std::string& histogram_name, int32_t histogram_lower_value, int32_t histogram_upper_value) = 0;

  virtual void ClearUMACallback(BackgroundTracingRulePtr rule) = 0;
};

class BackgroundTracingAgentProviderProxy;

template <typename ImplRefTraits>
class BackgroundTracingAgentProviderStub;

class BackgroundTracingAgentProviderRequestValidator;


class COMPONENT_EXPORT(TRACING_MOJOM) BackgroundTracingAgentProvider
    : public BackgroundTracingAgentProviderInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "tracing.mojom.BackgroundTracingAgentProvider";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = BackgroundTracingAgentProviderInterfaceBase;
  using Proxy_ = BackgroundTracingAgentProviderProxy;

  template <typename ImplRefTraits>
  using Stub_ = BackgroundTracingAgentProviderStub<ImplRefTraits>;

  using RequestValidator_ = BackgroundTracingAgentProviderRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreateMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Create_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~BackgroundTracingAgentProvider() = default;

  virtual void Create(uint64_t tracing_process_id, ::mojo::PendingRemote<BackgroundTracingAgentClient> client, ::mojo::PendingReceiver<BackgroundTracingAgent> agent) = 0;
};



class COMPONENT_EXPORT(TRACING_MOJOM) BackgroundTracingAgentClientProxy
    : public BackgroundTracingAgentClient {
 public:
  using InterfaceType = BackgroundTracingAgentClient;

  explicit BackgroundTracingAgentClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnInitialized() final;
  
  void OnTriggerBackgroundTrace(BackgroundTracingRulePtr rule, std::optional<int32_t> histogram_value, uint64_t flow_id) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class COMPONENT_EXPORT(TRACING_MOJOM) BackgroundTracingAgentProxy
    : public BackgroundTracingAgent {
 public:
  using InterfaceType = BackgroundTracingAgent;

  explicit BackgroundTracingAgentProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetUMACallback(BackgroundTracingRulePtr rule, const std::string& histogram_name, int32_t histogram_lower_value, int32_t histogram_upper_value) final;
  
  void ClearUMACallback(BackgroundTracingRulePtr rule) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class COMPONENT_EXPORT(TRACING_MOJOM) BackgroundTracingAgentProviderProxy
    : public BackgroundTracingAgentProvider {
 public:
  using InterfaceType = BackgroundTracingAgentProvider;

  explicit BackgroundTracingAgentProviderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Create(uint64_t tracing_process_id, ::mojo::PendingRemote<BackgroundTracingAgentClient> client, ::mojo::PendingReceiver<BackgroundTracingAgent> agent) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class COMPONENT_EXPORT(TRACING_MOJOM) BackgroundTracingAgentClientStubDispatch {
 public:
  static bool Accept(BackgroundTracingAgentClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      BackgroundTracingAgentClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<BackgroundTracingAgentClient>>
class BackgroundTracingAgentClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  BackgroundTracingAgentClientStub() = default;
  ~BackgroundTracingAgentClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return BackgroundTracingAgentClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return BackgroundTracingAgentClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(TRACING_MOJOM) BackgroundTracingAgentStubDispatch {
 public:
  static bool Accept(BackgroundTracingAgent* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      BackgroundTracingAgent* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<BackgroundTracingAgent>>
class BackgroundTracingAgentStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  BackgroundTracingAgentStub() = default;
  ~BackgroundTracingAgentStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return BackgroundTracingAgentStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return BackgroundTracingAgentStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(TRACING_MOJOM) BackgroundTracingAgentProviderStubDispatch {
 public:
  static bool Accept(BackgroundTracingAgentProvider* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      BackgroundTracingAgentProvider* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<BackgroundTracingAgentProvider>>
class BackgroundTracingAgentProviderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  BackgroundTracingAgentProviderStub() = default;
  ~BackgroundTracingAgentProviderStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return BackgroundTracingAgentProviderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return BackgroundTracingAgentProviderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(TRACING_MOJOM) BackgroundTracingAgentClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(TRACING_MOJOM) BackgroundTracingAgentRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(TRACING_MOJOM) BackgroundTracingAgentProviderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class COMPONENT_EXPORT(TRACING_MOJOM) BackgroundTracingRule {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BackgroundTracingRule, T>::value>;
  using DataView = BackgroundTracingRuleDataView;
  using Data_ = internal::BackgroundTracingRule_Data;

  template <typename... Args>
  static BackgroundTracingRulePtr New(Args&&... args) {
    return BackgroundTracingRulePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BackgroundTracingRulePtr From(const U& u) {
    return mojo::TypeConverter<BackgroundTracingRulePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BackgroundTracingRule>::Convert(*this);
  }


  BackgroundTracingRule();

  explicit BackgroundTracingRule(
      const std::string& rule_id);


  ~BackgroundTracingRule();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BackgroundTracingRulePtr>
  BackgroundTracingRulePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BackgroundTracingRule::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, BackgroundTracingRule::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, BackgroundTracingRule::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BackgroundTracingRule::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BackgroundTracingRule::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BackgroundTracingRule::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BackgroundTracingRule_UnserializedMessageContext<
            UserType, BackgroundTracingRule::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<BackgroundTracingRule::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return BackgroundTracingRule::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BackgroundTracingRule_UnserializedMessageContext<
            UserType, BackgroundTracingRule::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BackgroundTracingRule::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string rule_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BackgroundTracingRule::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BackgroundTracingRule::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BackgroundTracingRule::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BackgroundTracingRule::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}




template <typename StructPtrType>
BackgroundTracingRulePtr BackgroundTracingRule::Clone() const {
  return New(
      mojo::Clone(rule_id)
  );
}

template <typename T, BackgroundTracingRule::EnableIfSame<T>*>
bool BackgroundTracingRule::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->rule_id, other_struct.rule_id))
    return false;
  return true;
}

template <typename T, BackgroundTracingRule::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.rule_id < rhs.rule_id)
    return true;
  if (rhs.rule_id < lhs.rule_id)
    return false;
  return false;
}


}  // tracing::mojom

namespace mojo {


template <>
struct COMPONENT_EXPORT(TRACING_MOJOM) StructTraits<::tracing::mojom::BackgroundTracingRule::DataView,
                                         ::tracing::mojom::BackgroundTracingRulePtr> {
  static bool IsNull(const ::tracing::mojom::BackgroundTracingRulePtr& input) { return !input; }
  static void SetToNull(::tracing::mojom::BackgroundTracingRulePtr* output) { output->reset(); }

  static const decltype(::tracing::mojom::BackgroundTracingRule::rule_id)& rule_id(
      const ::tracing::mojom::BackgroundTracingRulePtr& input) {
    return input->rule_id;
  }

  static bool Read(::tracing::mojom::BackgroundTracingRule::DataView input, ::tracing::mojom::BackgroundTracingRulePtr* output);
};

}  // namespace mojo

#endif  // SERVICES_TRACING_PUBLIC_MOJOM_BACKGROUND_TRACING_AGENT_MOJOM_H_