// services/tracing/public/mojom/background_tracing_agent.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_TRACING_PUBLIC_MOJOM_BACKGROUND_TRACING_AGENT_MOJOM_SHARED_H_
#define SERVICES_TRACING_PUBLIC_MOJOM_BACKGROUND_TRACING_AGENT_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/tracing/public/mojom/background_tracing_agent.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "services/tracing/public/mojom/background_tracing_agent.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tracing::mojom::BackgroundTracingRuleDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tracing::mojom::BackgroundTracingRuleDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tracing::mojom::internal::BackgroundTracingRule_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::rule_id(input)) in_rule_id = Traits::rule_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->rule_id)::BaseType> rule_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_rule_id,
      rule_id_fragment);

    fragment->rule_id.Set(
        rule_id_fragment.is_null() ? nullptr : rule_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->rule_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null rule_id in BackgroundTracingRule struct");
  }

  static bool Deserialize(::tracing::mojom::internal::BackgroundTracingRule_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::tracing::mojom::BackgroundTracingRuleDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace tracing::mojom {

inline void BackgroundTracingRuleDataView::GetRuleIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->rule_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}



}  // tracing::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SERVICES_TRACING_PUBLIC_MOJOM_BACKGROUND_TRACING_AGENT_MOJOM_SHARED_H_