// services/shape_detection/public/mojom/facedetection.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_SHAPE_DETECTION_PUBLIC_MOJOM_FACEDETECTION_MOJOM_SHARED_H_
#define SERVICES_SHAPE_DETECTION_PUBLIC_MOJOM_FACEDETECTION_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/shape_detection/public/mojom/facedetection.mojom-shared-internal.h"
#include "skia/public/mojom/bitmap.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "services/shape_detection/public/mojom/facedetection.mojom-data-view.h"




namespace std {

template <>
struct hash<::shape_detection::mojom::LandmarkType>
    : public mojo::internal::EnumHashImpl<::shape_detection::mojom::LandmarkType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::shape_detection::mojom::LandmarkType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::shape_detection::mojom::LandmarkType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::shape_detection::mojom::LandmarkType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::shape_detection::mojom::LandmarkDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::shape_detection::mojom::LandmarkDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::shape_detection::mojom::internal::Landmark_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::locations(input)) in_locations = Traits::locations(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->locations)::BaseType>
        locations_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& locations_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::gfx::mojom::PointFDataView>>(
      in_locations,
      locations_fragment,
      &locations_validate_params);

    fragment->locations.Set(
        locations_fragment.is_null() ? nullptr : locations_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->locations.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null locations in Landmark struct");

    
    mojo::internal::Serialize<::shape_detection::mojom::LandmarkType>(
      Traits::type(input),
      &fragment->type);
  }

  static bool Deserialize(::shape_detection::mojom::internal::Landmark_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::shape_detection::mojom::LandmarkDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::shape_detection::mojom::FaceDetectionResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::shape_detection::mojom::FaceDetectionResultDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::shape_detection::mojom::internal::FaceDetectionResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::bounding_box(input)) in_bounding_box = Traits::bounding_box(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->bounding_box)::BaseType> bounding_box_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::RectFDataView>(
      in_bounding_box,
      bounding_box_fragment);

    fragment->bounding_box.Set(
        bounding_box_fragment.is_null() ? nullptr : bounding_box_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->bounding_box.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null bounding_box in FaceDetectionResult struct");

    decltype(Traits::landmarks(input)) in_landmarks = Traits::landmarks(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->landmarks)::BaseType>
        landmarks_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& landmarks_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::shape_detection::mojom::LandmarkDataView>>(
      in_landmarks,
      landmarks_fragment,
      &landmarks_validate_params);

    fragment->landmarks.Set(
        landmarks_fragment.is_null() ? nullptr : landmarks_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->landmarks.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null landmarks in FaceDetectionResult struct");
  }

  static bool Deserialize(::shape_detection::mojom::internal::FaceDetectionResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::shape_detection::mojom::FaceDetectionResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::shape_detection::mojom::FaceDetectorOptionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::shape_detection::mojom::FaceDetectorOptionsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::shape_detection::mojom::internal::FaceDetectorOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->max_detected_faces = Traits::max_detected_faces(input);

    fragment->fast_mode = Traits::fast_mode(input);
  }

  static bool Deserialize(::shape_detection::mojom::internal::FaceDetectorOptions_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::shape_detection::mojom::FaceDetectorOptionsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace shape_detection::mojom {

inline void LandmarkDataView::GetLocationsDataView(
    mojo::ArrayDataView<::gfx::mojom::PointFDataView>* output) {
  auto pointer = data_->locations.Get();
  *output = mojo::ArrayDataView<::gfx::mojom::PointFDataView>(pointer, message_);
}


inline void FaceDetectionResultDataView::GetBoundingBoxDataView(
    ::gfx::mojom::RectFDataView* output) {
  auto pointer = data_->bounding_box.Get();
  *output = ::gfx::mojom::RectFDataView(pointer, message_);
}
inline void FaceDetectionResultDataView::GetLandmarksDataView(
    mojo::ArrayDataView<LandmarkDataView>* output) {
  auto pointer = data_->landmarks.Get();
  *output = mojo::ArrayDataView<LandmarkDataView>(pointer, message_);
}





}  // shape_detection::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::shape_detection::mojom::LandmarkType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::shape_detection::mojom::LandmarkType value);
};

} // namespace perfetto

#endif  // SERVICES_SHAPE_DETECTION_PUBLIC_MOJOM_FACEDETECTION_MOJOM_SHARED_H_