// services/shape_detection/public/mojom/facedetection.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_SHAPE_DETECTION_PUBLIC_MOJOM_FACEDETECTION_MOJOM_SEND_VALIDATION_H_
#define SERVICES_SHAPE_DETECTION_PUBLIC_MOJOM_FACEDETECTION_MOJOM_SEND_VALIDATION_H_

#include "services/shape_detection/public/mojom/facedetection.mojom-shared-internal.h"
#include "skia/public/mojom/bitmap.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"

#include "services/shape_detection/public/mojom/facedetection.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::shape_detection::mojom::LandmarkType, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::shape_detection::mojom::LandmarkDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::shape_detection::mojom::LandmarkDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::shape_detection::mojom::internal::Landmark_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::locations(input)) in_locations = Traits::locations(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->locations)::BaseType>
          locations_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& locations_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::gfx::mojom::PointFDataView>, send_validation>(
        in_locations,
        locations_fragment,
        &locations_validate_params);

      fragment->locations.Set(
          locations_fragment.is_null() ? nullptr : locations_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->locations.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null locations in Landmark struct");

      
      mojo::internal::Serialize<::shape_detection::mojom::LandmarkType>(
        Traits::type(input),
        &fragment->type);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::shape_detection::mojom::FaceDetectionResultDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::shape_detection::mojom::FaceDetectionResultDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::shape_detection::mojom::internal::FaceDetectionResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::bounding_box(input)) in_bounding_box = Traits::bounding_box(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->bounding_box)::BaseType> bounding_box_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::RectFDataView, send_validation>(
        in_bounding_box,
        bounding_box_fragment);

      fragment->bounding_box.Set(
          bounding_box_fragment.is_null() ? nullptr : bounding_box_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->bounding_box.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null bounding_box in FaceDetectionResult struct");

      decltype(Traits::landmarks(input)) in_landmarks = Traits::landmarks(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->landmarks)::BaseType>
          landmarks_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& landmarks_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::shape_detection::mojom::LandmarkDataView>, send_validation>(
        in_landmarks,
        landmarks_fragment,
        &landmarks_validate_params);

      fragment->landmarks.Set(
          landmarks_fragment.is_null() ? nullptr : landmarks_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->landmarks.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null landmarks in FaceDetectionResult struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::shape_detection::mojom::FaceDetectorOptionsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::shape_detection::mojom::FaceDetectorOptionsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::shape_detection::mojom::internal::FaceDetectorOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->max_detected_faces = Traits::max_detected_faces(input);

      fragment->fast_mode = Traits::fast_mode(input);
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_SHAPE_DETECTION_PUBLIC_MOJOM_FACEDETECTION_MOJOM_SEND_VALIDATION_H_