// services/shape_detection/public/mojom/facedetection.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_SHAPE_DETECTION_PUBLIC_MOJOM_FACEDETECTION_MOJOM_DATA_VIEW_H_
#define SERVICES_SHAPE_DETECTION_PUBLIC_MOJOM_FACEDETECTION_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "services/shape_detection/public/mojom/facedetection.mojom-shared-internal.h"
#include "skia/public/mojom/bitmap.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"


namespace shape_detection::mojom {
class LandmarkDataView;

class FaceDetectionResultDataView;

class FaceDetectorOptionsDataView;



}  // shape_detection::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::shape_detection::mojom::LandmarkDataView> {
  using Data = ::shape_detection::mojom::internal::Landmark_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::shape_detection::mojom::FaceDetectionResultDataView> {
  using Data = ::shape_detection::mojom::internal::FaceDetectionResult_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::shape_detection::mojom::FaceDetectorOptionsDataView> {
  using Data = ::shape_detection::mojom::internal::FaceDetectorOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace shape_detection::mojom {


enum class LandmarkType : int32_t {
  
  MOUTH = 0,
  
  EYE = 1,
  
  NOSE = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, LandmarkType value);
inline bool IsKnownEnumValue(LandmarkType value) {
  return internal::LandmarkType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class FaceDetectionInterfaceBase {};

using FaceDetectionPtrDataView =
    mojo::InterfacePtrDataView<FaceDetectionInterfaceBase>;
using FaceDetectionRequestDataView =
    mojo::InterfaceRequestDataView<FaceDetectionInterfaceBase>;
using FaceDetectionAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<FaceDetectionInterfaceBase>;
using FaceDetectionAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<FaceDetectionInterfaceBase>;


class LandmarkDataView {
 public:
  LandmarkDataView() = default;

  LandmarkDataView(
      internal::Landmark_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetLocationsDataView(
      mojo::ArrayDataView<::gfx::mojom::PointFDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLocations(UserType* output) {
    
    auto* pointer = data_->locations.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::gfx::mojom::PointFDataView>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::shape_detection::mojom::LandmarkType>(
        data_value, output);
  }
  LandmarkType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::shape_detection::mojom::LandmarkType>(data_->type));
  }
 private:
  internal::Landmark_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FaceDetectionResultDataView {
 public:
  FaceDetectionResultDataView() = default;

  FaceDetectionResultDataView(
      internal::FaceDetectionResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetBoundingBoxDataView(
      ::gfx::mojom::RectFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBoundingBox(UserType* output) {
    
    auto* pointer = data_->bounding_box.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectFDataView>(
        pointer, output, message_);
  }
  inline void GetLandmarksDataView(
      mojo::ArrayDataView<LandmarkDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLandmarks(UserType* output) {
    
    auto* pointer = data_->landmarks.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::shape_detection::mojom::LandmarkDataView>>(
        pointer, output, message_);
  }
 private:
  internal::FaceDetectionResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FaceDetectorOptionsDataView {
 public:
  FaceDetectorOptionsDataView() = default;

  FaceDetectorOptionsDataView(
      internal::FaceDetectorOptions_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint32_t max_detected_faces() const {
    return data_->max_detected_faces;
  }
  bool fast_mode() const {
    return data_->fast_mode;
  }
 private:
  internal::FaceDetectorOptions_Data* data_ = nullptr;
};


}  // shape_detection::mojom

#endif  // SERVICES_SHAPE_DETECTION_PUBLIC_MOJOM_FACEDETECTION_MOJOM_DATA_VIEW_H_