// services/shape_detection/public/mojom/barcodedetection_provider.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/shape_detection/public/mojom/barcodedetection_provider.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/shape_detection/public/mojom/barcodedetection_provider.mojom-params-data.h"
namespace shape_detection {
namespace mojom {

namespace internal {


// static
bool BarcodeDetectorOptions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BarcodeDetectorOptions_Data* object =
      static_cast<const BarcodeDetectorOptions_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->formats, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& formats_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::shape_detection::mojom::internal::BarcodeFormat_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->formats, validation_context,
                                         &formats_validate_params)) {
    return false;
  }

  return true;
}

BarcodeDetectorOptions_Data::BarcodeDetectorOptions_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BarcodeDetectionProvider_CreateBarcodeDetection_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BarcodeDetectionProvider_CreateBarcodeDetection_Params_Data* object =
      static_cast<const BarcodeDetectionProvider_CreateBarcodeDetection_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->options, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->options, validation_context))
    return false;

  return true;
}

BarcodeDetectionProvider_CreateBarcodeDetection_Params_Data::BarcodeDetectionProvider_CreateBarcodeDetection_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BarcodeDetectionProvider_EnumerateSupportedFormats_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BarcodeDetectionProvider_EnumerateSupportedFormats_Params_Data* object =
      static_cast<const BarcodeDetectionProvider_EnumerateSupportedFormats_Params_Data*>(data);

  return true;
}

BarcodeDetectionProvider_EnumerateSupportedFormats_Params_Data::BarcodeDetectionProvider_EnumerateSupportedFormats_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BarcodeDetectionProvider_EnumerateSupportedFormats_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BarcodeDetectionProvider_EnumerateSupportedFormats_ResponseParams_Data* object =
      static_cast<const BarcodeDetectionProvider_EnumerateSupportedFormats_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->supported_formats, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& supported_formats_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::shape_detection::mojom::internal::BarcodeFormat_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->supported_formats, validation_context,
                                         &supported_formats_validate_params)) {
    return false;
  }

  return true;
}

BarcodeDetectionProvider_EnumerateSupportedFormats_ResponseParams_Data::BarcodeDetectionProvider_EnumerateSupportedFormats_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace shape_detection