// services/shape_detection/public/mojom/barcodedetection_provider.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/shape_detection/public/mojom/barcodedetection_provider.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/shape_detection/public/mojom/barcodedetection_provider.mojom-params-data.h"
#include "services/shape_detection/public/mojom/barcodedetection_provider.mojom-shared-message-ids.h"

#include "services/shape_detection/public/mojom/barcodedetection_provider.mojom-blink-import-headers.h"
#include "services/shape_detection/public/mojom/barcodedetection_provider.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace shape_detection::mojom::blink {
BarcodeDetectorOptions::BarcodeDetectorOptions()
    : formats() {}

BarcodeDetectorOptions::BarcodeDetectorOptions(
    ::blink::Vector<::shape_detection::mojom::blink::BarcodeFormat> formats_in)
    : formats(std::move(formats_in)) {}

BarcodeDetectorOptions::~BarcodeDetectorOptions() = default;

void BarcodeDetectorOptions::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "formats"), this->formats,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<::shape_detection::mojom::blink::BarcodeFormat>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool BarcodeDetectorOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

BarcodeDetectionProvider::IPCStableHashFunction BarcodeDetectionProvider::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::BarcodeDetectionProvider>(message.name())) {
    case messages::BarcodeDetectionProvider::kCreateBarcodeDetection: {
      return &BarcodeDetectionProvider::CreateBarcodeDetection_Sym::IPCStableHash;
    }
    case messages::BarcodeDetectionProvider::kEnumerateSupportedFormats: {
      return &BarcodeDetectionProvider::EnumerateSupportedFormats_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* BarcodeDetectionProvider::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::BarcodeDetectionProvider>(message.name())) {
      case messages::BarcodeDetectionProvider::kCreateBarcodeDetection:
            return "Receive shape_detection::mojom::BarcodeDetectionProvider::CreateBarcodeDetection";
      case messages::BarcodeDetectionProvider::kEnumerateSupportedFormats:
            return "Receive shape_detection::mojom::BarcodeDetectionProvider::EnumerateSupportedFormats";
    }
  } else {
    switch (static_cast<messages::BarcodeDetectionProvider>(message.name())) {
      case messages::BarcodeDetectionProvider::kCreateBarcodeDetection:
            return "Receive reply shape_detection::mojom::BarcodeDetectionProvider::CreateBarcodeDetection";
      case messages::BarcodeDetectionProvider::kEnumerateSupportedFormats:
            return "Receive reply shape_detection::mojom::BarcodeDetectionProvider::EnumerateSupportedFormats";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t BarcodeDetectionProvider::CreateBarcodeDetection_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xeebdf97f;  // IPCStableHash for shape_detection::mojom::BarcodeDetectionProvider::CreateBarcodeDetection
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t BarcodeDetectionProvider::EnumerateSupportedFormats_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x884a5477;  // IPCStableHash for shape_detection::mojom::BarcodeDetectionProvider::EnumerateSupportedFormats
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class BarcodeDetectionProvider_EnumerateSupportedFormats_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  BarcodeDetectionProvider_EnumerateSupportedFormats_ForwardToCallback(
      BarcodeDetectionProvider::EnumerateSupportedFormatsCallback callback
      ) : callback_(std::move(callback)) {
  }

  BarcodeDetectionProvider_EnumerateSupportedFormats_ForwardToCallback(const BarcodeDetectionProvider_EnumerateSupportedFormats_ForwardToCallback&) = delete;
  BarcodeDetectionProvider_EnumerateSupportedFormats_ForwardToCallback& operator=(const BarcodeDetectionProvider_EnumerateSupportedFormats_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  BarcodeDetectionProvider::EnumerateSupportedFormatsCallback callback_;
};

BarcodeDetectionProviderProxy::BarcodeDetectionProviderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void BarcodeDetectionProviderProxy::CreateBarcodeDetection(
    ::mojo::PendingReceiver<::shape_detection::mojom::blink::BarcodeDetection> in_receiver, BarcodeDetectorOptionsPtr in_options) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send shape_detection::mojom::BarcodeDetectionProvider::CreateBarcodeDetection", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::shape_detection::mojom::blink::BarcodeDetection>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type BarcodeDetectorOptionsPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BarcodeDetectionProvider::kCreateBarcodeDetection), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::shape_detection::mojom::internal::BarcodeDetectionProvider_CreateBarcodeDetection_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::shape_detection::mojom::BarcodeDetectionInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in BarcodeDetectionProvider.CreateBarcodeDetection request");
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  
  mojo::internal::Serialize<::shape_detection::mojom::BarcodeDetectorOptionsDataView>(
    in_options,
    options_fragment);

  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->options.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null options in BarcodeDetectionProvider.CreateBarcodeDetection request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BarcodeDetectionProvider::Name_);
  message.set_method_name("CreateBarcodeDetection");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void BarcodeDetectionProviderProxy::EnumerateSupportedFormats(
    EnumerateSupportedFormatsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send shape_detection::mojom::BarcodeDetectionProvider::EnumerateSupportedFormats");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BarcodeDetectionProvider::kEnumerateSupportedFormats), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::shape_detection::mojom::internal::BarcodeDetectionProvider_EnumerateSupportedFormats_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BarcodeDetectionProvider::Name_);
  message.set_method_name("EnumerateSupportedFormats");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BarcodeDetectionProvider_EnumerateSupportedFormats_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class BarcodeDetectionProvider_EnumerateSupportedFormats_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static BarcodeDetectionProvider::EnumerateSupportedFormatsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<BarcodeDetectionProvider_EnumerateSupportedFormats_ProxyToResponder> proxy(
        new BarcodeDetectionProvider_EnumerateSupportedFormats_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&BarcodeDetectionProvider_EnumerateSupportedFormats_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~BarcodeDetectionProvider_EnumerateSupportedFormats_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  BarcodeDetectionProvider_EnumerateSupportedFormats_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "BarcodeDetectionProvider::EnumerateSupportedFormatsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::blink::Vector<::shape_detection::mojom::blink::BarcodeFormat>& in_supported_formats);
};

bool BarcodeDetectionProvider_EnumerateSupportedFormats_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::BarcodeDetectionProvider_EnumerateSupportedFormats_ResponseParams_Data* params =
      reinterpret_cast<
          internal::BarcodeDetectionProvider_EnumerateSupportedFormats_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for BarcodeDetectionProvider.1
  bool success = true;
  ::blink::Vector<::shape_detection::mojom::blink::BarcodeFormat> p_supported_formats{};
  BarcodeDetectionProvider_EnumerateSupportedFormats_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadSupportedFormats(&p_supported_formats))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BarcodeDetectionProvider::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_supported_formats));
  }
  return true;
}

void BarcodeDetectionProvider_EnumerateSupportedFormats_ProxyToResponder::Run(
    const ::blink::Vector<::shape_detection::mojom::blink::BarcodeFormat>& in_supported_formats) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply shape_detection::mojom::BarcodeDetectionProvider::EnumerateSupportedFormats", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("supported_formats"), in_supported_formats,
                        "<value of type const ::blink::Vector<::shape_detection::mojom::blink::BarcodeFormat>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BarcodeDetectionProvider::kEnumerateSupportedFormats), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::shape_detection::mojom::internal::BarcodeDetectionProvider_EnumerateSupportedFormats_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->supported_formats)::BaseType>
      supported_formats_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& supported_formats_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::shape_detection::mojom::internal::BarcodeFormat_Data::Validate>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::shape_detection::mojom::BarcodeFormat>>(
    in_supported_formats,
    supported_formats_fragment,
    &supported_formats_validate_params);

  params->supported_formats.Set(
      supported_formats_fragment.is_null() ? nullptr : supported_formats_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->supported_formats.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null supported_formats in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BarcodeDetectionProvider::Name_);
  message.set_method_name("EnumerateSupportedFormats");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool BarcodeDetectionProviderStubDispatch::Accept(
    BarcodeDetectionProvider* impl,
    mojo::Message* message) {
  switch (static_cast<messages::BarcodeDetectionProvider>(message->header()->name)) {
    case messages::BarcodeDetectionProvider::kCreateBarcodeDetection: {
      DCHECK(message->is_serialized());
      internal::BarcodeDetectionProvider_CreateBarcodeDetection_Params_Data* params =
          reinterpret_cast<internal::BarcodeDetectionProvider_CreateBarcodeDetection_Params_Data*>(
              message->mutable_payload());
      

      // Validation for BarcodeDetectionProvider.0
      bool success = true;
      ::mojo::PendingReceiver<::shape_detection::mojom::blink::BarcodeDetection> p_receiver{};
      BarcodeDetectorOptionsPtr p_options{};
      BarcodeDetectionProvider_CreateBarcodeDetection_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BarcodeDetectionProvider::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateBarcodeDetection(        
        std::move(p_receiver), 
        std::move(p_options));
      return true;
    }
    case messages::BarcodeDetectionProvider::kEnumerateSupportedFormats: {
      break;
    }
  }
  return false;
}

// static
bool BarcodeDetectionProviderStubDispatch::AcceptWithResponder(
    BarcodeDetectionProvider* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::BarcodeDetectionProvider>(message->header()->name)) {
    case messages::BarcodeDetectionProvider::kCreateBarcodeDetection: {
      break;
    }
    case messages::BarcodeDetectionProvider::kEnumerateSupportedFormats: {
      internal::BarcodeDetectionProvider_EnumerateSupportedFormats_Params_Data* params =
          reinterpret_cast<
              internal::BarcodeDetectionProvider_EnumerateSupportedFormats_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for BarcodeDetectionProvider.1
      bool success = true;
      BarcodeDetectionProvider_EnumerateSupportedFormats_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BarcodeDetectionProvider::Name_, 1, false);
        return false;
      }
      auto callback =
          BarcodeDetectionProvider_EnumerateSupportedFormats_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EnumerateSupportedFormats(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kBarcodeDetectionProviderValidationInfo[] = {
    { &internal::BarcodeDetectionProvider_CreateBarcodeDetection_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::BarcodeDetectionProvider_EnumerateSupportedFormats_Params_Data::Validate,
     &internal::BarcodeDetectionProvider_EnumerateSupportedFormats_ResponseParams_Data::Validate},
};

bool BarcodeDetectionProviderRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::shape_detection::mojom::blink::BarcodeDetectionProvider::Name_,
    kBarcodeDetectionProviderValidationInfo);
}

bool BarcodeDetectionProviderResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::shape_detection::mojom::blink::BarcodeDetectionProvider::Name_,
    kBarcodeDetectionProviderValidationInfo);
}


}  // shape_detection::mojom::blink


namespace mojo {


// static
bool StructTraits<::shape_detection::mojom::blink::BarcodeDetectorOptions::DataView, ::shape_detection::mojom::blink::BarcodeDetectorOptionsPtr>::Read(
    ::shape_detection::mojom::blink::BarcodeDetectorOptions::DataView input,
    ::shape_detection::mojom::blink::BarcodeDetectorOptionsPtr* output) {
  bool success = true;
  ::shape_detection::mojom::blink::BarcodeDetectorOptionsPtr result(::shape_detection::mojom::blink::BarcodeDetectorOptions::New());
  
      if (success && !input.ReadFormats(&result->formats))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace shape_detection::mojom::blink {


void BarcodeDetectionProviderInterceptorForTesting::CreateBarcodeDetection(::mojo::PendingReceiver<::shape_detection::mojom::blink::BarcodeDetection> receiver, BarcodeDetectorOptionsPtr options) {
  GetForwardingInterface()->CreateBarcodeDetection(
    std::move(receiver)
    , 
    std::move(options)
    );
}
void BarcodeDetectionProviderInterceptorForTesting::EnumerateSupportedFormats(EnumerateSupportedFormatsCallback callback) {
  GetForwardingInterface()->EnumerateSupportedFormats(std::move(callback));
}
BarcodeDetectionProviderAsyncWaiter::BarcodeDetectionProviderAsyncWaiter(
    BarcodeDetectionProvider* proxy) : proxy_(proxy) {}

BarcodeDetectionProviderAsyncWaiter::~BarcodeDetectionProviderAsyncWaiter() = default;


void BarcodeDetectionProviderAsyncWaiter::EnumerateSupportedFormats(
    ::blink::Vector<::shape_detection::mojom::blink::BarcodeFormat>* out_supported_formats) {
  base::RunLoop loop;
  proxy_->EnumerateSupportedFormats(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::Vector<::shape_detection::mojom::blink::BarcodeFormat>* out_supported_formats
,
             const ::blink::Vector<::shape_detection::mojom::blink::BarcodeFormat>& supported_formats) {*out_supported_formats = std::move(supported_formats);
            loop->Quit();
          },
          &loop,
          out_supported_formats));
  loop.Run();
}

::blink::Vector<::shape_detection::mojom::blink::BarcodeFormat> BarcodeDetectionProviderAsyncWaiter::EnumerateSupportedFormats(
    ) {
  ::blink::Vector<::shape_detection::mojom::blink::BarcodeFormat> async_wait_result;
  EnumerateSupportedFormats(&async_wait_result);
  return async_wait_result;
}






}  // shape_detection::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif