// services/shape_detection/public/mojom/barcodedetection.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_SHAPE_DETECTION_PUBLIC_MOJOM_BARCODEDETECTION_MOJOM_H_
#define SERVICES_SHAPE_DETECTION_PUBLIC_MOJOM_BARCODEDETECTION_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/shape_detection/public/mojom/barcodedetection.mojom-features.h"  // IWYU pragma: export
#include "services/shape_detection/public/mojom/barcodedetection.mojom-shared.h"  // IWYU pragma: export
#include "services/shape_detection/public/mojom/barcodedetection.mojom-forward.h"  // IWYU pragma: export
#include "skia/public/mojom/bitmap.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace shape_detection::mojom {

class BarcodeDetectionProxy;

template <typename ImplRefTraits>
class BarcodeDetectionStub;

class BarcodeDetectionRequestValidator;
class BarcodeDetectionResponseValidator;


class BarcodeDetection
    : public BarcodeDetectionInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "shape_detection.mojom.BarcodeDetection";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = BarcodeDetectionInterfaceBase;
  using Proxy_ = BarcodeDetectionProxy;

  template <typename ImplRefTraits>
  using Stub_ = BarcodeDetectionStub<ImplRefTraits>;

  using RequestValidator_ = BarcodeDetectionRequestValidator;
  using ResponseValidator_ = BarcodeDetectionResponseValidator;
  enum MethodMinVersions : uint32_t {
    kDetectMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Detect_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~BarcodeDetection() = default;

  using DetectCallback = base::OnceCallback<void(std::vector<BarcodeDetectionResultPtr>)>;
  using DetectMojoCallback = base::OnceCallback<void(std::vector<BarcodeDetectionResultPtr>)>;

  virtual void Detect(const ::SkBitmap& bitmap_data, DetectCallback callback) = 0;
};



class  BarcodeDetectionProxy
    : public BarcodeDetection {
 public:
  using InterfaceType = BarcodeDetection;

  explicit BarcodeDetectionProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Detect(const ::SkBitmap& bitmap_data, DetectCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  BarcodeDetectionStubDispatch {
 public:
  static bool Accept(BarcodeDetection* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      BarcodeDetection* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<BarcodeDetection>>
class BarcodeDetectionStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  BarcodeDetectionStub() = default;
  ~BarcodeDetectionStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return BarcodeDetectionStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return BarcodeDetectionStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  BarcodeDetectionRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  BarcodeDetectionResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class  BarcodeDetectionResult {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BarcodeDetectionResult, T>::value>;
  using DataView = BarcodeDetectionResultDataView;
  using Data_ = internal::BarcodeDetectionResult_Data;

  template <typename... Args>
  static BarcodeDetectionResultPtr New(Args&&... args) {
    return BarcodeDetectionResultPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BarcodeDetectionResultPtr From(const U& u) {
    return mojo::TypeConverter<BarcodeDetectionResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BarcodeDetectionResult>::Convert(*this);
  }


  BarcodeDetectionResult();

  BarcodeDetectionResult(
      const std::string& raw_value,
      const ::gfx::RectF& bounding_box,
      BarcodeFormat format,
      std::vector<::gfx::PointF> corner_points);


  ~BarcodeDetectionResult();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BarcodeDetectionResultPtr>
  BarcodeDetectionResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BarcodeDetectionResult::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, BarcodeDetectionResult::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, BarcodeDetectionResult::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BarcodeDetectionResult::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BarcodeDetectionResult::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BarcodeDetectionResult::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BarcodeDetectionResult_UnserializedMessageContext<
            UserType, BarcodeDetectionResult::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<BarcodeDetectionResult::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return BarcodeDetectionResult::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BarcodeDetectionResult_UnserializedMessageContext<
            UserType, BarcodeDetectionResult::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BarcodeDetectionResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string raw_value;
  
  ::gfx::RectF bounding_box;
  
  BarcodeFormat format;
  
  std::vector<::gfx::PointF> corner_points;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BarcodeDetectionResult::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BarcodeDetectionResult::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BarcodeDetectionResult::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BarcodeDetectionResult::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
BarcodeDetectionResultPtr BarcodeDetectionResult::Clone() const {
  return New(
      mojo::Clone(raw_value),
      mojo::Clone(bounding_box),
      mojo::Clone(format),
      mojo::Clone(corner_points)
  );
}

template <typename T, BarcodeDetectionResult::EnableIfSame<T>*>
bool BarcodeDetectionResult::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->raw_value, other_struct.raw_value))
    return false;
  if (!mojo::Equals(this->bounding_box, other_struct.bounding_box))
    return false;
  if (!mojo::Equals(this->format, other_struct.format))
    return false;
  if (!mojo::Equals(this->corner_points, other_struct.corner_points))
    return false;
  return true;
}

template <typename T, BarcodeDetectionResult::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.raw_value < rhs.raw_value)
    return true;
  if (rhs.raw_value < lhs.raw_value)
    return false;
  if (lhs.bounding_box < rhs.bounding_box)
    return true;
  if (rhs.bounding_box < lhs.bounding_box)
    return false;
  if (lhs.format < rhs.format)
    return true;
  if (rhs.format < lhs.format)
    return false;
  if (lhs.corner_points < rhs.corner_points)
    return true;
  if (rhs.corner_points < lhs.corner_points)
    return false;
  return false;
}


}  // shape_detection::mojom

namespace mojo {


template <>
struct  StructTraits<::shape_detection::mojom::BarcodeDetectionResult::DataView,
                                         ::shape_detection::mojom::BarcodeDetectionResultPtr> {
  static bool IsNull(const ::shape_detection::mojom::BarcodeDetectionResultPtr& input) { return !input; }
  static void SetToNull(::shape_detection::mojom::BarcodeDetectionResultPtr* output) { output->reset(); }

  static const decltype(::shape_detection::mojom::BarcodeDetectionResult::raw_value)& raw_value(
      const ::shape_detection::mojom::BarcodeDetectionResultPtr& input) {
    return input->raw_value;
  }

  static const decltype(::shape_detection::mojom::BarcodeDetectionResult::bounding_box)& bounding_box(
      const ::shape_detection::mojom::BarcodeDetectionResultPtr& input) {
    return input->bounding_box;
  }

  static decltype(::shape_detection::mojom::BarcodeDetectionResult::format) format(
      const ::shape_detection::mojom::BarcodeDetectionResultPtr& input) {
    return input->format;
  }

  static const decltype(::shape_detection::mojom::BarcodeDetectionResult::corner_points)& corner_points(
      const ::shape_detection::mojom::BarcodeDetectionResultPtr& input) {
    return input->corner_points;
  }

  static bool Read(::shape_detection::mojom::BarcodeDetectionResult::DataView input, ::shape_detection::mojom::BarcodeDetectionResultPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_SHAPE_DETECTION_PUBLIC_MOJOM_BARCODEDETECTION_MOJOM_H_