// services/service_manager/public/mojom/service_manager.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_SERVICE_MANAGER_PUBLIC_MOJOM_SERVICE_MANAGER_MOJOM_PARAMS_DATA_H_
#define SERVICES_SERVICE_MANAGER_PUBLIC_MOJOM_SERVICE_MANAGER_MOJOM_PARAMS_DATA_H_
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace service_manager::mojom {
namespace internal {
class COMPONENT_EXPORT(SERVICE_MANAGER_MOJOM_SHARED) ServiceManagerListener_OnInit_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::RunningServiceInfo_Data>>> running_services;

 private:
  friend class mojo::internal::MessageFragment<ServiceManagerListener_OnInit_Params_Data>;

  ServiceManagerListener_OnInit_Params_Data();
  ~ServiceManagerListener_OnInit_Params_Data() = delete;
};
static_assert(sizeof(ServiceManagerListener_OnInit_Params_Data) == 16,
              "Bad sizeof(ServiceManagerListener_OnInit_Params_Data)");
class COMPONENT_EXPORT(SERVICE_MANAGER_MOJOM_SHARED) ServiceManagerListener_OnServiceCreated_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::RunningServiceInfo_Data> service;

 private:
  friend class mojo::internal::MessageFragment<ServiceManagerListener_OnServiceCreated_Params_Data>;

  ServiceManagerListener_OnServiceCreated_Params_Data();
  ~ServiceManagerListener_OnServiceCreated_Params_Data() = delete;
};
static_assert(sizeof(ServiceManagerListener_OnServiceCreated_Params_Data) == 16,
              "Bad sizeof(ServiceManagerListener_OnServiceCreated_Params_Data)");
class COMPONENT_EXPORT(SERVICE_MANAGER_MOJOM_SHARED) ServiceManagerListener_OnServiceStarted_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::service_manager::mojom::internal::Identity_Data> identity;
  uint32_t pid_deprecated;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<ServiceManagerListener_OnServiceStarted_Params_Data>;

  ServiceManagerListener_OnServiceStarted_Params_Data();
  ~ServiceManagerListener_OnServiceStarted_Params_Data() = delete;
};
static_assert(sizeof(ServiceManagerListener_OnServiceStarted_Params_Data) == 24,
              "Bad sizeof(ServiceManagerListener_OnServiceStarted_Params_Data)");
class COMPONENT_EXPORT(SERVICE_MANAGER_MOJOM_SHARED) ServiceManagerListener_OnServicePIDReceived_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::service_manager::mojom::internal::Identity_Data> identity;
  uint32_t pid;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<ServiceManagerListener_OnServicePIDReceived_Params_Data>;

  ServiceManagerListener_OnServicePIDReceived_Params_Data();
  ~ServiceManagerListener_OnServicePIDReceived_Params_Data() = delete;
};
static_assert(sizeof(ServiceManagerListener_OnServicePIDReceived_Params_Data) == 24,
              "Bad sizeof(ServiceManagerListener_OnServicePIDReceived_Params_Data)");
class COMPONENT_EXPORT(SERVICE_MANAGER_MOJOM_SHARED) ServiceManagerListener_OnServiceFailedToStart_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::service_manager::mojom::internal::Identity_Data> identity;

 private:
  friend class mojo::internal::MessageFragment<ServiceManagerListener_OnServiceFailedToStart_Params_Data>;

  ServiceManagerListener_OnServiceFailedToStart_Params_Data();
  ~ServiceManagerListener_OnServiceFailedToStart_Params_Data() = delete;
};
static_assert(sizeof(ServiceManagerListener_OnServiceFailedToStart_Params_Data) == 16,
              "Bad sizeof(ServiceManagerListener_OnServiceFailedToStart_Params_Data)");
class COMPONENT_EXPORT(SERVICE_MANAGER_MOJOM_SHARED) ServiceManagerListener_OnServiceStopped_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::service_manager::mojom::internal::Identity_Data> identity;

 private:
  friend class mojo::internal::MessageFragment<ServiceManagerListener_OnServiceStopped_Params_Data>;

  ServiceManagerListener_OnServiceStopped_Params_Data();
  ~ServiceManagerListener_OnServiceStopped_Params_Data() = delete;
};
static_assert(sizeof(ServiceManagerListener_OnServiceStopped_Params_Data) == 16,
              "Bad sizeof(ServiceManagerListener_OnServiceStopped_Params_Data)");
class COMPONENT_EXPORT(SERVICE_MANAGER_MOJOM_SHARED) ServiceManager_AddListener_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Interface_Data listener;

 private:
  friend class mojo::internal::MessageFragment<ServiceManager_AddListener_Params_Data>;

  ServiceManager_AddListener_Params_Data();
  ~ServiceManager_AddListener_Params_Data() = delete;
};
static_assert(sizeof(ServiceManager_AddListener_Params_Data) == 16,
              "Bad sizeof(ServiceManager_AddListener_Params_Data)");

}  // namespace internal


class ServiceManagerListener_OnInit_ParamsDataView {
 public:
  ServiceManagerListener_OnInit_ParamsDataView() = default;

  ServiceManagerListener_OnInit_ParamsDataView(
      internal::ServiceManagerListener_OnInit_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRunningServicesDataView(
      mojo::ArrayDataView<RunningServiceInfoDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRunningServices(UserType* output) {
    
    auto* pointer = data_->running_services.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::service_manager::mojom::RunningServiceInfoDataView>>(
        pointer, output, message_);
  }
 private:
  internal::ServiceManagerListener_OnInit_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ServiceManagerListener_OnServiceCreated_ParamsDataView {
 public:
  ServiceManagerListener_OnServiceCreated_ParamsDataView() = default;

  ServiceManagerListener_OnServiceCreated_ParamsDataView(
      internal::ServiceManagerListener_OnServiceCreated_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetServiceDataView(
      RunningServiceInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadService(UserType* output) {
    
    auto* pointer = data_->service.Get();
    return mojo::internal::Deserialize<::service_manager::mojom::RunningServiceInfoDataView>(
        pointer, output, message_);
  }
 private:
  internal::ServiceManagerListener_OnServiceCreated_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ServiceManagerListener_OnServiceStarted_ParamsDataView {
 public:
  ServiceManagerListener_OnServiceStarted_ParamsDataView() = default;

  ServiceManagerListener_OnServiceStarted_ParamsDataView(
      internal::ServiceManagerListener_OnServiceStarted_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdentityDataView(
      ::service_manager::mojom::IdentityDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIdentity(UserType* output) {
    
    auto* pointer = data_->identity.Get();
    return mojo::internal::Deserialize<::service_manager::mojom::IdentityDataView>(
        pointer, output, message_);
  }
  uint32_t pid_deprecated() const {
    return data_->pid_deprecated;
  }
 private:
  internal::ServiceManagerListener_OnServiceStarted_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ServiceManagerListener_OnServicePIDReceived_ParamsDataView {
 public:
  ServiceManagerListener_OnServicePIDReceived_ParamsDataView() = default;

  ServiceManagerListener_OnServicePIDReceived_ParamsDataView(
      internal::ServiceManagerListener_OnServicePIDReceived_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdentityDataView(
      ::service_manager::mojom::IdentityDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIdentity(UserType* output) {
    
    auto* pointer = data_->identity.Get();
    return mojo::internal::Deserialize<::service_manager::mojom::IdentityDataView>(
        pointer, output, message_);
  }
  uint32_t pid() const {
    return data_->pid;
  }
 private:
  internal::ServiceManagerListener_OnServicePIDReceived_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ServiceManagerListener_OnServiceFailedToStart_ParamsDataView {
 public:
  ServiceManagerListener_OnServiceFailedToStart_ParamsDataView() = default;

  ServiceManagerListener_OnServiceFailedToStart_ParamsDataView(
      internal::ServiceManagerListener_OnServiceFailedToStart_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdentityDataView(
      ::service_manager::mojom::IdentityDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIdentity(UserType* output) {
    
    auto* pointer = data_->identity.Get();
    return mojo::internal::Deserialize<::service_manager::mojom::IdentityDataView>(
        pointer, output, message_);
  }
 private:
  internal::ServiceManagerListener_OnServiceFailedToStart_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ServiceManagerListener_OnServiceStopped_ParamsDataView {
 public:
  ServiceManagerListener_OnServiceStopped_ParamsDataView() = default;

  ServiceManagerListener_OnServiceStopped_ParamsDataView(
      internal::ServiceManagerListener_OnServiceStopped_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdentityDataView(
      ::service_manager::mojom::IdentityDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIdentity(UserType* output) {
    
    auto* pointer = data_->identity.Get();
    return mojo::internal::Deserialize<::service_manager::mojom::IdentityDataView>(
        pointer, output, message_);
  }
 private:
  internal::ServiceManagerListener_OnServiceStopped_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ServiceManager_AddListener_ParamsDataView {
 public:
  ServiceManager_AddListener_ParamsDataView() = default;

  ServiceManager_AddListener_ParamsDataView(
      internal::ServiceManager_AddListener_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeListener() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::service_manager::mojom::ServiceManagerListenerInterfaceBase>>(
            &data_->listener, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::ServiceManager_AddListener_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};

inline void ServiceManagerListener_OnInit_ParamsDataView::GetRunningServicesDataView(
    mojo::ArrayDataView<RunningServiceInfoDataView>* output) {
  auto pointer = data_->running_services.Get();
  *output = mojo::ArrayDataView<RunningServiceInfoDataView>(pointer, message_);
}


inline void ServiceManagerListener_OnServiceCreated_ParamsDataView::GetServiceDataView(
    RunningServiceInfoDataView* output) {
  auto pointer = data_->service.Get();
  *output = RunningServiceInfoDataView(pointer, message_);
}


inline void ServiceManagerListener_OnServiceStarted_ParamsDataView::GetIdentityDataView(
    ::service_manager::mojom::IdentityDataView* output) {
  auto pointer = data_->identity.Get();
  *output = ::service_manager::mojom::IdentityDataView(pointer, message_);
}


inline void ServiceManagerListener_OnServicePIDReceived_ParamsDataView::GetIdentityDataView(
    ::service_manager::mojom::IdentityDataView* output) {
  auto pointer = data_->identity.Get();
  *output = ::service_manager::mojom::IdentityDataView(pointer, message_);
}


inline void ServiceManagerListener_OnServiceFailedToStart_ParamsDataView::GetIdentityDataView(
    ::service_manager::mojom::IdentityDataView* output) {
  auto pointer = data_->identity.Get();
  *output = ::service_manager::mojom::IdentityDataView(pointer, message_);
}


inline void ServiceManagerListener_OnServiceStopped_ParamsDataView::GetIdentityDataView(
    ::service_manager::mojom::IdentityDataView* output) {
  auto pointer = data_->identity.Get();
  *output = ::service_manager::mojom::IdentityDataView(pointer, message_);
}





}  // service_manager::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // SERVICES_SERVICE_MANAGER_PUBLIC_MOJOM_SERVICE_MANAGER_MOJOM_PARAMS_DATA_H_