// services/service_manager/public/mojom/service_manager.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('serviceManager.mojom');





/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
serviceManager.mojom.InstanceStateSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
serviceManager.mojom.InstanceState = {
  
  kCreated: 0,
  kStarted: 1,
  kUnreachable: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};





/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
serviceManager.mojom.ServiceManagerListenerPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        serviceManager.mojom.ServiceManagerListener.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { serviceManager.mojom.ServiceManagerListenerInterface }
 */
serviceManager.mojom.ServiceManagerListenerRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!serviceManager.mojom.ServiceManagerListenerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          serviceManager.mojom.ServiceManagerListenerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!serviceManager.mojom.ServiceManagerListenerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Array<!serviceManager.mojom.RunningServiceInfo> } runningServices
   */

  onInit(
      runningServices) {
    this.proxy.sendMessage(
        0,
        serviceManager.mojom.ServiceManagerListener_OnInit_ParamsSpec.$,
        null,
        [
          runningServices
        ],
        false);
  }

  
  /**
   * @param { !serviceManager.mojom.RunningServiceInfo } service
   */

  onServiceCreated(
      service) {
    this.proxy.sendMessage(
        1,
        serviceManager.mojom.ServiceManagerListener_OnServiceCreated_ParamsSpec.$,
        null,
        [
          service
        ],
        false);
  }

  
  /**
   * @param { !serviceManager.mojom.Identity } identity
   * @param { !number } pidDeprecated
   */

  onServiceStarted(
      identity,
      pidDeprecated) {
    this.proxy.sendMessage(
        2,
        serviceManager.mojom.ServiceManagerListener_OnServiceStarted_ParamsSpec.$,
        null,
        [
          identity,
          pidDeprecated
        ],
        false);
  }

  
  /**
   * @param { !serviceManager.mojom.Identity } identity
   * @param { !number } pid
   */

  onServicePIDReceived(
      identity,
      pid) {
    this.proxy.sendMessage(
        3,
        serviceManager.mojom.ServiceManagerListener_OnServicePIDReceived_ParamsSpec.$,
        null,
        [
          identity,
          pid
        ],
        false);
  }

  
  /**
   * @param { !serviceManager.mojom.Identity } identity
   */

  onServiceFailedToStart(
      identity) {
    this.proxy.sendMessage(
        4,
        serviceManager.mojom.ServiceManagerListener_OnServiceFailedToStart_ParamsSpec.$,
        null,
        [
          identity
        ],
        false);
  }

  
  /**
   * @param { !serviceManager.mojom.Identity } identity
   */

  onServiceStopped(
      identity) {
    this.proxy.sendMessage(
        5,
        serviceManager.mojom.ServiceManagerListener_OnServiceStopped_ParamsSpec.$,
        null,
        [
          identity
        ],
        false);
  }
};

/**
 * An object which receives request messages for the ServiceManagerListener
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
serviceManager.mojom.ServiceManagerListenerReceiver = class {
  /**
   * @param {!serviceManager.mojom.ServiceManagerListenerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!serviceManager.mojom.ServiceManagerListenerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        serviceManager.mojom.ServiceManagerListenerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!serviceManager.mojom.ServiceManagerListenerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        serviceManager.mojom.ServiceManagerListener_OnInit_ParamsSpec.$,
        null,
        impl.onInit.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        serviceManager.mojom.ServiceManagerListener_OnServiceCreated_ParamsSpec.$,
        null,
        impl.onServiceCreated.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        serviceManager.mojom.ServiceManagerListener_OnServiceStarted_ParamsSpec.$,
        null,
        impl.onServiceStarted.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        serviceManager.mojom.ServiceManagerListener_OnServicePIDReceived_ParamsSpec.$,
        null,
        impl.onServicePIDReceived.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        serviceManager.mojom.ServiceManagerListener_OnServiceFailedToStart_ParamsSpec.$,
        null,
        impl.onServiceFailedToStart.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        serviceManager.mojom.ServiceManagerListener_OnServiceStopped_ParamsSpec.$,
        null,
        impl.onServiceStopped.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
serviceManager.mojom.ServiceManagerListener = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "service_manager.mojom.ServiceManagerListener";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!serviceManager.mojom.ServiceManagerListenerRemote}
   * @export
   */
  static getRemote() {
    let remote = new serviceManager.mojom.ServiceManagerListenerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the ServiceManagerListener
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
serviceManager.mojom.ServiceManagerListenerCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      serviceManager.mojom.ServiceManagerListenerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!serviceManager.mojom.ServiceManagerListenerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onInit =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        serviceManager.mojom.ServiceManagerListener_OnInit_ParamsSpec.$,
        null,
        this.onInit.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onServiceCreated =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        serviceManager.mojom.ServiceManagerListener_OnServiceCreated_ParamsSpec.$,
        null,
        this.onServiceCreated.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onServiceStarted =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        serviceManager.mojom.ServiceManagerListener_OnServiceStarted_ParamsSpec.$,
        null,
        this.onServiceStarted.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onServicePIDReceived =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        serviceManager.mojom.ServiceManagerListener_OnServicePIDReceived_ParamsSpec.$,
        null,
        this.onServicePIDReceived.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onServiceFailedToStart =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        serviceManager.mojom.ServiceManagerListener_OnServiceFailedToStart_ParamsSpec.$,
        null,
        this.onServiceFailedToStart.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onServiceStopped =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        serviceManager.mojom.ServiceManagerListener_OnServiceStopped_ParamsSpec.$,
        null,
        this.onServiceStopped.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
serviceManager.mojom.ServiceManagerPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        serviceManager.mojom.ServiceManager.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { serviceManager.mojom.ServiceManagerInterface }
 */
serviceManager.mojom.ServiceManagerRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!serviceManager.mojom.ServiceManagerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          serviceManager.mojom.ServiceManagerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!serviceManager.mojom.ServiceManagerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !serviceManager.mojom.ServiceManagerListenerRemote } listener
   */

  addListener(
      listener) {
    this.proxy.sendMessage(
        0,
        serviceManager.mojom.ServiceManager_AddListener_ParamsSpec.$,
        null,
        [
          listener
        ],
        false);
  }
};

/**
 * An object which receives request messages for the ServiceManager
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
serviceManager.mojom.ServiceManagerReceiver = class {
  /**
   * @param {!serviceManager.mojom.ServiceManagerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!serviceManager.mojom.ServiceManagerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        serviceManager.mojom.ServiceManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!serviceManager.mojom.ServiceManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        serviceManager.mojom.ServiceManager_AddListener_ParamsSpec.$,
        null,
        impl.addListener.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
serviceManager.mojom.ServiceManager = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "service_manager.mojom.ServiceManager";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!serviceManager.mojom.ServiceManagerRemote}
   * @export
   */
  static getRemote() {
    let remote = new serviceManager.mojom.ServiceManagerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the ServiceManager
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
serviceManager.mojom.ServiceManagerCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      serviceManager.mojom.ServiceManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!serviceManager.mojom.ServiceManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addListener =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        serviceManager.mojom.ServiceManager_AddListener_ParamsSpec.$,
        null,
        this.addListener.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
serviceManager.mojom.RunningServiceInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
serviceManager.mojom.ServiceManagerListener_OnInit_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
serviceManager.mojom.ServiceManagerListener_OnServiceCreated_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
serviceManager.mojom.ServiceManagerListener_OnServiceStarted_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
serviceManager.mojom.ServiceManagerListener_OnServicePIDReceived_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
serviceManager.mojom.ServiceManagerListener_OnServiceFailedToStart_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
serviceManager.mojom.ServiceManagerListener_OnServiceStopped_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
serviceManager.mojom.ServiceManager_AddListener_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    serviceManager.mojom.RunningServiceInfoSpec.$,
    'RunningServiceInfo',
    [
      mojo.internal.StructField(
        'identity', 0,
        0,
        serviceManager.mojom.IdentitySpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'pid', 8,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'state', 12,
        0,
        serviceManager.mojom.InstanceStateSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
serviceManager.mojom.RunningServiceInfo = class {
  constructor() {
    /** @export { !serviceManager.mojom.Identity } */
    this.identity;
    /** @export { !number } */
    this.pid;
    /** @export { !serviceManager.mojom.InstanceState } */
    this.state;
  }
};



mojo.internal.Struct(
    serviceManager.mojom.ServiceManagerListener_OnInit_ParamsSpec.$,
    'ServiceManagerListener_OnInit_Params',
    [
      mojo.internal.StructField(
        'runningServices', 0,
        0,
        mojo.internal.Array(serviceManager.mojom.RunningServiceInfoSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
serviceManager.mojom.ServiceManagerListener_OnInit_Params = class {
  constructor() {
    /** @export { !Array<!serviceManager.mojom.RunningServiceInfo> } */
    this.runningServices;
  }
};



mojo.internal.Struct(
    serviceManager.mojom.ServiceManagerListener_OnServiceCreated_ParamsSpec.$,
    'ServiceManagerListener_OnServiceCreated_Params',
    [
      mojo.internal.StructField(
        'service', 0,
        0,
        serviceManager.mojom.RunningServiceInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
serviceManager.mojom.ServiceManagerListener_OnServiceCreated_Params = class {
  constructor() {
    /** @export { !serviceManager.mojom.RunningServiceInfo } */
    this.service;
  }
};



mojo.internal.Struct(
    serviceManager.mojom.ServiceManagerListener_OnServiceStarted_ParamsSpec.$,
    'ServiceManagerListener_OnServiceStarted_Params',
    [
      mojo.internal.StructField(
        'identity', 0,
        0,
        serviceManager.mojom.IdentitySpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'pidDeprecated', 8,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
serviceManager.mojom.ServiceManagerListener_OnServiceStarted_Params = class {
  constructor() {
    /** @export { !serviceManager.mojom.Identity } */
    this.identity;
    /** @export { !number } */
    this.pidDeprecated;
  }
};



mojo.internal.Struct(
    serviceManager.mojom.ServiceManagerListener_OnServicePIDReceived_ParamsSpec.$,
    'ServiceManagerListener_OnServicePIDReceived_Params',
    [
      mojo.internal.StructField(
        'identity', 0,
        0,
        serviceManager.mojom.IdentitySpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'pid', 8,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
serviceManager.mojom.ServiceManagerListener_OnServicePIDReceived_Params = class {
  constructor() {
    /** @export { !serviceManager.mojom.Identity } */
    this.identity;
    /** @export { !number } */
    this.pid;
  }
};



mojo.internal.Struct(
    serviceManager.mojom.ServiceManagerListener_OnServiceFailedToStart_ParamsSpec.$,
    'ServiceManagerListener_OnServiceFailedToStart_Params',
    [
      mojo.internal.StructField(
        'identity', 0,
        0,
        serviceManager.mojom.IdentitySpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
serviceManager.mojom.ServiceManagerListener_OnServiceFailedToStart_Params = class {
  constructor() {
    /** @export { !serviceManager.mojom.Identity } */
    this.identity;
  }
};



mojo.internal.Struct(
    serviceManager.mojom.ServiceManagerListener_OnServiceStopped_ParamsSpec.$,
    'ServiceManagerListener_OnServiceStopped_Params',
    [
      mojo.internal.StructField(
        'identity', 0,
        0,
        serviceManager.mojom.IdentitySpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
serviceManager.mojom.ServiceManagerListener_OnServiceStopped_Params = class {
  constructor() {
    /** @export { !serviceManager.mojom.Identity } */
    this.identity;
  }
};



mojo.internal.Struct(
    serviceManager.mojom.ServiceManager_AddListener_ParamsSpec.$,
    'ServiceManager_AddListener_Params',
    [
      mojo.internal.StructField(
        'listener', 0,
        0,
        mojo.internal.InterfaceProxy(serviceManager.mojom.ServiceManagerListenerRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
serviceManager.mojom.ServiceManager_AddListener_Params = class {
  constructor() {
    /** @export { !serviceManager.mojom.ServiceManagerListenerRemote } */
    this.listener;
  }
};

