// services/service_manager/public/mojom/service_manager.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_SERVICE_MANAGER_PUBLIC_MOJOM_SERVICE_MANAGER_MOJOM_DATA_VIEW_H_
#define SERVICES_SERVICE_MANAGER_PUBLIC_MOJOM_SERVICE_MANAGER_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "services/service_manager/public/mojom/service_manager.mojom-shared-internal.h"
#include "services/service_manager/public/mojom/connector.mojom-shared.h"


namespace service_manager::mojom {
class RunningServiceInfoDataView;



}  // service_manager::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::service_manager::mojom::RunningServiceInfoDataView> {
  using Data = ::service_manager::mojom::internal::RunningServiceInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace service_manager::mojom {


enum class InstanceState : int32_t {
  
  kCreated = 0,
  
  kStarted = 1,
  
  kUnreachable = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(SERVICE_MANAGER_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, InstanceState value);
inline bool IsKnownEnumValue(InstanceState value) {
  return internal::InstanceState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class ServiceManagerListenerInterfaceBase {};

using ServiceManagerListenerPtrDataView =
    mojo::InterfacePtrDataView<ServiceManagerListenerInterfaceBase>;
using ServiceManagerListenerRequestDataView =
    mojo::InterfaceRequestDataView<ServiceManagerListenerInterfaceBase>;
using ServiceManagerListenerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ServiceManagerListenerInterfaceBase>;
using ServiceManagerListenerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ServiceManagerListenerInterfaceBase>;
class ServiceManagerInterfaceBase {};

using ServiceManagerPtrDataView =
    mojo::InterfacePtrDataView<ServiceManagerInterfaceBase>;
using ServiceManagerRequestDataView =
    mojo::InterfaceRequestDataView<ServiceManagerInterfaceBase>;
using ServiceManagerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ServiceManagerInterfaceBase>;
using ServiceManagerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ServiceManagerInterfaceBase>;


class RunningServiceInfoDataView {
 public:
  RunningServiceInfoDataView() = default;

  RunningServiceInfoDataView(
      internal::RunningServiceInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdentityDataView(
      ::service_manager::mojom::IdentityDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIdentity(UserType* output) {
    
    auto* pointer = data_->identity.Get();
    return mojo::internal::Deserialize<::service_manager::mojom::IdentityDataView>(
        pointer, output, message_);
  }
  uint32_t pid() const {
    return data_->pid;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadState(UserType* output) const {
    auto data_value = data_->state;
    return mojo::internal::Deserialize<::service_manager::mojom::InstanceState>(
        data_value, output);
  }
  InstanceState state() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::service_manager::mojom::InstanceState>(data_->state));
  }
 private:
  internal::RunningServiceInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // service_manager::mojom

#endif  // SERVICES_SERVICE_MANAGER_PUBLIC_MOJOM_SERVICE_MANAGER_MOJOM_DATA_VIEW_H_