// services/service_manager/public/mojom/service_manager.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/service_manager/public/mojom/service_manager.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/service_manager/public/mojom/service_manager.mojom-params-data.h"
#include "services/service_manager/public/mojom/service_manager.mojom-shared-message-ids.h"

#include "services/service_manager/public/mojom/service_manager.mojom-blink-import-headers.h"
#include "services/service_manager/public/mojom/service_manager.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace service_manager::mojom::blink {
RunningServiceInfo::RunningServiceInfo()
    : identity(),
      pid(),
      state() {}

RunningServiceInfo::RunningServiceInfo(
    ::service_manager::mojom::blink::IdentityPtr identity_in,
    uint32_t pid_in,
    InstanceState state_in)
    : identity(std::move(identity_in)),
      pid(std::move(pid_in)),
      state(std::move(state_in)) {}

RunningServiceInfo::~RunningServiceInfo() = default;

void RunningServiceInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "identity"), this->identity,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::service_manager::mojom::blink::IdentityPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pid"), this->pid,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "state"), this->state,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type InstanceState>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool RunningServiceInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

ServiceManagerListener::IPCStableHashFunction ServiceManagerListener::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ServiceManagerListener>(message.name())) {
    case messages::ServiceManagerListener::kOnInit: {
      return &ServiceManagerListener::OnInit_Sym::IPCStableHash;
    }
    case messages::ServiceManagerListener::kOnServiceCreated: {
      return &ServiceManagerListener::OnServiceCreated_Sym::IPCStableHash;
    }
    case messages::ServiceManagerListener::kOnServiceStarted: {
      return &ServiceManagerListener::OnServiceStarted_Sym::IPCStableHash;
    }
    case messages::ServiceManagerListener::kOnServicePIDReceived: {
      return &ServiceManagerListener::OnServicePIDReceived_Sym::IPCStableHash;
    }
    case messages::ServiceManagerListener::kOnServiceFailedToStart: {
      return &ServiceManagerListener::OnServiceFailedToStart_Sym::IPCStableHash;
    }
    case messages::ServiceManagerListener::kOnServiceStopped: {
      return &ServiceManagerListener::OnServiceStopped_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ServiceManagerListener::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ServiceManagerListener>(message.name())) {
      case messages::ServiceManagerListener::kOnInit:
            return "Receive service_manager::mojom::ServiceManagerListener::OnInit";
      case messages::ServiceManagerListener::kOnServiceCreated:
            return "Receive service_manager::mojom::ServiceManagerListener::OnServiceCreated";
      case messages::ServiceManagerListener::kOnServiceStarted:
            return "Receive service_manager::mojom::ServiceManagerListener::OnServiceStarted";
      case messages::ServiceManagerListener::kOnServicePIDReceived:
            return "Receive service_manager::mojom::ServiceManagerListener::OnServicePIDReceived";
      case messages::ServiceManagerListener::kOnServiceFailedToStart:
            return "Receive service_manager::mojom::ServiceManagerListener::OnServiceFailedToStart";
      case messages::ServiceManagerListener::kOnServiceStopped:
            return "Receive service_manager::mojom::ServiceManagerListener::OnServiceStopped";
    }
  } else {
    switch (static_cast<messages::ServiceManagerListener>(message.name())) {
      case messages::ServiceManagerListener::kOnInit:
            return "Receive reply service_manager::mojom::ServiceManagerListener::OnInit";
      case messages::ServiceManagerListener::kOnServiceCreated:
            return "Receive reply service_manager::mojom::ServiceManagerListener::OnServiceCreated";
      case messages::ServiceManagerListener::kOnServiceStarted:
            return "Receive reply service_manager::mojom::ServiceManagerListener::OnServiceStarted";
      case messages::ServiceManagerListener::kOnServicePIDReceived:
            return "Receive reply service_manager::mojom::ServiceManagerListener::OnServicePIDReceived";
      case messages::ServiceManagerListener::kOnServiceFailedToStart:
            return "Receive reply service_manager::mojom::ServiceManagerListener::OnServiceFailedToStart";
      case messages::ServiceManagerListener::kOnServiceStopped:
            return "Receive reply service_manager::mojom::ServiceManagerListener::OnServiceStopped";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ServiceManagerListener::OnInit_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x487ec3df;  // IPCStableHash for service_manager::mojom::ServiceManagerListener::OnInit
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceManagerListener::OnServiceCreated_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc3d11eab;  // IPCStableHash for service_manager::mojom::ServiceManagerListener::OnServiceCreated
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceManagerListener::OnServiceStarted_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xba8a2b98;  // IPCStableHash for service_manager::mojom::ServiceManagerListener::OnServiceStarted
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceManagerListener::OnServicePIDReceived_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9f1dad2f;  // IPCStableHash for service_manager::mojom::ServiceManagerListener::OnServicePIDReceived
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceManagerListener::OnServiceFailedToStart_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc15752d8;  // IPCStableHash for service_manager::mojom::ServiceManagerListener::OnServiceFailedToStart
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceManagerListener::OnServiceStopped_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7f87f9d9;  // IPCStableHash for service_manager::mojom::ServiceManagerListener::OnServiceStopped
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

ServiceManagerListenerProxy::ServiceManagerListenerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ServiceManagerListenerProxy::OnInit(
    ::blink::Vector<RunningServiceInfoPtr> in_running_services) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send service_manager::mojom::ServiceManagerListener::OnInit", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("running_services"), in_running_services,
                        "<value of type ::blink::Vector<RunningServiceInfoPtr>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceManagerListener::kOnInit), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::service_manager::mojom::internal::ServiceManagerListener_OnInit_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->running_services)::BaseType>
      running_services_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& running_services_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::service_manager::mojom::RunningServiceInfoDataView>>(
    in_running_services,
    running_services_fragment,
    &running_services_validate_params);

  params->running_services.Set(
      running_services_fragment.is_null() ? nullptr : running_services_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->running_services.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null running_services in ServiceManagerListener.OnInit request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceManagerListener::Name_);
  message.set_method_name("OnInit");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ServiceManagerListenerProxy::OnServiceCreated(
    RunningServiceInfoPtr in_service) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send service_manager::mojom::ServiceManagerListener::OnServiceCreated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service"), in_service,
                        "<value of type RunningServiceInfoPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceManagerListener::kOnServiceCreated), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::service_manager::mojom::internal::ServiceManagerListener_OnServiceCreated_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->service)::BaseType> service_fragment(
          params.message());
  
  mojo::internal::Serialize<::service_manager::mojom::RunningServiceInfoDataView>(
    in_service,
    service_fragment);

  params->service.Set(
      service_fragment.is_null() ? nullptr : service_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->service.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null service in ServiceManagerListener.OnServiceCreated request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceManagerListener::Name_);
  message.set_method_name("OnServiceCreated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ServiceManagerListenerProxy::OnServiceStarted(
    ::service_manager::mojom::blink::IdentityPtr in_identity, uint32_t in_pid_deprecated) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send service_manager::mojom::ServiceManagerListener::OnServiceStarted", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("identity"), in_identity,
                        "<value of type ::service_manager::mojom::blink::IdentityPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pid_deprecated"), in_pid_deprecated,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceManagerListener::kOnServiceStarted), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::service_manager::mojom::internal::ServiceManagerListener_OnServiceStarted_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->identity)::BaseType> identity_fragment(
          params.message());
  
  mojo::internal::Serialize<::service_manager::mojom::IdentityDataView>(
    in_identity,
    identity_fragment);

  params->identity.Set(
      identity_fragment.is_null() ? nullptr : identity_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->identity.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null identity in ServiceManagerListener.OnServiceStarted request");

  params->pid_deprecated = in_pid_deprecated;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceManagerListener::Name_);
  message.set_method_name("OnServiceStarted");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ServiceManagerListenerProxy::OnServicePIDReceived(
    ::service_manager::mojom::blink::IdentityPtr in_identity, uint32_t in_pid) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send service_manager::mojom::ServiceManagerListener::OnServicePIDReceived", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("identity"), in_identity,
                        "<value of type ::service_manager::mojom::blink::IdentityPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pid"), in_pid,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceManagerListener::kOnServicePIDReceived), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::service_manager::mojom::internal::ServiceManagerListener_OnServicePIDReceived_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->identity)::BaseType> identity_fragment(
          params.message());
  
  mojo::internal::Serialize<::service_manager::mojom::IdentityDataView>(
    in_identity,
    identity_fragment);

  params->identity.Set(
      identity_fragment.is_null() ? nullptr : identity_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->identity.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null identity in ServiceManagerListener.OnServicePIDReceived request");

  params->pid = in_pid;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceManagerListener::Name_);
  message.set_method_name("OnServicePIDReceived");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ServiceManagerListenerProxy::OnServiceFailedToStart(
    ::service_manager::mojom::blink::IdentityPtr in_identity) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send service_manager::mojom::ServiceManagerListener::OnServiceFailedToStart", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("identity"), in_identity,
                        "<value of type ::service_manager::mojom::blink::IdentityPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceManagerListener::kOnServiceFailedToStart), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::service_manager::mojom::internal::ServiceManagerListener_OnServiceFailedToStart_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->identity)::BaseType> identity_fragment(
          params.message());
  
  mojo::internal::Serialize<::service_manager::mojom::IdentityDataView>(
    in_identity,
    identity_fragment);

  params->identity.Set(
      identity_fragment.is_null() ? nullptr : identity_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->identity.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null identity in ServiceManagerListener.OnServiceFailedToStart request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceManagerListener::Name_);
  message.set_method_name("OnServiceFailedToStart");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ServiceManagerListenerProxy::OnServiceStopped(
    ::service_manager::mojom::blink::IdentityPtr in_identity) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send service_manager::mojom::ServiceManagerListener::OnServiceStopped", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("identity"), in_identity,
                        "<value of type ::service_manager::mojom::blink::IdentityPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceManagerListener::kOnServiceStopped), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::service_manager::mojom::internal::ServiceManagerListener_OnServiceStopped_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->identity)::BaseType> identity_fragment(
          params.message());
  
  mojo::internal::Serialize<::service_manager::mojom::IdentityDataView>(
    in_identity,
    identity_fragment);

  params->identity.Set(
      identity_fragment.is_null() ? nullptr : identity_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->identity.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null identity in ServiceManagerListener.OnServiceStopped request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceManagerListener::Name_);
  message.set_method_name("OnServiceStopped");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool ServiceManagerListenerStubDispatch::Accept(
    ServiceManagerListener* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ServiceManagerListener>(message->header()->name)) {
    case messages::ServiceManagerListener::kOnInit: {
      DCHECK(message->is_serialized());
      internal::ServiceManagerListener_OnInit_Params_Data* params =
          reinterpret_cast<internal::ServiceManagerListener_OnInit_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ServiceManagerListener.0
      bool success = true;
      ::blink::Vector<RunningServiceInfoPtr> p_running_services{};
      ServiceManagerListener_OnInit_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRunningServices(&p_running_services))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceManagerListener::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnInit(        
        std::move(p_running_services));
      return true;
    }
    case messages::ServiceManagerListener::kOnServiceCreated: {
      DCHECK(message->is_serialized());
      internal::ServiceManagerListener_OnServiceCreated_Params_Data* params =
          reinterpret_cast<internal::ServiceManagerListener_OnServiceCreated_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ServiceManagerListener.1
      bool success = true;
      RunningServiceInfoPtr p_service{};
      ServiceManagerListener_OnServiceCreated_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadService(&p_service))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceManagerListener::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnServiceCreated(        
        std::move(p_service));
      return true;
    }
    case messages::ServiceManagerListener::kOnServiceStarted: {
      DCHECK(message->is_serialized());
      internal::ServiceManagerListener_OnServiceStarted_Params_Data* params =
          reinterpret_cast<internal::ServiceManagerListener_OnServiceStarted_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ServiceManagerListener.2
      bool success = true;
      ::service_manager::mojom::blink::IdentityPtr p_identity{};
      uint32_t p_pid_deprecated{};
      ServiceManagerListener_OnServiceStarted_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadIdentity(&p_identity))
        success = false;
      if (success)
        p_pid_deprecated = input_data_view.pid_deprecated();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceManagerListener::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnServiceStarted(        
        std::move(p_identity), 
        std::move(p_pid_deprecated));
      return true;
    }
    case messages::ServiceManagerListener::kOnServicePIDReceived: {
      DCHECK(message->is_serialized());
      internal::ServiceManagerListener_OnServicePIDReceived_Params_Data* params =
          reinterpret_cast<internal::ServiceManagerListener_OnServicePIDReceived_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ServiceManagerListener.3
      bool success = true;
      ::service_manager::mojom::blink::IdentityPtr p_identity{};
      uint32_t p_pid{};
      ServiceManagerListener_OnServicePIDReceived_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadIdentity(&p_identity))
        success = false;
      if (success)
        p_pid = input_data_view.pid();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceManagerListener::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnServicePIDReceived(        
        std::move(p_identity), 
        std::move(p_pid));
      return true;
    }
    case messages::ServiceManagerListener::kOnServiceFailedToStart: {
      DCHECK(message->is_serialized());
      internal::ServiceManagerListener_OnServiceFailedToStart_Params_Data* params =
          reinterpret_cast<internal::ServiceManagerListener_OnServiceFailedToStart_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ServiceManagerListener.4
      bool success = true;
      ::service_manager::mojom::blink::IdentityPtr p_identity{};
      ServiceManagerListener_OnServiceFailedToStart_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadIdentity(&p_identity))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceManagerListener::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnServiceFailedToStart(        
        std::move(p_identity));
      return true;
    }
    case messages::ServiceManagerListener::kOnServiceStopped: {
      DCHECK(message->is_serialized());
      internal::ServiceManagerListener_OnServiceStopped_Params_Data* params =
          reinterpret_cast<internal::ServiceManagerListener_OnServiceStopped_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ServiceManagerListener.5
      bool success = true;
      ::service_manager::mojom::blink::IdentityPtr p_identity{};
      ServiceManagerListener_OnServiceStopped_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadIdentity(&p_identity))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceManagerListener::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnServiceStopped(        
        std::move(p_identity));
      return true;
    }
  }
  return false;
}

// static
bool ServiceManagerListenerStubDispatch::AcceptWithResponder(
    ServiceManagerListener* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ServiceManagerListener>(message->header()->name)) {
    case messages::ServiceManagerListener::kOnInit: {
      break;
    }
    case messages::ServiceManagerListener::kOnServiceCreated: {
      break;
    }
    case messages::ServiceManagerListener::kOnServiceStarted: {
      break;
    }
    case messages::ServiceManagerListener::kOnServicePIDReceived: {
      break;
    }
    case messages::ServiceManagerListener::kOnServiceFailedToStart: {
      break;
    }
    case messages::ServiceManagerListener::kOnServiceStopped: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kServiceManagerListenerValidationInfo[] = {
    { &internal::ServiceManagerListener_OnInit_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ServiceManagerListener_OnServiceCreated_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ServiceManagerListener_OnServiceStarted_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ServiceManagerListener_OnServicePIDReceived_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ServiceManagerListener_OnServiceFailedToStart_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ServiceManagerListener_OnServiceStopped_Params_Data::Validate,
     nullptr /* no response */},
};

bool ServiceManagerListenerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::service_manager::mojom::blink::ServiceManagerListener::Name_,
    kServiceManagerListenerValidationInfo);
}

// The declaration includes the definition on other builds.

ServiceManager::IPCStableHashFunction ServiceManager::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ServiceManager>(message.name())) {
    case messages::ServiceManager::kAddListener: {
      return &ServiceManager::AddListener_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ServiceManager::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ServiceManager>(message.name())) {
      case messages::ServiceManager::kAddListener:
            return "Receive service_manager::mojom::ServiceManager::AddListener";
    }
  } else {
    switch (static_cast<messages::ServiceManager>(message.name())) {
      case messages::ServiceManager::kAddListener:
            return "Receive reply service_manager::mojom::ServiceManager::AddListener";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ServiceManager::AddListener_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6a78e2dc;  // IPCStableHash for service_manager::mojom::ServiceManager::AddListener
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

ServiceManagerProxy::ServiceManagerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ServiceManagerProxy::AddListener(
    ::mojo::PendingRemote<ServiceManagerListener> in_listener) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send service_manager::mojom::ServiceManager::AddListener", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("listener"), in_listener,
                        "<value of type ::mojo::PendingRemote<ServiceManagerListener>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceManager::kAddListener), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::service_manager::mojom::internal::ServiceManager_AddListener_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::service_manager::mojom::ServiceManagerListenerInterfaceBase>>(
    in_listener,
    &params->listener,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->listener)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid listener in ServiceManager.AddListener request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceManager::Name_);
  message.set_method_name("AddListener");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool ServiceManagerStubDispatch::Accept(
    ServiceManager* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ServiceManager>(message->header()->name)) {
    case messages::ServiceManager::kAddListener: {
      DCHECK(message->is_serialized());
      internal::ServiceManager_AddListener_Params_Data* params =
          reinterpret_cast<internal::ServiceManager_AddListener_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ServiceManager.0
      bool success = true;
      ::mojo::PendingRemote<ServiceManagerListener> p_listener{};
      ServiceManager_AddListener_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_listener =
            input_data_view.TakeListener<decltype(p_listener)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceManager::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddListener(        
        std::move(p_listener));
      return true;
    }
  }
  return false;
}

// static
bool ServiceManagerStubDispatch::AcceptWithResponder(
    ServiceManager* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ServiceManager>(message->header()->name)) {
    case messages::ServiceManager::kAddListener: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kServiceManagerValidationInfo[] = {
    { &internal::ServiceManager_AddListener_Params_Data::Validate,
     nullptr /* no response */},
};

bool ServiceManagerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::service_manager::mojom::blink::ServiceManager::Name_,
    kServiceManagerValidationInfo);
}



}  // service_manager::mojom::blink


namespace mojo {


// static
bool StructTraits<::service_manager::mojom::blink::RunningServiceInfo::DataView, ::service_manager::mojom::blink::RunningServiceInfoPtr>::Read(
    ::service_manager::mojom::blink::RunningServiceInfo::DataView input,
    ::service_manager::mojom::blink::RunningServiceInfoPtr* output) {
  bool success = true;
  ::service_manager::mojom::blink::RunningServiceInfoPtr result(::service_manager::mojom::blink::RunningServiceInfo::New());
  
      if (success && !input.ReadIdentity(&result->identity))
        success = false;
      if (success)
        result->pid = input.pid();
      if (success && !input.ReadState(&result->state))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace service_manager::mojom::blink {


void ServiceManagerListenerInterceptorForTesting::OnInit(::blink::Vector<RunningServiceInfoPtr> running_services) {
  GetForwardingInterface()->OnInit(
    std::move(running_services)
    );
}
void ServiceManagerListenerInterceptorForTesting::OnServiceCreated(RunningServiceInfoPtr service) {
  GetForwardingInterface()->OnServiceCreated(
    std::move(service)
    );
}
void ServiceManagerListenerInterceptorForTesting::OnServiceStarted(::service_manager::mojom::blink::IdentityPtr identity, uint32_t pid_deprecated) {
  GetForwardingInterface()->OnServiceStarted(
    std::move(identity)
    , 
    std::move(pid_deprecated)
    );
}
void ServiceManagerListenerInterceptorForTesting::OnServicePIDReceived(::service_manager::mojom::blink::IdentityPtr identity, uint32_t pid) {
  GetForwardingInterface()->OnServicePIDReceived(
    std::move(identity)
    , 
    std::move(pid)
    );
}
void ServiceManagerListenerInterceptorForTesting::OnServiceFailedToStart(::service_manager::mojom::blink::IdentityPtr identity) {
  GetForwardingInterface()->OnServiceFailedToStart(
    std::move(identity)
    );
}
void ServiceManagerListenerInterceptorForTesting::OnServiceStopped(::service_manager::mojom::blink::IdentityPtr identity) {
  GetForwardingInterface()->OnServiceStopped(
    std::move(identity)
    );
}
ServiceManagerListenerAsyncWaiter::ServiceManagerListenerAsyncWaiter(
    ServiceManagerListener* proxy) : proxy_(proxy) {}

ServiceManagerListenerAsyncWaiter::~ServiceManagerListenerAsyncWaiter() = default;





void ServiceManagerInterceptorForTesting::AddListener(::mojo::PendingRemote<ServiceManagerListener> listener) {
  GetForwardingInterface()->AddListener(
    std::move(listener)
    );
}
ServiceManagerAsyncWaiter::ServiceManagerAsyncWaiter(
    ServiceManager* proxy) : proxy_(proxy) {}

ServiceManagerAsyncWaiter::~ServiceManagerAsyncWaiter() = default;







}  // service_manager::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif