// services/service_manager/public/mojom/service_filter.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_SERVICE_MANAGER_PUBLIC_MOJOM_SERVICE_FILTER_MOJOM_H_
#define SERVICES_SERVICE_MANAGER_PUBLIC_MOJOM_SERVICE_FILTER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/service_manager/public/mojom/service_filter.mojom-features.h"  // IWYU pragma: export
#include "services/service_manager/public/mojom/service_filter.mojom-shared.h"  // IWYU pragma: export
#include "services/service_manager/public/mojom/service_filter.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/token.mojom.h"
#include <string>
#include <vector>




#include "services/service_manager/public/cpp/service_filter_mojom_traits.h"
#include "base/component_export.h"




namespace service_manager::mojom {








class COMPONENT_EXPORT(SERVICE_MANAGER_MOJOM) ServiceFilter {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ServiceFilter, T>::value>;
  using DataView = ServiceFilterDataView;
  using Data_ = internal::ServiceFilter_Data;

  template <typename... Args>
  static ServiceFilterPtr New(Args&&... args) {
    return ServiceFilterPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ServiceFilterPtr From(const U& u) {
    return mojo::TypeConverter<ServiceFilterPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ServiceFilter>::Convert(*this);
  }


  ServiceFilter();

  ServiceFilter(
      const std::string& service_name,
      const std::optional<::base::Token>& instance_group,
      const std::optional<::base::Token>& instance_id,
      const std::optional<::base::Token>& globally_unique_id);


  ~ServiceFilter();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ServiceFilterPtr>
  ServiceFilterPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ServiceFilter::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ServiceFilter::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ServiceFilter::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ServiceFilter::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ServiceFilter::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ServiceFilter::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ServiceFilter_UnserializedMessageContext<
            UserType, ServiceFilter::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ServiceFilter::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ServiceFilter::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ServiceFilter_UnserializedMessageContext<
            UserType, ServiceFilter::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ServiceFilter::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string service_name;
  
  std::optional<::base::Token> instance_group;
  
  std::optional<::base::Token> instance_id;
  
  std::optional<::base::Token> globally_unique_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ServiceFilter::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ServiceFilter::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ServiceFilter::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ServiceFilter::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ServiceFilterPtr ServiceFilter::Clone() const {
  return New(
      mojo::Clone(service_name),
      mojo::Clone(instance_group),
      mojo::Clone(instance_id),
      mojo::Clone(globally_unique_id)
  );
}

template <typename T, ServiceFilter::EnableIfSame<T>*>
bool ServiceFilter::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->service_name, other_struct.service_name))
    return false;
  if (!mojo::Equals(this->instance_group, other_struct.instance_group))
    return false;
  if (!mojo::Equals(this->instance_id, other_struct.instance_id))
    return false;
  if (!mojo::Equals(this->globally_unique_id, other_struct.globally_unique_id))
    return false;
  return true;
}

template <typename T, ServiceFilter::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.service_name < rhs.service_name)
    return true;
  if (rhs.service_name < lhs.service_name)
    return false;
  if (lhs.instance_group < rhs.instance_group)
    return true;
  if (rhs.instance_group < lhs.instance_group)
    return false;
  if (lhs.instance_id < rhs.instance_id)
    return true;
  if (rhs.instance_id < lhs.instance_id)
    return false;
  if (lhs.globally_unique_id < rhs.globally_unique_id)
    return true;
  if (rhs.globally_unique_id < lhs.globally_unique_id)
    return false;
  return false;
}


}  // service_manager::mojom

namespace mojo {


template <>
struct COMPONENT_EXPORT(SERVICE_MANAGER_MOJOM) StructTraits<::service_manager::mojom::ServiceFilter::DataView,
                                         ::service_manager::mojom::ServiceFilterPtr> {
  static bool IsNull(const ::service_manager::mojom::ServiceFilterPtr& input) { return !input; }
  static void SetToNull(::service_manager::mojom::ServiceFilterPtr* output) { output->reset(); }

  static const decltype(::service_manager::mojom::ServiceFilter::service_name)& service_name(
      const ::service_manager::mojom::ServiceFilterPtr& input) {
    return input->service_name;
  }

  static const decltype(::service_manager::mojom::ServiceFilter::instance_group)& instance_group(
      const ::service_manager::mojom::ServiceFilterPtr& input) {
    return input->instance_group;
  }

  static const decltype(::service_manager::mojom::ServiceFilter::instance_id)& instance_id(
      const ::service_manager::mojom::ServiceFilterPtr& input) {
    return input->instance_id;
  }

  static const decltype(::service_manager::mojom::ServiceFilter::globally_unique_id)& globally_unique_id(
      const ::service_manager::mojom::ServiceFilterPtr& input) {
    return input->globally_unique_id;
  }

  static bool Read(::service_manager::mojom::ServiceFilter::DataView input, ::service_manager::mojom::ServiceFilterPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_SERVICE_MANAGER_PUBLIC_MOJOM_SERVICE_FILTER_MOJOM_H_