// services/service_manager/public/mojom/service_filter.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_SERVICE_MANAGER_PUBLIC_MOJOM_SERVICE_FILTER_MOJOM_SHARED_H_
#define SERVICES_SERVICE_MANAGER_PUBLIC_MOJOM_SERVICE_FILTER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/service_manager/public/mojom/service_filter.mojom-shared-internal.h"
#include "mojo/public/mojom/base/token.mojom-shared.h"




#include "services/service_manager/public/mojom/service_filter.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::service_manager::mojom::ServiceFilterDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::service_manager::mojom::ServiceFilterDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::service_manager::mojom::internal::ServiceFilter_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::service_name(input)) in_service_name = Traits::service_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->service_name)::BaseType> service_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_service_name,
      service_name_fragment);

    fragment->service_name.Set(
        service_name_fragment.is_null() ? nullptr : service_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->service_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null service_name in ServiceFilter struct");

    decltype(Traits::instance_group(input)) in_instance_group = Traits::instance_group(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->instance_group)::BaseType> instance_group_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TokenDataView>(
      in_instance_group,
      instance_group_fragment);

    fragment->instance_group.Set(
        instance_group_fragment.is_null() ? nullptr : instance_group_fragment.data());

    decltype(Traits::instance_id(input)) in_instance_id = Traits::instance_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->instance_id)::BaseType> instance_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TokenDataView>(
      in_instance_id,
      instance_id_fragment);

    fragment->instance_id.Set(
        instance_id_fragment.is_null() ? nullptr : instance_id_fragment.data());

    decltype(Traits::globally_unique_id(input)) in_globally_unique_id = Traits::globally_unique_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->globally_unique_id)::BaseType> globally_unique_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TokenDataView>(
      in_globally_unique_id,
      globally_unique_id_fragment);

    fragment->globally_unique_id.Set(
        globally_unique_id_fragment.is_null() ? nullptr : globally_unique_id_fragment.data());
  }

  static bool Deserialize(::service_manager::mojom::internal::ServiceFilter_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::service_manager::mojom::ServiceFilterDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace service_manager::mojom {

inline void ServiceFilterDataView::GetServiceNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->service_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ServiceFilterDataView::GetInstanceGroupDataView(
    ::mojo_base::mojom::TokenDataView* output) {
  auto pointer = data_->instance_group.Get();
  *output = ::mojo_base::mojom::TokenDataView(pointer, message_);
}
inline void ServiceFilterDataView::GetInstanceIdDataView(
    ::mojo_base::mojom::TokenDataView* output) {
  auto pointer = data_->instance_id.Get();
  *output = ::mojo_base::mojom::TokenDataView(pointer, message_);
}
inline void ServiceFilterDataView::GetGloballyUniqueIdDataView(
    ::mojo_base::mojom::TokenDataView* output) {
  auto pointer = data_->globally_unique_id.Get();
  *output = ::mojo_base::mojom::TokenDataView(pointer, message_);
}



}  // service_manager::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SERVICES_SERVICE_MANAGER_PUBLIC_MOJOM_SERVICE_FILTER_MOJOM_SHARED_H_