// services/service_manager/public/mojom/service.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';

import {
  ConnectorRemote as serviceManager_mojom_ConnectorRemote,
  ConnectorPendingReceiver as serviceManager_mojom_ConnectorPendingReceiver,
  ProcessMetadataRemote as serviceManager_mojom_ProcessMetadataRemote,
  ProcessMetadataPendingReceiver as serviceManager_mojom_ProcessMetadataPendingReceiver,
  Identity as serviceManager_mojom_Identity,
  IdentitySpec as serviceManager_mojom_IdentitySpec
} from './connector.mojom.m.js';

import {
  CapabilitySet as serviceManager_mojom_CapabilitySet,
  CapabilitySetSpec as serviceManager_mojom_CapabilitySetSpec
} from './interface_provider_spec.mojom.m.js';

import {
  ServiceControlRemote as serviceManager_mojom_ServiceControlRemote,
  ServiceControlPendingReceiver as serviceManager_mojom_ServiceControlPendingReceiver
} from './service_control.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class ServicePendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'service_manager.mojom.Service', scope);
  }
}

/** @interface */
export class ServiceInterface {
  
  /**
   * @param { !serviceManager_mojom_Identity } identity
   * @return {!Promise<{
        connectorReceiver: !serviceManager_mojom_ConnectorPendingReceiver,
        controlReceiver: !Object,
   *  }>}
   */

  onStart(identity) {}
  
  /**
   * @param { !BindSourceInfo } source
   * @param { !string } interfaceName
   * @param { !MojoHandle } interfacePipe
   * @return {!Promise}
   */

  onBindInterface(source, interfaceName, interfacePipe) {}
  
  /**
   * @param { !serviceManager_mojom_Identity } identity
   * @param { !ServicePendingReceiver } receiver
   * @param { !serviceManager_mojom_ProcessMetadataRemote } metadata
   */

  createPackagedServiceInstance(identity, receiver, metadata) {}
}

/**
 * @implements { ServiceInterface }
 */
export class ServiceRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !serviceManager_mojom_Identity } identity
   * @return {!Promise<{
        connectorReceiver: !serviceManager_mojom_ConnectorPendingReceiver,
        controlReceiver: !Object,
   *  }>}
   */

  onStart(
      identity) {
    return this.proxy.sendMessage(
        0,
        Service_OnStart_ParamsSpec.$,
        Service_OnStart_ResponseParamsSpec.$,
        [
          identity
        ],
        false);
  }

  
  /**
   * @param { !BindSourceInfo } source
   * @param { !string } interfaceName
   * @param { !MojoHandle } interfacePipe
   * @return {!Promise}
   */

  onBindInterface(
      source,
      interfaceName,
      interfacePipe) {
    return this.proxy.sendMessage(
        1,
        Service_OnBindInterface_ParamsSpec.$,
        Service_OnBindInterface_ResponseParamsSpec.$,
        [
          source,
          interfaceName,
          interfacePipe
        ],
        false);
  }

  
  /**
   * @param { !serviceManager_mojom_Identity } identity
   * @param { !ServicePendingReceiver } receiver
   * @param { !serviceManager_mojom_ProcessMetadataRemote } metadata
   */

  createPackagedServiceInstance(
      identity,
      receiver,
      metadata) {
    this.proxy.sendMessage(
        2,
        Service_CreatePackagedServiceInstance_ParamsSpec.$,
        null,
        [
          identity,
          receiver,
          metadata
        ],
        false);
  }
}

/**
 * An object which receives request messages for the Service
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ServiceReceiver {
  /**
   * @param {!ServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        Service_OnStart_ParamsSpec.$,
        Service_OnStart_ResponseParamsSpec.$,
        impl.onStart.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        Service_OnBindInterface_ParamsSpec.$,
        Service_OnBindInterface_ResponseParamsSpec.$,
        impl.onBindInterface.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        Service_CreatePackagedServiceInstance_ParamsSpec.$,
        null,
        impl.createPackagedServiceInstance.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class Service {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "service_manager.mojom.Service";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ServiceRemote}
   */
  static getRemote() {
    let remote = new ServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the Service
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ServiceCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onStart =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        Service_OnStart_ParamsSpec.$,
        Service_OnStart_ResponseParamsSpec.$,
        this.onStart.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onBindInterface =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        Service_OnBindInterface_ParamsSpec.$,
        Service_OnBindInterface_ResponseParamsSpec.$,
        this.onBindInterface.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createPackagedServiceInstance =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        Service_CreatePackagedServiceInstance_ParamsSpec.$,
        null,
        this.createPackagedServiceInstance.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BindSourceInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Service_OnStart_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Service_OnStart_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Service_OnBindInterface_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Service_OnBindInterface_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Service_CreatePackagedServiceInstance_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    BindSourceInfoSpec.$,
    'BindSourceInfo',
    [
      mojo.internal.StructField(
        'identity', 0,
        0,
        serviceManager_mojom_IdentitySpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'requiredCapabilities', 8,
        0,
        serviceManager_mojom_CapabilitySetSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class BindSourceInfo {
  constructor() {
    /** @type { !serviceManager_mojom_Identity } */
    this.identity;
    /** @type { !serviceManager_mojom_CapabilitySet } */
    this.requiredCapabilities;
  }
}



mojo.internal.Struct(
    Service_OnStart_ParamsSpec.$,
    'Service_OnStart_Params',
    [
      mojo.internal.StructField(
        'identity', 0,
        0,
        serviceManager_mojom_IdentitySpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Service_OnStart_Params {
  constructor() {
    /** @type { !serviceManager_mojom_Identity } */
    this.identity;
  }
}



mojo.internal.Struct(
    Service_OnStart_ResponseParamsSpec.$,
    'Service_OnStart_ResponseParams',
    [
      mojo.internal.StructField(
        'connectorReceiver', 0,
        0,
        mojo.internal.InterfaceRequest(serviceManager_mojom_ConnectorPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'controlReceiver', 4,
        0,
        mojo.internal.AssociatedInterfaceRequest(serviceManager_mojom_ServiceControlPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Service_OnStart_ResponseParams {
  constructor() {
    /** @type { !serviceManager_mojom_ConnectorPendingReceiver } */
    this.connectorReceiver;
    /** @type { !Object } */
    this.controlReceiver;
  }
}



mojo.internal.Struct(
    Service_OnBindInterface_ParamsSpec.$,
    'Service_OnBindInterface_Params',
    [
      mojo.internal.StructField(
        'source', 0,
        0,
        BindSourceInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'interfaceName', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'interfacePipe', 16,
        0,
        mojo.internal.Handle,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class Service_OnBindInterface_Params {
  constructor() {
    /** @type { !BindSourceInfo } */
    this.source;
    /** @type { !string } */
    this.interfaceName;
    /** @type { !MojoHandle } */
    this.interfacePipe;
  }
}



mojo.internal.Struct(
    Service_OnBindInterface_ResponseParamsSpec.$,
    'Service_OnBindInterface_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class Service_OnBindInterface_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    Service_CreatePackagedServiceInstance_ParamsSpec.$,
    'Service_CreatePackagedServiceInstance_Params',
    [
      mojo.internal.StructField(
        'identity', 0,
        0,
        serviceManager_mojom_IdentitySpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'receiver', 8,
        0,
        mojo.internal.InterfaceRequest(ServicePendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'metadata', 12,
        0,
        mojo.internal.InterfaceProxy(serviceManager_mojom_ProcessMetadataRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class Service_CreatePackagedServiceInstance_Params {
  constructor() {
    /** @type { !serviceManager_mojom_Identity } */
    this.identity;
    /** @type { !ServicePendingReceiver } */
    this.receiver;
    /** @type { !serviceManager_mojom_ProcessMetadataRemote } */
    this.metadata;
  }
}

