// services/service_manager/public/mojom/service.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_SERVICE_MANAGER_PUBLIC_MOJOM_SERVICE_MOJOM_SHARED_H_
#define SERVICES_SERVICE_MANAGER_PUBLIC_MOJOM_SERVICE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/service_manager/public/mojom/service.mojom-shared-internal.h"
#include "services/service_manager/public/mojom/connector.mojom-shared.h"
#include "services/service_manager/public/mojom/interface_provider.mojom-shared.h"
#include "services/service_manager/public/mojom/interface_provider_spec.mojom-shared.h"
#include "services/service_manager/public/mojom/service_control.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "services/service_manager/public/mojom/service.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::service_manager::mojom::BindSourceInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::service_manager::mojom::BindSourceInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::service_manager::mojom::internal::BindSourceInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::identity(input)) in_identity = Traits::identity(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->identity)::BaseType> identity_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::service_manager::mojom::IdentityDataView>(
      in_identity,
      identity_fragment);

    fragment->identity.Set(
        identity_fragment.is_null() ? nullptr : identity_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->identity.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null identity in BindSourceInfo struct");

    decltype(Traits::required_capabilities(input)) in_required_capabilities = Traits::required_capabilities(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->required_capabilities)::BaseType> required_capabilities_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::service_manager::mojom::CapabilitySetDataView>(
      in_required_capabilities,
      required_capabilities_fragment);

    fragment->required_capabilities.Set(
        required_capabilities_fragment.is_null() ? nullptr : required_capabilities_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->required_capabilities.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null required_capabilities in BindSourceInfo struct");
  }

  static bool Deserialize(::service_manager::mojom::internal::BindSourceInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::service_manager::mojom::BindSourceInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace service_manager::mojom {

inline void BindSourceInfoDataView::GetIdentityDataView(
    ::service_manager::mojom::IdentityDataView* output) {
  auto pointer = data_->identity.Get();
  *output = ::service_manager::mojom::IdentityDataView(pointer, message_);
}
inline void BindSourceInfoDataView::GetRequiredCapabilitiesDataView(
    ::service_manager::mojom::CapabilitySetDataView* output) {
  auto pointer = data_->required_capabilities.Get();
  *output = ::service_manager::mojom::CapabilitySetDataView(pointer, message_);
}



}  // service_manager::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SERVICES_SERVICE_MANAGER_PUBLIC_MOJOM_SERVICE_MOJOM_SHARED_H_