// services/service_manager/public/mojom/interface_provider.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('serviceManager.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
serviceManager.mojom.InterfaceProviderPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        serviceManager.mojom.InterfaceProvider.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { serviceManager.mojom.InterfaceProviderInterface }
 */
serviceManager.mojom.InterfaceProviderRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!serviceManager.mojom.InterfaceProviderPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          serviceManager.mojom.InterfaceProviderPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!serviceManager.mojom.InterfaceProviderPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !string } interfaceName
   * @param { !MojoHandle } pipe
   */

  getInterface(
      interfaceName,
      pipe) {
    this.proxy.sendMessage(
        0,
        serviceManager.mojom.InterfaceProvider_GetInterface_ParamsSpec.$,
        null,
        [
          interfaceName,
          pipe
        ],
        false);
  }
};

/**
 * An object which receives request messages for the InterfaceProvider
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
serviceManager.mojom.InterfaceProviderReceiver = class {
  /**
   * @param {!serviceManager.mojom.InterfaceProviderInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!serviceManager.mojom.InterfaceProviderRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        serviceManager.mojom.InterfaceProviderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!serviceManager.mojom.InterfaceProviderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        serviceManager.mojom.InterfaceProvider_GetInterface_ParamsSpec.$,
        null,
        impl.getInterface.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
serviceManager.mojom.InterfaceProvider = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "service_manager.mojom.InterfaceProvider";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!serviceManager.mojom.InterfaceProviderRemote}
   * @export
   */
  static getRemote() {
    let remote = new serviceManager.mojom.InterfaceProviderRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the InterfaceProvider
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
serviceManager.mojom.InterfaceProviderCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      serviceManager.mojom.InterfaceProviderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!serviceManager.mojom.InterfaceProviderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getInterface =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        serviceManager.mojom.InterfaceProvider_GetInterface_ParamsSpec.$,
        null,
        this.getInterface.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
serviceManager.mojom.InterfaceProvider_GetInterface_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    serviceManager.mojom.InterfaceProvider_GetInterface_ParamsSpec.$,
    'InterfaceProvider_GetInterface_Params',
    [
      mojo.internal.StructField(
        'interfaceName', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'pipe', 8,
        0,
        mojo.internal.Handle,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
serviceManager.mojom.InterfaceProvider_GetInterface_Params = class {
  constructor() {
    /** @export { !string } */
    this.interfaceName;
    /** @export { !MojoHandle } */
    this.pipe;
  }
};

