// services/service_manager/public/mojom/connector.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';

import {
  ProcessId as mojoBase_mojom_ProcessId,
  ProcessIdSpec as mojoBase_mojom_ProcessIdSpec
} from '../../../../mojo/public/mojom/base/process_id.mojom.m.js';

import {
  Token as mojoBase_mojom_Token,
  TokenSpec as mojoBase_mojom_TokenSpec
} from '../../../../mojo/public/mojom/base/token.mojom.m.js';

import {
  ServiceFilter as serviceManager_mojom_ServiceFilter,
  ServiceFilterSpec as serviceManager_mojom_ServiceFilterSpec
} from './service_filter.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const ConnectResultSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const ConnectResult = {
  
  SUCCEEDED: 0,
  INVALID_ARGUMENT: 1,
  ACCESS_DENIED: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const BindInterfacePrioritySpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const BindInterfacePriority = {
  
  kImportant: 0,
  kBestEffort: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class ProcessMetadataPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'service_manager.mojom.ProcessMetadata', scope);
  }
}

/** @interface */
export class ProcessMetadataInterface {
  
  /**
   * @param { !mojoBase_mojom_ProcessId } pid
   */

  setPID(pid) {}
}

/**
 * @implements { ProcessMetadataInterface }
 */
export class ProcessMetadataRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ProcessMetadataPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ProcessMetadataPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ProcessMetadataPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !mojoBase_mojom_ProcessId } pid
   */

  setPID(
      pid) {
    this.proxy.sendMessage(
        0,
        ProcessMetadata_SetPID_ParamsSpec.$,
        null,
        [
          pid
        ],
        false);
  }
}

/**
 * An object which receives request messages for the ProcessMetadata
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ProcessMetadataReceiver {
  /**
   * @param {!ProcessMetadataInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ProcessMetadataRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ProcessMetadataRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ProcessMetadataRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ProcessMetadata_SetPID_ParamsSpec.$,
        null,
        impl.setPID.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class ProcessMetadata {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "service_manager.mojom.ProcessMetadata";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ProcessMetadataRemote}
   */
  static getRemote() {
    let remote = new ProcessMetadataRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the ProcessMetadata
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ProcessMetadataCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ProcessMetadataRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ProcessMetadataRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setPID =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ProcessMetadata_SetPID_ParamsSpec.$,
        null,
        this.setPID.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class ConnectorPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'service_manager.mojom.Connector', scope);
  }
}

/** @interface */
export class ConnectorInterface {
  
  /**
   * @param { !serviceManager_mojom_ServiceFilter } filter
   * @param { !string } interfaceName
   * @param { !MojoHandle } interfacePipe
   * @param { !BindInterfacePriority } priority
   * @return {!Promise<{
        result: !ConnectResult,
        identity: ?Identity,
   *  }>}
   */

  bindInterface(filter, interfaceName, interfacePipe, priority) {}
  
  /**
   * @param { !string } serviceName
   * @return {!Promise<{
        info: ?ServiceInfo,
   *  }>}
   */

  queryService(serviceName) {}
  
  /**
   * @param { !serviceManager_mojom_ServiceFilter } filter
   * @return {!Promise<{
        result: !ConnectResult,
        identity: ?Identity,
   *  }>}
   */

  warmService(filter) {}
  
  /**
   * @param { !Identity } identity
   * @param { !MojoHandle } service
   * @param { ?ProcessMetadataPendingReceiver } metadataReceiver
   * @return {!Promise<{
        result: !ConnectResult,
   *  }>}
   */

  registerServiceInstance(identity, service, metadataReceiver) {}
  
  /**
   * @param { !ConnectorPendingReceiver } receiver
   */

  clone(receiver) {}
}

/**
 * @implements { ConnectorInterface }
 */
export class ConnectorRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ConnectorPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ConnectorPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ConnectorPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !serviceManager_mojom_ServiceFilter } filter
   * @param { !string } interfaceName
   * @param { !MojoHandle } interfacePipe
   * @param { !BindInterfacePriority } priority
   * @return {!Promise<{
        result: !ConnectResult,
        identity: ?Identity,
   *  }>}
   */

  bindInterface(
      filter,
      interfaceName,
      interfacePipe,
      priority) {
    return this.proxy.sendMessage(
        0,
        Connector_BindInterface_ParamsSpec.$,
        Connector_BindInterface_ResponseParamsSpec.$,
        [
          filter,
          interfaceName,
          interfacePipe,
          priority
        ],
        false);
  }

  
  /**
   * @param { !string } serviceName
   * @return {!Promise<{
        info: ?ServiceInfo,
   *  }>}
   */

  queryService(
      serviceName) {
    return this.proxy.sendMessage(
        1,
        Connector_QueryService_ParamsSpec.$,
        Connector_QueryService_ResponseParamsSpec.$,
        [
          serviceName
        ],
        false);
  }

  
  /**
   * @param { !serviceManager_mojom_ServiceFilter } filter
   * @return {!Promise<{
        result: !ConnectResult,
        identity: ?Identity,
   *  }>}
   */

  warmService(
      filter) {
    return this.proxy.sendMessage(
        2,
        Connector_WarmService_ParamsSpec.$,
        Connector_WarmService_ResponseParamsSpec.$,
        [
          filter
        ],
        false);
  }

  
  /**
   * @param { !Identity } identity
   * @param { !MojoHandle } service
   * @param { ?ProcessMetadataPendingReceiver } metadataReceiver
   * @return {!Promise<{
        result: !ConnectResult,
   *  }>}
   */

  registerServiceInstance(
      identity,
      service,
      metadataReceiver) {
    return this.proxy.sendMessage(
        3,
        Connector_RegisterServiceInstance_ParamsSpec.$,
        Connector_RegisterServiceInstance_ResponseParamsSpec.$,
        [
          identity,
          service,
          metadataReceiver
        ],
        false);
  }

  
  /**
   * @param { !ConnectorPendingReceiver } receiver
   */

  clone(
      receiver) {
    this.proxy.sendMessage(
        4,
        Connector_Clone_ParamsSpec.$,
        null,
        [
          receiver
        ],
        false);
  }
}

/**
 * An object which receives request messages for the Connector
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ConnectorReceiver {
  /**
   * @param {!ConnectorInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ConnectorRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ConnectorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ConnectorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        Connector_BindInterface_ParamsSpec.$,
        Connector_BindInterface_ResponseParamsSpec.$,
        impl.bindInterface.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        Connector_QueryService_ParamsSpec.$,
        Connector_QueryService_ResponseParamsSpec.$,
        impl.queryService.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        Connector_WarmService_ParamsSpec.$,
        Connector_WarmService_ResponseParamsSpec.$,
        impl.warmService.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        Connector_RegisterServiceInstance_ParamsSpec.$,
        Connector_RegisterServiceInstance_ResponseParamsSpec.$,
        impl.registerServiceInstance.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        Connector_Clone_ParamsSpec.$,
        null,
        impl.clone.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class Connector {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "service_manager.mojom.Connector";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ConnectorRemote}
   */
  static getRemote() {
    let remote = new ConnectorRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the Connector
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ConnectorCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ConnectorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ConnectorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.bindInterface =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        Connector_BindInterface_ParamsSpec.$,
        Connector_BindInterface_ResponseParamsSpec.$,
        this.bindInterface.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.queryService =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        Connector_QueryService_ParamsSpec.$,
        Connector_QueryService_ResponseParamsSpec.$,
        this.queryService.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.warmService =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        Connector_WarmService_ParamsSpec.$,
        Connector_WarmService_ResponseParamsSpec.$,
        this.warmService.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.registerServiceInstance =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        Connector_RegisterServiceInstance_ParamsSpec.$,
        Connector_RegisterServiceInstance_ResponseParamsSpec.$,
        this.registerServiceInstance.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clone =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        Connector_Clone_ParamsSpec.$,
        null,
        this.clone.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const IdentitySpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ProcessMetadata_SetPID_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Connector_BindInterface_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Connector_BindInterface_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Connector_QueryService_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Connector_QueryService_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Connector_WarmService_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Connector_WarmService_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Connector_RegisterServiceInstance_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Connector_RegisterServiceInstance_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Connector_Clone_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    IdentitySpec.$,
    'Identity',
    [
      mojo.internal.StructField(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'instanceGroup', 8,
        0,
        mojoBase_mojom_TokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'instanceId', 16,
        0,
        mojoBase_mojom_TokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'globallyUniqueId', 24,
        0,
        mojoBase_mojom_TokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class Identity {
  constructor() {
    /** @type { !string } */
    this.name;
    /** @type { !mojoBase_mojom_Token } */
    this.instanceGroup;
    /** @type { !mojoBase_mojom_Token } */
    this.instanceId;
    /** @type { !mojoBase_mojom_Token } */
    this.globallyUniqueId;
  }
}



mojo.internal.Struct(
    ServiceInfoSpec.$,
    'ServiceInfo',
    [
      mojo.internal.StructField(
        'sandboxType', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ServiceInfo {
  constructor() {
    /** @type { !string } */
    this.sandboxType;
  }
}



mojo.internal.Struct(
    ProcessMetadata_SetPID_ParamsSpec.$,
    'ProcessMetadata_SetPID_Params',
    [
      mojo.internal.StructField(
        'pid', 0,
        0,
        mojoBase_mojom_ProcessIdSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ProcessMetadata_SetPID_Params {
  constructor() {
    /** @type { !mojoBase_mojom_ProcessId } */
    this.pid;
  }
}



mojo.internal.Struct(
    Connector_BindInterface_ParamsSpec.$,
    'Connector_BindInterface_Params',
    [
      mojo.internal.StructField(
        'filter', 0,
        0,
        serviceManager_mojom_ServiceFilterSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'interfaceName', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'interfacePipe', 16,
        0,
        mojo.internal.Handle,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'priority', 20,
        0,
        BindInterfacePrioritySpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class Connector_BindInterface_Params {
  constructor() {
    /** @type { !serviceManager_mojom_ServiceFilter } */
    this.filter;
    /** @type { !string } */
    this.interfaceName;
    /** @type { !MojoHandle } */
    this.interfacePipe;
    /** @type { !BindInterfacePriority } */
    this.priority;
  }
}



mojo.internal.Struct(
    Connector_BindInterface_ResponseParamsSpec.$,
    'Connector_BindInterface_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        ConnectResultSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'identity', 8,
        0,
        IdentitySpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class Connector_BindInterface_ResponseParams {
  constructor() {
    /** @type { !ConnectResult } */
    this.result;
    /** @type { (Identity|undefined) } */
    this.identity;
  }
}



mojo.internal.Struct(
    Connector_QueryService_ParamsSpec.$,
    'Connector_QueryService_Params',
    [
      mojo.internal.StructField(
        'serviceName', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Connector_QueryService_Params {
  constructor() {
    /** @type { !string } */
    this.serviceName;
  }
}



mojo.internal.Struct(
    Connector_QueryService_ResponseParamsSpec.$,
    'Connector_QueryService_ResponseParams',
    [
      mojo.internal.StructField(
        'info', 0,
        0,
        ServiceInfoSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Connector_QueryService_ResponseParams {
  constructor() {
    /** @type { (ServiceInfo|undefined) } */
    this.info;
  }
}



mojo.internal.Struct(
    Connector_WarmService_ParamsSpec.$,
    'Connector_WarmService_Params',
    [
      mojo.internal.StructField(
        'filter', 0,
        0,
        serviceManager_mojom_ServiceFilterSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Connector_WarmService_Params {
  constructor() {
    /** @type { !serviceManager_mojom_ServiceFilter } */
    this.filter;
  }
}



mojo.internal.Struct(
    Connector_WarmService_ResponseParamsSpec.$,
    'Connector_WarmService_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        ConnectResultSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'identity', 8,
        0,
        IdentitySpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class Connector_WarmService_ResponseParams {
  constructor() {
    /** @type { !ConnectResult } */
    this.result;
    /** @type { (Identity|undefined) } */
    this.identity;
  }
}



mojo.internal.Struct(
    Connector_RegisterServiceInstance_ParamsSpec.$,
    'Connector_RegisterServiceInstance_Params',
    [
      mojo.internal.StructField(
        'identity', 0,
        0,
        IdentitySpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'service', 8,
        0,
        mojo.internal.Handle,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'metadataReceiver', 12,
        0,
        mojo.internal.InterfaceRequest(ProcessMetadataPendingReceiver),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class Connector_RegisterServiceInstance_Params {
  constructor() {
    /** @type { !Identity } */
    this.identity;
    /** @type { !MojoHandle } */
    this.service;
    /** @type { (ProcessMetadataPendingReceiver|undefined) } */
    this.metadataReceiver;
  }
}



mojo.internal.Struct(
    Connector_RegisterServiceInstance_ResponseParamsSpec.$,
    'Connector_RegisterServiceInstance_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        ConnectResultSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Connector_RegisterServiceInstance_ResponseParams {
  constructor() {
    /** @type { !ConnectResult } */
    this.result;
  }
}



mojo.internal.Struct(
    Connector_Clone_ParamsSpec.$,
    'Connector_Clone_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(ConnectorPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Connector_Clone_Params {
  constructor() {
    /** @type { !ConnectorPendingReceiver } */
    this.receiver;
  }
}

