// services/service_manager/public/mojom/connector.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('serviceManager.mojom');





/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
serviceManager.mojom.ConnectResultSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
serviceManager.mojom.ConnectResult = {
  
  SUCCEEDED: 0,
  INVALID_ARGUMENT: 1,
  ACCESS_DENIED: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
serviceManager.mojom.BindInterfacePrioritySpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
serviceManager.mojom.BindInterfacePriority = {
  
  kImportant: 0,
  kBestEffort: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};





/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
serviceManager.mojom.ProcessMetadataPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        serviceManager.mojom.ProcessMetadata.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { serviceManager.mojom.ProcessMetadataInterface }
 */
serviceManager.mojom.ProcessMetadataRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!serviceManager.mojom.ProcessMetadataPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          serviceManager.mojom.ProcessMetadataPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!serviceManager.mojom.ProcessMetadataPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !mojoBase.mojom.ProcessId } pid
   */

  setPID(
      pid) {
    this.proxy.sendMessage(
        0,
        serviceManager.mojom.ProcessMetadata_SetPID_ParamsSpec.$,
        null,
        [
          pid
        ],
        false);
  }
};

/**
 * An object which receives request messages for the ProcessMetadata
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
serviceManager.mojom.ProcessMetadataReceiver = class {
  /**
   * @param {!serviceManager.mojom.ProcessMetadataInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!serviceManager.mojom.ProcessMetadataRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        serviceManager.mojom.ProcessMetadataRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!serviceManager.mojom.ProcessMetadataRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        serviceManager.mojom.ProcessMetadata_SetPID_ParamsSpec.$,
        null,
        impl.setPID.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
serviceManager.mojom.ProcessMetadata = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "service_manager.mojom.ProcessMetadata";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!serviceManager.mojom.ProcessMetadataRemote}
   * @export
   */
  static getRemote() {
    let remote = new serviceManager.mojom.ProcessMetadataRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the ProcessMetadata
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
serviceManager.mojom.ProcessMetadataCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      serviceManager.mojom.ProcessMetadataRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!serviceManager.mojom.ProcessMetadataRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setPID =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        serviceManager.mojom.ProcessMetadata_SetPID_ParamsSpec.$,
        null,
        this.setPID.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
serviceManager.mojom.ConnectorPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        serviceManager.mojom.Connector.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { serviceManager.mojom.ConnectorInterface }
 */
serviceManager.mojom.ConnectorRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!serviceManager.mojom.ConnectorPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          serviceManager.mojom.ConnectorPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!serviceManager.mojom.ConnectorPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !serviceManager.mojom.ServiceFilter } filter
   * @param { !string } interfaceName
   * @param { !MojoHandle } interfacePipe
   * @param { !serviceManager.mojom.BindInterfacePriority } priority
   * @return {!Promise<{
        result: !serviceManager.mojom.ConnectResult,
        identity: ?serviceManager.mojom.Identity,
   *  }>}
   */

  bindInterface(
      filter,
      interfaceName,
      interfacePipe,
      priority) {
    return this.proxy.sendMessage(
        0,
        serviceManager.mojom.Connector_BindInterface_ParamsSpec.$,
        serviceManager.mojom.Connector_BindInterface_ResponseParamsSpec.$,
        [
          filter,
          interfaceName,
          interfacePipe,
          priority
        ],
        false);
  }

  
  /**
   * @param { !string } serviceName
   * @return {!Promise<{
        info: ?serviceManager.mojom.ServiceInfo,
   *  }>}
   */

  queryService(
      serviceName) {
    return this.proxy.sendMessage(
        1,
        serviceManager.mojom.Connector_QueryService_ParamsSpec.$,
        serviceManager.mojom.Connector_QueryService_ResponseParamsSpec.$,
        [
          serviceName
        ],
        false);
  }

  
  /**
   * @param { !serviceManager.mojom.ServiceFilter } filter
   * @return {!Promise<{
        result: !serviceManager.mojom.ConnectResult,
        identity: ?serviceManager.mojom.Identity,
   *  }>}
   */

  warmService(
      filter) {
    return this.proxy.sendMessage(
        2,
        serviceManager.mojom.Connector_WarmService_ParamsSpec.$,
        serviceManager.mojom.Connector_WarmService_ResponseParamsSpec.$,
        [
          filter
        ],
        false);
  }

  
  /**
   * @param { !serviceManager.mojom.Identity } identity
   * @param { !MojoHandle } service
   * @param { ?serviceManager.mojom.ProcessMetadataPendingReceiver } metadataReceiver
   * @return {!Promise<{
        result: !serviceManager.mojom.ConnectResult,
   *  }>}
   */

  registerServiceInstance(
      identity,
      service,
      metadataReceiver) {
    return this.proxy.sendMessage(
        3,
        serviceManager.mojom.Connector_RegisterServiceInstance_ParamsSpec.$,
        serviceManager.mojom.Connector_RegisterServiceInstance_ResponseParamsSpec.$,
        [
          identity,
          service,
          metadataReceiver
        ],
        false);
  }

  
  /**
   * @param { !serviceManager.mojom.ConnectorPendingReceiver } receiver
   */

  clone(
      receiver) {
    this.proxy.sendMessage(
        4,
        serviceManager.mojom.Connector_Clone_ParamsSpec.$,
        null,
        [
          receiver
        ],
        false);
  }
};

/**
 * An object which receives request messages for the Connector
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
serviceManager.mojom.ConnectorReceiver = class {
  /**
   * @param {!serviceManager.mojom.ConnectorInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!serviceManager.mojom.ConnectorRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        serviceManager.mojom.ConnectorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!serviceManager.mojom.ConnectorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        serviceManager.mojom.Connector_BindInterface_ParamsSpec.$,
        serviceManager.mojom.Connector_BindInterface_ResponseParamsSpec.$,
        impl.bindInterface.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        serviceManager.mojom.Connector_QueryService_ParamsSpec.$,
        serviceManager.mojom.Connector_QueryService_ResponseParamsSpec.$,
        impl.queryService.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        serviceManager.mojom.Connector_WarmService_ParamsSpec.$,
        serviceManager.mojom.Connector_WarmService_ResponseParamsSpec.$,
        impl.warmService.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        serviceManager.mojom.Connector_RegisterServiceInstance_ParamsSpec.$,
        serviceManager.mojom.Connector_RegisterServiceInstance_ResponseParamsSpec.$,
        impl.registerServiceInstance.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        serviceManager.mojom.Connector_Clone_ParamsSpec.$,
        null,
        impl.clone.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
serviceManager.mojom.Connector = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "service_manager.mojom.Connector";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!serviceManager.mojom.ConnectorRemote}
   * @export
   */
  static getRemote() {
    let remote = new serviceManager.mojom.ConnectorRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the Connector
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
serviceManager.mojom.ConnectorCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      serviceManager.mojom.ConnectorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!serviceManager.mojom.ConnectorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.bindInterface =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        serviceManager.mojom.Connector_BindInterface_ParamsSpec.$,
        serviceManager.mojom.Connector_BindInterface_ResponseParamsSpec.$,
        this.bindInterface.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.queryService =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        serviceManager.mojom.Connector_QueryService_ParamsSpec.$,
        serviceManager.mojom.Connector_QueryService_ResponseParamsSpec.$,
        this.queryService.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.warmService =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        serviceManager.mojom.Connector_WarmService_ParamsSpec.$,
        serviceManager.mojom.Connector_WarmService_ResponseParamsSpec.$,
        this.warmService.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.registerServiceInstance =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        serviceManager.mojom.Connector_RegisterServiceInstance_ParamsSpec.$,
        serviceManager.mojom.Connector_RegisterServiceInstance_ResponseParamsSpec.$,
        this.registerServiceInstance.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clone =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        serviceManager.mojom.Connector_Clone_ParamsSpec.$,
        null,
        this.clone.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
serviceManager.mojom.IdentitySpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
serviceManager.mojom.ServiceInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
serviceManager.mojom.ProcessMetadata_SetPID_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
serviceManager.mojom.Connector_BindInterface_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
serviceManager.mojom.Connector_BindInterface_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
serviceManager.mojom.Connector_QueryService_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
serviceManager.mojom.Connector_QueryService_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
serviceManager.mojom.Connector_WarmService_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
serviceManager.mojom.Connector_WarmService_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
serviceManager.mojom.Connector_RegisterServiceInstance_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
serviceManager.mojom.Connector_RegisterServiceInstance_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
serviceManager.mojom.Connector_Clone_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    serviceManager.mojom.IdentitySpec.$,
    'Identity',
    [
      mojo.internal.StructField(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'instanceGroup', 8,
        0,
        mojoBase.mojom.TokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'instanceId', 16,
        0,
        mojoBase.mojom.TokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'globallyUniqueId', 24,
        0,
        mojoBase.mojom.TokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
serviceManager.mojom.Identity = class {
  constructor() {
    /** @export { !string } */
    this.name;
    /** @export { !mojoBase.mojom.Token } */
    this.instanceGroup;
    /** @export { !mojoBase.mojom.Token } */
    this.instanceId;
    /** @export { !mojoBase.mojom.Token } */
    this.globallyUniqueId;
  }
};



mojo.internal.Struct(
    serviceManager.mojom.ServiceInfoSpec.$,
    'ServiceInfo',
    [
      mojo.internal.StructField(
        'sandboxType', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
serviceManager.mojom.ServiceInfo = class {
  constructor() {
    /** @export { !string } */
    this.sandboxType;
  }
};



mojo.internal.Struct(
    serviceManager.mojom.ProcessMetadata_SetPID_ParamsSpec.$,
    'ProcessMetadata_SetPID_Params',
    [
      mojo.internal.StructField(
        'pid', 0,
        0,
        mojoBase.mojom.ProcessIdSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
serviceManager.mojom.ProcessMetadata_SetPID_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.ProcessId } */
    this.pid;
  }
};



mojo.internal.Struct(
    serviceManager.mojom.Connector_BindInterface_ParamsSpec.$,
    'Connector_BindInterface_Params',
    [
      mojo.internal.StructField(
        'filter', 0,
        0,
        serviceManager.mojom.ServiceFilterSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'interfaceName', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'interfacePipe', 16,
        0,
        mojo.internal.Handle,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'priority', 20,
        0,
        serviceManager.mojom.BindInterfacePrioritySpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
serviceManager.mojom.Connector_BindInterface_Params = class {
  constructor() {
    /** @export { !serviceManager.mojom.ServiceFilter } */
    this.filter;
    /** @export { !string } */
    this.interfaceName;
    /** @export { !MojoHandle } */
    this.interfacePipe;
    /** @export { !serviceManager.mojom.BindInterfacePriority } */
    this.priority;
  }
};



mojo.internal.Struct(
    serviceManager.mojom.Connector_BindInterface_ResponseParamsSpec.$,
    'Connector_BindInterface_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        serviceManager.mojom.ConnectResultSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'identity', 8,
        0,
        serviceManager.mojom.IdentitySpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
serviceManager.mojom.Connector_BindInterface_ResponseParams = class {
  constructor() {
    /** @export { !serviceManager.mojom.ConnectResult } */
    this.result;
    /** @export { (serviceManager.mojom.Identity|undefined) } */
    this.identity;
  }
};



mojo.internal.Struct(
    serviceManager.mojom.Connector_QueryService_ParamsSpec.$,
    'Connector_QueryService_Params',
    [
      mojo.internal.StructField(
        'serviceName', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
serviceManager.mojom.Connector_QueryService_Params = class {
  constructor() {
    /** @export { !string } */
    this.serviceName;
  }
};



mojo.internal.Struct(
    serviceManager.mojom.Connector_QueryService_ResponseParamsSpec.$,
    'Connector_QueryService_ResponseParams',
    [
      mojo.internal.StructField(
        'info', 0,
        0,
        serviceManager.mojom.ServiceInfoSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
serviceManager.mojom.Connector_QueryService_ResponseParams = class {
  constructor() {
    /** @export { (serviceManager.mojom.ServiceInfo|undefined) } */
    this.info;
  }
};



mojo.internal.Struct(
    serviceManager.mojom.Connector_WarmService_ParamsSpec.$,
    'Connector_WarmService_Params',
    [
      mojo.internal.StructField(
        'filter', 0,
        0,
        serviceManager.mojom.ServiceFilterSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
serviceManager.mojom.Connector_WarmService_Params = class {
  constructor() {
    /** @export { !serviceManager.mojom.ServiceFilter } */
    this.filter;
  }
};



mojo.internal.Struct(
    serviceManager.mojom.Connector_WarmService_ResponseParamsSpec.$,
    'Connector_WarmService_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        serviceManager.mojom.ConnectResultSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'identity', 8,
        0,
        serviceManager.mojom.IdentitySpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
serviceManager.mojom.Connector_WarmService_ResponseParams = class {
  constructor() {
    /** @export { !serviceManager.mojom.ConnectResult } */
    this.result;
    /** @export { (serviceManager.mojom.Identity|undefined) } */
    this.identity;
  }
};



mojo.internal.Struct(
    serviceManager.mojom.Connector_RegisterServiceInstance_ParamsSpec.$,
    'Connector_RegisterServiceInstance_Params',
    [
      mojo.internal.StructField(
        'identity', 0,
        0,
        serviceManager.mojom.IdentitySpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'service', 8,
        0,
        mojo.internal.Handle,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'metadataReceiver', 12,
        0,
        mojo.internal.InterfaceRequest(serviceManager.mojom.ProcessMetadataPendingReceiver),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
serviceManager.mojom.Connector_RegisterServiceInstance_Params = class {
  constructor() {
    /** @export { !serviceManager.mojom.Identity } */
    this.identity;
    /** @export { !MojoHandle } */
    this.service;
    /** @export { (serviceManager.mojom.ProcessMetadataPendingReceiver|undefined) } */
    this.metadataReceiver;
  }
};



mojo.internal.Struct(
    serviceManager.mojom.Connector_RegisterServiceInstance_ResponseParamsSpec.$,
    'Connector_RegisterServiceInstance_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        serviceManager.mojom.ConnectResultSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
serviceManager.mojom.Connector_RegisterServiceInstance_ResponseParams = class {
  constructor() {
    /** @export { !serviceManager.mojom.ConnectResult } */
    this.result;
  }
};



mojo.internal.Struct(
    serviceManager.mojom.Connector_Clone_ParamsSpec.$,
    'Connector_Clone_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(serviceManager.mojom.ConnectorPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
serviceManager.mojom.Connector_Clone_Params = class {
  constructor() {
    /** @export { !serviceManager.mojom.ConnectorPendingReceiver } */
    this.receiver;
  }
};

