// services/service_manager/public/mojom/connector.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_SERVICE_MANAGER_PUBLIC_MOJOM_CONNECTOR_MOJOM_DATA_VIEW_H_
#define SERVICES_SERVICE_MANAGER_PUBLIC_MOJOM_CONNECTOR_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "services/service_manager/public/mojom/connector.mojom-shared-internal.h"
#include "mojo/public/mojom/base/process_id.mojom-shared.h"
#include "mojo/public/mojom/base/token.mojom-shared.h"
#include "services/service_manager/public/mojom/constants.mojom-shared.h"
#include "services/service_manager/public/mojom/interface_provider.mojom-shared.h"
#include "services/service_manager/public/mojom/service_filter.mojom-shared.h"


namespace service_manager::mojom {
class IdentityDataView;

class ServiceInfoDataView;



}  // service_manager::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::service_manager::mojom::IdentityDataView> {
  using Data = ::service_manager::mojom::internal::Identity_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::service_manager::mojom::ServiceInfoDataView> {
  using Data = ::service_manager::mojom::internal::ServiceInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace service_manager::mojom {


enum class ConnectResult : int32_t {
  
  SUCCEEDED = 0,
  
  INVALID_ARGUMENT = 1,
  
  ACCESS_DENIED = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(SERVICE_MANAGER_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, ConnectResult value);
inline bool IsKnownEnumValue(ConnectResult value) {
  return internal::ConnectResult_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class BindInterfacePriority : int32_t {
  
  kImportant = 0,
  
  kBestEffort = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(SERVICE_MANAGER_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, BindInterfacePriority value);
inline bool IsKnownEnumValue(BindInterfacePriority value) {
  return internal::BindInterfacePriority_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class ProcessMetadataInterfaceBase {};

using ProcessMetadataPtrDataView =
    mojo::InterfacePtrDataView<ProcessMetadataInterfaceBase>;
using ProcessMetadataRequestDataView =
    mojo::InterfaceRequestDataView<ProcessMetadataInterfaceBase>;
using ProcessMetadataAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ProcessMetadataInterfaceBase>;
using ProcessMetadataAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ProcessMetadataInterfaceBase>;
class ConnectorInterfaceBase {};

using ConnectorPtrDataView =
    mojo::InterfacePtrDataView<ConnectorInterfaceBase>;
using ConnectorRequestDataView =
    mojo::InterfaceRequestDataView<ConnectorInterfaceBase>;
using ConnectorAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ConnectorInterfaceBase>;
using ConnectorAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ConnectorInterfaceBase>;


class IdentityDataView {
 public:
  IdentityDataView() = default;

  IdentityDataView(
      internal::Identity_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetInstanceGroupDataView(
      ::mojo_base::mojom::TokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInstanceGroup(UserType* output) {
    
    auto* pointer = data_->instance_group.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TokenDataView>(
        pointer, output, message_);
  }
  inline void GetInstanceIdDataView(
      ::mojo_base::mojom::TokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInstanceId(UserType* output) {
    
    auto* pointer = data_->instance_id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TokenDataView>(
        pointer, output, message_);
  }
  inline void GetGloballyUniqueIdDataView(
      ::mojo_base::mojom::TokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGloballyUniqueId(UserType* output) {
    
    auto* pointer = data_->globally_unique_id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TokenDataView>(
        pointer, output, message_);
  }
 private:
  internal::Identity_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ServiceInfoDataView {
 public:
  ServiceInfoDataView() = default;

  ServiceInfoDataView(
      internal::ServiceInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSandboxTypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSandboxType(UserType* output) {
    
    auto* pointer = data_->sandbox_type.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::ServiceInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // service_manager::mojom

#endif  // SERVICES_SERVICE_MANAGER_PUBLIC_MOJOM_CONNECTOR_MOJOM_DATA_VIEW_H_