// services/screen_ai/public/mojom/screen_ai_service.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_SCREEN_AI_PUBLIC_MOJOM_SCREEN_AI_SERVICE_MOJOM_DATA_VIEW_H_
#define SERVICES_SCREEN_AI_PUBLIC_MOJOM_SCREEN_AI_SERVICE_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "services/screen_ai/public/mojom/screen_ai_service.mojom-shared-internal.h"
#include "skia/public/mojom/bitmap.mojom-shared.h"
#include "ui/accessibility/ax_features.mojom-shared.h"
#include "ui/accessibility/mojom/ax_tree_id.mojom-shared.h"
#include "ui/accessibility/mojom/ax_tree_update.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"


namespace screen_ai::mojom {
class VisualAnnotationDataView;

class LineBoxDataView;

class WordBoxDataView;



}  // screen_ai::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::screen_ai::mojom::VisualAnnotationDataView> {
  using Data = ::screen_ai::mojom::internal::VisualAnnotation_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::screen_ai::mojom::LineBoxDataView> {
  using Data = ::screen_ai::mojom::internal::LineBox_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::screen_ai::mojom::WordBoxDataView> {
  using Data = ::screen_ai::mojom::internal::WordBox_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace screen_ai::mojom {


enum class Direction : int32_t {
  
  DIRECTION_UNSPECIFIED = 0,
  
  DIRECTION_LEFT_TO_RIGHT = 1,
  
  DIRECTION_RIGHT_TO_LEFT = 2,
  
  DIRECTION_TOP_TO_BOTTOM = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, Direction value);
inline bool IsKnownEnumValue(Direction value) {
  return internal::Direction_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class OcrClientType : int32_t {
  
  kTest = 0,
  
  kPdfViewer = 1,
  
  kLocalSearch = 2,
  
  kCameraApp = 3,
  
  kMediaApp = 4,
  
  kScreenshotTextDetection = 5,
  kMinValue = 0,
  kMaxValue = 5,
};

 std::ostream& operator<<(std::ostream& os, OcrClientType value);
inline bool IsKnownEnumValue(OcrClientType value) {
  return internal::OcrClientType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class MceClientType : int32_t {
  
  kTest = 0,
  
  kReadingMode = 1,
  
  kMainNode = 2,
  
  kMahi = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, MceClientType value);
inline bool IsKnownEnumValue(MceClientType value) {
  return internal::MceClientType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class ScreenAIAnnotatorInterfaceBase {};

using ScreenAIAnnotatorPtrDataView =
    mojo::InterfacePtrDataView<ScreenAIAnnotatorInterfaceBase>;
using ScreenAIAnnotatorRequestDataView =
    mojo::InterfaceRequestDataView<ScreenAIAnnotatorInterfaceBase>;
using ScreenAIAnnotatorAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ScreenAIAnnotatorInterfaceBase>;
using ScreenAIAnnotatorAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ScreenAIAnnotatorInterfaceBase>;
class Screen2xMainContentExtractorInterfaceBase {};

using Screen2xMainContentExtractorPtrDataView =
    mojo::InterfacePtrDataView<Screen2xMainContentExtractorInterfaceBase>;
using Screen2xMainContentExtractorRequestDataView =
    mojo::InterfaceRequestDataView<Screen2xMainContentExtractorInterfaceBase>;
using Screen2xMainContentExtractorAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<Screen2xMainContentExtractorInterfaceBase>;
using Screen2xMainContentExtractorAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<Screen2xMainContentExtractorInterfaceBase>;
class OCRServiceInterfaceBase {};

using OCRServicePtrDataView =
    mojo::InterfacePtrDataView<OCRServiceInterfaceBase>;
using OCRServiceRequestDataView =
    mojo::InterfaceRequestDataView<OCRServiceInterfaceBase>;
using OCRServiceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<OCRServiceInterfaceBase>;
using OCRServiceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<OCRServiceInterfaceBase>;
class MainContentExtractionServiceInterfaceBase {};

using MainContentExtractionServicePtrDataView =
    mojo::InterfacePtrDataView<MainContentExtractionServiceInterfaceBase>;
using MainContentExtractionServiceRequestDataView =
    mojo::InterfaceRequestDataView<MainContentExtractionServiceInterfaceBase>;
using MainContentExtractionServiceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<MainContentExtractionServiceInterfaceBase>;
using MainContentExtractionServiceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<MainContentExtractionServiceInterfaceBase>;


class VisualAnnotationDataView {
 public:
  VisualAnnotationDataView() = default;

  VisualAnnotationDataView(
      internal::VisualAnnotation_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetLinesDataView(
      mojo::ArrayDataView<LineBoxDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLines(UserType* output) {
    
    auto* pointer = data_->lines.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::screen_ai::mojom::LineBoxDataView>>(
        pointer, output, message_);
  }
 private:
  internal::VisualAnnotation_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class LineBoxDataView {
 public:
  LineBoxDataView() = default;

  LineBoxDataView(
      internal::LineBox_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetWordsDataView(
      mojo::ArrayDataView<WordBoxDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWords(UserType* output) {
    
    auto* pointer = data_->words.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::screen_ai::mojom::WordBoxDataView>>(
        pointer, output, message_);
  }
  inline void GetTextLineDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTextLine(UserType* output) {
    
    auto* pointer = data_->text_line.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetLanguageDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLanguage(UserType* output) {
    
    auto* pointer = data_->language.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  int32_t block_id() const {
    return data_->block_id;
  }
  int32_t paragraph_id() const {
    return data_->paragraph_id;
  }
  inline void GetBoundingBoxDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBoundingBox(UserType* output) {
    
    auto* pointer = data_->bounding_box.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  float bounding_box_angle() const {
    return data_->bounding_box_angle;
  }
  float confidence() const {
    return data_->confidence;
  }
 private:
  internal::LineBox_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WordBoxDataView {
 public:
  WordBoxDataView() = default;

  WordBoxDataView(
      internal::WordBox_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetWordDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWord(UserType* output) {
    
    auto* pointer = data_->word.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetLanguageDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLanguage(UserType* output) {
    
    auto* pointer = data_->language.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetBoundingBoxDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBoundingBox(UserType* output) {
    
    auto* pointer = data_->bounding_box.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  float bounding_box_angle() const {
    return data_->bounding_box_angle;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadDirection(UserType* output) const {
    auto data_value = data_->direction;
    return mojo::internal::Deserialize<::screen_ai::mojom::Direction>(
        data_value, output);
  }
  Direction direction() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::screen_ai::mojom::Direction>(data_->direction));
  }
  inline void GetWhitespaceBoundingBoxDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWhitespaceBoundingBox(UserType* output) {
    
    auto* pointer = data_->whitespace_bounding_box.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  float whitespace_bounding_box_angle() const {
    return data_->whitespace_bounding_box_angle;
  }
  float confidence() const {
    return data_->confidence;
  }
 private:
  internal::WordBox_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // screen_ai::mojom

#endif  // SERVICES_SCREEN_AI_PUBLIC_MOJOM_SCREEN_AI_SERVICE_MOJOM_DATA_VIEW_H_