// services/proxy_resolver/public/mojom/proxy_resolver.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_PROXY_RESOLVER_PUBLIC_MOJOM_PROXY_RESOLVER_MOJOM_SHARED_H_
#define SERVICES_PROXY_RESOLVER_PUBLIC_MOJOM_PROXY_RESOLVER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/proxy_resolver/public/mojom/proxy_resolver.mojom-shared-internal.h"
#include "sandbox/policy/mojom/sandbox.mojom-shared.h"
#include "services/network/public/mojom/ip_address.mojom-shared.h"
#include "services/network/public/mojom/network_anonymization_key.mojom-shared.h"
#include "services/network/public/mojom/network_param.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "services/proxy_resolver/public/mojom/proxy_resolver.mojom-data-view.h"




namespace std {

template <>
struct hash<::proxy_resolver::mojom::HostResolveOperation>
    : public mojo::internal::EnumHashImpl<::proxy_resolver::mojom::HostResolveOperation> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::proxy_resolver::mojom::HostResolveOperation, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::proxy_resolver::mojom::HostResolveOperation, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::proxy_resolver::mojom::HostResolveOperation>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::proxy_resolver::mojom::ProxyInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::proxy_resolver::mojom::ProxyInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::proxy_resolver::mojom::internal::ProxyInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::proxy_chains(input)) in_proxy_chains = Traits::proxy_chains(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->proxy_chains)::BaseType>
        proxy_chains_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& proxy_chains_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::ProxyChainDataView>>(
      in_proxy_chains,
      proxy_chains_fragment,
      &proxy_chains_validate_params);

    fragment->proxy_chains.Set(
        proxy_chains_fragment.is_null() ? nullptr : proxy_chains_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->proxy_chains.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null proxy_chains in ProxyInfo struct");
  }

  static bool Deserialize(::proxy_resolver::mojom::internal::ProxyInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::proxy_resolver::mojom::ProxyInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::proxy_resolver::mojom::SystemProxyResolutionStatusDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::proxy_resolver::mojom::SystemProxyResolutionStatusDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::proxy_resolver::mojom::internal::SystemProxyResolutionStatus_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->is_success = Traits::is_success(input);

    fragment->os_error = Traits::os_error(input);
  }

  static bool Deserialize(::proxy_resolver::mojom::internal::SystemProxyResolutionStatus_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::proxy_resolver::mojom::SystemProxyResolutionStatusDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace proxy_resolver::mojom {

inline void ProxyInfoDataView::GetProxyChainsDataView(
    mojo::ArrayDataView<::network::mojom::ProxyChainDataView>* output) {
  auto pointer = data_->proxy_chains.Get();
  *output = mojo::ArrayDataView<::network::mojom::ProxyChainDataView>(pointer, message_);
}





}  // proxy_resolver::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::proxy_resolver::mojom::HostResolveOperation> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::proxy_resolver::mojom::HostResolveOperation value);
};

} // namespace perfetto

#endif  // SERVICES_PROXY_RESOLVER_PUBLIC_MOJOM_PROXY_RESOLVER_MOJOM_SHARED_H_