// services/proxy_resolver/public/mojom/proxy_resolver.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_PROXY_RESOLVER_PUBLIC_MOJOM_PROXY_RESOLVER_MOJOM_DATA_VIEW_H_
#define SERVICES_PROXY_RESOLVER_PUBLIC_MOJOM_PROXY_RESOLVER_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "services/proxy_resolver/public/mojom/proxy_resolver.mojom-shared-internal.h"
#include "sandbox/policy/mojom/sandbox.mojom-shared.h"
#include "services/network/public/mojom/ip_address.mojom-shared.h"
#include "services/network/public/mojom/network_anonymization_key.mojom-shared.h"
#include "services/network/public/mojom/network_param.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace proxy_resolver::mojom {
class ProxyInfoDataView;

class SystemProxyResolutionStatusDataView;



}  // proxy_resolver::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::proxy_resolver::mojom::ProxyInfoDataView> {
  using Data = ::proxy_resolver::mojom::internal::ProxyInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::proxy_resolver::mojom::SystemProxyResolutionStatusDataView> {
  using Data = ::proxy_resolver::mojom::internal::SystemProxyResolutionStatus_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace proxy_resolver::mojom {


enum class HostResolveOperation : int32_t {
  
  DNS_RESOLVE = 0,
  
  DNS_RESOLVE_EX = 1,
  
  MY_IP_ADDRESS = 2,
  
  MY_IP_ADDRESS_EX = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, HostResolveOperation value);
inline bool IsKnownEnumValue(HostResolveOperation value) {
  return internal::HostResolveOperation_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class HostResolverRequestClientInterfaceBase {};

using HostResolverRequestClientPtrDataView =
    mojo::InterfacePtrDataView<HostResolverRequestClientInterfaceBase>;
using HostResolverRequestClientRequestDataView =
    mojo::InterfaceRequestDataView<HostResolverRequestClientInterfaceBase>;
using HostResolverRequestClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<HostResolverRequestClientInterfaceBase>;
using HostResolverRequestClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<HostResolverRequestClientInterfaceBase>;
class ProxyResolverInterfaceBase {};

using ProxyResolverPtrDataView =
    mojo::InterfacePtrDataView<ProxyResolverInterfaceBase>;
using ProxyResolverRequestDataView =
    mojo::InterfaceRequestDataView<ProxyResolverInterfaceBase>;
using ProxyResolverAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ProxyResolverInterfaceBase>;
using ProxyResolverAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ProxyResolverInterfaceBase>;
class ProxyResolverRequestClientInterfaceBase {};

using ProxyResolverRequestClientPtrDataView =
    mojo::InterfacePtrDataView<ProxyResolverRequestClientInterfaceBase>;
using ProxyResolverRequestClientRequestDataView =
    mojo::InterfaceRequestDataView<ProxyResolverRequestClientInterfaceBase>;
using ProxyResolverRequestClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ProxyResolverRequestClientInterfaceBase>;
using ProxyResolverRequestClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ProxyResolverRequestClientInterfaceBase>;
class ProxyResolverFactoryInterfaceBase {};

using ProxyResolverFactoryPtrDataView =
    mojo::InterfacePtrDataView<ProxyResolverFactoryInterfaceBase>;
using ProxyResolverFactoryRequestDataView =
    mojo::InterfaceRequestDataView<ProxyResolverFactoryInterfaceBase>;
using ProxyResolverFactoryAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ProxyResolverFactoryInterfaceBase>;
using ProxyResolverFactoryAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ProxyResolverFactoryInterfaceBase>;
class ProxyResolverFactoryRequestClientInterfaceBase {};

using ProxyResolverFactoryRequestClientPtrDataView =
    mojo::InterfacePtrDataView<ProxyResolverFactoryRequestClientInterfaceBase>;
using ProxyResolverFactoryRequestClientRequestDataView =
    mojo::InterfaceRequestDataView<ProxyResolverFactoryRequestClientInterfaceBase>;
using ProxyResolverFactoryRequestClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ProxyResolverFactoryRequestClientInterfaceBase>;
using ProxyResolverFactoryRequestClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ProxyResolverFactoryRequestClientInterfaceBase>;


class ProxyInfoDataView {
 public:
  ProxyInfoDataView() = default;

  ProxyInfoDataView(
      internal::ProxyInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetProxyChainsDataView(
      mojo::ArrayDataView<::network::mojom::ProxyChainDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadProxyChains(UserType* output) {
    
    auto* pointer = data_->proxy_chains.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::ProxyChainDataView>>(
        pointer, output, message_);
  }
 private:
  internal::ProxyInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SystemProxyResolutionStatusDataView {
 public:
  SystemProxyResolutionStatusDataView() = default;

  SystemProxyResolutionStatusDataView(
      internal::SystemProxyResolutionStatus_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool is_success() const {
    return data_->is_success;
  }
  int32_t os_error() const {
    return data_->os_error;
  }
 private:
  internal::SystemProxyResolutionStatus_Data* data_ = nullptr;
};


}  // proxy_resolver::mojom

#endif  // SERVICES_PROXY_RESOLVER_PUBLIC_MOJOM_PROXY_RESOLVER_MOJOM_DATA_VIEW_H_