// services/preferences/public/mojom/preferences.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_PREFERENCES_PUBLIC_MOJOM_PREFERENCES_MOJOM_H_
#define SERVICES_PREFERENCES_PUBLIC_MOJOM_PREFERENCES_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/preferences/public/mojom/preferences.mojom-features.h"  // IWYU pragma: export
#include "services/preferences/public/mojom/preferences.mojom-shared.h"  // IWYU pragma: export
#include "services/preferences/public/mojom/preferences.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/token.mojom-forward.h"
#include "mojo/public/mojom/base/file_path.mojom.h"
#include "mojo/public/mojom/base/string16.mojom.h"
#include "mojo/public/mojom/base/values.mojom-forward.h"
#include "services/preferences/public/mojom/tracked_preference_validation_delegate.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace prefs::mojom {

class ResetOnLoadObserverProxy;

template <typename ImplRefTraits>
class ResetOnLoadObserverStub;

class ResetOnLoadObserverRequestValidator;


class ResetOnLoadObserver
    : public ResetOnLoadObserverInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "prefs.mojom.ResetOnLoadObserver";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ResetOnLoadObserverInterfaceBase;
  using Proxy_ = ResetOnLoadObserverProxy;

  template <typename ImplRefTraits>
  using Stub_ = ResetOnLoadObserverStub<ImplRefTraits>;

  using RequestValidator_ = ResetOnLoadObserverRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnResetOnLoadMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnResetOnLoad_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ResetOnLoadObserver() = default;

  virtual void OnResetOnLoad() = 0;
};



class  ResetOnLoadObserverProxy
    : public ResetOnLoadObserver {
 public:
  using InterfaceType = ResetOnLoadObserver;

  explicit ResetOnLoadObserverProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnResetOnLoad() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  ResetOnLoadObserverStubDispatch {
 public:
  static bool Accept(ResetOnLoadObserver* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ResetOnLoadObserver* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ResetOnLoadObserver>>
class ResetOnLoadObserverStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ResetOnLoadObserverStub() = default;
  ~ResetOnLoadObserverStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ResetOnLoadObserverStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ResetOnLoadObserverStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ResetOnLoadObserverRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};









class  TrackedPersistentPrefStoreConfiguration {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TrackedPersistentPrefStoreConfiguration, T>::value>;
  using DataView = TrackedPersistentPrefStoreConfigurationDataView;
  using Data_ = internal::TrackedPersistentPrefStoreConfiguration_Data;

  template <typename... Args>
  static TrackedPersistentPrefStoreConfigurationPtr New(Args&&... args) {
    return TrackedPersistentPrefStoreConfigurationPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TrackedPersistentPrefStoreConfigurationPtr From(const U& u) {
    return mojo::TypeConverter<TrackedPersistentPrefStoreConfigurationPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TrackedPersistentPrefStoreConfiguration>::Convert(*this);
  }


  TrackedPersistentPrefStoreConfiguration();

  TrackedPersistentPrefStoreConfiguration(
      const ::base::FilePath& unprotected_pref_filename,
      const ::base::FilePath& protected_pref_filename,
      std::vector<TrackedPreferenceMetadataPtr> tracking_configuration,
      uint64_t reporting_ids_count,
      const std::string& seed,
      const std::string& registry_seed,
      const ::std::u16string& registry_path,
      ::mojo::PendingRemote<::prefs::mojom::TrackedPreferenceValidationDelegate> validation_delegate,
      ::mojo::PendingRemote<ResetOnLoadObserver> reset_on_load_observer);

TrackedPersistentPrefStoreConfiguration(const TrackedPersistentPrefStoreConfiguration&) = delete;
TrackedPersistentPrefStoreConfiguration& operator=(const TrackedPersistentPrefStoreConfiguration&) = delete;

  ~TrackedPersistentPrefStoreConfiguration();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TrackedPersistentPrefStoreConfigurationPtr>
  TrackedPersistentPrefStoreConfigurationPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TrackedPersistentPrefStoreConfiguration::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TrackedPersistentPrefStoreConfiguration::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TrackedPersistentPrefStoreConfiguration::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TrackedPersistentPrefStoreConfiguration::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TrackedPersistentPrefStoreConfiguration_UnserializedMessageContext<
            UserType, TrackedPersistentPrefStoreConfiguration::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TrackedPersistentPrefStoreConfiguration::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TrackedPersistentPrefStoreConfiguration::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TrackedPersistentPrefStoreConfiguration_UnserializedMessageContext<
            UserType, TrackedPersistentPrefStoreConfiguration::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TrackedPersistentPrefStoreConfiguration::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::FilePath unprotected_pref_filename;
  
  ::base::FilePath protected_pref_filename;
  
  std::vector<TrackedPreferenceMetadataPtr> tracking_configuration;
  
  uint64_t reporting_ids_count;
  
  std::string seed;
  
  std::string registry_seed;
  
  ::std::u16string registry_path;
  
  ::mojo::PendingRemote<::prefs::mojom::TrackedPreferenceValidationDelegate> validation_delegate;
  
  ::mojo::PendingRemote<ResetOnLoadObserver> reset_on_load_observer;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TrackedPersistentPrefStoreConfiguration::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TrackedPersistentPrefStoreConfiguration::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TrackedPersistentPrefStoreConfiguration::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TrackedPersistentPrefStoreConfiguration::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  TrackedPreferenceMetadata {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TrackedPreferenceMetadata, T>::value>;
  using DataView = TrackedPreferenceMetadataDataView;
  using Data_ = internal::TrackedPreferenceMetadata_Data;
  using EnforcementLevel = TrackedPreferenceMetadata_EnforcementLevel;
  using PrefTrackingStrategy = TrackedPreferenceMetadata_PrefTrackingStrategy;
  using ValueType = TrackedPreferenceMetadata_ValueType;

  template <typename... Args>
  static TrackedPreferenceMetadataPtr New(Args&&... args) {
    return TrackedPreferenceMetadataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TrackedPreferenceMetadataPtr From(const U& u) {
    return mojo::TypeConverter<TrackedPreferenceMetadataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TrackedPreferenceMetadata>::Convert(*this);
  }


  TrackedPreferenceMetadata();

  TrackedPreferenceMetadata(
      uint64_t reporting_id,
      const std::string& name,
      TrackedPreferenceMetadata::EnforcementLevel enforcement_level,
      TrackedPreferenceMetadata::PrefTrackingStrategy strategy,
      TrackedPreferenceMetadata::ValueType value_type);


  ~TrackedPreferenceMetadata();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TrackedPreferenceMetadataPtr>
  TrackedPreferenceMetadataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TrackedPreferenceMetadata::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TrackedPreferenceMetadata::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TrackedPreferenceMetadata::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TrackedPreferenceMetadata::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TrackedPreferenceMetadata::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TrackedPreferenceMetadata::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TrackedPreferenceMetadata_UnserializedMessageContext<
            UserType, TrackedPreferenceMetadata::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TrackedPreferenceMetadata::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TrackedPreferenceMetadata::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TrackedPreferenceMetadata_UnserializedMessageContext<
            UserType, TrackedPreferenceMetadata::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TrackedPreferenceMetadata::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint64_t reporting_id;
  
  std::string name;
  
  TrackedPreferenceMetadata::EnforcementLevel enforcement_level;
  
  TrackedPreferenceMetadata::PrefTrackingStrategy strategy;
  
  TrackedPreferenceMetadata::ValueType value_type;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TrackedPreferenceMetadata::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TrackedPreferenceMetadata::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TrackedPreferenceMetadata::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TrackedPreferenceMetadata::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
TrackedPersistentPrefStoreConfigurationPtr TrackedPersistentPrefStoreConfiguration::Clone() const {
  return New(
      mojo::Clone(unprotected_pref_filename),
      mojo::Clone(protected_pref_filename),
      mojo::Clone(tracking_configuration),
      mojo::Clone(reporting_ids_count),
      mojo::Clone(seed),
      mojo::Clone(registry_seed),
      mojo::Clone(registry_path),
      mojo::Clone(validation_delegate),
      mojo::Clone(reset_on_load_observer)
  );
}

template <typename T, TrackedPersistentPrefStoreConfiguration::EnableIfSame<T>*>
bool TrackedPersistentPrefStoreConfiguration::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->unprotected_pref_filename, other_struct.unprotected_pref_filename))
    return false;
  if (!mojo::Equals(this->protected_pref_filename, other_struct.protected_pref_filename))
    return false;
  if (!mojo::Equals(this->tracking_configuration, other_struct.tracking_configuration))
    return false;
  if (!mojo::Equals(this->reporting_ids_count, other_struct.reporting_ids_count))
    return false;
  if (!mojo::Equals(this->seed, other_struct.seed))
    return false;
  if (!mojo::Equals(this->registry_seed, other_struct.registry_seed))
    return false;
  if (!mojo::Equals(this->registry_path, other_struct.registry_path))
    return false;
  if (!mojo::Equals(this->validation_delegate, other_struct.validation_delegate))
    return false;
  if (!mojo::Equals(this->reset_on_load_observer, other_struct.reset_on_load_observer))
    return false;
  return true;
}

template <typename T, TrackedPersistentPrefStoreConfiguration::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.unprotected_pref_filename < rhs.unprotected_pref_filename)
    return true;
  if (rhs.unprotected_pref_filename < lhs.unprotected_pref_filename)
    return false;
  if (lhs.protected_pref_filename < rhs.protected_pref_filename)
    return true;
  if (rhs.protected_pref_filename < lhs.protected_pref_filename)
    return false;
  if (lhs.tracking_configuration < rhs.tracking_configuration)
    return true;
  if (rhs.tracking_configuration < lhs.tracking_configuration)
    return false;
  if (lhs.reporting_ids_count < rhs.reporting_ids_count)
    return true;
  if (rhs.reporting_ids_count < lhs.reporting_ids_count)
    return false;
  if (lhs.seed < rhs.seed)
    return true;
  if (rhs.seed < lhs.seed)
    return false;
  if (lhs.registry_seed < rhs.registry_seed)
    return true;
  if (rhs.registry_seed < lhs.registry_seed)
    return false;
  if (lhs.registry_path < rhs.registry_path)
    return true;
  if (rhs.registry_path < lhs.registry_path)
    return false;
  if (lhs.validation_delegate < rhs.validation_delegate)
    return true;
  if (rhs.validation_delegate < lhs.validation_delegate)
    return false;
  if (lhs.reset_on_load_observer < rhs.reset_on_load_observer)
    return true;
  if (rhs.reset_on_load_observer < lhs.reset_on_load_observer)
    return false;
  return false;
}
template <typename StructPtrType>
TrackedPreferenceMetadataPtr TrackedPreferenceMetadata::Clone() const {
  return New(
      mojo::Clone(reporting_id),
      mojo::Clone(name),
      mojo::Clone(enforcement_level),
      mojo::Clone(strategy),
      mojo::Clone(value_type)
  );
}

template <typename T, TrackedPreferenceMetadata::EnableIfSame<T>*>
bool TrackedPreferenceMetadata::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->reporting_id, other_struct.reporting_id))
    return false;
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->enforcement_level, other_struct.enforcement_level))
    return false;
  if (!mojo::Equals(this->strategy, other_struct.strategy))
    return false;
  if (!mojo::Equals(this->value_type, other_struct.value_type))
    return false;
  return true;
}

template <typename T, TrackedPreferenceMetadata::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.reporting_id < rhs.reporting_id)
    return true;
  if (rhs.reporting_id < lhs.reporting_id)
    return false;
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.enforcement_level < rhs.enforcement_level)
    return true;
  if (rhs.enforcement_level < lhs.enforcement_level)
    return false;
  if (lhs.strategy < rhs.strategy)
    return true;
  if (rhs.strategy < lhs.strategy)
    return false;
  if (lhs.value_type < rhs.value_type)
    return true;
  if (rhs.value_type < lhs.value_type)
    return false;
  return false;
}


}  // prefs::mojom

namespace mojo {


template <>
struct  StructTraits<::prefs::mojom::TrackedPersistentPrefStoreConfiguration::DataView,
                                         ::prefs::mojom::TrackedPersistentPrefStoreConfigurationPtr> {
  static bool IsNull(const ::prefs::mojom::TrackedPersistentPrefStoreConfigurationPtr& input) { return !input; }
  static void SetToNull(::prefs::mojom::TrackedPersistentPrefStoreConfigurationPtr* output) { output->reset(); }

  static const decltype(::prefs::mojom::TrackedPersistentPrefStoreConfiguration::unprotected_pref_filename)& unprotected_pref_filename(
      const ::prefs::mojom::TrackedPersistentPrefStoreConfigurationPtr& input) {
    return input->unprotected_pref_filename;
  }

  static const decltype(::prefs::mojom::TrackedPersistentPrefStoreConfiguration::protected_pref_filename)& protected_pref_filename(
      const ::prefs::mojom::TrackedPersistentPrefStoreConfigurationPtr& input) {
    return input->protected_pref_filename;
  }

  static const decltype(::prefs::mojom::TrackedPersistentPrefStoreConfiguration::tracking_configuration)& tracking_configuration(
      const ::prefs::mojom::TrackedPersistentPrefStoreConfigurationPtr& input) {
    return input->tracking_configuration;
  }

  static decltype(::prefs::mojom::TrackedPersistentPrefStoreConfiguration::reporting_ids_count) reporting_ids_count(
      const ::prefs::mojom::TrackedPersistentPrefStoreConfigurationPtr& input) {
    return input->reporting_ids_count;
  }

  static const decltype(::prefs::mojom::TrackedPersistentPrefStoreConfiguration::seed)& seed(
      const ::prefs::mojom::TrackedPersistentPrefStoreConfigurationPtr& input) {
    return input->seed;
  }

  static const decltype(::prefs::mojom::TrackedPersistentPrefStoreConfiguration::registry_seed)& registry_seed(
      const ::prefs::mojom::TrackedPersistentPrefStoreConfigurationPtr& input) {
    return input->registry_seed;
  }

  static const decltype(::prefs::mojom::TrackedPersistentPrefStoreConfiguration::registry_path)& registry_path(
      const ::prefs::mojom::TrackedPersistentPrefStoreConfigurationPtr& input) {
    return input->registry_path;
  }

  static  decltype(::prefs::mojom::TrackedPersistentPrefStoreConfiguration::validation_delegate)& validation_delegate(
       ::prefs::mojom::TrackedPersistentPrefStoreConfigurationPtr& input) {
    return input->validation_delegate;
  }

  static  decltype(::prefs::mojom::TrackedPersistentPrefStoreConfiguration::reset_on_load_observer)& reset_on_load_observer(
       ::prefs::mojom::TrackedPersistentPrefStoreConfigurationPtr& input) {
    return input->reset_on_load_observer;
  }

  static bool Read(::prefs::mojom::TrackedPersistentPrefStoreConfiguration::DataView input, ::prefs::mojom::TrackedPersistentPrefStoreConfigurationPtr* output);
};


template <>
struct  StructTraits<::prefs::mojom::TrackedPreferenceMetadata::DataView,
                                         ::prefs::mojom::TrackedPreferenceMetadataPtr> {
  static bool IsNull(const ::prefs::mojom::TrackedPreferenceMetadataPtr& input) { return !input; }
  static void SetToNull(::prefs::mojom::TrackedPreferenceMetadataPtr* output) { output->reset(); }

  static decltype(::prefs::mojom::TrackedPreferenceMetadata::reporting_id) reporting_id(
      const ::prefs::mojom::TrackedPreferenceMetadataPtr& input) {
    return input->reporting_id;
  }

  static const decltype(::prefs::mojom::TrackedPreferenceMetadata::name)& name(
      const ::prefs::mojom::TrackedPreferenceMetadataPtr& input) {
    return input->name;
  }

  static decltype(::prefs::mojom::TrackedPreferenceMetadata::enforcement_level) enforcement_level(
      const ::prefs::mojom::TrackedPreferenceMetadataPtr& input) {
    return input->enforcement_level;
  }

  static decltype(::prefs::mojom::TrackedPreferenceMetadata::strategy) strategy(
      const ::prefs::mojom::TrackedPreferenceMetadataPtr& input) {
    return input->strategy;
  }

  static decltype(::prefs::mojom::TrackedPreferenceMetadata::value_type) value_type(
      const ::prefs::mojom::TrackedPreferenceMetadataPtr& input) {
    return input->value_type;
  }

  static bool Read(::prefs::mojom::TrackedPreferenceMetadata::DataView input, ::prefs::mojom::TrackedPreferenceMetadataPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_PREFERENCES_PUBLIC_MOJOM_PREFERENCES_MOJOM_H_