// services/preferences/public/mojom/preferences.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_PREFERENCES_PUBLIC_MOJOM_PREFERENCES_MOJOM_SHARED_H_
#define SERVICES_PREFERENCES_PUBLIC_MOJOM_PREFERENCES_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/preferences/public/mojom/preferences.mojom-shared-internal.h"
#include "mojo/public/mojom/base/token.mojom-shared.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/values.mojom-shared.h"
#include "services/preferences/public/mojom/tracked_preference_validation_delegate.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "services/preferences/public/mojom/preferences.mojom-data-view.h"




namespace std {

template <>
struct hash<::prefs::mojom::TrackedPreferenceMetadata_EnforcementLevel>
    : public mojo::internal::EnumHashImpl<::prefs::mojom::TrackedPreferenceMetadata_EnforcementLevel> {};

template <>
struct hash<::prefs::mojom::TrackedPreferenceMetadata_PrefTrackingStrategy>
    : public mojo::internal::EnumHashImpl<::prefs::mojom::TrackedPreferenceMetadata_PrefTrackingStrategy> {};

template <>
struct hash<::prefs::mojom::TrackedPreferenceMetadata_ValueType>
    : public mojo::internal::EnumHashImpl<::prefs::mojom::TrackedPreferenceMetadata_ValueType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::prefs::mojom::TrackedPreferenceMetadata_EnforcementLevel, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::prefs::mojom::TrackedPreferenceMetadata_EnforcementLevel, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::prefs::mojom::TrackedPreferenceMetadata_EnforcementLevel>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::prefs::mojom::TrackedPreferenceMetadata_PrefTrackingStrategy, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::prefs::mojom::TrackedPreferenceMetadata_PrefTrackingStrategy, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::prefs::mojom::TrackedPreferenceMetadata_PrefTrackingStrategy>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::prefs::mojom::TrackedPreferenceMetadata_ValueType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::prefs::mojom::TrackedPreferenceMetadata_ValueType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::prefs::mojom::TrackedPreferenceMetadata_ValueType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::prefs::mojom::TrackedPersistentPrefStoreConfigurationDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::prefs::mojom::TrackedPersistentPrefStoreConfigurationDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::prefs::mojom::internal::TrackedPersistentPrefStoreConfiguration_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::unprotected_pref_filename(input)) in_unprotected_pref_filename = Traits::unprotected_pref_filename(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->unprotected_pref_filename)::BaseType> unprotected_pref_filename_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
      in_unprotected_pref_filename,
      unprotected_pref_filename_fragment);

    fragment->unprotected_pref_filename.Set(
        unprotected_pref_filename_fragment.is_null() ? nullptr : unprotected_pref_filename_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->unprotected_pref_filename.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null unprotected_pref_filename in TrackedPersistentPrefStoreConfiguration struct");

    decltype(Traits::protected_pref_filename(input)) in_protected_pref_filename = Traits::protected_pref_filename(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->protected_pref_filename)::BaseType> protected_pref_filename_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
      in_protected_pref_filename,
      protected_pref_filename_fragment);

    fragment->protected_pref_filename.Set(
        protected_pref_filename_fragment.is_null() ? nullptr : protected_pref_filename_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->protected_pref_filename.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null protected_pref_filename in TrackedPersistentPrefStoreConfiguration struct");

    decltype(Traits::tracking_configuration(input)) in_tracking_configuration = Traits::tracking_configuration(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->tracking_configuration)::BaseType>
        tracking_configuration_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& tracking_configuration_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::prefs::mojom::TrackedPreferenceMetadataDataView>>(
      in_tracking_configuration,
      tracking_configuration_fragment,
      &tracking_configuration_validate_params);

    fragment->tracking_configuration.Set(
        tracking_configuration_fragment.is_null() ? nullptr : tracking_configuration_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->tracking_configuration.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null tracking_configuration in TrackedPersistentPrefStoreConfiguration struct");

    fragment->reporting_ids_count = Traits::reporting_ids_count(input);

    decltype(Traits::seed(input)) in_seed = Traits::seed(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->seed)::BaseType> seed_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_seed,
      seed_fragment);

    fragment->seed.Set(
        seed_fragment.is_null() ? nullptr : seed_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->seed.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null seed in TrackedPersistentPrefStoreConfiguration struct");

    decltype(Traits::registry_seed(input)) in_registry_seed = Traits::registry_seed(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->registry_seed)::BaseType> registry_seed_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_registry_seed,
      registry_seed_fragment);

    fragment->registry_seed.Set(
        registry_seed_fragment.is_null() ? nullptr : registry_seed_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->registry_seed.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null registry_seed in TrackedPersistentPrefStoreConfiguration struct");

    decltype(Traits::registry_path(input)) in_registry_path = Traits::registry_path(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->registry_path)::BaseType> registry_path_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_registry_path,
      registry_path_fragment);

    fragment->registry_path.Set(
        registry_path_fragment.is_null() ? nullptr : registry_path_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->registry_path.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null registry_path in TrackedPersistentPrefStoreConfiguration struct");

    decltype(Traits::validation_delegate(input)) in_validation_delegate = Traits::validation_delegate(input);

    
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::prefs::mojom::TrackedPreferenceValidationDelegateInterfaceBase>>(
      in_validation_delegate,
      &fragment->validation_delegate,
      &fragment.message());

    decltype(Traits::reset_on_load_observer(input)) in_reset_on_load_observer = Traits::reset_on_load_observer(input);

    
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::prefs::mojom::ResetOnLoadObserverInterfaceBase>>(
      in_reset_on_load_observer,
      &fragment->reset_on_load_observer,
      &fragment.message());
  }

  static bool Deserialize(::prefs::mojom::internal::TrackedPersistentPrefStoreConfiguration_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::prefs::mojom::TrackedPersistentPrefStoreConfigurationDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::prefs::mojom::TrackedPreferenceMetadataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::prefs::mojom::TrackedPreferenceMetadataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::prefs::mojom::internal::TrackedPreferenceMetadata_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->reporting_id = Traits::reporting_id(input);

    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_name,
      name_fragment);

    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in TrackedPreferenceMetadata struct");

    
    mojo::internal::Serialize<::prefs::mojom::TrackedPreferenceMetadata_EnforcementLevel>(
      Traits::enforcement_level(input),
      &fragment->enforcement_level);

    
    mojo::internal::Serialize<::prefs::mojom::TrackedPreferenceMetadata_PrefTrackingStrategy>(
      Traits::strategy(input),
      &fragment->strategy);

    
    mojo::internal::Serialize<::prefs::mojom::TrackedPreferenceMetadata_ValueType>(
      Traits::value_type(input),
      &fragment->value_type);
  }

  static bool Deserialize(::prefs::mojom::internal::TrackedPreferenceMetadata_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::prefs::mojom::TrackedPreferenceMetadataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace prefs::mojom {

inline void TrackedPersistentPrefStoreConfigurationDataView::GetUnprotectedPrefFilenameDataView(
    ::mojo_base::mojom::FilePathDataView* output) {
  auto pointer = data_->unprotected_pref_filename.Get();
  *output = ::mojo_base::mojom::FilePathDataView(pointer, message_);
}
inline void TrackedPersistentPrefStoreConfigurationDataView::GetProtectedPrefFilenameDataView(
    ::mojo_base::mojom::FilePathDataView* output) {
  auto pointer = data_->protected_pref_filename.Get();
  *output = ::mojo_base::mojom::FilePathDataView(pointer, message_);
}
inline void TrackedPersistentPrefStoreConfigurationDataView::GetTrackingConfigurationDataView(
    mojo::ArrayDataView<TrackedPreferenceMetadataDataView>* output) {
  auto pointer = data_->tracking_configuration.Get();
  *output = mojo::ArrayDataView<TrackedPreferenceMetadataDataView>(pointer, message_);
}
inline void TrackedPersistentPrefStoreConfigurationDataView::GetSeedDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->seed.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void TrackedPersistentPrefStoreConfigurationDataView::GetRegistrySeedDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->registry_seed.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void TrackedPersistentPrefStoreConfigurationDataView::GetRegistryPathDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->registry_path.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}


inline void TrackedPreferenceMetadataDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}



}  // prefs::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::prefs::mojom::TrackedPreferenceMetadata_EnforcementLevel> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::prefs::mojom::TrackedPreferenceMetadata_EnforcementLevel value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::prefs::mojom::TrackedPreferenceMetadata_PrefTrackingStrategy> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::prefs::mojom::TrackedPreferenceMetadata_PrefTrackingStrategy value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::prefs::mojom::TrackedPreferenceMetadata_ValueType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::prefs::mojom::TrackedPreferenceMetadata_ValueType value);
};

} // namespace perfetto

#endif  // SERVICES_PREFERENCES_PUBLIC_MOJOM_PREFERENCES_MOJOM_SHARED_H_