// services/preferences/public/mojom/preferences.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/preferences/public/mojom/preferences.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/preferences/public/mojom/preferences.mojom-params-data.h"
namespace prefs {
namespace mojom {

NOINLINE static const char* TrackedPreferenceMetadata_EnforcementLevelToStringHelper(TrackedPreferenceMetadata_EnforcementLevel value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case TrackedPreferenceMetadata_EnforcementLevel::NO_ENFORCEMENT:
      return "NO_ENFORCEMENT";
    case TrackedPreferenceMetadata_EnforcementLevel::ENFORCE_ON_LOAD:
      return "ENFORCE_ON_LOAD";
    default:
      return nullptr;
  }
}

std::string TrackedPreferenceMetadata_EnforcementLevelToString(TrackedPreferenceMetadata_EnforcementLevel value) {
  const char *str = TrackedPreferenceMetadata_EnforcementLevelToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown TrackedPreferenceMetadata_EnforcementLevel value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, TrackedPreferenceMetadata_EnforcementLevel value) {
  return os << TrackedPreferenceMetadata_EnforcementLevelToString(value);
}

NOINLINE static const char* TrackedPreferenceMetadata_PrefTrackingStrategyToStringHelper(TrackedPreferenceMetadata_PrefTrackingStrategy value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case TrackedPreferenceMetadata_PrefTrackingStrategy::ATOMIC:
      return "ATOMIC";
    case TrackedPreferenceMetadata_PrefTrackingStrategy::SPLIT:
      return "SPLIT";
    default:
      return nullptr;
  }
}

std::string TrackedPreferenceMetadata_PrefTrackingStrategyToString(TrackedPreferenceMetadata_PrefTrackingStrategy value) {
  const char *str = TrackedPreferenceMetadata_PrefTrackingStrategyToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown TrackedPreferenceMetadata_PrefTrackingStrategy value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, TrackedPreferenceMetadata_PrefTrackingStrategy value) {
  return os << TrackedPreferenceMetadata_PrefTrackingStrategyToString(value);
}

NOINLINE static const char* TrackedPreferenceMetadata_ValueTypeToStringHelper(TrackedPreferenceMetadata_ValueType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case TrackedPreferenceMetadata_ValueType::IMPERSONAL:
      return "IMPERSONAL";
    case TrackedPreferenceMetadata_ValueType::PERSONAL:
      return "PERSONAL";
    default:
      return nullptr;
  }
}

std::string TrackedPreferenceMetadata_ValueTypeToString(TrackedPreferenceMetadata_ValueType value) {
  const char *str = TrackedPreferenceMetadata_ValueTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown TrackedPreferenceMetadata_ValueType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, TrackedPreferenceMetadata_ValueType value) {
  return os << TrackedPreferenceMetadata_ValueTypeToString(value);
}

namespace internal {


// static
bool TrackedPersistentPrefStoreConfiguration_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 80, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TrackedPersistentPrefStoreConfiguration_Data* object =
      static_cast<const TrackedPersistentPrefStoreConfiguration_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->unprotected_pref_filename, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->unprotected_pref_filename, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->protected_pref_filename, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->protected_pref_filename, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->tracking_configuration, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& tracking_configuration_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->tracking_configuration, validation_context,
                                         &tracking_configuration_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->seed, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& seed_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->seed, validation_context,
                                         &seed_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->registry_seed, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& registry_seed_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->registry_seed, validation_context,
                                         &registry_seed_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->registry_path, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->registry_path, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterface(object->validation_delegate,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterface(object->reset_on_load_observer,
                                                 validation_context)) {
    return false;
  }

  return true;
}

TrackedPersistentPrefStoreConfiguration_Data::TrackedPersistentPrefStoreConfiguration_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TrackedPreferenceMetadata_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TrackedPreferenceMetadata_Data* object =
      static_cast<const TrackedPreferenceMetadata_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }


  if (!::prefs::mojom::internal::TrackedPreferenceMetadata_EnforcementLevel_Data
        ::Validate(object->enforcement_level, validation_context))
    return false;


  if (!::prefs::mojom::internal::TrackedPreferenceMetadata_PrefTrackingStrategy_Data
        ::Validate(object->strategy, validation_context))
    return false;


  if (!::prefs::mojom::internal::TrackedPreferenceMetadata_ValueType_Data
        ::Validate(object->value_type, validation_context))
    return false;

  return true;
}

TrackedPreferenceMetadata_Data::TrackedPreferenceMetadata_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ResetOnLoadObserver_OnResetOnLoad_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ResetOnLoadObserver_OnResetOnLoad_Params_Data* object =
      static_cast<const ResetOnLoadObserver_OnResetOnLoad_Params_Data*>(data);

  return true;
}

ResetOnLoadObserver_OnResetOnLoad_Params_Data::ResetOnLoadObserver_OnResetOnLoad_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace prefs

namespace perfetto {

// static
void TraceFormatTraits<::prefs::mojom::TrackedPreferenceMetadata_EnforcementLevel>::WriteIntoTrace(
   perfetto::TracedValue context, ::prefs::mojom::TrackedPreferenceMetadata_EnforcementLevel value) {
  return std::move(context).WriteString(::prefs::mojom::TrackedPreferenceMetadata_EnforcementLevelToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::prefs::mojom::TrackedPreferenceMetadata_PrefTrackingStrategy>::WriteIntoTrace(
   perfetto::TracedValue context, ::prefs::mojom::TrackedPreferenceMetadata_PrefTrackingStrategy value) {
  return std::move(context).WriteString(::prefs::mojom::TrackedPreferenceMetadata_PrefTrackingStrategyToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::prefs::mojom::TrackedPreferenceMetadata_ValueType>::WriteIntoTrace(
   perfetto::TracedValue context, ::prefs::mojom::TrackedPreferenceMetadata_ValueType value) {
  return std::move(context).WriteString(::prefs::mojom::TrackedPreferenceMetadata_ValueTypeToString(value));
}

} // namespace perfetto