// services/passage_embeddings/public/mojom/passage_embeddings.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/passage_embeddings/public/mojom/passage_embeddings.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/passage_embeddings/public/mojom/passage_embeddings.mojom-params-data.h"
#include "services/passage_embeddings/public/mojom/passage_embeddings.mojom-shared-message-ids.h"

#include "services/passage_embeddings/public/mojom/passage_embeddings.mojom-import-headers.h"
#include "services/passage_embeddings/public/mojom/passage_embeddings.mojom-test-utils.h"


namespace passage_embeddings::mojom {
PassageEmbeddingsResult::PassageEmbeddingsResult()
    : embeddings() {}

PassageEmbeddingsResult::PassageEmbeddingsResult(
    std::vector<float> embeddings_in)
    : embeddings(std::move(embeddings_in)) {}

PassageEmbeddingsResult::~PassageEmbeddingsResult() = default;

void PassageEmbeddingsResult::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "embeddings"), this->embeddings,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<float>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PassageEmbeddingsResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PassageEmbeddingsLoadModelsParams::PassageEmbeddingsLoadModelsParams()
    : embeddings_model(),
      sp_model(),
      input_window_size() {}

PassageEmbeddingsLoadModelsParams::PassageEmbeddingsLoadModelsParams(
    ::base::File embeddings_model_in,
    ::base::File sp_model_in,
    uint32_t input_window_size_in)
    : embeddings_model(std::move(embeddings_model_in)),
      sp_model(std::move(sp_model_in)),
      input_window_size(std::move(input_window_size_in)) {}

PassageEmbeddingsLoadModelsParams::~PassageEmbeddingsLoadModelsParams() = default;

void PassageEmbeddingsLoadModelsParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "embeddings_model"), this->embeddings_model,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::File>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sp_model"), this->sp_model,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::File>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_window_size"), this->input_window_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PassageEmbeddingsLoadModelsParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PassageEmbedderParams::PassageEmbedderParams()
    : user_initiated_priority_num_threads(),
      urgent_priority_num_threads(),
      passive_priority_num_threads(),
      embedder_cache_size(),
      allow_gpu_execution() {}

PassageEmbedderParams::PassageEmbedderParams(
    uint32_t user_initiated_priority_num_threads_in,
    uint32_t urgent_priority_num_threads_in,
    uint32_t passive_priority_num_threads_in,
    uint32_t embedder_cache_size_in,
    bool allow_gpu_execution_in)
    : user_initiated_priority_num_threads(std::move(user_initiated_priority_num_threads_in)),
      urgent_priority_num_threads(std::move(urgent_priority_num_threads_in)),
      passive_priority_num_threads(std::move(passive_priority_num_threads_in)),
      embedder_cache_size(std::move(embedder_cache_size_in)),
      allow_gpu_execution(std::move(allow_gpu_execution_in)) {}

PassageEmbedderParams::~PassageEmbedderParams() = default;
size_t PassageEmbedderParams::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->user_initiated_priority_num_threads);
  seed = mojo::internal::Hash(seed, this->urgent_priority_num_threads);
  seed = mojo::internal::Hash(seed, this->passive_priority_num_threads);
  seed = mojo::internal::Hash(seed, this->embedder_cache_size);
  seed = mojo::internal::Hash(seed, this->allow_gpu_execution);
  return seed;
}

void PassageEmbedderParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "user_initiated_priority_num_threads"), this->user_initiated_priority_num_threads,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "urgent_priority_num_threads"), this->urgent_priority_num_threads,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "passive_priority_num_threads"), this->passive_priority_num_threads,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "embedder_cache_size"), this->embedder_cache_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allow_gpu_execution"), this->allow_gpu_execution,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PassageEmbedderParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

PassageEmbedder::IPCStableHashFunction PassageEmbedder::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PassageEmbedder>(message.name())) {
    case messages::PassageEmbedder::kGenerateEmbeddings: {
      return &PassageEmbedder::GenerateEmbeddings_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PassageEmbedder::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PassageEmbedder>(message.name())) {
      case messages::PassageEmbedder::kGenerateEmbeddings:
            return "Receive passage_embeddings::mojom::PassageEmbedder::GenerateEmbeddings";
    }
  } else {
    switch (static_cast<messages::PassageEmbedder>(message.name())) {
      case messages::PassageEmbedder::kGenerateEmbeddings:
            return "Receive reply passage_embeddings::mojom::PassageEmbedder::GenerateEmbeddings";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PassageEmbedder::GenerateEmbeddings_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x85d052cd;  // IPCStableHash for passage_embeddings::mojom::PassageEmbedder::GenerateEmbeddings
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class PassageEmbedder_GenerateEmbeddings_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PassageEmbedder_GenerateEmbeddings_ForwardToCallback(
      PassageEmbedder::GenerateEmbeddingsCallback callback
      ) : callback_(std::move(callback)) {
  }

  PassageEmbedder_GenerateEmbeddings_ForwardToCallback(const PassageEmbedder_GenerateEmbeddings_ForwardToCallback&) = delete;
  PassageEmbedder_GenerateEmbeddings_ForwardToCallback& operator=(const PassageEmbedder_GenerateEmbeddings_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PassageEmbedder::GenerateEmbeddingsCallback callback_;
};

PassageEmbedderProxy::PassageEmbedderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PassageEmbedderProxy::GenerateEmbeddings(
    const std::vector<std::string>& in_passages, PassagePriority in_priority, GenerateEmbeddingsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send passage_embeddings::mojom::PassageEmbedder::GenerateEmbeddings", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("passages"), in_passages,
                        "<value of type const std::vector<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("priority"), in_priority,
                        "<value of type PassagePriority>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PassageEmbedder::kGenerateEmbeddings), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::passage_embeddings::mojom::internal::PassageEmbedder_GenerateEmbeddings_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->passages)::BaseType>
      passages_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& passages_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
    in_passages,
    passages_fragment,
    &passages_validate_params);

  params->passages.Set(
      passages_fragment.is_null() ? nullptr : passages_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->passages.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null passages in PassageEmbedder.GenerateEmbeddings request");

  
  mojo::internal::Serialize<::passage_embeddings::mojom::PassagePriority>(
    in_priority,
    &params->priority);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PassageEmbedder::Name_);
  message.set_method_name("GenerateEmbeddings");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PassageEmbedder_GenerateEmbeddings_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class PassageEmbedder_GenerateEmbeddings_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PassageEmbedder::GenerateEmbeddingsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PassageEmbedder_GenerateEmbeddings_ProxyToResponder> proxy(
        new PassageEmbedder_GenerateEmbeddings_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PassageEmbedder_GenerateEmbeddings_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PassageEmbedder_GenerateEmbeddings_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PassageEmbedder_GenerateEmbeddings_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PassageEmbedder::GenerateEmbeddingsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<PassageEmbeddingsResultPtr> in_results);
};

bool PassageEmbedder_GenerateEmbeddings_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PassageEmbedder_GenerateEmbeddings_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PassageEmbedder_GenerateEmbeddings_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PassageEmbedder.0
  bool success = true;
  std::vector<PassageEmbeddingsResultPtr> p_results{};
  PassageEmbedder_GenerateEmbeddings_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResults(&p_results))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PassageEmbedder::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_results));
  }
  return true;
}

void PassageEmbedder_GenerateEmbeddings_ProxyToResponder::Run(
    std::vector<PassageEmbeddingsResultPtr> in_results) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply passage_embeddings::mojom::PassageEmbedder::GenerateEmbeddings", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("results"), in_results,
                        "<value of type std::vector<PassageEmbeddingsResultPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PassageEmbedder::kGenerateEmbeddings), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::passage_embeddings::mojom::internal::PassageEmbedder_GenerateEmbeddings_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->results)::BaseType>
      results_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& results_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::passage_embeddings::mojom::PassageEmbeddingsResultDataView>>(
    in_results,
    results_fragment,
    &results_validate_params);

  params->results.Set(
      results_fragment.is_null() ? nullptr : results_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->results.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null results in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PassageEmbedder::Name_);
  message.set_method_name("GenerateEmbeddings");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PassageEmbedderStubDispatch::Accept(
    PassageEmbedder* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PassageEmbedder>(message->header()->name)) {
    case messages::PassageEmbedder::kGenerateEmbeddings: {
      break;
    }
  }
  return false;
}

// static
bool PassageEmbedderStubDispatch::AcceptWithResponder(
    PassageEmbedder* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PassageEmbedder>(message->header()->name)) {
    case messages::PassageEmbedder::kGenerateEmbeddings: {
      internal::PassageEmbedder_GenerateEmbeddings_Params_Data* params =
          reinterpret_cast<
              internal::PassageEmbedder_GenerateEmbeddings_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PassageEmbedder.0
      bool success = true;
      std::vector<std::string> p_passages{};
      PassagePriority p_priority{};
      PassageEmbedder_GenerateEmbeddings_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPassages(&p_passages))
        success = false;
      if (success && !input_data_view.ReadPriority(&p_priority))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PassageEmbedder::Name_, 0, false);
        return false;
      }
      auto callback =
          PassageEmbedder_GenerateEmbeddings_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GenerateEmbeddings(        
        std::move(p_passages), 
        std::move(p_priority), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPassageEmbedderValidationInfo[] = {
    { &internal::PassageEmbedder_GenerateEmbeddings_Params_Data::Validate,
     &internal::PassageEmbedder_GenerateEmbeddings_ResponseParams_Data::Validate},
};

bool PassageEmbedderRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::passage_embeddings::mojom::PassageEmbedder::Name_,
    kPassageEmbedderValidationInfo);
}

bool PassageEmbedderResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::passage_embeddings::mojom::PassageEmbedder::Name_,
    kPassageEmbedderValidationInfo);
}
// The declaration includes the definition on other builds.

PassageEmbeddingsService::IPCStableHashFunction PassageEmbeddingsService::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PassageEmbeddingsService>(message.name())) {
    case messages::PassageEmbeddingsService::kLoadModels: {
      return &PassageEmbeddingsService::LoadModels_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PassageEmbeddingsService::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PassageEmbeddingsService>(message.name())) {
      case messages::PassageEmbeddingsService::kLoadModels:
            return "Receive passage_embeddings::mojom::PassageEmbeddingsService::LoadModels";
    }
  } else {
    switch (static_cast<messages::PassageEmbeddingsService>(message.name())) {
      case messages::PassageEmbeddingsService::kLoadModels:
            return "Receive reply passage_embeddings::mojom::PassageEmbeddingsService::LoadModels";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PassageEmbeddingsService::LoadModels_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x208b63f7;  // IPCStableHash for passage_embeddings::mojom::PassageEmbeddingsService::LoadModels
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class PassageEmbeddingsService_LoadModels_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PassageEmbeddingsService_LoadModels_ForwardToCallback(
      PassageEmbeddingsService::LoadModelsCallback callback
      ) : callback_(std::move(callback)) {
  }

  PassageEmbeddingsService_LoadModels_ForwardToCallback(const PassageEmbeddingsService_LoadModels_ForwardToCallback&) = delete;
  PassageEmbeddingsService_LoadModels_ForwardToCallback& operator=(const PassageEmbeddingsService_LoadModels_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PassageEmbeddingsService::LoadModelsCallback callback_;
};

PassageEmbeddingsServiceProxy::PassageEmbeddingsServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PassageEmbeddingsServiceProxy::LoadModels(
    PassageEmbeddingsLoadModelsParamsPtr in_model_params, PassageEmbedderParamsPtr in_params, ::mojo::PendingReceiver<PassageEmbedder> in_model, LoadModelsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send passage_embeddings::mojom::PassageEmbeddingsService::LoadModels", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("model_params"), in_model_params,
                        "<value of type PassageEmbeddingsLoadModelsParamsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type PassageEmbedderParamsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("model"), in_model,
                        "<value of type ::mojo::PendingReceiver<PassageEmbedder>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PassageEmbeddingsService::kLoadModels), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::passage_embeddings::mojom::internal::PassageEmbeddingsService_LoadModels_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->model_params)::BaseType> model_params_fragment(
          params.message());
  
  mojo::internal::Serialize<::passage_embeddings::mojom::PassageEmbeddingsLoadModelsParamsDataView>(
    in_model_params,
    model_params_fragment);

  params->model_params.Set(
      model_params_fragment.is_null() ? nullptr : model_params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->model_params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null model_params in PassageEmbeddingsService.LoadModels request");
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  
  mojo::internal::Serialize<::passage_embeddings::mojom::PassageEmbedderParamsDataView>(
    in_params,
    params_fragment);

  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null params in PassageEmbeddingsService.LoadModels request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::passage_embeddings::mojom::PassageEmbedderInterfaceBase>>(
    in_model,
    &params->model,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->model)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid model in PassageEmbeddingsService.LoadModels request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PassageEmbeddingsService::Name_);
  message.set_method_name("LoadModels");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PassageEmbeddingsService_LoadModels_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class PassageEmbeddingsService_LoadModels_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PassageEmbeddingsService::LoadModelsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PassageEmbeddingsService_LoadModels_ProxyToResponder> proxy(
        new PassageEmbeddingsService_LoadModels_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PassageEmbeddingsService_LoadModels_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PassageEmbeddingsService_LoadModels_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PassageEmbeddingsService_LoadModels_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PassageEmbeddingsService::LoadModelsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool PassageEmbeddingsService_LoadModels_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PassageEmbeddingsService_LoadModels_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PassageEmbeddingsService_LoadModels_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PassageEmbeddingsService.0
  bool success = true;
  bool p_success{};
  PassageEmbeddingsService_LoadModels_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PassageEmbeddingsService::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void PassageEmbeddingsService_LoadModels_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply passage_embeddings::mojom::PassageEmbeddingsService::LoadModels", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PassageEmbeddingsService::kLoadModels), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::passage_embeddings::mojom::internal::PassageEmbeddingsService_LoadModels_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PassageEmbeddingsService::Name_);
  message.set_method_name("LoadModels");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PassageEmbeddingsServiceStubDispatch::Accept(
    PassageEmbeddingsService* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PassageEmbeddingsService>(message->header()->name)) {
    case messages::PassageEmbeddingsService::kLoadModels: {
      break;
    }
  }
  return false;
}

// static
bool PassageEmbeddingsServiceStubDispatch::AcceptWithResponder(
    PassageEmbeddingsService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PassageEmbeddingsService>(message->header()->name)) {
    case messages::PassageEmbeddingsService::kLoadModels: {
      internal::PassageEmbeddingsService_LoadModels_Params_Data* params =
          reinterpret_cast<
              internal::PassageEmbeddingsService_LoadModels_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PassageEmbeddingsService.0
      bool success = true;
      PassageEmbeddingsLoadModelsParamsPtr p_model_params{};
      PassageEmbedderParamsPtr p_params{};
      ::mojo::PendingReceiver<PassageEmbedder> p_model{};
      PassageEmbeddingsService_LoadModels_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadModelParams(&p_model_params))
        success = false;
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (success) {
        p_model =
            input_data_view.TakeModel<decltype(p_model)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PassageEmbeddingsService::Name_, 0, false);
        return false;
      }
      auto callback =
          PassageEmbeddingsService_LoadModels_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->LoadModels(        
        std::move(p_model_params), 
        std::move(p_params), 
        std::move(p_model), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPassageEmbeddingsServiceValidationInfo[] = {
    { &internal::PassageEmbeddingsService_LoadModels_Params_Data::Validate,
     &internal::PassageEmbeddingsService_LoadModels_ResponseParams_Data::Validate},
};

bool PassageEmbeddingsServiceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::passage_embeddings::mojom::PassageEmbeddingsService::Name_,
    kPassageEmbeddingsServiceValidationInfo);
}

bool PassageEmbeddingsServiceResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::passage_embeddings::mojom::PassageEmbeddingsService::Name_,
    kPassageEmbeddingsServiceValidationInfo);
}


}  // passage_embeddings::mojom


namespace mojo {


// static
bool StructTraits<::passage_embeddings::mojom::PassageEmbeddingsResult::DataView, ::passage_embeddings::mojom::PassageEmbeddingsResultPtr>::Read(
    ::passage_embeddings::mojom::PassageEmbeddingsResult::DataView input,
    ::passage_embeddings::mojom::PassageEmbeddingsResultPtr* output) {
  bool success = true;
  ::passage_embeddings::mojom::PassageEmbeddingsResultPtr result(::passage_embeddings::mojom::PassageEmbeddingsResult::New());
  
      if (success && !input.ReadEmbeddings(&result->embeddings))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::passage_embeddings::mojom::PassageEmbeddingsLoadModelsParams::DataView, ::passage_embeddings::mojom::PassageEmbeddingsLoadModelsParamsPtr>::Read(
    ::passage_embeddings::mojom::PassageEmbeddingsLoadModelsParams::DataView input,
    ::passage_embeddings::mojom::PassageEmbeddingsLoadModelsParamsPtr* output) {
  bool success = true;
  ::passage_embeddings::mojom::PassageEmbeddingsLoadModelsParamsPtr result(::passage_embeddings::mojom::PassageEmbeddingsLoadModelsParams::New());
  
      if (success && !input.ReadEmbeddingsModel(&result->embeddings_model))
        success = false;
      if (success && !input.ReadSpModel(&result->sp_model))
        success = false;
      if (success)
        result->input_window_size = input.input_window_size();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::passage_embeddings::mojom::PassageEmbedderParams::DataView, ::passage_embeddings::mojom::PassageEmbedderParamsPtr>::Read(
    ::passage_embeddings::mojom::PassageEmbedderParams::DataView input,
    ::passage_embeddings::mojom::PassageEmbedderParamsPtr* output) {
  bool success = true;
  ::passage_embeddings::mojom::PassageEmbedderParamsPtr result(::passage_embeddings::mojom::PassageEmbedderParams::New());
  
      if (success)
        result->user_initiated_priority_num_threads = input.user_initiated_priority_num_threads();
      if (success)
        result->urgent_priority_num_threads = input.urgent_priority_num_threads();
      if (success)
        result->passive_priority_num_threads = input.passive_priority_num_threads();
      if (success)
        result->embedder_cache_size = input.embedder_cache_size();
      if (success)
        result->allow_gpu_execution = input.allow_gpu_execution();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace passage_embeddings::mojom {


void PassageEmbedderInterceptorForTesting::GenerateEmbeddings(const std::vector<std::string>& passages, PassagePriority priority, GenerateEmbeddingsCallback callback) {
  GetForwardingInterface()->GenerateEmbeddings(
    std::move(passages)
    , 
    std::move(priority)
    , std::move(callback));
}
PassageEmbedderAsyncWaiter::PassageEmbedderAsyncWaiter(
    PassageEmbedder* proxy) : proxy_(proxy) {}

PassageEmbedderAsyncWaiter::~PassageEmbedderAsyncWaiter() = default;


void PassageEmbedderAsyncWaiter::GenerateEmbeddings(
    const std::vector<std::string>& passages, PassagePriority priority, std::vector<PassageEmbeddingsResultPtr>* out_results) {
  base::RunLoop loop;
  proxy_->GenerateEmbeddings(
      std::move(passages),
      std::move(priority),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<PassageEmbeddingsResultPtr>* out_results
,
             std::vector<PassageEmbeddingsResultPtr> results) {*out_results = std::move(results);
            loop->Quit();
          },
          &loop,
          out_results));
  loop.Run();
}

std::vector<PassageEmbeddingsResultPtr> PassageEmbedderAsyncWaiter::GenerateEmbeddings(
    const std::vector<std::string>& passages, PassagePriority priority) {
  std::vector<PassageEmbeddingsResultPtr> async_wait_result;
  GenerateEmbeddings(std::move(passages),std::move(priority),&async_wait_result);
  return async_wait_result;
}




void PassageEmbeddingsServiceInterceptorForTesting::LoadModels(PassageEmbeddingsLoadModelsParamsPtr model_params, PassageEmbedderParamsPtr params, ::mojo::PendingReceiver<PassageEmbedder> model, LoadModelsCallback callback) {
  GetForwardingInterface()->LoadModels(
    std::move(model_params)
    , 
    std::move(params)
    , 
    std::move(model)
    , std::move(callback));
}
PassageEmbeddingsServiceAsyncWaiter::PassageEmbeddingsServiceAsyncWaiter(
    PassageEmbeddingsService* proxy) : proxy_(proxy) {}

PassageEmbeddingsServiceAsyncWaiter::~PassageEmbeddingsServiceAsyncWaiter() = default;


void PassageEmbeddingsServiceAsyncWaiter::LoadModels(
    PassageEmbeddingsLoadModelsParamsPtr model_params, PassageEmbedderParamsPtr params, ::mojo::PendingReceiver<PassageEmbedder> model, bool* out_success) {
  base::RunLoop loop;
  proxy_->LoadModels(
      std::move(model_params),
      std::move(params),
      std::move(model),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool PassageEmbeddingsServiceAsyncWaiter::LoadModels(
    PassageEmbeddingsLoadModelsParamsPtr model_params, PassageEmbedderParamsPtr params, ::mojo::PendingReceiver<PassageEmbedder> model) {
  bool async_wait_result;
  LoadModels(std::move(model_params),std::move(params),std::move(model),&async_wait_result);
  return async_wait_result;
}






}  // passage_embeddings::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif