// services/passage_embeddings/public/mojom/passage_embeddings.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_PASSAGE_EMBEDDINGS_PUBLIC_MOJOM_PASSAGE_EMBEDDINGS_MOJOM_SHARED_H_
#define SERVICES_PASSAGE_EMBEDDINGS_PUBLIC_MOJOM_PASSAGE_EMBEDDINGS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/passage_embeddings/public/mojom/passage_embeddings.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "sandbox/policy/mojom/context.mojom-shared.h"
#include "sandbox/policy/mojom/sandbox.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "services/passage_embeddings/public/mojom/passage_embeddings.mojom-data-view.h"




namespace std {

template <>
struct hash<::passage_embeddings::mojom::PassagePriority>
    : public mojo::internal::EnumHashImpl<::passage_embeddings::mojom::PassagePriority> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::passage_embeddings::mojom::PassagePriority, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::passage_embeddings::mojom::PassagePriority, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::passage_embeddings::mojom::PassagePriority>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::passage_embeddings::mojom::PassageEmbeddingsResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::passage_embeddings::mojom::PassageEmbeddingsResultDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::passage_embeddings::mojom::internal::PassageEmbeddingsResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::embeddings(input)) in_embeddings = Traits::embeddings(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->embeddings)::BaseType>
        embeddings_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& embeddings_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<float>>(
      in_embeddings,
      embeddings_fragment,
      &embeddings_validate_params);

    fragment->embeddings.Set(
        embeddings_fragment.is_null() ? nullptr : embeddings_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->embeddings.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null embeddings in PassageEmbeddingsResult struct");
  }

  static bool Deserialize(::passage_embeddings::mojom::internal::PassageEmbeddingsResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::passage_embeddings::mojom::PassageEmbeddingsResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::passage_embeddings::mojom::PassageEmbeddingsLoadModelsParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::passage_embeddings::mojom::PassageEmbeddingsLoadModelsParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::passage_embeddings::mojom::internal::PassageEmbeddingsLoadModelsParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::embeddings_model(input)) in_embeddings_model = Traits::embeddings_model(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->embeddings_model)::BaseType> embeddings_model_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::ReadOnlyFileDataView>(
      in_embeddings_model,
      embeddings_model_fragment);

    fragment->embeddings_model.Set(
        embeddings_model_fragment.is_null() ? nullptr : embeddings_model_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->embeddings_model.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null embeddings_model in PassageEmbeddingsLoadModelsParams struct");

    decltype(Traits::sp_model(input)) in_sp_model = Traits::sp_model(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->sp_model)::BaseType> sp_model_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::ReadOnlyFileDataView>(
      in_sp_model,
      sp_model_fragment);

    fragment->sp_model.Set(
        sp_model_fragment.is_null() ? nullptr : sp_model_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->sp_model.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null sp_model in PassageEmbeddingsLoadModelsParams struct");

    fragment->input_window_size = Traits::input_window_size(input);
  }

  static bool Deserialize(::passage_embeddings::mojom::internal::PassageEmbeddingsLoadModelsParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::passage_embeddings::mojom::PassageEmbeddingsLoadModelsParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::passage_embeddings::mojom::PassageEmbedderParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::passage_embeddings::mojom::PassageEmbedderParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::passage_embeddings::mojom::internal::PassageEmbedderParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->user_initiated_priority_num_threads = Traits::user_initiated_priority_num_threads(input);

    fragment->urgent_priority_num_threads = Traits::urgent_priority_num_threads(input);

    fragment->passive_priority_num_threads = Traits::passive_priority_num_threads(input);

    fragment->embedder_cache_size = Traits::embedder_cache_size(input);

    fragment->allow_gpu_execution = Traits::allow_gpu_execution(input);
  }

  static bool Deserialize(::passage_embeddings::mojom::internal::PassageEmbedderParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::passage_embeddings::mojom::PassageEmbedderParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace passage_embeddings::mojom {

inline void PassageEmbeddingsResultDataView::GetEmbeddingsDataView(
    mojo::ArrayDataView<float>* output) {
  auto pointer = data_->embeddings.Get();
  *output = mojo::ArrayDataView<float>(pointer, message_);
}


inline void PassageEmbeddingsLoadModelsParamsDataView::GetEmbeddingsModelDataView(
    ::mojo_base::mojom::ReadOnlyFileDataView* output) {
  auto pointer = data_->embeddings_model.Get();
  *output = ::mojo_base::mojom::ReadOnlyFileDataView(pointer, message_);
}
inline void PassageEmbeddingsLoadModelsParamsDataView::GetSpModelDataView(
    ::mojo_base::mojom::ReadOnlyFileDataView* output) {
  auto pointer = data_->sp_model.Get();
  *output = ::mojo_base::mojom::ReadOnlyFileDataView(pointer, message_);
}





}  // passage_embeddings::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::passage_embeddings::mojom::PassagePriority> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::passage_embeddings::mojom::PassagePriority value);
};

} // namespace perfetto

#endif  // SERVICES_PASSAGE_EMBEDDINGS_PUBLIC_MOJOM_PASSAGE_EMBEDDINGS_MOJOM_SHARED_H_