// services/passage_embeddings/public/mojom/passage_embeddings.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/passage_embeddings/public/mojom/passage_embeddings.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/passage_embeddings/public/mojom/passage_embeddings.mojom-params-data.h"
namespace passage_embeddings {
namespace mojom {

NOINLINE static const char* PassagePriorityToStringHelper(PassagePriority value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case PassagePriority::kUnknown:
      return "kUnknown";
    case PassagePriority::kUrgent:
      return "kUrgent";
    case PassagePriority::kUserInitiated:
      return "kUserInitiated";
    case PassagePriority::kPassive:
      return "kPassive";
    default:
      return nullptr;
  }
}

std::string PassagePriorityToString(PassagePriority value) {
  const char *str = PassagePriorityToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown PassagePriority value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, PassagePriority value) {
  return os << PassagePriorityToString(value);
}

namespace internal {


// static
bool PassageEmbeddingsResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PassageEmbeddingsResult_Data* object =
      static_cast<const PassageEmbeddingsResult_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->embeddings, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& embeddings_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->embeddings, validation_context,
                                         &embeddings_validate_params)) {
    return false;
  }

  return true;
}

PassageEmbeddingsResult_Data::PassageEmbeddingsResult_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PassageEmbeddingsLoadModelsParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PassageEmbeddingsLoadModelsParams_Data* object =
      static_cast<const PassageEmbeddingsLoadModelsParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->embeddings_model, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->embeddings_model, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->sp_model, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->sp_model, validation_context))
    return false;

  return true;
}

PassageEmbeddingsLoadModelsParams_Data::PassageEmbeddingsLoadModelsParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PassageEmbedderParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PassageEmbedderParams_Data* object =
      static_cast<const PassageEmbedderParams_Data*>(data);

  return true;
}

PassageEmbedderParams_Data::PassageEmbedderParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PassageEmbedder_GenerateEmbeddings_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PassageEmbedder_GenerateEmbeddings_Params_Data* object =
      static_cast<const PassageEmbedder_GenerateEmbeddings_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->passages, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& passages_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->passages, validation_context,
                                         &passages_validate_params)) {
    return false;
  }


  if (!::passage_embeddings::mojom::internal::PassagePriority_Data
        ::Validate(object->priority, validation_context))
    return false;

  return true;
}

PassageEmbedder_GenerateEmbeddings_Params_Data::PassageEmbedder_GenerateEmbeddings_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PassageEmbedder_GenerateEmbeddings_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PassageEmbedder_GenerateEmbeddings_ResponseParams_Data* object =
      static_cast<const PassageEmbedder_GenerateEmbeddings_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->results, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& results_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->results, validation_context,
                                         &results_validate_params)) {
    return false;
  }

  return true;
}

PassageEmbedder_GenerateEmbeddings_ResponseParams_Data::PassageEmbedder_GenerateEmbeddings_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PassageEmbeddingsService_LoadModels_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PassageEmbeddingsService_LoadModels_Params_Data* object =
      static_cast<const PassageEmbeddingsService_LoadModels_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->model_params, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->model_params, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->model, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->model,
                                                 validation_context)) {
    return false;
  }

  return true;
}

PassageEmbeddingsService_LoadModels_Params_Data::PassageEmbeddingsService_LoadModels_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PassageEmbeddingsService_LoadModels_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PassageEmbeddingsService_LoadModels_ResponseParams_Data* object =
      static_cast<const PassageEmbeddingsService_LoadModels_ResponseParams_Data*>(data);

  return true;
}

PassageEmbeddingsService_LoadModels_ResponseParams_Data::PassageEmbeddingsService_LoadModels_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace passage_embeddings

namespace perfetto {

// static
void TraceFormatTraits<::passage_embeddings::mojom::PassagePriority>::WriteIntoTrace(
   perfetto::TracedValue context, ::passage_embeddings::mojom::PassagePriority value) {
  return std::move(context).WriteString(::passage_embeddings::mojom::PassagePriorityToString(value));
}

} // namespace perfetto