// services/on_device_model/public/mojom/on_device_model_service.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';

import {
  File as mojoBase_mojom_File,
  FileSpec as mojoBase_mojom_FileSpec,
  ReadOnlyFile as mojoBase_mojom_ReadOnlyFile,
  ReadOnlyFileSpec as mojoBase_mojom_ReadOnlyFileSpec
} from '../../../../mojo/public/mojom/base/file.mojom.m.js';

import {
  FilePath as mojoBase_mojom_FilePath,
  FilePathSpec as mojoBase_mojom_FilePathSpec
} from '../../../../mojo/public/mojom/base/file_path.mojom.m.js';

import {
  Uuid as mojoBase_mojom_Uuid,
  UuidSpec as mojoBase_mojom_UuidSpec
} from '../../../../mojo/public/mojom/base/uuid.mojom.m.js';

import {
  LoadModelResult as onDeviceModel_mojom_LoadModelResult,
  LoadModelResultSpec as onDeviceModel_mojom_LoadModelResultSpec,
  PerformanceClass as onDeviceModel_mojom_PerformanceClass,
  PerformanceClassSpec as onDeviceModel_mojom_PerformanceClassSpec,
  OnDeviceModelRemote as onDeviceModel_mojom_OnDeviceModelRemote,
  OnDeviceModelPendingReceiver as onDeviceModel_mojom_OnDeviceModelPendingReceiver,
  TextSafetyModelRemote as onDeviceModel_mojom_TextSafetyModelRemote,
  TextSafetyModelPendingReceiver as onDeviceModel_mojom_TextSafetyModelPendingReceiver,
  Capabilities as onDeviceModel_mojom_Capabilities,
  CapabilitiesSpec as onDeviceModel_mojom_CapabilitiesSpec,
  DeviceInfo as onDeviceModel_mojom_DeviceInfo,
  DeviceInfoSpec as onDeviceModel_mojom_DeviceInfoSpec,
  DevicePerformanceInfo as onDeviceModel_mojom_DevicePerformanceInfo,
  DevicePerformanceInfoSpec as onDeviceModel_mojom_DevicePerformanceInfoSpec,
  SafetyInfo as onDeviceModel_mojom_SafetyInfo,
  SafetyInfoSpec as onDeviceModel_mojom_SafetyInfoSpec
} from './on_device_model.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const ModelBackendTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const ModelBackendType = {
  
  kGpu: 0,
  kApu: 1,
  kCpu: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const ModelPerformanceHintSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const ModelPerformanceHint = {
  
  kHighestQuality: 0,
  kFastestInference: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const PlatformModelStateSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const PlatformModelState = {
  
  kUnknownState: 0,
  kInstalledOnDisk: 1,
  kInvalidUuid: 2,
  kInvalidDlcClient: 3,
  kInvalidDlcPackage: 4,
  kInvalidDlcVerifiedState: 5,
  kInvalidDlcInstall: 6,
  kInvalidModelFormat: 7,
  kInvalidModelDescriptor: 8,
  kInvalidBaseModelDescriptor: 9,
  MIN_VALUE: 0,
  MAX_VALUE: 9,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const FormatFeatureSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const FormatFeature = {
  
  kNone: 0,
  kPrompt: 1,
  kAudioSummary: 2,
  kAudioTitle: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const SafetyFeatureSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const SafetyFeature = {
  
  kGeneral: 0,
  kAudioSummaryRequest: 1,
  kAudioTitleRequest: 2,
  kAudioSummaryResponse: 3,
  kAudioTitleResponse: 4,
  kAudioSummaryResponseV2: 5,
  kAudioTitleResponseV2: 6,
  MIN_VALUE: 0,
  MAX_VALUE: 6,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class PlatformModelProgressObserverPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'on_device_model.mojom.PlatformModelProgressObserver', scope);
  }
}

/** @interface */
export class PlatformModelProgressObserverInterface {
  
  /**
   * @param { !number } progress
   */

  progress(progress) {}
}

/**
 * @implements { PlatformModelProgressObserverInterface }
 */
export class PlatformModelProgressObserverRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!PlatformModelProgressObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PlatformModelProgressObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!PlatformModelProgressObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !number } progress
   */

  progress(
      progress) {
    this.proxy.sendMessage(
        0,
        PlatformModelProgressObserver_Progress_ParamsSpec.$,
        null,
        [
          progress
        ],
        false);
  }
}

/**
 * An object which receives request messages for the PlatformModelProgressObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PlatformModelProgressObserverReceiver {
  /**
   * @param {!PlatformModelProgressObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!PlatformModelProgressObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PlatformModelProgressObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!PlatformModelProgressObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PlatformModelProgressObserver_Progress_ParamsSpec.$,
        null,
        impl.progress.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PlatformModelProgressObserver {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "on_device_model.mojom.PlatformModelProgressObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!PlatformModelProgressObserverRemote}
   */
  static getRemote() {
    let remote = new PlatformModelProgressObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the PlatformModelProgressObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PlatformModelProgressObserverCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PlatformModelProgressObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!PlatformModelProgressObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.progress =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PlatformModelProgressObserver_Progress_ParamsSpec.$,
        null,
        this.progress.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class OnDeviceModelServicePendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'on_device_model.mojom.OnDeviceModelService', scope);
  }
}

/** @interface */
export class OnDeviceModelServiceInterface {
  
  /**
   * @param { !LoadModelParams } params
   * @param { !onDeviceModel_mojom_OnDeviceModelPendingReceiver } model
   * @return {!Promise<{
        result: !onDeviceModel_mojom_LoadModelResult,
   *  }>}
   */

  loadModel(params, model) {}
  
  /**
   * @param { !ModelFile } weights
   * @return {!Promise<{
        capabilities: !onDeviceModel_mojom_Capabilities,
   *  }>}
   */

  getCapabilities(weights) {}
  
  /**
   * @param { !TextSafetyModelParams } params
   * @param { !onDeviceModel_mojom_TextSafetyModelPendingReceiver } model
   */

  loadTextSafetyModel(params, model) {}
  
  /**
   * @return {!Promise<{
        performanceInfo: !onDeviceModel_mojom_DevicePerformanceInfo,
        deviceInfo: !onDeviceModel_mojom_DeviceInfo,
   *  }>}
   */

  getDeviceAndPerformanceInfo() {}
}

/**
 * @implements { OnDeviceModelServiceInterface }
 */
export class OnDeviceModelServiceRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!OnDeviceModelServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          OnDeviceModelServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!OnDeviceModelServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !LoadModelParams } params
   * @param { !onDeviceModel_mojom_OnDeviceModelPendingReceiver } model
   * @return {!Promise<{
        result: !onDeviceModel_mojom_LoadModelResult,
   *  }>}
   */

  loadModel(
      params,
      model) {
    return this.proxy.sendMessage(
        0,
        OnDeviceModelService_LoadModel_ParamsSpec.$,
        OnDeviceModelService_LoadModel_ResponseParamsSpec.$,
        [
          params,
          model
        ],
        false);
  }

  
  /**
   * @param { !ModelFile } weights
   * @return {!Promise<{
        capabilities: !onDeviceModel_mojom_Capabilities,
   *  }>}
   */

  getCapabilities(
      weights) {
    return this.proxy.sendMessage(
        1,
        OnDeviceModelService_GetCapabilities_ParamsSpec.$,
        OnDeviceModelService_GetCapabilities_ResponseParamsSpec.$,
        [
          weights
        ],
        false);
  }

  
  /**
   * @param { !TextSafetyModelParams } params
   * @param { !onDeviceModel_mojom_TextSafetyModelPendingReceiver } model
   */

  loadTextSafetyModel(
      params,
      model) {
    this.proxy.sendMessage(
        2,
        OnDeviceModelService_LoadTextSafetyModel_ParamsSpec.$,
        null,
        [
          params,
          model
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        performanceInfo: !onDeviceModel_mojom_DevicePerformanceInfo,
        deviceInfo: !onDeviceModel_mojom_DeviceInfo,
   *  }>}
   */

  getDeviceAndPerformanceInfo() {
    return this.proxy.sendMessage(
        3,
        OnDeviceModelService_GetDeviceAndPerformanceInfo_ParamsSpec.$,
        OnDeviceModelService_GetDeviceAndPerformanceInfo_ResponseParamsSpec.$,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the OnDeviceModelService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class OnDeviceModelServiceReceiver {
  /**
   * @param {!OnDeviceModelServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!OnDeviceModelServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        OnDeviceModelServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!OnDeviceModelServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        OnDeviceModelService_LoadModel_ParamsSpec.$,
        OnDeviceModelService_LoadModel_ResponseParamsSpec.$,
        impl.loadModel.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        OnDeviceModelService_GetCapabilities_ParamsSpec.$,
        OnDeviceModelService_GetCapabilities_ResponseParamsSpec.$,
        impl.getCapabilities.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        OnDeviceModelService_LoadTextSafetyModel_ParamsSpec.$,
        null,
        impl.loadTextSafetyModel.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        OnDeviceModelService_GetDeviceAndPerformanceInfo_ParamsSpec.$,
        OnDeviceModelService_GetDeviceAndPerformanceInfo_ResponseParamsSpec.$,
        impl.getDeviceAndPerformanceInfo.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class OnDeviceModelService {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "on_device_model.mojom.OnDeviceModelService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!OnDeviceModelServiceRemote}
   */
  static getRemote() {
    let remote = new OnDeviceModelServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the OnDeviceModelService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class OnDeviceModelServiceCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      OnDeviceModelServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!OnDeviceModelServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.loadModel =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        OnDeviceModelService_LoadModel_ParamsSpec.$,
        OnDeviceModelService_LoadModel_ResponseParamsSpec.$,
        this.loadModel.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getCapabilities =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        OnDeviceModelService_GetCapabilities_ParamsSpec.$,
        OnDeviceModelService_GetCapabilities_ResponseParamsSpec.$,
        this.getCapabilities.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.loadTextSafetyModel =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        OnDeviceModelService_LoadTextSafetyModel_ParamsSpec.$,
        null,
        this.loadTextSafetyModel.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getDeviceAndPerformanceInfo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        OnDeviceModelService_GetDeviceAndPerformanceInfo_ParamsSpec.$,
        OnDeviceModelService_GetDeviceAndPerformanceInfo_ResponseParamsSpec.$,
        this.getDeviceAndPerformanceInfo.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class OnDeviceModelPlatformServicePendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'on_device_model.mojom.OnDeviceModelPlatformService', scope);
  }
}

/** @interface */
export class OnDeviceModelPlatformServiceInterface {
  
  /**
   * @param { !mojoBase_mojom_Uuid } uuid
   * @param { !onDeviceModel_mojom_OnDeviceModelPendingReceiver } model
   * @param { ?PlatformModelProgressObserverRemote } progressObserver
   * @return {!Promise<{
        result: !onDeviceModel_mojom_LoadModelResult,
   *  }>}
   */

  loadPlatformModel(uuid, model, progressObserver) {}
  
  /**
   * @param { !mojoBase_mojom_Uuid } uuid
   * @return {!Promise<{
        result: !PlatformModelState,
   *  }>}
   */

  getPlatformModelState(uuid) {}
  
  /**
   * @return {!Promise<{
        performanceClass: !onDeviceModel_mojom_PerformanceClass,
   *  }>}
   */

  getEstimatedPerformanceClass() {}
  
  /**
   * @param { !mojoBase_mojom_Uuid } uuid
   * @param { !FormatFeature } feature
   * @param { !Object<!string, !string> } fields
   * @return {!Promise<{
        result: ?string,
   *  }>}
   */

  formatInput(uuid, feature, fields) {}
  
  /**
   * @param { !SafetyFeature } safetyFeature
   * @param { !string } text
   * @param { !onDeviceModel_mojom_SafetyInfo } safetyInfo
   * @return {!Promise<{
        result: !boolean,
   *  }>}
   */

  validateSafetyResult(safetyFeature, text, safetyInfo) {}
}

/**
 * @implements { OnDeviceModelPlatformServiceInterface }
 */
export class OnDeviceModelPlatformServiceRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!OnDeviceModelPlatformServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          OnDeviceModelPlatformServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!OnDeviceModelPlatformServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !mojoBase_mojom_Uuid } uuid
   * @param { !onDeviceModel_mojom_OnDeviceModelPendingReceiver } model
   * @param { ?PlatformModelProgressObserverRemote } progressObserver
   * @return {!Promise<{
        result: !onDeviceModel_mojom_LoadModelResult,
   *  }>}
   */

  loadPlatformModel(
      uuid,
      model,
      progressObserver) {
    return this.proxy.sendMessage(
        0,
        OnDeviceModelPlatformService_LoadPlatformModel_ParamsSpec.$,
        OnDeviceModelPlatformService_LoadPlatformModel_ResponseParamsSpec.$,
        [
          uuid,
          model,
          progressObserver
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_Uuid } uuid
   * @return {!Promise<{
        result: !PlatformModelState,
   *  }>}
   */

  getPlatformModelState(
      uuid) {
    return this.proxy.sendMessage(
        1,
        OnDeviceModelPlatformService_GetPlatformModelState_ParamsSpec.$,
        OnDeviceModelPlatformService_GetPlatformModelState_ResponseParamsSpec.$,
        [
          uuid
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        performanceClass: !onDeviceModel_mojom_PerformanceClass,
   *  }>}
   */

  getEstimatedPerformanceClass() {
    return this.proxy.sendMessage(
        2,
        OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ParamsSpec.$,
        OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_Uuid } uuid
   * @param { !FormatFeature } feature
   * @param { !Object<!string, !string> } fields
   * @return {!Promise<{
        result: ?string,
   *  }>}
   */

  formatInput(
      uuid,
      feature,
      fields) {
    return this.proxy.sendMessage(
        3,
        OnDeviceModelPlatformService_FormatInput_ParamsSpec.$,
        OnDeviceModelPlatformService_FormatInput_ResponseParamsSpec.$,
        [
          uuid,
          feature,
          fields
        ],
        false);
  }

  
  /**
   * @param { !SafetyFeature } safetyFeature
   * @param { !string } text
   * @param { !onDeviceModel_mojom_SafetyInfo } safetyInfo
   * @return {!Promise<{
        result: !boolean,
   *  }>}
   */

  validateSafetyResult(
      safetyFeature,
      text,
      safetyInfo) {
    return this.proxy.sendMessage(
        4,
        OnDeviceModelPlatformService_ValidateSafetyResult_ParamsSpec.$,
        OnDeviceModelPlatformService_ValidateSafetyResult_ResponseParamsSpec.$,
        [
          safetyFeature,
          text,
          safetyInfo
        ],
        false);
  }
}

/**
 * An object which receives request messages for the OnDeviceModelPlatformService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class OnDeviceModelPlatformServiceReceiver {
  /**
   * @param {!OnDeviceModelPlatformServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!OnDeviceModelPlatformServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        OnDeviceModelPlatformServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!OnDeviceModelPlatformServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        OnDeviceModelPlatformService_LoadPlatformModel_ParamsSpec.$,
        OnDeviceModelPlatformService_LoadPlatformModel_ResponseParamsSpec.$,
        impl.loadPlatformModel.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        OnDeviceModelPlatformService_GetPlatformModelState_ParamsSpec.$,
        OnDeviceModelPlatformService_GetPlatformModelState_ResponseParamsSpec.$,
        impl.getPlatformModelState.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ParamsSpec.$,
        OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ResponseParamsSpec.$,
        impl.getEstimatedPerformanceClass.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        OnDeviceModelPlatformService_FormatInput_ParamsSpec.$,
        OnDeviceModelPlatformService_FormatInput_ResponseParamsSpec.$,
        impl.formatInput.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        OnDeviceModelPlatformService_ValidateSafetyResult_ParamsSpec.$,
        OnDeviceModelPlatformService_ValidateSafetyResult_ResponseParamsSpec.$,
        impl.validateSafetyResult.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class OnDeviceModelPlatformService {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "on_device_model.mojom.OnDeviceModelPlatformService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!OnDeviceModelPlatformServiceRemote}
   */
  static getRemote() {
    let remote = new OnDeviceModelPlatformServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the OnDeviceModelPlatformService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class OnDeviceModelPlatformServiceCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      OnDeviceModelPlatformServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!OnDeviceModelPlatformServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.loadPlatformModel =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        OnDeviceModelPlatformService_LoadPlatformModel_ParamsSpec.$,
        OnDeviceModelPlatformService_LoadPlatformModel_ResponseParamsSpec.$,
        this.loadPlatformModel.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getPlatformModelState =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        OnDeviceModelPlatformService_GetPlatformModelState_ParamsSpec.$,
        OnDeviceModelPlatformService_GetPlatformModelState_ResponseParamsSpec.$,
        this.getPlatformModelState.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getEstimatedPerformanceClass =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ParamsSpec.$,
        OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ResponseParamsSpec.$,
        this.getEstimatedPerformanceClass.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.formatInput =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        OnDeviceModelPlatformService_FormatInput_ParamsSpec.$,
        OnDeviceModelPlatformService_FormatInput_ResponseParamsSpec.$,
        this.formatInput.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.validateSafetyResult =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        OnDeviceModelPlatformService_ValidateSafetyResult_ParamsSpec.$,
        OnDeviceModelPlatformService_ValidateSafetyResult_ResponseParamsSpec.$,
        this.validateSafetyResult.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ModelAssetsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const LoadModelParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TextSafetyModelAssetsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BertSafetyModelAssetsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const LanguageModelAssetsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TextSafetyModelParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PlatformModelProgressObserver_Progress_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const OnDeviceModelService_LoadModel_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const OnDeviceModelService_LoadModel_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const OnDeviceModelService_GetCapabilities_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const OnDeviceModelService_GetCapabilities_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const OnDeviceModelService_LoadTextSafetyModel_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const OnDeviceModelService_GetDeviceAndPerformanceInfo_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const OnDeviceModelService_GetDeviceAndPerformanceInfo_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const OnDeviceModelPlatformService_LoadPlatformModel_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const OnDeviceModelPlatformService_LoadPlatformModel_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const OnDeviceModelPlatformService_GetPlatformModelState_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const OnDeviceModelPlatformService_GetPlatformModelState_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const OnDeviceModelPlatformService_FormatInput_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const OnDeviceModelPlatformService_FormatInput_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const OnDeviceModelPlatformService_ValidateSafetyResult_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const OnDeviceModelPlatformService_ValidateSafetyResult_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const ModelFileSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const SafetyModelAssetsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    ModelAssetsSpec.$,
    'ModelAssets',
    [
      mojo.internal.StructField(
        'weights', 0,
        0,
        ModelFileSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'spModelPath', 16,
        0,
        mojoBase_mojom_FilePathSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'cache', 24,
        0,
        mojoBase_mojom_FileSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'encoderCache', 32,
        0,
        mojoBase_mojom_FileSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'adapterCache', 40,
        0,
        mojoBase_mojom_FileSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 56],]);



/**
 * @record
 */
export class ModelAssets {
  constructor() {
    /** @type { !ModelFile } */
    this.weights;
    /** @type { (mojoBase_mojom_FilePath|undefined) } */
    this.spModelPath;
    /** @type { (mojoBase_mojom_File|undefined) } */
    this.cache;
    /** @type { (mojoBase_mojom_File|undefined) } */
    this.encoderCache;
    /** @type { (mojoBase_mojom_File|undefined) } */
    this.adapterCache;
  }
}



mojo.internal.Struct(
    LoadModelParamsSpec.$,
    'LoadModelParams',
    [
      mojo.internal.StructField(
        'backendType', 0,
        0,
        ModelBackendTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'assets', 8,
        0,
        ModelAssetsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxTokens', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'adaptationRanks', 16,
        0,
        mojo.internal.Array(mojo.internal.Uint32, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'performanceHint', 24,
        0,
        ModelPerformanceHintSpec.$,
        ModelPerformanceHint.kHighestQuality,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class LoadModelParams {
  constructor() {
    /** @type { !ModelBackendType } */
    this.backendType;
    /** @type { !ModelAssets } */
    this.assets;
    /** @type { !number } */
    this.maxTokens;
    /** @type { !Array<!number> } */
    this.adaptationRanks;
    /** @type { !ModelPerformanceHint } */
    this.performanceHint;
  }
}



mojo.internal.Struct(
    TextSafetyModelAssetsSpec.$,
    'TextSafetyModelAssets',
    [
      mojo.internal.StructField(
        'data', 0,
        0,
        mojoBase_mojom_ReadOnlyFileSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'spModel', 8,
        0,
        mojoBase_mojom_ReadOnlyFileSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class TextSafetyModelAssets {
  constructor() {
    /** @type { !mojoBase_mojom_ReadOnlyFile } */
    this.data;
    /** @type { !mojoBase_mojom_ReadOnlyFile } */
    this.spModel;
  }
}



mojo.internal.Struct(
    BertSafetyModelAssetsSpec.$,
    'BertSafetyModelAssets',
    [
      mojo.internal.StructField(
        'model', 0,
        0,
        mojoBase_mojom_ReadOnlyFileSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class BertSafetyModelAssets {
  constructor() {
    /** @type { !mojoBase_mojom_ReadOnlyFile } */
    this.model;
  }
}



mojo.internal.Struct(
    LanguageModelAssetsSpec.$,
    'LanguageModelAssets',
    [
      mojo.internal.StructField(
        'model', 0,
        0,
        mojoBase_mojom_ReadOnlyFileSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class LanguageModelAssets {
  constructor() {
    /** @type { !mojoBase_mojom_ReadOnlyFile } */
    this.model;
  }
}



mojo.internal.Struct(
    TextSafetyModelParamsSpec.$,
    'TextSafetyModelParams',
    [
      mojo.internal.StructField(
        'safetyAssets', 0,
        0,
        SafetyModelAssetsSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'languageAssets', 16,
        0,
        LanguageModelAssetsSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class TextSafetyModelParams {
  constructor() {
    /** @type { (SafetyModelAssets|undefined) } */
    this.safetyAssets;
    /** @type { (LanguageModelAssets|undefined) } */
    this.languageAssets;
  }
}



mojo.internal.Struct(
    PlatformModelProgressObserver_Progress_ParamsSpec.$,
    'PlatformModelProgressObserver_Progress_Params',
    [
      mojo.internal.StructField(
        'progress', 0,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PlatformModelProgressObserver_Progress_Params {
  constructor() {
    /** @type { !number } */
    this.progress;
  }
}



mojo.internal.Struct(
    OnDeviceModelService_LoadModel_ParamsSpec.$,
    'OnDeviceModelService_LoadModel_Params',
    [
      mojo.internal.StructField(
        'params', 0,
        0,
        LoadModelParamsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'model', 8,
        0,
        mojo.internal.InterfaceRequest(onDeviceModel_mojom_OnDeviceModelPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class OnDeviceModelService_LoadModel_Params {
  constructor() {
    /** @type { !LoadModelParams } */
    this.params;
    /** @type { !onDeviceModel_mojom_OnDeviceModelPendingReceiver } */
    this.model;
  }
}



mojo.internal.Struct(
    OnDeviceModelService_LoadModel_ResponseParamsSpec.$,
    'OnDeviceModelService_LoadModel_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        onDeviceModel_mojom_LoadModelResultSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class OnDeviceModelService_LoadModel_ResponseParams {
  constructor() {
    /** @type { !onDeviceModel_mojom_LoadModelResult } */
    this.result;
  }
}



mojo.internal.Struct(
    OnDeviceModelService_GetCapabilities_ParamsSpec.$,
    'OnDeviceModelService_GetCapabilities_Params',
    [
      mojo.internal.StructField(
        'weights', 0,
        0,
        ModelFileSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class OnDeviceModelService_GetCapabilities_Params {
  constructor() {
    /** @type { !ModelFile } */
    this.weights;
  }
}



mojo.internal.Struct(
    OnDeviceModelService_GetCapabilities_ResponseParamsSpec.$,
    'OnDeviceModelService_GetCapabilities_ResponseParams',
    [
      mojo.internal.StructField(
        'capabilities', 0,
        0,
        onDeviceModel_mojom_CapabilitiesSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class OnDeviceModelService_GetCapabilities_ResponseParams {
  constructor() {
    /** @type { !onDeviceModel_mojom_Capabilities } */
    this.capabilities;
  }
}



mojo.internal.Struct(
    OnDeviceModelService_LoadTextSafetyModel_ParamsSpec.$,
    'OnDeviceModelService_LoadTextSafetyModel_Params',
    [
      mojo.internal.StructField(
        'params', 0,
        0,
        TextSafetyModelParamsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'model', 8,
        0,
        mojo.internal.InterfaceRequest(onDeviceModel_mojom_TextSafetyModelPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class OnDeviceModelService_LoadTextSafetyModel_Params {
  constructor() {
    /** @type { !TextSafetyModelParams } */
    this.params;
    /** @type { !onDeviceModel_mojom_TextSafetyModelPendingReceiver } */
    this.model;
  }
}



mojo.internal.Struct(
    OnDeviceModelService_GetDeviceAndPerformanceInfo_ParamsSpec.$,
    'OnDeviceModelService_GetDeviceAndPerformanceInfo_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class OnDeviceModelService_GetDeviceAndPerformanceInfo_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    OnDeviceModelService_GetDeviceAndPerformanceInfo_ResponseParamsSpec.$,
    'OnDeviceModelService_GetDeviceAndPerformanceInfo_ResponseParams',
    [
      mojo.internal.StructField(
        'performanceInfo', 0,
        0,
        onDeviceModel_mojom_DevicePerformanceInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'deviceInfo', 8,
        0,
        onDeviceModel_mojom_DeviceInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class OnDeviceModelService_GetDeviceAndPerformanceInfo_ResponseParams {
  constructor() {
    /** @type { !onDeviceModel_mojom_DevicePerformanceInfo } */
    this.performanceInfo;
    /** @type { !onDeviceModel_mojom_DeviceInfo } */
    this.deviceInfo;
  }
}



mojo.internal.Struct(
    OnDeviceModelPlatformService_LoadPlatformModel_ParamsSpec.$,
    'OnDeviceModelPlatformService_LoadPlatformModel_Params',
    [
      mojo.internal.StructField(
        'uuid', 0,
        0,
        mojoBase_mojom_UuidSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'model', 8,
        0,
        mojo.internal.InterfaceRequest(onDeviceModel_mojom_OnDeviceModelPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'progressObserver', 12,
        0,
        mojo.internal.InterfaceProxy(PlatformModelProgressObserverRemote),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class OnDeviceModelPlatformService_LoadPlatformModel_Params {
  constructor() {
    /** @type { !mojoBase_mojom_Uuid } */
    this.uuid;
    /** @type { !onDeviceModel_mojom_OnDeviceModelPendingReceiver } */
    this.model;
    /** @type { (PlatformModelProgressObserverRemote|undefined) } */
    this.progressObserver;
  }
}



mojo.internal.Struct(
    OnDeviceModelPlatformService_LoadPlatformModel_ResponseParamsSpec.$,
    'OnDeviceModelPlatformService_LoadPlatformModel_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        onDeviceModel_mojom_LoadModelResultSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class OnDeviceModelPlatformService_LoadPlatformModel_ResponseParams {
  constructor() {
    /** @type { !onDeviceModel_mojom_LoadModelResult } */
    this.result;
  }
}



mojo.internal.Struct(
    OnDeviceModelPlatformService_GetPlatformModelState_ParamsSpec.$,
    'OnDeviceModelPlatformService_GetPlatformModelState_Params',
    [
      mojo.internal.StructField(
        'uuid', 0,
        0,
        mojoBase_mojom_UuidSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class OnDeviceModelPlatformService_GetPlatformModelState_Params {
  constructor() {
    /** @type { !mojoBase_mojom_Uuid } */
    this.uuid;
  }
}



mojo.internal.Struct(
    OnDeviceModelPlatformService_GetPlatformModelState_ResponseParamsSpec.$,
    'OnDeviceModelPlatformService_GetPlatformModelState_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        PlatformModelStateSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class OnDeviceModelPlatformService_GetPlatformModelState_ResponseParams {
  constructor() {
    /** @type { !PlatformModelState } */
    this.result;
  }
}



mojo.internal.Struct(
    OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ParamsSpec.$,
    'OnDeviceModelPlatformService_GetEstimatedPerformanceClass_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class OnDeviceModelPlatformService_GetEstimatedPerformanceClass_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ResponseParamsSpec.$,
    'OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ResponseParams',
    [
      mojo.internal.StructField(
        'performanceClass', 0,
        0,
        onDeviceModel_mojom_PerformanceClassSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ResponseParams {
  constructor() {
    /** @type { !onDeviceModel_mojom_PerformanceClass } */
    this.performanceClass;
  }
}



mojo.internal.Struct(
    OnDeviceModelPlatformService_FormatInput_ParamsSpec.$,
    'OnDeviceModelPlatformService_FormatInput_Params',
    [
      mojo.internal.StructField(
        'uuid', 0,
        0,
        mojoBase_mojom_UuidSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'feature', 8,
        0,
        FormatFeatureSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'fields', 16,
        0,
        mojo.internal.Map(mojo.internal.String, mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class OnDeviceModelPlatformService_FormatInput_Params {
  constructor() {
    /** @type { !mojoBase_mojom_Uuid } */
    this.uuid;
    /** @type { !FormatFeature } */
    this.feature;
    /** @type { !Object<!string, !string> } */
    this.fields;
  }
}



mojo.internal.Struct(
    OnDeviceModelPlatformService_FormatInput_ResponseParamsSpec.$,
    'OnDeviceModelPlatformService_FormatInput_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class OnDeviceModelPlatformService_FormatInput_ResponseParams {
  constructor() {
    /** @type { (string|undefined) } */
    this.result;
  }
}



mojo.internal.Struct(
    OnDeviceModelPlatformService_ValidateSafetyResult_ParamsSpec.$,
    'OnDeviceModelPlatformService_ValidateSafetyResult_Params',
    [
      mojo.internal.StructField(
        'safetyFeature', 0,
        0,
        SafetyFeatureSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'text', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'safetyInfo', 16,
        0,
        onDeviceModel_mojom_SafetyInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class OnDeviceModelPlatformService_ValidateSafetyResult_Params {
  constructor() {
    /** @type { !SafetyFeature } */
    this.safetyFeature;
    /** @type { !string } */
    this.text;
    /** @type { !onDeviceModel_mojom_SafetyInfo } */
    this.safetyInfo;
  }
}



mojo.internal.Struct(
    OnDeviceModelPlatformService_ValidateSafetyResult_ResponseParamsSpec.$,
    'OnDeviceModelPlatformService_ValidateSafetyResult_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class OnDeviceModelPlatformService_ValidateSafetyResult_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.result;
  }
}

mojo.internal.Union(
    ModelFileSpec.$, 'ModelFile',
    {
      'file': {
        'ordinal': 0,
        'type': mojoBase_mojom_FileSpec.$,
      },
      'path': {
        'ordinal': 1,
        'type': mojoBase_mojom_FilePathSpec.$,
      },
    });

/**
 * @typedef { {
 *   file: (!mojoBase_mojom_File|undefined),
 *   path: (!mojoBase_mojom_FilePath|undefined),
 * } }
 */
export const ModelFile = {};
mojo.internal.Union(
    SafetyModelAssetsSpec.$, 'SafetyModelAssets',
    {
      'tsAssets': {
        'ordinal': 0,
        'type': TextSafetyModelAssetsSpec.$,
      },
      'bsAssets': {
        'ordinal': 1,
        'type': BertSafetyModelAssetsSpec.$,
      },
    });

/**
 * @typedef { {
 *   tsAssets: (!TextSafetyModelAssets|undefined),
 *   bsAssets: (!BertSafetyModelAssets|undefined),
 * } }
 */
export const SafetyModelAssets = {};
