// services/on_device_model/public/mojom/on_device_model_service.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_ON_DEVICE_MODEL_PUBLIC_MOJOM_ON_DEVICE_MODEL_SERVICE_MOJOM_H_
#define SERVICES_ON_DEVICE_MODEL_PUBLIC_MOJOM_ON_DEVICE_MODEL_SERVICE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/on_device_model/public/mojom/on_device_model_service.mojom-features.h"  // IWYU pragma: export
#include "services/on_device_model/public/mojom/on_device_model_service.mojom-shared.h"  // IWYU pragma: export
#include "services/on_device_model/public/mojom/on_device_model_service.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/file.mojom.h"
#include "mojo/public/mojom/base/file_path.mojom.h"
#include "mojo/public/mojom/base/uuid.mojom.h"
#include "sandbox/policy/mojom/context.mojom-forward.h"
#include "sandbox/policy/mojom/sandbox.mojom-forward.h"
#include "services/on_device_model/public/mojom/on_device_model.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "services/on_device_model/public/cpp/adaptation_assets_mojom_traits.h"
#include "services/on_device_model/public/cpp/capabilities_mojom_traits.h"
#include "services/on_device_model/public/cpp/chrome_ml_types_mojom_traits.h"
#include "services/on_device_model/public/cpp/model_assets_mojom_traits.h"
#include "services/on_device_model/public/cpp/model_file_mojom_traits.h"




namespace on_device_model::mojom {

class PlatformModelProgressObserverProxy;

template <typename ImplRefTraits>
class PlatformModelProgressObserverStub;

class PlatformModelProgressObserverRequestValidator;


class PlatformModelProgressObserver
    : public PlatformModelProgressObserverInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "on_device_model.mojom.PlatformModelProgressObserver";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PlatformModelProgressObserverInterfaceBase;
  using Proxy_ = PlatformModelProgressObserverProxy;

  template <typename ImplRefTraits>
  using Stub_ = PlatformModelProgressObserverStub<ImplRefTraits>;

  using RequestValidator_ = PlatformModelProgressObserverRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kProgressMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Progress_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PlatformModelProgressObserver() = default;

  virtual void Progress(double progress) = 0;
};

class OnDeviceModelServiceProxy;

template <typename ImplRefTraits>
class OnDeviceModelServiceStub;

class OnDeviceModelServiceRequestValidator;
class OnDeviceModelServiceResponseValidator;


class OnDeviceModelService
    : public OnDeviceModelServiceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "on_device_model.mojom.OnDeviceModelService";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr auto kServiceSandbox = sandbox::mojom::Sandbox::kOnDeviceModelExecution;
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = OnDeviceModelServiceInterfaceBase;
  using Proxy_ = OnDeviceModelServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = OnDeviceModelServiceStub<ImplRefTraits>;

  using RequestValidator_ = OnDeviceModelServiceRequestValidator;
  using ResponseValidator_ = OnDeviceModelServiceResponseValidator;
  enum MethodMinVersions : uint32_t {
    kLoadModelMinVersion = 0,
    kGetCapabilitiesMinVersion = 0,
    kLoadTextSafetyModelMinVersion = 0,
    kGetDeviceAndPerformanceInfoMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct LoadModel_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetCapabilities_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct LoadTextSafetyModel_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetDeviceAndPerformanceInfo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~OnDeviceModelService() = default;

  using LoadModelCallback = base::OnceCallback<void(::on_device_model::mojom::LoadModelResult)>;
  using LoadModelMojoCallback = base::OnceCallback<void(::on_device_model::mojom::LoadModelResult)>;

  virtual void LoadModel(LoadModelParamsPtr params, ::mojo::PendingReceiver<::on_device_model::mojom::OnDeviceModel> model, LoadModelCallback callback) = 0;

  using GetCapabilitiesCallback = base::OnceCallback<void(const ::on_device_model::Capabilities&)>;
  using GetCapabilitiesMojoCallback = base::OnceCallback<void(const ::on_device_model::Capabilities&)>;

  virtual void GetCapabilities(::on_device_model::ModelFile weights, GetCapabilitiesCallback callback) = 0;

  virtual void LoadTextSafetyModel(TextSafetyModelParamsPtr params, ::mojo::PendingReceiver<::on_device_model::mojom::TextSafetyModel> model) = 0;

  using GetDeviceAndPerformanceInfoCallback = base::OnceCallback<void(::on_device_model::mojom::DevicePerformanceInfoPtr, ::on_device_model::mojom::DeviceInfoPtr)>;
  using GetDeviceAndPerformanceInfoMojoCallback = base::OnceCallback<void(::on_device_model::mojom::DevicePerformanceInfoPtr, ::on_device_model::mojom::DeviceInfoPtr)>;

  virtual void GetDeviceAndPerformanceInfo(GetDeviceAndPerformanceInfoCallback callback) = 0;
};

class OnDeviceModelPlatformServiceProxy;

template <typename ImplRefTraits>
class OnDeviceModelPlatformServiceStub;

class OnDeviceModelPlatformServiceRequestValidator;
class OnDeviceModelPlatformServiceResponseValidator;


class OnDeviceModelPlatformService
    : public OnDeviceModelPlatformServiceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "on_device_model.mojom.OnDeviceModelPlatformService";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = OnDeviceModelPlatformServiceInterfaceBase;
  using Proxy_ = OnDeviceModelPlatformServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = OnDeviceModelPlatformServiceStub<ImplRefTraits>;

  using RequestValidator_ = OnDeviceModelPlatformServiceRequestValidator;
  using ResponseValidator_ = OnDeviceModelPlatformServiceResponseValidator;
  enum MethodMinVersions : uint32_t {
    kLoadPlatformModelMinVersion = 0,
    kGetPlatformModelStateMinVersion = 0,
    kGetEstimatedPerformanceClassMinVersion = 0,
    kFormatInputMinVersion = 0,
    kValidateSafetyResultMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct LoadPlatformModel_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetPlatformModelState_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetEstimatedPerformanceClass_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct FormatInput_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ValidateSafetyResult_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~OnDeviceModelPlatformService() = default;

  using LoadPlatformModelCallback = base::OnceCallback<void(::on_device_model::mojom::LoadModelResult)>;
  using LoadPlatformModelMojoCallback = base::OnceCallback<void(::on_device_model::mojom::LoadModelResult)>;

  virtual void LoadPlatformModel(const ::base::Uuid& uuid, ::mojo::PendingReceiver<::on_device_model::mojom::OnDeviceModel> model, ::mojo::PendingRemote<PlatformModelProgressObserver> progress_observer, LoadPlatformModelCallback callback) = 0;

  using GetPlatformModelStateCallback = base::OnceCallback<void(PlatformModelState)>;
  using GetPlatformModelStateMojoCallback = base::OnceCallback<void(PlatformModelState)>;

  virtual void GetPlatformModelState(const ::base::Uuid& uuid, GetPlatformModelStateCallback callback) = 0;

  using GetEstimatedPerformanceClassCallback = base::OnceCallback<void(::on_device_model::mojom::PerformanceClass)>;
  using GetEstimatedPerformanceClassMojoCallback = base::OnceCallback<void(::on_device_model::mojom::PerformanceClass)>;

  virtual void GetEstimatedPerformanceClass(GetEstimatedPerformanceClassCallback callback) = 0;

  using FormatInputCallback = base::OnceCallback<void(const std::optional<std::string>&)>;
  using FormatInputMojoCallback = base::OnceCallback<void(const std::optional<std::string>&)>;

  virtual void FormatInput(const ::base::Uuid& uuid, FormatFeature feature, const base::flat_map<std::string, std::string>& fields, FormatInputCallback callback) = 0;

  using ValidateSafetyResultCallback = base::OnceCallback<void(bool)>;
  using ValidateSafetyResultMojoCallback = base::OnceCallback<void(bool)>;

  virtual void ValidateSafetyResult(SafetyFeature safety_feature, const std::string& text, ::on_device_model::mojom::SafetyInfoPtr safety_info, ValidateSafetyResultCallback callback) = 0;
};



class  PlatformModelProgressObserverProxy
    : public PlatformModelProgressObserver {
 public:
  using InterfaceType = PlatformModelProgressObserver;

  explicit PlatformModelProgressObserverProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Progress(double progress) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  OnDeviceModelServiceProxy
    : public OnDeviceModelService {
 public:
  using InterfaceType = OnDeviceModelService;

  explicit OnDeviceModelServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void LoadModel(LoadModelParamsPtr params, ::mojo::PendingReceiver<::on_device_model::mojom::OnDeviceModel> model, LoadModelCallback callback) final;
  
  void GetCapabilities(::on_device_model::ModelFile weights, GetCapabilitiesCallback callback) final;
  
  void LoadTextSafetyModel(TextSafetyModelParamsPtr params, ::mojo::PendingReceiver<::on_device_model::mojom::TextSafetyModel> model) final;
  
  void GetDeviceAndPerformanceInfo(GetDeviceAndPerformanceInfoCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  OnDeviceModelPlatformServiceProxy
    : public OnDeviceModelPlatformService {
 public:
  using InterfaceType = OnDeviceModelPlatformService;

  explicit OnDeviceModelPlatformServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void LoadPlatformModel(const ::base::Uuid& uuid, ::mojo::PendingReceiver<::on_device_model::mojom::OnDeviceModel> model, ::mojo::PendingRemote<PlatformModelProgressObserver> progress_observer, LoadPlatformModelCallback callback) final;
  
  void GetPlatformModelState(const ::base::Uuid& uuid, GetPlatformModelStateCallback callback) final;
  
  void GetEstimatedPerformanceClass(GetEstimatedPerformanceClassCallback callback) final;
  
  void FormatInput(const ::base::Uuid& uuid, FormatFeature feature, const base::flat_map<std::string, std::string>& fields, FormatInputCallback callback) final;
  
  void ValidateSafetyResult(SafetyFeature safety_feature, const std::string& text, ::on_device_model::mojom::SafetyInfoPtr safety_info, ValidateSafetyResultCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  PlatformModelProgressObserverStubDispatch {
 public:
  static bool Accept(PlatformModelProgressObserver* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PlatformModelProgressObserver* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PlatformModelProgressObserver>>
class PlatformModelProgressObserverStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PlatformModelProgressObserverStub() = default;
  ~PlatformModelProgressObserverStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PlatformModelProgressObserverStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PlatformModelProgressObserverStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  OnDeviceModelServiceStubDispatch {
 public:
  static bool Accept(OnDeviceModelService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      OnDeviceModelService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<OnDeviceModelService>>
class OnDeviceModelServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  OnDeviceModelServiceStub() = default;
  ~OnDeviceModelServiceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return OnDeviceModelServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return OnDeviceModelServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  OnDeviceModelPlatformServiceStubDispatch {
 public:
  static bool Accept(OnDeviceModelPlatformService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      OnDeviceModelPlatformService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<OnDeviceModelPlatformService>>
class OnDeviceModelPlatformServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  OnDeviceModelPlatformServiceStub() = default;
  ~OnDeviceModelPlatformServiceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return OnDeviceModelPlatformServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return OnDeviceModelPlatformServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PlatformModelProgressObserverRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  OnDeviceModelServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  OnDeviceModelPlatformServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  OnDeviceModelServiceResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  OnDeviceModelPlatformServiceResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};











class  ModelFile {
 public:
  using DataView = ModelFileDataView;
  using Data_ = internal::ModelFile_Data;
  using Tag = Data_::ModelFile_Tag;

  template <typename... Args>
  static ModelFilePtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |file|.
  static ModelFilePtr NewFile(
      ::base::File value);
  // Construct an instance holding |path|.
  static ModelFilePtr NewPath(
      const ::base::FilePath& value);

  template <typename U>
  static ModelFilePtr From(const U& u) {
    return mojo::TypeConverter<ModelFilePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ModelFile>::Convert(*this);
  }
  ~ModelFile();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  ModelFile(const ModelFile& other) = delete;
  ModelFile& operator=(const ModelFile& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = ModelFilePtr>
  ModelFilePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, ModelFile>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, ModelFile>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_file() const { return tag_ == Tag::kFile; }
  const ::base::File& get_file() const {
    CHECK(tag_ == Tag::kFile);
    return data_.file;
  }
  ::base::File& get_file() {
    CHECK(tag_ == Tag::kFile);
    return data_.file;
  }
  void set_file(::base::File file);

  bool is_path() const { return tag_ == Tag::kPath; }
  const ::base::FilePath& get_path() const {
    CHECK(tag_ == Tag::kPath);
    return data_.path;
  }
  ::base::FilePath& get_path() {
    CHECK(tag_ == Tag::kPath);
    return data_.path;
  }
  void set_path(const ::base::FilePath& path);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ModelFile::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<ModelFile::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kFile)>,
        ::base::File value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kPath)>,
        const ::base::FilePath& value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    ::base::File file;
    ::base::FilePath path;
  };

  ModelFile(
      std::in_place_index_t<static_cast<size_t>(Tag::kFile)>,
      ::base::File value);
  ModelFile(
      std::in_place_index_t<static_cast<size_t>(Tag::kPath)>,
      const ::base::FilePath& value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class  SafetyModelAssets {
 public:
  using DataView = SafetyModelAssetsDataView;
  using Data_ = internal::SafetyModelAssets_Data;
  using Tag = Data_::SafetyModelAssets_Tag;

  template <typename... Args>
  static SafetyModelAssetsPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |ts_assets|.
  static SafetyModelAssetsPtr NewTsAssets(
      TextSafetyModelAssetsPtr value);
  // Construct an instance holding |bs_assets|.
  static SafetyModelAssetsPtr NewBsAssets(
      BertSafetyModelAssetsPtr value);

  template <typename U>
  static SafetyModelAssetsPtr From(const U& u) {
    return mojo::TypeConverter<SafetyModelAssetsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SafetyModelAssets>::Convert(*this);
  }
  ~SafetyModelAssets();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  SafetyModelAssets(const SafetyModelAssets& other) = delete;
  SafetyModelAssets& operator=(const SafetyModelAssets& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = SafetyModelAssetsPtr>
  SafetyModelAssetsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, SafetyModelAssets>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, SafetyModelAssets>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_ts_assets() const { return tag_ == Tag::kTsAssets; }
  const TextSafetyModelAssetsPtr& get_ts_assets() const {
    CHECK(tag_ == Tag::kTsAssets);
    return data_.ts_assets;
  }
  TextSafetyModelAssetsPtr& get_ts_assets() {
    CHECK(tag_ == Tag::kTsAssets);
    return data_.ts_assets;
  }
  void set_ts_assets(TextSafetyModelAssetsPtr ts_assets);

  bool is_bs_assets() const { return tag_ == Tag::kBsAssets; }
  const BertSafetyModelAssetsPtr& get_bs_assets() const {
    CHECK(tag_ == Tag::kBsAssets);
    return data_.bs_assets;
  }
  BertSafetyModelAssetsPtr& get_bs_assets() {
    CHECK(tag_ == Tag::kBsAssets);
    return data_.bs_assets;
  }
  void set_bs_assets(BertSafetyModelAssetsPtr bs_assets);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SafetyModelAssets::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<SafetyModelAssets::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kTsAssets)>,
        TextSafetyModelAssetsPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kBsAssets)>,
        BertSafetyModelAssetsPtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    TextSafetyModelAssetsPtr ts_assets;
    BertSafetyModelAssetsPtr bs_assets;
  };

  SafetyModelAssets(
      std::in_place_index_t<static_cast<size_t>(Tag::kTsAssets)>,
      TextSafetyModelAssetsPtr value);
  SafetyModelAssets(
      std::in_place_index_t<static_cast<size_t>(Tag::kBsAssets)>,
      BertSafetyModelAssetsPtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class  ModelAssets {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ModelAssets, T>::value>;
  using DataView = ModelAssetsDataView;
  using Data_ = internal::ModelAssets_Data;

  template <typename... Args>
  static ModelAssetsPtr New(Args&&... args) {
    return ModelAssetsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ModelAssetsPtr From(const U& u) {
    return mojo::TypeConverter<ModelAssetsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ModelAssets>::Convert(*this);
  }


  ModelAssets();

  ModelAssets(
      ::on_device_model::ModelFile weights,
      const std::optional<::base::FilePath>& sp_model_path,
      ::base::File cache,
      ::base::File encoder_cache,
      ::base::File adapter_cache);

ModelAssets(const ModelAssets&) = delete;
ModelAssets& operator=(const ModelAssets&) = delete;

  ~ModelAssets();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ModelAssetsPtr>
  ModelAssetsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ModelAssets::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ModelAssets::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ModelAssets::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ModelAssets::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ModelAssets_UnserializedMessageContext<
            UserType, ModelAssets::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ModelAssets::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ModelAssets::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ModelAssets_UnserializedMessageContext<
            UserType, ModelAssets::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ModelAssets::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::on_device_model::ModelFile weights;
  
  std::optional<::base::FilePath> sp_model_path;
  
  ::base::File cache;
  
  ::base::File encoder_cache;
  
  ::base::File adapter_cache;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ModelAssets::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ModelAssets::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ModelAssets::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ModelAssets::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  LoadModelParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<LoadModelParams, T>::value>;
  using DataView = LoadModelParamsDataView;
  using Data_ = internal::LoadModelParams_Data;

  template <typename... Args>
  static LoadModelParamsPtr New(Args&&... args) {
    return LoadModelParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static LoadModelParamsPtr From(const U& u) {
    return mojo::TypeConverter<LoadModelParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, LoadModelParams>::Convert(*this);
  }


  LoadModelParams();

  LoadModelParams(
      ::ml::ModelBackendType backend_type,
      ::on_device_model::ModelAssets assets,
      uint32_t max_tokens,
      std::vector<uint32_t> adaptation_ranks,
      ::ml::ModelPerformanceHint performance_hint);

LoadModelParams(const LoadModelParams&) = delete;
LoadModelParams& operator=(const LoadModelParams&) = delete;

  ~LoadModelParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = LoadModelParamsPtr>
  LoadModelParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, LoadModelParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, LoadModelParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, LoadModelParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        LoadModelParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::LoadModelParams_UnserializedMessageContext<
            UserType, LoadModelParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<LoadModelParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return LoadModelParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::LoadModelParams_UnserializedMessageContext<
            UserType, LoadModelParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<LoadModelParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::ml::ModelBackendType backend_type;
  
  ::on_device_model::ModelAssets assets;
  
  uint32_t max_tokens;
  
  std::vector<uint32_t> adaptation_ranks;
  
  ::ml::ModelPerformanceHint performance_hint;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, LoadModelParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, LoadModelParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, LoadModelParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, LoadModelParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  TextSafetyModelAssets {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TextSafetyModelAssets, T>::value>;
  using DataView = TextSafetyModelAssetsDataView;
  using Data_ = internal::TextSafetyModelAssets_Data;

  template <typename... Args>
  static TextSafetyModelAssetsPtr New(Args&&... args) {
    return TextSafetyModelAssetsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TextSafetyModelAssetsPtr From(const U& u) {
    return mojo::TypeConverter<TextSafetyModelAssetsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TextSafetyModelAssets>::Convert(*this);
  }


  TextSafetyModelAssets();

  TextSafetyModelAssets(
      ::base::File data,
      ::base::File sp_model);

TextSafetyModelAssets(const TextSafetyModelAssets&) = delete;
TextSafetyModelAssets& operator=(const TextSafetyModelAssets&) = delete;

  ~TextSafetyModelAssets();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TextSafetyModelAssetsPtr>
  TextSafetyModelAssetsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TextSafetyModelAssets::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TextSafetyModelAssets::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TextSafetyModelAssets::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TextSafetyModelAssets::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TextSafetyModelAssets_UnserializedMessageContext<
            UserType, TextSafetyModelAssets::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TextSafetyModelAssets::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TextSafetyModelAssets::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TextSafetyModelAssets_UnserializedMessageContext<
            UserType, TextSafetyModelAssets::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TextSafetyModelAssets::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::File data;
  
  ::base::File sp_model;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TextSafetyModelAssets::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TextSafetyModelAssets::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TextSafetyModelAssets::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TextSafetyModelAssets::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  BertSafetyModelAssets {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BertSafetyModelAssets, T>::value>;
  using DataView = BertSafetyModelAssetsDataView;
  using Data_ = internal::BertSafetyModelAssets_Data;

  template <typename... Args>
  static BertSafetyModelAssetsPtr New(Args&&... args) {
    return BertSafetyModelAssetsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BertSafetyModelAssetsPtr From(const U& u) {
    return mojo::TypeConverter<BertSafetyModelAssetsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BertSafetyModelAssets>::Convert(*this);
  }


  BertSafetyModelAssets();

  explicit BertSafetyModelAssets(
      ::base::File model);

BertSafetyModelAssets(const BertSafetyModelAssets&) = delete;
BertSafetyModelAssets& operator=(const BertSafetyModelAssets&) = delete;

  ~BertSafetyModelAssets();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BertSafetyModelAssetsPtr>
  BertSafetyModelAssetsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BertSafetyModelAssets::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, BertSafetyModelAssets::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, BertSafetyModelAssets::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BertSafetyModelAssets::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BertSafetyModelAssets_UnserializedMessageContext<
            UserType, BertSafetyModelAssets::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<BertSafetyModelAssets::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return BertSafetyModelAssets::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BertSafetyModelAssets_UnserializedMessageContext<
            UserType, BertSafetyModelAssets::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BertSafetyModelAssets::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::File model;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BertSafetyModelAssets::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BertSafetyModelAssets::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BertSafetyModelAssets::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BertSafetyModelAssets::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  LanguageModelAssets {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<LanguageModelAssets, T>::value>;
  using DataView = LanguageModelAssetsDataView;
  using Data_ = internal::LanguageModelAssets_Data;

  template <typename... Args>
  static LanguageModelAssetsPtr New(Args&&... args) {
    return LanguageModelAssetsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static LanguageModelAssetsPtr From(const U& u) {
    return mojo::TypeConverter<LanguageModelAssetsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, LanguageModelAssets>::Convert(*this);
  }


  LanguageModelAssets();

  explicit LanguageModelAssets(
      ::base::File model);

LanguageModelAssets(const LanguageModelAssets&) = delete;
LanguageModelAssets& operator=(const LanguageModelAssets&) = delete;

  ~LanguageModelAssets();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = LanguageModelAssetsPtr>
  LanguageModelAssetsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, LanguageModelAssets::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, LanguageModelAssets::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, LanguageModelAssets::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        LanguageModelAssets::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::LanguageModelAssets_UnserializedMessageContext<
            UserType, LanguageModelAssets::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<LanguageModelAssets::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return LanguageModelAssets::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::LanguageModelAssets_UnserializedMessageContext<
            UserType, LanguageModelAssets::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<LanguageModelAssets::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::File model;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, LanguageModelAssets::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, LanguageModelAssets::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, LanguageModelAssets::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, LanguageModelAssets::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  TextSafetyModelParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TextSafetyModelParams, T>::value>;
  using DataView = TextSafetyModelParamsDataView;
  using Data_ = internal::TextSafetyModelParams_Data;

  template <typename... Args>
  static TextSafetyModelParamsPtr New(Args&&... args) {
    return TextSafetyModelParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TextSafetyModelParamsPtr From(const U& u) {
    return mojo::TypeConverter<TextSafetyModelParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TextSafetyModelParams>::Convert(*this);
  }


  TextSafetyModelParams();

  TextSafetyModelParams(
      SafetyModelAssetsPtr safety_assets,
      LanguageModelAssetsPtr language_assets);

TextSafetyModelParams(const TextSafetyModelParams&) = delete;
TextSafetyModelParams& operator=(const TextSafetyModelParams&) = delete;

  ~TextSafetyModelParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TextSafetyModelParamsPtr>
  TextSafetyModelParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TextSafetyModelParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TextSafetyModelParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TextSafetyModelParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TextSafetyModelParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TextSafetyModelParams_UnserializedMessageContext<
            UserType, TextSafetyModelParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TextSafetyModelParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TextSafetyModelParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TextSafetyModelParams_UnserializedMessageContext<
            UserType, TextSafetyModelParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TextSafetyModelParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  SafetyModelAssetsPtr safety_assets;
  
  LanguageModelAssetsPtr language_assets;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TextSafetyModelParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TextSafetyModelParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TextSafetyModelParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TextSafetyModelParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
ModelFilePtr ModelFile::Clone() const {
  switch (tag_) {
    case Tag::kFile:
      return NewFile(
          mojo::Clone(data_.file));
    case Tag::kPath:
      return NewPath(
          mojo::Clone(data_.path));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, ModelFile>::value>::type*>
bool ModelFile::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kFile:
      return mojo::Equals(data_.file, other.data_.file);
    case Tag::kPath:
      return mojo::Equals(data_.path, other.data_.path);
  }

  return false;
}
template <typename UnionPtrType>
SafetyModelAssetsPtr SafetyModelAssets::Clone() const {
  switch (tag_) {
    case Tag::kTsAssets:
      return NewTsAssets(
          mojo::Clone(data_.ts_assets));
    case Tag::kBsAssets:
      return NewBsAssets(
          mojo::Clone(data_.bs_assets));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, SafetyModelAssets>::value>::type*>
bool SafetyModelAssets::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kTsAssets:
      return mojo::Equals(data_.ts_assets, other.data_.ts_assets);
    case Tag::kBsAssets:
      return mojo::Equals(data_.bs_assets, other.data_.bs_assets);
  }

  return false;
}
template <typename StructPtrType>
ModelAssetsPtr ModelAssets::Clone() const {
  return New(
      mojo::Clone(weights),
      mojo::Clone(sp_model_path),
      mojo::Clone(cache),
      mojo::Clone(encoder_cache),
      mojo::Clone(adapter_cache)
  );
}

template <typename T, ModelAssets::EnableIfSame<T>*>
bool ModelAssets::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->weights, other_struct.weights))
    return false;
  if (!mojo::Equals(this->sp_model_path, other_struct.sp_model_path))
    return false;
  if (!mojo::Equals(this->cache, other_struct.cache))
    return false;
  if (!mojo::Equals(this->encoder_cache, other_struct.encoder_cache))
    return false;
  if (!mojo::Equals(this->adapter_cache, other_struct.adapter_cache))
    return false;
  return true;
}

template <typename T, ModelAssets::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.weights < rhs.weights)
    return true;
  if (rhs.weights < lhs.weights)
    return false;
  if (lhs.sp_model_path < rhs.sp_model_path)
    return true;
  if (rhs.sp_model_path < lhs.sp_model_path)
    return false;
  if (lhs.cache < rhs.cache)
    return true;
  if (rhs.cache < lhs.cache)
    return false;
  if (lhs.encoder_cache < rhs.encoder_cache)
    return true;
  if (rhs.encoder_cache < lhs.encoder_cache)
    return false;
  if (lhs.adapter_cache < rhs.adapter_cache)
    return true;
  if (rhs.adapter_cache < lhs.adapter_cache)
    return false;
  return false;
}
template <typename StructPtrType>
LoadModelParamsPtr LoadModelParams::Clone() const {
  return New(
      mojo::Clone(backend_type),
      mojo::Clone(assets),
      mojo::Clone(max_tokens),
      mojo::Clone(adaptation_ranks),
      mojo::Clone(performance_hint)
  );
}

template <typename T, LoadModelParams::EnableIfSame<T>*>
bool LoadModelParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->backend_type, other_struct.backend_type))
    return false;
  if (!mojo::Equals(this->assets, other_struct.assets))
    return false;
  if (!mojo::Equals(this->max_tokens, other_struct.max_tokens))
    return false;
  if (!mojo::Equals(this->adaptation_ranks, other_struct.adaptation_ranks))
    return false;
  if (!mojo::Equals(this->performance_hint, other_struct.performance_hint))
    return false;
  return true;
}

template <typename T, LoadModelParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.backend_type < rhs.backend_type)
    return true;
  if (rhs.backend_type < lhs.backend_type)
    return false;
  if (lhs.assets < rhs.assets)
    return true;
  if (rhs.assets < lhs.assets)
    return false;
  if (lhs.max_tokens < rhs.max_tokens)
    return true;
  if (rhs.max_tokens < lhs.max_tokens)
    return false;
  if (lhs.adaptation_ranks < rhs.adaptation_ranks)
    return true;
  if (rhs.adaptation_ranks < lhs.adaptation_ranks)
    return false;
  if (lhs.performance_hint < rhs.performance_hint)
    return true;
  if (rhs.performance_hint < lhs.performance_hint)
    return false;
  return false;
}
template <typename StructPtrType>
TextSafetyModelAssetsPtr TextSafetyModelAssets::Clone() const {
  return New(
      mojo::Clone(data),
      mojo::Clone(sp_model)
  );
}

template <typename T, TextSafetyModelAssets::EnableIfSame<T>*>
bool TextSafetyModelAssets::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->data, other_struct.data))
    return false;
  if (!mojo::Equals(this->sp_model, other_struct.sp_model))
    return false;
  return true;
}

template <typename T, TextSafetyModelAssets::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.data < rhs.data)
    return true;
  if (rhs.data < lhs.data)
    return false;
  if (lhs.sp_model < rhs.sp_model)
    return true;
  if (rhs.sp_model < lhs.sp_model)
    return false;
  return false;
}
template <typename StructPtrType>
BertSafetyModelAssetsPtr BertSafetyModelAssets::Clone() const {
  return New(
      mojo::Clone(model)
  );
}

template <typename T, BertSafetyModelAssets::EnableIfSame<T>*>
bool BertSafetyModelAssets::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->model, other_struct.model))
    return false;
  return true;
}

template <typename T, BertSafetyModelAssets::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.model < rhs.model)
    return true;
  if (rhs.model < lhs.model)
    return false;
  return false;
}
template <typename StructPtrType>
LanguageModelAssetsPtr LanguageModelAssets::Clone() const {
  return New(
      mojo::Clone(model)
  );
}

template <typename T, LanguageModelAssets::EnableIfSame<T>*>
bool LanguageModelAssets::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->model, other_struct.model))
    return false;
  return true;
}

template <typename T, LanguageModelAssets::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.model < rhs.model)
    return true;
  if (rhs.model < lhs.model)
    return false;
  return false;
}
template <typename StructPtrType>
TextSafetyModelParamsPtr TextSafetyModelParams::Clone() const {
  return New(
      mojo::Clone(safety_assets),
      mojo::Clone(language_assets)
  );
}

template <typename T, TextSafetyModelParams::EnableIfSame<T>*>
bool TextSafetyModelParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->safety_assets, other_struct.safety_assets))
    return false;
  if (!mojo::Equals(this->language_assets, other_struct.language_assets))
    return false;
  return true;
}

template <typename T, TextSafetyModelParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.safety_assets < rhs.safety_assets)
    return true;
  if (rhs.safety_assets < lhs.safety_assets)
    return false;
  if (lhs.language_assets < rhs.language_assets)
    return true;
  if (rhs.language_assets < lhs.language_assets)
    return false;
  return false;
}


}  // on_device_model::mojom

namespace mojo {


template <>
struct  StructTraits<::on_device_model::mojom::ModelAssets::DataView,
                                         ::on_device_model::mojom::ModelAssetsPtr> {
  static bool IsNull(const ::on_device_model::mojom::ModelAssetsPtr& input) { return !input; }
  static void SetToNull(::on_device_model::mojom::ModelAssetsPtr* output) { output->reset(); }

  static  decltype(::on_device_model::mojom::ModelAssets::weights)& weights(
       ::on_device_model::mojom::ModelAssetsPtr& input) {
    return input->weights;
  }

  static const decltype(::on_device_model::mojom::ModelAssets::sp_model_path)& sp_model_path(
      const ::on_device_model::mojom::ModelAssetsPtr& input) {
    return input->sp_model_path;
  }

  static  decltype(::on_device_model::mojom::ModelAssets::cache)& cache(
       ::on_device_model::mojom::ModelAssetsPtr& input) {
    return input->cache;
  }

  static  decltype(::on_device_model::mojom::ModelAssets::encoder_cache)& encoder_cache(
       ::on_device_model::mojom::ModelAssetsPtr& input) {
    return input->encoder_cache;
  }

  static  decltype(::on_device_model::mojom::ModelAssets::adapter_cache)& adapter_cache(
       ::on_device_model::mojom::ModelAssetsPtr& input) {
    return input->adapter_cache;
  }

  static bool Read(::on_device_model::mojom::ModelAssets::DataView input, ::on_device_model::mojom::ModelAssetsPtr* output);
};


template <>
struct  StructTraits<::on_device_model::mojom::LoadModelParams::DataView,
                                         ::on_device_model::mojom::LoadModelParamsPtr> {
  static bool IsNull(const ::on_device_model::mojom::LoadModelParamsPtr& input) { return !input; }
  static void SetToNull(::on_device_model::mojom::LoadModelParamsPtr* output) { output->reset(); }

  static decltype(::on_device_model::mojom::LoadModelParams::backend_type) backend_type(
      const ::on_device_model::mojom::LoadModelParamsPtr& input) {
    return input->backend_type;
  }

  static  decltype(::on_device_model::mojom::LoadModelParams::assets)& assets(
       ::on_device_model::mojom::LoadModelParamsPtr& input) {
    return input->assets;
  }

  static decltype(::on_device_model::mojom::LoadModelParams::max_tokens) max_tokens(
      const ::on_device_model::mojom::LoadModelParamsPtr& input) {
    return input->max_tokens;
  }

  static const decltype(::on_device_model::mojom::LoadModelParams::adaptation_ranks)& adaptation_ranks(
      const ::on_device_model::mojom::LoadModelParamsPtr& input) {
    return input->adaptation_ranks;
  }

  static decltype(::on_device_model::mojom::LoadModelParams::performance_hint) performance_hint(
      const ::on_device_model::mojom::LoadModelParamsPtr& input) {
    return input->performance_hint;
  }

  static bool Read(::on_device_model::mojom::LoadModelParams::DataView input, ::on_device_model::mojom::LoadModelParamsPtr* output);
};


template <>
struct  StructTraits<::on_device_model::mojom::TextSafetyModelAssets::DataView,
                                         ::on_device_model::mojom::TextSafetyModelAssetsPtr> {
  static bool IsNull(const ::on_device_model::mojom::TextSafetyModelAssetsPtr& input) { return !input; }
  static void SetToNull(::on_device_model::mojom::TextSafetyModelAssetsPtr* output) { output->reset(); }

  static  decltype(::on_device_model::mojom::TextSafetyModelAssets::data)& data(
       ::on_device_model::mojom::TextSafetyModelAssetsPtr& input) {
    return input->data;
  }

  static  decltype(::on_device_model::mojom::TextSafetyModelAssets::sp_model)& sp_model(
       ::on_device_model::mojom::TextSafetyModelAssetsPtr& input) {
    return input->sp_model;
  }

  static bool Read(::on_device_model::mojom::TextSafetyModelAssets::DataView input, ::on_device_model::mojom::TextSafetyModelAssetsPtr* output);
};


template <>
struct  StructTraits<::on_device_model::mojom::BertSafetyModelAssets::DataView,
                                         ::on_device_model::mojom::BertSafetyModelAssetsPtr> {
  static bool IsNull(const ::on_device_model::mojom::BertSafetyModelAssetsPtr& input) { return !input; }
  static void SetToNull(::on_device_model::mojom::BertSafetyModelAssetsPtr* output) { output->reset(); }

  static  decltype(::on_device_model::mojom::BertSafetyModelAssets::model)& model(
       ::on_device_model::mojom::BertSafetyModelAssetsPtr& input) {
    return input->model;
  }

  static bool Read(::on_device_model::mojom::BertSafetyModelAssets::DataView input, ::on_device_model::mojom::BertSafetyModelAssetsPtr* output);
};


template <>
struct  StructTraits<::on_device_model::mojom::LanguageModelAssets::DataView,
                                         ::on_device_model::mojom::LanguageModelAssetsPtr> {
  static bool IsNull(const ::on_device_model::mojom::LanguageModelAssetsPtr& input) { return !input; }
  static void SetToNull(::on_device_model::mojom::LanguageModelAssetsPtr* output) { output->reset(); }

  static  decltype(::on_device_model::mojom::LanguageModelAssets::model)& model(
       ::on_device_model::mojom::LanguageModelAssetsPtr& input) {
    return input->model;
  }

  static bool Read(::on_device_model::mojom::LanguageModelAssets::DataView input, ::on_device_model::mojom::LanguageModelAssetsPtr* output);
};


template <>
struct  StructTraits<::on_device_model::mojom::TextSafetyModelParams::DataView,
                                         ::on_device_model::mojom::TextSafetyModelParamsPtr> {
  static bool IsNull(const ::on_device_model::mojom::TextSafetyModelParamsPtr& input) { return !input; }
  static void SetToNull(::on_device_model::mojom::TextSafetyModelParamsPtr* output) { output->reset(); }

  static  decltype(::on_device_model::mojom::TextSafetyModelParams::safety_assets)& safety_assets(
       ::on_device_model::mojom::TextSafetyModelParamsPtr& input) {
    return input->safety_assets;
  }

  static  decltype(::on_device_model::mojom::TextSafetyModelParams::language_assets)& language_assets(
       ::on_device_model::mojom::TextSafetyModelParamsPtr& input) {
    return input->language_assets;
  }

  static bool Read(::on_device_model::mojom::TextSafetyModelParams::DataView input, ::on_device_model::mojom::TextSafetyModelParamsPtr* output);
};


template <>
struct  UnionTraits<::on_device_model::mojom::ModelFile::DataView,
                                        ::on_device_model::mojom::ModelFilePtr> {
  static bool IsNull(const ::on_device_model::mojom::ModelFilePtr& input) { return !input; }
  static void SetToNull(::on_device_model::mojom::ModelFilePtr* output) { output->reset(); }

  static ::on_device_model::mojom::ModelFile::Tag GetTag(const ::on_device_model::mojom::ModelFilePtr& input) {
    return input->which();
  }

  static  ::base::File& file( ::on_device_model::mojom::ModelFilePtr& input) {
    return input->get_file();
  }

  static const ::base::FilePath& path(const ::on_device_model::mojom::ModelFilePtr& input) {
    return input->get_path();
  }

  static bool Read(::on_device_model::mojom::ModelFile::DataView input, ::on_device_model::mojom::ModelFilePtr* output);
};


template <>
struct  UnionTraits<::on_device_model::mojom::SafetyModelAssets::DataView,
                                        ::on_device_model::mojom::SafetyModelAssetsPtr> {
  static bool IsNull(const ::on_device_model::mojom::SafetyModelAssetsPtr& input) { return !input; }
  static void SetToNull(::on_device_model::mojom::SafetyModelAssetsPtr* output) { output->reset(); }

  static ::on_device_model::mojom::SafetyModelAssets::Tag GetTag(const ::on_device_model::mojom::SafetyModelAssetsPtr& input) {
    return input->which();
  }

  static  ::on_device_model::mojom::TextSafetyModelAssetsPtr& ts_assets( ::on_device_model::mojom::SafetyModelAssetsPtr& input) {
    return input->get_ts_assets();
  }

  static  ::on_device_model::mojom::BertSafetyModelAssetsPtr& bs_assets( ::on_device_model::mojom::SafetyModelAssetsPtr& input) {
    return input->get_bs_assets();
  }

  static bool Read(::on_device_model::mojom::SafetyModelAssets::DataView input, ::on_device_model::mojom::SafetyModelAssetsPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_ON_DEVICE_MODEL_PUBLIC_MOJOM_ON_DEVICE_MODEL_SERVICE_MOJOM_H_