// services/on_device_model/public/mojom/on_device_model_service.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('onDeviceModel.mojom.LoadModelResult');
goog.require('onDeviceModel.mojom.PerformanceClass');
goog.require('onDeviceModel.mojom.OnDeviceModel');
goog.require('onDeviceModel.mojom.TextSafetyModel');
goog.require('onDeviceModel.mojom.Capabilities');
goog.require('onDeviceModel.mojom.DeviceInfo');
goog.require('onDeviceModel.mojom.DevicePerformanceInfo');
goog.require('mojoBase.mojom.File');
goog.require('mojoBase.mojom.FilePath');
goog.require('mojoBase.mojom.ReadOnlyFile');
goog.require('onDeviceModel.mojom.SafetyInfo');
goog.require('mojoBase.mojom.Uuid');




goog.provide('onDeviceModel.mojom.ModelBackendType');
goog.provide('onDeviceModel.mojom.ModelBackendTypeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
onDeviceModel.mojom.ModelBackendTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
onDeviceModel.mojom.ModelBackendType = {
  
  kGpu: 0,
  kApu: 1,
  kCpu: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

goog.provide('onDeviceModel.mojom.ModelPerformanceHint');
goog.provide('onDeviceModel.mojom.ModelPerformanceHintSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
onDeviceModel.mojom.ModelPerformanceHintSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
onDeviceModel.mojom.ModelPerformanceHint = {
  
  kHighestQuality: 0,
  kFastestInference: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

goog.provide('onDeviceModel.mojom.PlatformModelState');
goog.provide('onDeviceModel.mojom.PlatformModelStateSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
onDeviceModel.mojom.PlatformModelStateSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
onDeviceModel.mojom.PlatformModelState = {
  
  kUnknownState: 0,
  kInstalledOnDisk: 1,
  kInvalidUuid: 2,
  kInvalidDlcClient: 3,
  kInvalidDlcPackage: 4,
  kInvalidDlcVerifiedState: 5,
  kInvalidDlcInstall: 6,
  kInvalidModelFormat: 7,
  kInvalidModelDescriptor: 8,
  kInvalidBaseModelDescriptor: 9,
  MIN_VALUE: 0,
  MAX_VALUE: 9,
};

goog.provide('onDeviceModel.mojom.FormatFeature');
goog.provide('onDeviceModel.mojom.FormatFeatureSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
onDeviceModel.mojom.FormatFeatureSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
onDeviceModel.mojom.FormatFeature = {
  
  kNone: 0,
  kPrompt: 1,
  kAudioSummary: 2,
  kAudioTitle: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};

goog.provide('onDeviceModel.mojom.SafetyFeature');
goog.provide('onDeviceModel.mojom.SafetyFeatureSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
onDeviceModel.mojom.SafetyFeatureSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
onDeviceModel.mojom.SafetyFeature = {
  
  kGeneral: 0,
  kAudioSummaryRequest: 1,
  kAudioTitleRequest: 2,
  kAudioSummaryResponse: 3,
  kAudioTitleResponse: 4,
  kAudioSummaryResponseV2: 5,
  kAudioTitleResponseV2: 6,
  MIN_VALUE: 0,
  MAX_VALUE: 6,
};



goog.provide('onDeviceModel.mojom.PlatformModelProgressObserver');
goog.provide('onDeviceModel.mojom.PlatformModelProgressObserverReceiver');
goog.provide('onDeviceModel.mojom.PlatformModelProgressObserverCallbackRouter');
goog.provide('onDeviceModel.mojom.PlatformModelProgressObserverInterface');
goog.provide('onDeviceModel.mojom.PlatformModelProgressObserverRemote');
goog.provide('onDeviceModel.mojom.PlatformModelProgressObserverPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
onDeviceModel.mojom.PlatformModelProgressObserverPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        onDeviceModel.mojom.PlatformModelProgressObserver.$interfaceName,
        scope);
  }
};

/** @interface */
onDeviceModel.mojom.PlatformModelProgressObserverInterface = class {
  
  /**
   * @param { !number } progress
   */

  progress(progress) {}
};

/**
 * @export
 * @implements { onDeviceModel.mojom.PlatformModelProgressObserverInterface }
 */
onDeviceModel.mojom.PlatformModelProgressObserverRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!onDeviceModel.mojom.PlatformModelProgressObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          onDeviceModel.mojom.PlatformModelProgressObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!onDeviceModel.mojom.PlatformModelProgressObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !number } progress
   */

  progress(
      progress) {
    this.proxy.sendMessage(
        0,
        onDeviceModel.mojom.PlatformModelProgressObserver_Progress_ParamsSpec.$,
        null,
        [
          progress
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PlatformModelProgressObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
onDeviceModel.mojom.PlatformModelProgressObserverReceiver = class {
  /**
   * @param {!onDeviceModel.mojom.PlatformModelProgressObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!onDeviceModel.mojom.PlatformModelProgressObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        onDeviceModel.mojom.PlatformModelProgressObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!onDeviceModel.mojom.PlatformModelProgressObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        onDeviceModel.mojom.PlatformModelProgressObserver_Progress_ParamsSpec.$,
        null,
        impl.progress.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
onDeviceModel.mojom.PlatformModelProgressObserver = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "on_device_model.mojom.PlatformModelProgressObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!onDeviceModel.mojom.PlatformModelProgressObserverRemote}
   * @export
   */
  static getRemote() {
    let remote = new onDeviceModel.mojom.PlatformModelProgressObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the PlatformModelProgressObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
onDeviceModel.mojom.PlatformModelProgressObserverCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      onDeviceModel.mojom.PlatformModelProgressObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!onDeviceModel.mojom.PlatformModelProgressObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.progress =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        onDeviceModel.mojom.PlatformModelProgressObserver_Progress_ParamsSpec.$,
        null,
        this.progress.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('onDeviceModel.mojom.OnDeviceModelService');
goog.provide('onDeviceModel.mojom.OnDeviceModelServiceReceiver');
goog.provide('onDeviceModel.mojom.OnDeviceModelServiceCallbackRouter');
goog.provide('onDeviceModel.mojom.OnDeviceModelServiceInterface');
goog.provide('onDeviceModel.mojom.OnDeviceModelServiceRemote');
goog.provide('onDeviceModel.mojom.OnDeviceModelServicePendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
onDeviceModel.mojom.OnDeviceModelServicePendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        onDeviceModel.mojom.OnDeviceModelService.$interfaceName,
        scope);
  }
};

/** @interface */
onDeviceModel.mojom.OnDeviceModelServiceInterface = class {
  
  /**
   * @param { !onDeviceModel.mojom.LoadModelParams } params
   * @param { !onDeviceModel.mojom.OnDeviceModelPendingReceiver } model
   * @return {!Promise<{
        result: !onDeviceModel.mojom.LoadModelResult,
   *  }>}
   */

  loadModel(params, model) {}
  
  /**
   * @param { !onDeviceModel.mojom.ModelFile } weights
   * @return {!Promise<{
        capabilities: !onDeviceModel.mojom.Capabilities,
   *  }>}
   */

  getCapabilities(weights) {}
  
  /**
   * @param { !onDeviceModel.mojom.TextSafetyModelParams } params
   * @param { !onDeviceModel.mojom.TextSafetyModelPendingReceiver } model
   */

  loadTextSafetyModel(params, model) {}
  
  /**
   * @return {!Promise<{
        performanceInfo: !onDeviceModel.mojom.DevicePerformanceInfo,
        deviceInfo: !onDeviceModel.mojom.DeviceInfo,
   *  }>}
   */

  getDeviceAndPerformanceInfo() {}
};

/**
 * @export
 * @implements { onDeviceModel.mojom.OnDeviceModelServiceInterface }
 */
onDeviceModel.mojom.OnDeviceModelServiceRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!onDeviceModel.mojom.OnDeviceModelServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          onDeviceModel.mojom.OnDeviceModelServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!onDeviceModel.mojom.OnDeviceModelServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !onDeviceModel.mojom.LoadModelParams } params
   * @param { !onDeviceModel.mojom.OnDeviceModelPendingReceiver } model
   * @return {!Promise<{
        result: !onDeviceModel.mojom.LoadModelResult,
   *  }>}
   */

  loadModel(
      params,
      model) {
    return this.proxy.sendMessage(
        0,
        onDeviceModel.mojom.OnDeviceModelService_LoadModel_ParamsSpec.$,
        onDeviceModel.mojom.OnDeviceModelService_LoadModel_ResponseParamsSpec.$,
        [
          params,
          model
        ],
        false);
  }

  
  /**
   * @param { !onDeviceModel.mojom.ModelFile } weights
   * @return {!Promise<{
        capabilities: !onDeviceModel.mojom.Capabilities,
   *  }>}
   */

  getCapabilities(
      weights) {
    return this.proxy.sendMessage(
        1,
        onDeviceModel.mojom.OnDeviceModelService_GetCapabilities_ParamsSpec.$,
        onDeviceModel.mojom.OnDeviceModelService_GetCapabilities_ResponseParamsSpec.$,
        [
          weights
        ],
        false);
  }

  
  /**
   * @param { !onDeviceModel.mojom.TextSafetyModelParams } params
   * @param { !onDeviceModel.mojom.TextSafetyModelPendingReceiver } model
   */

  loadTextSafetyModel(
      params,
      model) {
    this.proxy.sendMessage(
        2,
        onDeviceModel.mojom.OnDeviceModelService_LoadTextSafetyModel_ParamsSpec.$,
        null,
        [
          params,
          model
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        performanceInfo: !onDeviceModel.mojom.DevicePerformanceInfo,
        deviceInfo: !onDeviceModel.mojom.DeviceInfo,
   *  }>}
   */

  getDeviceAndPerformanceInfo() {
    return this.proxy.sendMessage(
        3,
        onDeviceModel.mojom.OnDeviceModelService_GetDeviceAndPerformanceInfo_ParamsSpec.$,
        onDeviceModel.mojom.OnDeviceModelService_GetDeviceAndPerformanceInfo_ResponseParamsSpec.$,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the OnDeviceModelService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
onDeviceModel.mojom.OnDeviceModelServiceReceiver = class {
  /**
   * @param {!onDeviceModel.mojom.OnDeviceModelServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!onDeviceModel.mojom.OnDeviceModelServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        onDeviceModel.mojom.OnDeviceModelServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!onDeviceModel.mojom.OnDeviceModelServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        onDeviceModel.mojom.OnDeviceModelService_LoadModel_ParamsSpec.$,
        onDeviceModel.mojom.OnDeviceModelService_LoadModel_ResponseParamsSpec.$,
        impl.loadModel.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        onDeviceModel.mojom.OnDeviceModelService_GetCapabilities_ParamsSpec.$,
        onDeviceModel.mojom.OnDeviceModelService_GetCapabilities_ResponseParamsSpec.$,
        impl.getCapabilities.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        onDeviceModel.mojom.OnDeviceModelService_LoadTextSafetyModel_ParamsSpec.$,
        null,
        impl.loadTextSafetyModel.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        onDeviceModel.mojom.OnDeviceModelService_GetDeviceAndPerformanceInfo_ParamsSpec.$,
        onDeviceModel.mojom.OnDeviceModelService_GetDeviceAndPerformanceInfo_ResponseParamsSpec.$,
        impl.getDeviceAndPerformanceInfo.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
onDeviceModel.mojom.OnDeviceModelService = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "on_device_model.mojom.OnDeviceModelService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!onDeviceModel.mojom.OnDeviceModelServiceRemote}
   * @export
   */
  static getRemote() {
    let remote = new onDeviceModel.mojom.OnDeviceModelServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the OnDeviceModelService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
onDeviceModel.mojom.OnDeviceModelServiceCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      onDeviceModel.mojom.OnDeviceModelServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!onDeviceModel.mojom.OnDeviceModelServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.loadModel =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        onDeviceModel.mojom.OnDeviceModelService_LoadModel_ParamsSpec.$,
        onDeviceModel.mojom.OnDeviceModelService_LoadModel_ResponseParamsSpec.$,
        this.loadModel.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getCapabilities =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        onDeviceModel.mojom.OnDeviceModelService_GetCapabilities_ParamsSpec.$,
        onDeviceModel.mojom.OnDeviceModelService_GetCapabilities_ResponseParamsSpec.$,
        this.getCapabilities.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.loadTextSafetyModel =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        onDeviceModel.mojom.OnDeviceModelService_LoadTextSafetyModel_ParamsSpec.$,
        null,
        this.loadTextSafetyModel.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getDeviceAndPerformanceInfo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        onDeviceModel.mojom.OnDeviceModelService_GetDeviceAndPerformanceInfo_ParamsSpec.$,
        onDeviceModel.mojom.OnDeviceModelService_GetDeviceAndPerformanceInfo_ResponseParamsSpec.$,
        this.getDeviceAndPerformanceInfo.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('onDeviceModel.mojom.OnDeviceModelPlatformService');
goog.provide('onDeviceModel.mojom.OnDeviceModelPlatformServiceReceiver');
goog.provide('onDeviceModel.mojom.OnDeviceModelPlatformServiceCallbackRouter');
goog.provide('onDeviceModel.mojom.OnDeviceModelPlatformServiceInterface');
goog.provide('onDeviceModel.mojom.OnDeviceModelPlatformServiceRemote');
goog.provide('onDeviceModel.mojom.OnDeviceModelPlatformServicePendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
onDeviceModel.mojom.OnDeviceModelPlatformServicePendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        onDeviceModel.mojom.OnDeviceModelPlatformService.$interfaceName,
        scope);
  }
};

/** @interface */
onDeviceModel.mojom.OnDeviceModelPlatformServiceInterface = class {
  
  /**
   * @param { !mojoBase.mojom.Uuid } uuid
   * @param { !onDeviceModel.mojom.OnDeviceModelPendingReceiver } model
   * @param { ?onDeviceModel.mojom.PlatformModelProgressObserverRemote } progressObserver
   * @return {!Promise<{
        result: !onDeviceModel.mojom.LoadModelResult,
   *  }>}
   */

  loadPlatformModel(uuid, model, progressObserver) {}
  
  /**
   * @param { !mojoBase.mojom.Uuid } uuid
   * @return {!Promise<{
        result: !onDeviceModel.mojom.PlatformModelState,
   *  }>}
   */

  getPlatformModelState(uuid) {}
  
  /**
   * @return {!Promise<{
        performanceClass: !onDeviceModel.mojom.PerformanceClass,
   *  }>}
   */

  getEstimatedPerformanceClass() {}
  
  /**
   * @param { !mojoBase.mojom.Uuid } uuid
   * @param { !onDeviceModel.mojom.FormatFeature } feature
   * @param { !Object<!string, !string> } fields
   * @return {!Promise<{
        result: ?string,
   *  }>}
   */

  formatInput(uuid, feature, fields) {}
  
  /**
   * @param { !onDeviceModel.mojom.SafetyFeature } safetyFeature
   * @param { !string } text
   * @param { !onDeviceModel.mojom.SafetyInfo } safetyInfo
   * @return {!Promise<{
        result: !boolean,
   *  }>}
   */

  validateSafetyResult(safetyFeature, text, safetyInfo) {}
};

/**
 * @export
 * @implements { onDeviceModel.mojom.OnDeviceModelPlatformServiceInterface }
 */
onDeviceModel.mojom.OnDeviceModelPlatformServiceRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!onDeviceModel.mojom.OnDeviceModelPlatformServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          onDeviceModel.mojom.OnDeviceModelPlatformServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!onDeviceModel.mojom.OnDeviceModelPlatformServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !mojoBase.mojom.Uuid } uuid
   * @param { !onDeviceModel.mojom.OnDeviceModelPendingReceiver } model
   * @param { ?onDeviceModel.mojom.PlatformModelProgressObserverRemote } progressObserver
   * @return {!Promise<{
        result: !onDeviceModel.mojom.LoadModelResult,
   *  }>}
   */

  loadPlatformModel(
      uuid,
      model,
      progressObserver) {
    return this.proxy.sendMessage(
        0,
        onDeviceModel.mojom.OnDeviceModelPlatformService_LoadPlatformModel_ParamsSpec.$,
        onDeviceModel.mojom.OnDeviceModelPlatformService_LoadPlatformModel_ResponseParamsSpec.$,
        [
          uuid,
          model,
          progressObserver
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.Uuid } uuid
   * @return {!Promise<{
        result: !onDeviceModel.mojom.PlatformModelState,
   *  }>}
   */

  getPlatformModelState(
      uuid) {
    return this.proxy.sendMessage(
        1,
        onDeviceModel.mojom.OnDeviceModelPlatformService_GetPlatformModelState_ParamsSpec.$,
        onDeviceModel.mojom.OnDeviceModelPlatformService_GetPlatformModelState_ResponseParamsSpec.$,
        [
          uuid
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        performanceClass: !onDeviceModel.mojom.PerformanceClass,
   *  }>}
   */

  getEstimatedPerformanceClass() {
    return this.proxy.sendMessage(
        2,
        onDeviceModel.mojom.OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ParamsSpec.$,
        onDeviceModel.mojom.OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.Uuid } uuid
   * @param { !onDeviceModel.mojom.FormatFeature } feature
   * @param { !Object<!string, !string> } fields
   * @return {!Promise<{
        result: ?string,
   *  }>}
   */

  formatInput(
      uuid,
      feature,
      fields) {
    return this.proxy.sendMessage(
        3,
        onDeviceModel.mojom.OnDeviceModelPlatformService_FormatInput_ParamsSpec.$,
        onDeviceModel.mojom.OnDeviceModelPlatformService_FormatInput_ResponseParamsSpec.$,
        [
          uuid,
          feature,
          fields
        ],
        false);
  }

  
  /**
   * @param { !onDeviceModel.mojom.SafetyFeature } safetyFeature
   * @param { !string } text
   * @param { !onDeviceModel.mojom.SafetyInfo } safetyInfo
   * @return {!Promise<{
        result: !boolean,
   *  }>}
   */

  validateSafetyResult(
      safetyFeature,
      text,
      safetyInfo) {
    return this.proxy.sendMessage(
        4,
        onDeviceModel.mojom.OnDeviceModelPlatformService_ValidateSafetyResult_ParamsSpec.$,
        onDeviceModel.mojom.OnDeviceModelPlatformService_ValidateSafetyResult_ResponseParamsSpec.$,
        [
          safetyFeature,
          text,
          safetyInfo
        ],
        false);
  }
};

/**
 * An object which receives request messages for the OnDeviceModelPlatformService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
onDeviceModel.mojom.OnDeviceModelPlatformServiceReceiver = class {
  /**
   * @param {!onDeviceModel.mojom.OnDeviceModelPlatformServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!onDeviceModel.mojom.OnDeviceModelPlatformServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        onDeviceModel.mojom.OnDeviceModelPlatformServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!onDeviceModel.mojom.OnDeviceModelPlatformServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        onDeviceModel.mojom.OnDeviceModelPlatformService_LoadPlatformModel_ParamsSpec.$,
        onDeviceModel.mojom.OnDeviceModelPlatformService_LoadPlatformModel_ResponseParamsSpec.$,
        impl.loadPlatformModel.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        onDeviceModel.mojom.OnDeviceModelPlatformService_GetPlatformModelState_ParamsSpec.$,
        onDeviceModel.mojom.OnDeviceModelPlatformService_GetPlatformModelState_ResponseParamsSpec.$,
        impl.getPlatformModelState.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        onDeviceModel.mojom.OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ParamsSpec.$,
        onDeviceModel.mojom.OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ResponseParamsSpec.$,
        impl.getEstimatedPerformanceClass.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        onDeviceModel.mojom.OnDeviceModelPlatformService_FormatInput_ParamsSpec.$,
        onDeviceModel.mojom.OnDeviceModelPlatformService_FormatInput_ResponseParamsSpec.$,
        impl.formatInput.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        onDeviceModel.mojom.OnDeviceModelPlatformService_ValidateSafetyResult_ParamsSpec.$,
        onDeviceModel.mojom.OnDeviceModelPlatformService_ValidateSafetyResult_ResponseParamsSpec.$,
        impl.validateSafetyResult.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
onDeviceModel.mojom.OnDeviceModelPlatformService = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "on_device_model.mojom.OnDeviceModelPlatformService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!onDeviceModel.mojom.OnDeviceModelPlatformServiceRemote}
   * @export
   */
  static getRemote() {
    let remote = new onDeviceModel.mojom.OnDeviceModelPlatformServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the OnDeviceModelPlatformService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
onDeviceModel.mojom.OnDeviceModelPlatformServiceCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      onDeviceModel.mojom.OnDeviceModelPlatformServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!onDeviceModel.mojom.OnDeviceModelPlatformServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.loadPlatformModel =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        onDeviceModel.mojom.OnDeviceModelPlatformService_LoadPlatformModel_ParamsSpec.$,
        onDeviceModel.mojom.OnDeviceModelPlatformService_LoadPlatformModel_ResponseParamsSpec.$,
        this.loadPlatformModel.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getPlatformModelState =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        onDeviceModel.mojom.OnDeviceModelPlatformService_GetPlatformModelState_ParamsSpec.$,
        onDeviceModel.mojom.OnDeviceModelPlatformService_GetPlatformModelState_ResponseParamsSpec.$,
        this.getPlatformModelState.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getEstimatedPerformanceClass =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        onDeviceModel.mojom.OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ParamsSpec.$,
        onDeviceModel.mojom.OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ResponseParamsSpec.$,
        this.getEstimatedPerformanceClass.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.formatInput =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        onDeviceModel.mojom.OnDeviceModelPlatformService_FormatInput_ParamsSpec.$,
        onDeviceModel.mojom.OnDeviceModelPlatformService_FormatInput_ResponseParamsSpec.$,
        this.formatInput.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.validateSafetyResult =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        onDeviceModel.mojom.OnDeviceModelPlatformService_ValidateSafetyResult_ParamsSpec.$,
        onDeviceModel.mojom.OnDeviceModelPlatformService_ValidateSafetyResult_ResponseParamsSpec.$,
        this.validateSafetyResult.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('onDeviceModel.mojom.ModelAssetsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
onDeviceModel.mojom.ModelAssetsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('onDeviceModel.mojom.LoadModelParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
onDeviceModel.mojom.LoadModelParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('onDeviceModel.mojom.TextSafetyModelAssetsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
onDeviceModel.mojom.TextSafetyModelAssetsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('onDeviceModel.mojom.BertSafetyModelAssetsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
onDeviceModel.mojom.BertSafetyModelAssetsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('onDeviceModel.mojom.LanguageModelAssetsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
onDeviceModel.mojom.LanguageModelAssetsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('onDeviceModel.mojom.TextSafetyModelParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
onDeviceModel.mojom.TextSafetyModelParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('onDeviceModel.mojom.PlatformModelProgressObserver_Progress_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
onDeviceModel.mojom.PlatformModelProgressObserver_Progress_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('onDeviceModel.mojom.OnDeviceModelService_LoadModel_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
onDeviceModel.mojom.OnDeviceModelService_LoadModel_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('onDeviceModel.mojom.OnDeviceModelService_LoadModel_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
onDeviceModel.mojom.OnDeviceModelService_LoadModel_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('onDeviceModel.mojom.OnDeviceModelService_GetCapabilities_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
onDeviceModel.mojom.OnDeviceModelService_GetCapabilities_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('onDeviceModel.mojom.OnDeviceModelService_GetCapabilities_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
onDeviceModel.mojom.OnDeviceModelService_GetCapabilities_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('onDeviceModel.mojom.OnDeviceModelService_LoadTextSafetyModel_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
onDeviceModel.mojom.OnDeviceModelService_LoadTextSafetyModel_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('onDeviceModel.mojom.OnDeviceModelService_GetDeviceAndPerformanceInfo_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
onDeviceModel.mojom.OnDeviceModelService_GetDeviceAndPerformanceInfo_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('onDeviceModel.mojom.OnDeviceModelService_GetDeviceAndPerformanceInfo_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
onDeviceModel.mojom.OnDeviceModelService_GetDeviceAndPerformanceInfo_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('onDeviceModel.mojom.OnDeviceModelPlatformService_LoadPlatformModel_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
onDeviceModel.mojom.OnDeviceModelPlatformService_LoadPlatformModel_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('onDeviceModel.mojom.OnDeviceModelPlatformService_LoadPlatformModel_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
onDeviceModel.mojom.OnDeviceModelPlatformService_LoadPlatformModel_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('onDeviceModel.mojom.OnDeviceModelPlatformService_GetPlatformModelState_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
onDeviceModel.mojom.OnDeviceModelPlatformService_GetPlatformModelState_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('onDeviceModel.mojom.OnDeviceModelPlatformService_GetPlatformModelState_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
onDeviceModel.mojom.OnDeviceModelPlatformService_GetPlatformModelState_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('onDeviceModel.mojom.OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
onDeviceModel.mojom.OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('onDeviceModel.mojom.OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
onDeviceModel.mojom.OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('onDeviceModel.mojom.OnDeviceModelPlatformService_FormatInput_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
onDeviceModel.mojom.OnDeviceModelPlatformService_FormatInput_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('onDeviceModel.mojom.OnDeviceModelPlatformService_FormatInput_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
onDeviceModel.mojom.OnDeviceModelPlatformService_FormatInput_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('onDeviceModel.mojom.OnDeviceModelPlatformService_ValidateSafetyResult_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
onDeviceModel.mojom.OnDeviceModelPlatformService_ValidateSafetyResult_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('onDeviceModel.mojom.OnDeviceModelPlatformService_ValidateSafetyResult_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
onDeviceModel.mojom.OnDeviceModelPlatformService_ValidateSafetyResult_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('onDeviceModel.mojom.ModelFileSpec');
/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
onDeviceModel.mojom.ModelFileSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('onDeviceModel.mojom.SafetyModelAssetsSpec');
/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
onDeviceModel.mojom.SafetyModelAssetsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    onDeviceModel.mojom.ModelAssetsSpec.$,
    'ModelAssets',
    [
      mojo.internal.StructField(
        'weights', 0,
        0,
        onDeviceModel.mojom.ModelFileSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'spModelPath', 16,
        0,
        mojoBase.mojom.FilePathSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'cache', 24,
        0,
        mojoBase.mojom.FileSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'encoderCache', 32,
        0,
        mojoBase.mojom.FileSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'adapterCache', 40,
        0,
        mojoBase.mojom.FileSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 56],]);



goog.provide('onDeviceModel.mojom.ModelAssets');

/** @record */
onDeviceModel.mojom.ModelAssets = class {
  constructor() {
    /** @export { !onDeviceModel.mojom.ModelFile } */
    this.weights;
    /** @export { (mojoBase.mojom.FilePath|undefined) } */
    this.spModelPath;
    /** @export { (mojoBase.mojom.File|undefined) } */
    this.cache;
    /** @export { (mojoBase.mojom.File|undefined) } */
    this.encoderCache;
    /** @export { (mojoBase.mojom.File|undefined) } */
    this.adapterCache;
  }
};



mojo.internal.Struct(
    onDeviceModel.mojom.LoadModelParamsSpec.$,
    'LoadModelParams',
    [
      mojo.internal.StructField(
        'backendType', 0,
        0,
        onDeviceModel.mojom.ModelBackendTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'assets', 8,
        0,
        onDeviceModel.mojom.ModelAssetsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'maxTokens', 4,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'adaptationRanks', 16,
        0,
        mojo.internal.Array(mojo.internal.Uint32, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'performanceHint', 24,
        0,
        onDeviceModel.mojom.ModelPerformanceHintSpec.$,
        onDeviceModel.mojom.ModelPerformanceHint.kHighestQuality,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('onDeviceModel.mojom.LoadModelParams');

/** @record */
onDeviceModel.mojom.LoadModelParams = class {
  constructor() {
    /** @export { !onDeviceModel.mojom.ModelBackendType } */
    this.backendType;
    /** @export { !onDeviceModel.mojom.ModelAssets } */
    this.assets;
    /** @export { !number } */
    this.maxTokens;
    /** @export { !Array<!number> } */
    this.adaptationRanks;
    /** @export { !onDeviceModel.mojom.ModelPerformanceHint } */
    this.performanceHint;
  }
};



mojo.internal.Struct(
    onDeviceModel.mojom.TextSafetyModelAssetsSpec.$,
    'TextSafetyModelAssets',
    [
      mojo.internal.StructField(
        'data', 0,
        0,
        mojoBase.mojom.ReadOnlyFileSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'spModel', 8,
        0,
        mojoBase.mojom.ReadOnlyFileSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('onDeviceModel.mojom.TextSafetyModelAssets');

/** @record */
onDeviceModel.mojom.TextSafetyModelAssets = class {
  constructor() {
    /** @export { !mojoBase.mojom.ReadOnlyFile } */
    this.data;
    /** @export { !mojoBase.mojom.ReadOnlyFile } */
    this.spModel;
  }
};



mojo.internal.Struct(
    onDeviceModel.mojom.BertSafetyModelAssetsSpec.$,
    'BertSafetyModelAssets',
    [
      mojo.internal.StructField(
        'model', 0,
        0,
        mojoBase.mojom.ReadOnlyFileSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('onDeviceModel.mojom.BertSafetyModelAssets');

/** @record */
onDeviceModel.mojom.BertSafetyModelAssets = class {
  constructor() {
    /** @export { !mojoBase.mojom.ReadOnlyFile } */
    this.model;
  }
};



mojo.internal.Struct(
    onDeviceModel.mojom.LanguageModelAssetsSpec.$,
    'LanguageModelAssets',
    [
      mojo.internal.StructField(
        'model', 0,
        0,
        mojoBase.mojom.ReadOnlyFileSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('onDeviceModel.mojom.LanguageModelAssets');

/** @record */
onDeviceModel.mojom.LanguageModelAssets = class {
  constructor() {
    /** @export { !mojoBase.mojom.ReadOnlyFile } */
    this.model;
  }
};



mojo.internal.Struct(
    onDeviceModel.mojom.TextSafetyModelParamsSpec.$,
    'TextSafetyModelParams',
    [
      mojo.internal.StructField(
        'safetyAssets', 0,
        0,
        onDeviceModel.mojom.SafetyModelAssetsSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'languageAssets', 16,
        0,
        onDeviceModel.mojom.LanguageModelAssetsSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('onDeviceModel.mojom.TextSafetyModelParams');

/** @record */
onDeviceModel.mojom.TextSafetyModelParams = class {
  constructor() {
    /** @export { (onDeviceModel.mojom.SafetyModelAssets|undefined) } */
    this.safetyAssets;
    /** @export { (onDeviceModel.mojom.LanguageModelAssets|undefined) } */
    this.languageAssets;
  }
};



mojo.internal.Struct(
    onDeviceModel.mojom.PlatformModelProgressObserver_Progress_ParamsSpec.$,
    'PlatformModelProgressObserver_Progress_Params',
    [
      mojo.internal.StructField(
        'progress', 0,
        0,
        mojo.internal.Double,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('onDeviceModel.mojom.PlatformModelProgressObserver_Progress_Params');

/** @record */
onDeviceModel.mojom.PlatformModelProgressObserver_Progress_Params = class {
  constructor() {
    /** @export { !number } */
    this.progress;
  }
};



mojo.internal.Struct(
    onDeviceModel.mojom.OnDeviceModelService_LoadModel_ParamsSpec.$,
    'OnDeviceModelService_LoadModel_Params',
    [
      mojo.internal.StructField(
        'params', 0,
        0,
        onDeviceModel.mojom.LoadModelParamsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'model', 8,
        0,
        mojo.internal.InterfaceRequest(onDeviceModel.mojom.OnDeviceModelPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('onDeviceModel.mojom.OnDeviceModelService_LoadModel_Params');

/** @record */
onDeviceModel.mojom.OnDeviceModelService_LoadModel_Params = class {
  constructor() {
    /** @export { !onDeviceModel.mojom.LoadModelParams } */
    this.params;
    /** @export { !onDeviceModel.mojom.OnDeviceModelPendingReceiver } */
    this.model;
  }
};



mojo.internal.Struct(
    onDeviceModel.mojom.OnDeviceModelService_LoadModel_ResponseParamsSpec.$,
    'OnDeviceModelService_LoadModel_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        onDeviceModel.mojom.LoadModelResultSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('onDeviceModel.mojom.OnDeviceModelService_LoadModel_ResponseParams');

/** @record */
onDeviceModel.mojom.OnDeviceModelService_LoadModel_ResponseParams = class {
  constructor() {
    /** @export { !onDeviceModel.mojom.LoadModelResult } */
    this.result;
  }
};



mojo.internal.Struct(
    onDeviceModel.mojom.OnDeviceModelService_GetCapabilities_ParamsSpec.$,
    'OnDeviceModelService_GetCapabilities_Params',
    [
      mojo.internal.StructField(
        'weights', 0,
        0,
        onDeviceModel.mojom.ModelFileSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('onDeviceModel.mojom.OnDeviceModelService_GetCapabilities_Params');

/** @record */
onDeviceModel.mojom.OnDeviceModelService_GetCapabilities_Params = class {
  constructor() {
    /** @export { !onDeviceModel.mojom.ModelFile } */
    this.weights;
  }
};



mojo.internal.Struct(
    onDeviceModel.mojom.OnDeviceModelService_GetCapabilities_ResponseParamsSpec.$,
    'OnDeviceModelService_GetCapabilities_ResponseParams',
    [
      mojo.internal.StructField(
        'capabilities', 0,
        0,
        onDeviceModel.mojom.CapabilitiesSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('onDeviceModel.mojom.OnDeviceModelService_GetCapabilities_ResponseParams');

/** @record */
onDeviceModel.mojom.OnDeviceModelService_GetCapabilities_ResponseParams = class {
  constructor() {
    /** @export { !onDeviceModel.mojom.Capabilities } */
    this.capabilities;
  }
};



mojo.internal.Struct(
    onDeviceModel.mojom.OnDeviceModelService_LoadTextSafetyModel_ParamsSpec.$,
    'OnDeviceModelService_LoadTextSafetyModel_Params',
    [
      mojo.internal.StructField(
        'params', 0,
        0,
        onDeviceModel.mojom.TextSafetyModelParamsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'model', 8,
        0,
        mojo.internal.InterfaceRequest(onDeviceModel.mojom.TextSafetyModelPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('onDeviceModel.mojom.OnDeviceModelService_LoadTextSafetyModel_Params');

/** @record */
onDeviceModel.mojom.OnDeviceModelService_LoadTextSafetyModel_Params = class {
  constructor() {
    /** @export { !onDeviceModel.mojom.TextSafetyModelParams } */
    this.params;
    /** @export { !onDeviceModel.mojom.TextSafetyModelPendingReceiver } */
    this.model;
  }
};



mojo.internal.Struct(
    onDeviceModel.mojom.OnDeviceModelService_GetDeviceAndPerformanceInfo_ParamsSpec.$,
    'OnDeviceModelService_GetDeviceAndPerformanceInfo_Params',
    [
    ],
    [[0, 8],]);



goog.provide('onDeviceModel.mojom.OnDeviceModelService_GetDeviceAndPerformanceInfo_Params');

/** @record */
onDeviceModel.mojom.OnDeviceModelService_GetDeviceAndPerformanceInfo_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    onDeviceModel.mojom.OnDeviceModelService_GetDeviceAndPerformanceInfo_ResponseParamsSpec.$,
    'OnDeviceModelService_GetDeviceAndPerformanceInfo_ResponseParams',
    [
      mojo.internal.StructField(
        'performanceInfo', 0,
        0,
        onDeviceModel.mojom.DevicePerformanceInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'deviceInfo', 8,
        0,
        onDeviceModel.mojom.DeviceInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('onDeviceModel.mojom.OnDeviceModelService_GetDeviceAndPerformanceInfo_ResponseParams');

/** @record */
onDeviceModel.mojom.OnDeviceModelService_GetDeviceAndPerformanceInfo_ResponseParams = class {
  constructor() {
    /** @export { !onDeviceModel.mojom.DevicePerformanceInfo } */
    this.performanceInfo;
    /** @export { !onDeviceModel.mojom.DeviceInfo } */
    this.deviceInfo;
  }
};



mojo.internal.Struct(
    onDeviceModel.mojom.OnDeviceModelPlatformService_LoadPlatformModel_ParamsSpec.$,
    'OnDeviceModelPlatformService_LoadPlatformModel_Params',
    [
      mojo.internal.StructField(
        'uuid', 0,
        0,
        mojoBase.mojom.UuidSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'model', 8,
        0,
        mojo.internal.InterfaceRequest(onDeviceModel.mojom.OnDeviceModelPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'progressObserver', 12,
        0,
        mojo.internal.InterfaceProxy(onDeviceModel.mojom.PlatformModelProgressObserverRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('onDeviceModel.mojom.OnDeviceModelPlatformService_LoadPlatformModel_Params');

/** @record */
onDeviceModel.mojom.OnDeviceModelPlatformService_LoadPlatformModel_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.Uuid } */
    this.uuid;
    /** @export { !onDeviceModel.mojom.OnDeviceModelPendingReceiver } */
    this.model;
    /** @export { (onDeviceModel.mojom.PlatformModelProgressObserverRemote|undefined) } */
    this.progressObserver;
  }
};



mojo.internal.Struct(
    onDeviceModel.mojom.OnDeviceModelPlatformService_LoadPlatformModel_ResponseParamsSpec.$,
    'OnDeviceModelPlatformService_LoadPlatformModel_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        onDeviceModel.mojom.LoadModelResultSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('onDeviceModel.mojom.OnDeviceModelPlatformService_LoadPlatformModel_ResponseParams');

/** @record */
onDeviceModel.mojom.OnDeviceModelPlatformService_LoadPlatformModel_ResponseParams = class {
  constructor() {
    /** @export { !onDeviceModel.mojom.LoadModelResult } */
    this.result;
  }
};



mojo.internal.Struct(
    onDeviceModel.mojom.OnDeviceModelPlatformService_GetPlatformModelState_ParamsSpec.$,
    'OnDeviceModelPlatformService_GetPlatformModelState_Params',
    [
      mojo.internal.StructField(
        'uuid', 0,
        0,
        mojoBase.mojom.UuidSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('onDeviceModel.mojom.OnDeviceModelPlatformService_GetPlatformModelState_Params');

/** @record */
onDeviceModel.mojom.OnDeviceModelPlatformService_GetPlatformModelState_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.Uuid } */
    this.uuid;
  }
};



mojo.internal.Struct(
    onDeviceModel.mojom.OnDeviceModelPlatformService_GetPlatformModelState_ResponseParamsSpec.$,
    'OnDeviceModelPlatformService_GetPlatformModelState_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        onDeviceModel.mojom.PlatformModelStateSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('onDeviceModel.mojom.OnDeviceModelPlatformService_GetPlatformModelState_ResponseParams');

/** @record */
onDeviceModel.mojom.OnDeviceModelPlatformService_GetPlatformModelState_ResponseParams = class {
  constructor() {
    /** @export { !onDeviceModel.mojom.PlatformModelState } */
    this.result;
  }
};



mojo.internal.Struct(
    onDeviceModel.mojom.OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ParamsSpec.$,
    'OnDeviceModelPlatformService_GetEstimatedPerformanceClass_Params',
    [
    ],
    [[0, 8],]);



goog.provide('onDeviceModel.mojom.OnDeviceModelPlatformService_GetEstimatedPerformanceClass_Params');

/** @record */
onDeviceModel.mojom.OnDeviceModelPlatformService_GetEstimatedPerformanceClass_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    onDeviceModel.mojom.OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ResponseParamsSpec.$,
    'OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ResponseParams',
    [
      mojo.internal.StructField(
        'performanceClass', 0,
        0,
        onDeviceModel.mojom.PerformanceClassSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('onDeviceModel.mojom.OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ResponseParams');

/** @record */
onDeviceModel.mojom.OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ResponseParams = class {
  constructor() {
    /** @export { !onDeviceModel.mojom.PerformanceClass } */
    this.performanceClass;
  }
};



mojo.internal.Struct(
    onDeviceModel.mojom.OnDeviceModelPlatformService_FormatInput_ParamsSpec.$,
    'OnDeviceModelPlatformService_FormatInput_Params',
    [
      mojo.internal.StructField(
        'uuid', 0,
        0,
        mojoBase.mojom.UuidSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'feature', 8,
        0,
        onDeviceModel.mojom.FormatFeatureSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'fields', 16,
        0,
        mojo.internal.Map(mojo.internal.String, mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('onDeviceModel.mojom.OnDeviceModelPlatformService_FormatInput_Params');

/** @record */
onDeviceModel.mojom.OnDeviceModelPlatformService_FormatInput_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.Uuid } */
    this.uuid;
    /** @export { !onDeviceModel.mojom.FormatFeature } */
    this.feature;
    /** @export { !Object<!string, !string> } */
    this.fields;
  }
};



mojo.internal.Struct(
    onDeviceModel.mojom.OnDeviceModelPlatformService_FormatInput_ResponseParamsSpec.$,
    'OnDeviceModelPlatformService_FormatInput_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('onDeviceModel.mojom.OnDeviceModelPlatformService_FormatInput_ResponseParams');

/** @record */
onDeviceModel.mojom.OnDeviceModelPlatformService_FormatInput_ResponseParams = class {
  constructor() {
    /** @export { (string|undefined) } */
    this.result;
  }
};



mojo.internal.Struct(
    onDeviceModel.mojom.OnDeviceModelPlatformService_ValidateSafetyResult_ParamsSpec.$,
    'OnDeviceModelPlatformService_ValidateSafetyResult_Params',
    [
      mojo.internal.StructField(
        'safetyFeature', 0,
        0,
        onDeviceModel.mojom.SafetyFeatureSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'text', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'safetyInfo', 16,
        0,
        onDeviceModel.mojom.SafetyInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('onDeviceModel.mojom.OnDeviceModelPlatformService_ValidateSafetyResult_Params');

/** @record */
onDeviceModel.mojom.OnDeviceModelPlatformService_ValidateSafetyResult_Params = class {
  constructor() {
    /** @export { !onDeviceModel.mojom.SafetyFeature } */
    this.safetyFeature;
    /** @export { !string } */
    this.text;
    /** @export { !onDeviceModel.mojom.SafetyInfo } */
    this.safetyInfo;
  }
};



mojo.internal.Struct(
    onDeviceModel.mojom.OnDeviceModelPlatformService_ValidateSafetyResult_ResponseParamsSpec.$,
    'OnDeviceModelPlatformService_ValidateSafetyResult_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('onDeviceModel.mojom.OnDeviceModelPlatformService_ValidateSafetyResult_ResponseParams');

/** @record */
onDeviceModel.mojom.OnDeviceModelPlatformService_ValidateSafetyResult_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.result;
  }
};

goog.provide('onDeviceModel.mojom.ModelFile');


mojo.internal.Union(
    onDeviceModel.mojom.ModelFileSpec.$, 'ModelFile',
    {
      'file': {
        'ordinal': 0,
        'type': mojoBase.mojom.FileSpec.$,
      },
      'path': {
        'ordinal': 1,
        'type': mojoBase.mojom.FilePathSpec.$,
      },
    });

/**
 * @typedef { {
 *   file: (!mojoBase.mojom.File|undefined),
 *   path: (!mojoBase.mojom.FilePath|undefined),
 * } }
 */
onDeviceModel.mojom.ModelFile;
goog.provide('onDeviceModel.mojom.SafetyModelAssets');


mojo.internal.Union(
    onDeviceModel.mojom.SafetyModelAssetsSpec.$, 'SafetyModelAssets',
    {
      'tsAssets': {
        'ordinal': 0,
        'type': onDeviceModel.mojom.TextSafetyModelAssetsSpec.$,
      },
      'bsAssets': {
        'ordinal': 1,
        'type': onDeviceModel.mojom.BertSafetyModelAssetsSpec.$,
      },
    });

/**
 * @typedef { {
 *   tsAssets: (!onDeviceModel.mojom.TextSafetyModelAssets|undefined),
 *   bsAssets: (!onDeviceModel.mojom.BertSafetyModelAssets|undefined),
 * } }
 */
onDeviceModel.mojom.SafetyModelAssets;
