// services/on_device_model/public/mojom/on_device_model_service.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_ON_DEVICE_MODEL_PUBLIC_MOJOM_ON_DEVICE_MODEL_SERVICE_MOJOM_DATA_VIEW_H_
#define SERVICES_ON_DEVICE_MODEL_PUBLIC_MOJOM_ON_DEVICE_MODEL_SERVICE_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "services/on_device_model/public/mojom/on_device_model_service.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file.mojom-shared.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "mojo/public/mojom/base/uuid.mojom-shared.h"
#include "sandbox/policy/mojom/context.mojom-shared.h"
#include "sandbox/policy/mojom/sandbox.mojom-shared.h"
#include "services/on_device_model/public/mojom/on_device_model.mojom-shared.h"


namespace on_device_model::mojom {
class ModelAssetsDataView;

class LoadModelParamsDataView;

class TextSafetyModelAssetsDataView;

class BertSafetyModelAssetsDataView;

class LanguageModelAssetsDataView;

class TextSafetyModelParamsDataView;

class ModelFileDataView;
class SafetyModelAssetsDataView;


}  // on_device_model::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::on_device_model::mojom::ModelAssetsDataView> {
  using Data = ::on_device_model::mojom::internal::ModelAssets_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::on_device_model::mojom::LoadModelParamsDataView> {
  using Data = ::on_device_model::mojom::internal::LoadModelParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::on_device_model::mojom::TextSafetyModelAssetsDataView> {
  using Data = ::on_device_model::mojom::internal::TextSafetyModelAssets_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::on_device_model::mojom::BertSafetyModelAssetsDataView> {
  using Data = ::on_device_model::mojom::internal::BertSafetyModelAssets_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::on_device_model::mojom::LanguageModelAssetsDataView> {
  using Data = ::on_device_model::mojom::internal::LanguageModelAssets_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::on_device_model::mojom::TextSafetyModelParamsDataView> {
  using Data = ::on_device_model::mojom::internal::TextSafetyModelParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::on_device_model::mojom::ModelFileDataView> {
  using Data = ::on_device_model::mojom::internal::ModelFile_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::on_device_model::mojom::SafetyModelAssetsDataView> {
  using Data = ::on_device_model::mojom::internal::SafetyModelAssets_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace on_device_model::mojom {


enum class ModelBackendType : int32_t {
  
  kGpu = 0,
  
  kApu = 1,
  
  kCpu = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, ModelBackendType value);
inline bool IsKnownEnumValue(ModelBackendType value) {
  return internal::ModelBackendType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ModelPerformanceHint : int32_t {
  
  kHighestQuality = 0,
  
  kFastestInference = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, ModelPerformanceHint value);
inline bool IsKnownEnumValue(ModelPerformanceHint value) {
  return internal::ModelPerformanceHint_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class PlatformModelState : int32_t {
  
  kUnknownState = 0,
  
  kInstalledOnDisk = 1,
  
  kInvalidUuid = 2,
  
  kInvalidDlcClient = 3,
  
  kInvalidDlcPackage = 4,
  
  kInvalidDlcVerifiedState = 5,
  
  kInvalidDlcInstall = 6,
  
  kInvalidModelFormat = 7,
  
  kInvalidModelDescriptor = 8,
  
  kInvalidBaseModelDescriptor = 9,
  kMinValue = 0,
  kMaxValue = 9,
  kDefaultValue = 0
};

 std::ostream& operator<<(std::ostream& os, PlatformModelState value);
inline bool IsKnownEnumValue(PlatformModelState value) {
  return internal::PlatformModelState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline PlatformModelState ToKnownEnumValue(PlatformModelState value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return PlatformModelState::kDefaultValue;
}


enum class FormatFeature : int32_t {
  
  kNone = 0,
  
  kPrompt = 1,
  
  kAudioSummary = 2,
  
  kAudioTitle = 3,
  kMinValue = 0,
  kMaxValue = 3,
  kDefaultValue = 0
};

 std::ostream& operator<<(std::ostream& os, FormatFeature value);
inline bool IsKnownEnumValue(FormatFeature value) {
  return internal::FormatFeature_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline FormatFeature ToKnownEnumValue(FormatFeature value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return FormatFeature::kDefaultValue;
}


enum class SafetyFeature : int32_t {
  
  kGeneral = 0,
  
  kAudioSummaryRequest = 1,
  
  kAudioTitleRequest = 2,
  
  kAudioSummaryResponse = 3,
  
  kAudioTitleResponse = 4,
  
  kAudioSummaryResponseV2 = 5,
  
  kAudioTitleResponseV2 = 6,
  kMinValue = 0,
  kMaxValue = 6,
  kDefaultValue = 0
};

 std::ostream& operator<<(std::ostream& os, SafetyFeature value);
inline bool IsKnownEnumValue(SafetyFeature value) {
  return internal::SafetyFeature_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline SafetyFeature ToKnownEnumValue(SafetyFeature value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return SafetyFeature::kDefaultValue;
}
// Interface base classes. They are used for type safety check.
class PlatformModelProgressObserverInterfaceBase {};

using PlatformModelProgressObserverPtrDataView =
    mojo::InterfacePtrDataView<PlatformModelProgressObserverInterfaceBase>;
using PlatformModelProgressObserverRequestDataView =
    mojo::InterfaceRequestDataView<PlatformModelProgressObserverInterfaceBase>;
using PlatformModelProgressObserverAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PlatformModelProgressObserverInterfaceBase>;
using PlatformModelProgressObserverAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PlatformModelProgressObserverInterfaceBase>;
class OnDeviceModelServiceInterfaceBase {};

using OnDeviceModelServicePtrDataView =
    mojo::InterfacePtrDataView<OnDeviceModelServiceInterfaceBase>;
using OnDeviceModelServiceRequestDataView =
    mojo::InterfaceRequestDataView<OnDeviceModelServiceInterfaceBase>;
using OnDeviceModelServiceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<OnDeviceModelServiceInterfaceBase>;
using OnDeviceModelServiceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<OnDeviceModelServiceInterfaceBase>;
class OnDeviceModelPlatformServiceInterfaceBase {};

using OnDeviceModelPlatformServicePtrDataView =
    mojo::InterfacePtrDataView<OnDeviceModelPlatformServiceInterfaceBase>;
using OnDeviceModelPlatformServiceRequestDataView =
    mojo::InterfaceRequestDataView<OnDeviceModelPlatformServiceInterfaceBase>;
using OnDeviceModelPlatformServiceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<OnDeviceModelPlatformServiceInterfaceBase>;
using OnDeviceModelPlatformServiceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<OnDeviceModelPlatformServiceInterfaceBase>;


class ModelAssetsDataView {
 public:
  ModelAssetsDataView() = default;

  ModelAssetsDataView(
      internal::ModelAssets_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetWeightsDataView(
      ModelFileDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWeights(UserType* output) {
    
    auto* pointer = !data_->weights.is_null() ? &data_->weights : nullptr;
    return mojo::internal::Deserialize<::on_device_model::mojom::ModelFileDataView>(
        pointer, output, message_);
  }
  inline void GetSpModelPathDataView(
      ::mojo_base::mojom::FilePathDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSpModelPath(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::FilePathDataView, UserType>(),
    "Attempting to read the optional `sp_model_path` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSpModelPath` instead "
    "of `ReadSpModelPath if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->sp_model_path.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FilePathDataView>(
        pointer, output, message_);
  }
  inline void GetCacheDataView(
      ::mojo_base::mojom::FileDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCache(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::FileDataView, UserType>(),
    "Attempting to read the optional `cache` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCache` instead "
    "of `ReadCache if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->cache.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FileDataView>(
        pointer, output, message_);
  }
  inline void GetEncoderCacheDataView(
      ::mojo_base::mojom::FileDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEncoderCache(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::FileDataView, UserType>(),
    "Attempting to read the optional `encoder_cache` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadEncoderCache` instead "
    "of `ReadEncoderCache if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->encoder_cache.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FileDataView>(
        pointer, output, message_);
  }
  inline void GetAdapterCacheDataView(
      ::mojo_base::mojom::FileDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAdapterCache(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::FileDataView, UserType>(),
    "Attempting to read the optional `adapter_cache` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAdapterCache` instead "
    "of `ReadAdapterCache if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->adapter_cache.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FileDataView>(
        pointer, output, message_);
  }
 private:
  internal::ModelAssets_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class LoadModelParamsDataView {
 public:
  LoadModelParamsDataView() = default;

  LoadModelParamsDataView(
      internal::LoadModelParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadBackendType(UserType* output) const {
    auto data_value = data_->backend_type;
    return mojo::internal::Deserialize<::on_device_model::mojom::ModelBackendType>(
        data_value, output);
  }
  ModelBackendType backend_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::on_device_model::mojom::ModelBackendType>(data_->backend_type));
  }
  inline void GetAssetsDataView(
      ModelAssetsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAssets(UserType* output) {
    
    auto* pointer = data_->assets.Get();
    return mojo::internal::Deserialize<::on_device_model::mojom::ModelAssetsDataView>(
        pointer, output, message_);
  }
  uint32_t max_tokens() const {
    return data_->max_tokens;
  }
  inline void GetAdaptationRanksDataView(
      mojo::ArrayDataView<uint32_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAdaptationRanks(UserType* output) {
    
    auto* pointer = data_->adaptation_ranks.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint32_t>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadPerformanceHint(UserType* output) const {
    auto data_value = data_->performance_hint;
    return mojo::internal::Deserialize<::on_device_model::mojom::ModelPerformanceHint>(
        data_value, output);
  }
  ModelPerformanceHint performance_hint() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::on_device_model::mojom::ModelPerformanceHint>(data_->performance_hint));
  }
 private:
  internal::LoadModelParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TextSafetyModelAssetsDataView {
 public:
  TextSafetyModelAssetsDataView() = default;

  TextSafetyModelAssetsDataView(
      internal::TextSafetyModelAssets_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDataDataView(
      ::mojo_base::mojom::ReadOnlyFileDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadData(UserType* output) {
    
    auto* pointer = data_->data.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ReadOnlyFileDataView>(
        pointer, output, message_);
  }
  inline void GetSpModelDataView(
      ::mojo_base::mojom::ReadOnlyFileDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSpModel(UserType* output) {
    
    auto* pointer = data_->sp_model.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ReadOnlyFileDataView>(
        pointer, output, message_);
  }
 private:
  internal::TextSafetyModelAssets_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class BertSafetyModelAssetsDataView {
 public:
  BertSafetyModelAssetsDataView() = default;

  BertSafetyModelAssetsDataView(
      internal::BertSafetyModelAssets_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetModelDataView(
      ::mojo_base::mojom::ReadOnlyFileDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadModel(UserType* output) {
    
    auto* pointer = data_->model.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ReadOnlyFileDataView>(
        pointer, output, message_);
  }
 private:
  internal::BertSafetyModelAssets_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class LanguageModelAssetsDataView {
 public:
  LanguageModelAssetsDataView() = default;

  LanguageModelAssetsDataView(
      internal::LanguageModelAssets_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetModelDataView(
      ::mojo_base::mojom::ReadOnlyFileDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadModel(UserType* output) {
    
    auto* pointer = data_->model.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ReadOnlyFileDataView>(
        pointer, output, message_);
  }
 private:
  internal::LanguageModelAssets_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TextSafetyModelParamsDataView {
 public:
  TextSafetyModelParamsDataView() = default;

  TextSafetyModelParamsDataView(
      internal::TextSafetyModelParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSafetyAssetsDataView(
      SafetyModelAssetsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSafetyAssets(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::on_device_model::mojom::SafetyModelAssetsDataView, UserType>(),
    "Attempting to read the optional `safety_assets` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSafetyAssets` instead "
    "of `ReadSafetyAssets if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->safety_assets.is_null() ? &data_->safety_assets : nullptr;
    return mojo::internal::Deserialize<::on_device_model::mojom::SafetyModelAssetsDataView>(
        pointer, output, message_);
  }
  inline void GetLanguageAssetsDataView(
      LanguageModelAssetsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLanguageAssets(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::on_device_model::mojom::LanguageModelAssetsDataView, UserType>(),
    "Attempting to read the optional `language_assets` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadLanguageAssets` instead "
    "of `ReadLanguageAssets if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->language_assets.Get();
    return mojo::internal::Deserialize<::on_device_model::mojom::LanguageModelAssetsDataView>(
        pointer, output, message_);
  }
 private:
  internal::TextSafetyModelParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ModelFileDataView {
 public:
  using Tag = internal::ModelFile_Data::ModelFile_Tag;

  ModelFileDataView() = default;

  ModelFileDataView(
      internal::ModelFile_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_file() const { return data_->tag == Tag::kFile; }
  inline void GetFileDataView(
      ::mojo_base::mojom::FileDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadFile(UserType* output) const {
    
    CHECK(is_file());
    return mojo::internal::Deserialize<::mojo_base::mojom::FileDataView>(
        data_->data.f_file.Get(), output, message_);
  }
  bool is_path() const { return data_->tag == Tag::kPath; }
  inline void GetPathDataView(
      ::mojo_base::mojom::FilePathDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadPath(UserType* output) const {
    
    CHECK(is_path());
    return mojo::internal::Deserialize<::mojo_base::mojom::FilePathDataView>(
        data_->data.f_path.Get(), output, message_);
  }

 private:
  internal::ModelFile_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class SafetyModelAssetsDataView {
 public:
  using Tag = internal::SafetyModelAssets_Data::SafetyModelAssets_Tag;

  SafetyModelAssetsDataView() = default;

  SafetyModelAssetsDataView(
      internal::SafetyModelAssets_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_ts_assets() const { return data_->tag == Tag::kTsAssets; }
  inline void GetTsAssetsDataView(
      TextSafetyModelAssetsDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadTsAssets(UserType* output) const {
    
    CHECK(is_ts_assets());
    return mojo::internal::Deserialize<::on_device_model::mojom::TextSafetyModelAssetsDataView>(
        data_->data.f_ts_assets.Get(), output, message_);
  }
  bool is_bs_assets() const { return data_->tag == Tag::kBsAssets; }
  inline void GetBsAssetsDataView(
      BertSafetyModelAssetsDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadBsAssets(UserType* output) const {
    
    CHECK(is_bs_assets());
    return mojo::internal::Deserialize<::on_device_model::mojom::BertSafetyModelAssetsDataView>(
        data_->data.f_bs_assets.Get(), output, message_);
  }

 private:
  internal::SafetyModelAssets_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // on_device_model::mojom

#endif  // SERVICES_ON_DEVICE_MODEL_PUBLIC_MOJOM_ON_DEVICE_MODEL_SERVICE_MOJOM_DATA_VIEW_H_